/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.notifyrule.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmVO;
import com.huawei.ism.drm.rest.service.framework.email.model.EmailVo;
import com.huawei.ism.drm.rest.service.framework.notifyrule.model.PhoneVo;
import com.huawei.ism.drm.rest.service.framework.notifyrule.model.RemoteNotifyRuleVo;
import com.huawei.ism.drm.rest.service.framework.notifyrule.service.INotifyRuleRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.DeviceVo;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.huawei.lego.nem.fault.sdk.model.NotifyResItem;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public class NotifyRuleRestServiceImpl
extends AbstractRestService
implements INotifyRuleRestService {
    private static Log log = LogFactory.getInstance(NotifyRuleRestServiceImpl.class);
    private static final String END_TIME = "9999-12-31 23:59:59";
    private static final long END_TIME_LONG = 253402271999000L;
    private static final Long ADMIN_ID = 1L;
    private static final Map<String, String> SENDCONTENTMAP = new HashMap<String, String>();
    private long managementSystemId = 1L;

    @Override
    public String getRemoteNotifyRuleList(String resName, String ruleName, String orderBy, String orderType, int startPage, int pageSize) {
        log.trace((Object)"enter getRemoteNotifyRuleList");
        this.checkUserOperationAuthority("notificationServer_queryNotificationRule_operateName", 2, "lego.event.notify.scan");
        if (startPage < 0 || pageSize < 0) {
            throw new LegoCheckedException(250L);
        }
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.canOrderBy((String)orderBy);
        boolean orderByAscend = false;
        if (orderType != null && orderType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        Paging paging = null;
        if (this.checkRuleName(resName, ruleName)) {
            ruleName = HtmlStringConverter.decode((String)ruleName);
            paging = service.getRuleAndCountByName(ruleName, startPage * pageSize, pageSize, orderBy, orderByAscend);
        } else {
            resName = HtmlStringConverter.decode((String)resName);
            paging = service.getRuleAndCountByResName(resName, startPage * pageSize, pageSize, orderBy, orderByAscend);
        }
        int total = paging.getiCount();
        List remoteNotifyRuleList = paging.getData();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)total);
        JSONArray jsonArray = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)remoteNotifyRuleList)) {
            for (RemoteNotifyRule rule : remoteNotifyRuleList) {
                jsonArray.add(this.remoteNotifyRuleToJsonStr(rule));
            }
        }
        resultObject.put((Object)"records", (Object)jsonArray);
        return resultObject.toString();
    }

    private boolean checkRuleName(String resName, String ruleName) {
        log.trace((Object)"enter checkRuleName");
        return !VerifyUtil.isEmpty((String)ruleName) || VerifyUtil.isEmpty((String)ruleName) && VerifyUtil.isEmpty((String)resName);
    }

    private Object remoteNotifyRuleToJsonStr(RemoteNotifyRule rule) {
        log.trace((Object)"enter remoteNotifyRuleToJsonStr");
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)rule)) {
            return jsonObject;
        }
        jsonObject.put((Object)"id", (Object)rule.getId());
        jsonObject.put((Object)"ruleName", (Object)rule.getRuleName());
        try {
            Long startTime = rule.getStartTime();
            jsonObject.put((Object)"startTime", (Object)CommUtils.formatDate((Date)new Date(startTime)));
        }
        catch (Exception e) {
            log.debug((Object)"param startTime is not a number Character string");
            jsonObject.put((Object)"startTime", (Object)"--");
        }
        Long endTime = rule.getEndTime();
        String endTimeStr = "--";
        if (endTime != null && endTime != 253402271999000L) {
            endTimeStr = CommUtils.formatDate((Date)new Date(endTime));
        }
        jsonObject.put((Object)"endTime", (Object)endTimeStr);
        jsonObject.put((Object)"isUseEnable", (Object)rule.isUseEnable());
        jsonObject.put((Object)"description", (Object)rule.getDescription());
        jsonObject.put((Object)"emailTo", (Object)rule.getEmailTo());
        jsonObject.put((Object)"expiredStatus", (Object)rule.isExpiredStatus());
        jsonObject.put((Object)"isClearEnable", (Object)rule.isClearEnable());
        jsonObject.put((Object)"isCriticalEnable", (Object)rule.isCriticalEnable());
        jsonObject.put((Object)"isInfoEnable", (Object)rule.isInfoEnable());
        jsonObject.put((Object)"isMajorEnable", (Object)rule.isMajorEnable());
        jsonObject.put((Object)"isWarningEnable", (Object)rule.isWarningEnable());
        jsonObject.put((Object)"moMainType", (Object)rule.getMoMainType());
        jsonObject.put((Object)"moSubType", (Object)rule.getMoSubType());
        jsonObject.put((Object)"sendContent", (Object)rule.getSendContent());
        jsonObject.put((Object)"smsMode", (Object)rule.getSmsMode());
        jsonObject.put((Object)"language", (Object)rule.getLanguage());
        jsonObject.put((Object)"smsPhone", (Object)rule.getSmsPhone());
        jsonObject.put((Object)"validStatus", (Object)rule.isValidStatus());
        Set notifyAlarmItems = rule.getNotifyAlarmItems();
        Set notifyResItems = rule.getNotifyResItems();
        jsonObject.put((Object)"notifyAlarmItems", (Object)CommUtils.responseJsonArrayResult((Collection)notifyAlarmItems, (String[])new String[]{"remoteNotifyRule"}));
        jsonObject.put((Object)"notifyResItems", (Object)CommUtils.responseJsonArrayResult((Collection)notifyResItems, (String[])new String[]{"remoteNotifyRule"}));
        return jsonObject;
    }

    @Override
    public Response createRemoteNotifyRule(RemoteNotifyRuleVo vo) {
        this.checkUserOperationAuthority("notificationServer_createNotificationRule_operateName", 1, "lego.event.notify.add");
        this.checkParam(vo);
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        RemoteNotifyRule remoteNotifyRule = this.voToBean(vo);
        remoteNotifyRule.setCreateUserId(this.getCurrentUserId().longValue());
        Object[] phoneList = this.checkPhone(vo);
        Object[] emailList = this.checkEmail(vo);
        if (VerifyUtil.isEmpty((Object[])phoneList) && VerifyUtil.isEmpty((Object[])emailList)) {
            throw new LegoCheckedException(250L);
        }
        String[] deviceStrArray = this.deviceSetToStrArray(vo.getDeviceSet());
        String[] alarmTypeList = this.alarmTypeSetToStrArray(vo.getAlarmTypeSet());
        try {
            service.addRule(remoteNotifyRule, (String[])emailList, (String[])phoneList, this.convertSelectiveFields(vo.getSelectiveFields()), deviceStrArray, alarmTypeList);
            this.writeSucOperationLog("notificationServer_createNotificationRule_operateName", 1, vo.getRuleName(), null, null);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"create notify rule failed!", (Throwable)e, e.getErrorCode());
            this.writeFailedOperationLog("notificationServer_createNotificationRule_operateName", 1, vo.getRuleName(), (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("create notify rule failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1053L);
            this.writeFailedOperationLog("notificationServer_createNotificationRule_operateName", 1, vo.getRuleName(), (Exception)((Object)new LegoCheckedException(1053L, (Throwable)e)));
            throw new LegoCheckedException(1053L, (Throwable)e);
        }
        return Response.ok().build();
    }

    private String[] convertSelectiveFields(String[] selectiveFields) {
        log.trace((Object)"enter convertSelectiveFields");
        if (selectiveFields == null || selectiveFields.length == 0) {
            return selectiveFields;
        }
        int size = selectiveFields.length;
        for (int i = 0; i < size; ++i) {
            selectiveFields[i] = this.getSelectiveFields(selectiveFields[i]);
        }
        return selectiveFields;
    }

    private RemoteNotifyRule voToBean(RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter voToBean");
        String ruleName = vo.getRuleName();
        Long startTime = vo.getStartTime();
        Long endTime = vo.getEndTime();
        String description = vo.getDescription();
        Integer language = vo.getLanguage();
        boolean useEnable = vo.isUseEnable();
        RemoteNotifyRule remoteNotifyRule = new RemoteNotifyRule();
        remoteNotifyRule.setLanguage(language.intValue());
        remoteNotifyRule.setRuleName(ruleName);
        remoteNotifyRule.setClearEnable(true);
        remoteNotifyRule.setUseEnable(useEnable);
        remoteNotifyRule.setStartTimeStr(CommUtils.formatDate((Date)new Date(startTime)));
        String endTimeStr = endTime == null || endTime <= 0L ? END_TIME : CommUtils.formatDate((Date)new Date(endTime));
        remoteNotifyRule.setEndTimeStr(endTimeStr);
        int smsMode = 2;
        remoteNotifyRule.setSmsMode(2);
        remoteNotifyRule.setDescription(description);
        return remoteNotifyRule;
    }

    private String[] alarmTypeSetToStrArray(Set<AlarmVO> alarmTypeSet) {
        log.trace((Object)"enter alarmTypeSetToStrArray");
        Iterator<AlarmVO> iterator = alarmTypeSet.iterator();
        ArrayList<String> alarmList = new ArrayList<String>();
        while (iterator.hasNext()) {
            AlarmVO alarmVo = iterator.next();
            String severity = alarmVo.getSeverity();
            String alarmId = alarmVo.getAlarmId();
            String alarmName = alarmVo.getAlarmName();
            String alarmType = alarmVo.getAlarmType();
            CommUtils.checkParamEmpty((Object[])new Object[]{severity, alarmId, alarmName, alarmType});
            String alarmStr = severity + "\t" + alarmId + "\t" + alarmName + "\t" + alarmType;
            alarmList.add(alarmStr);
        }
        String[] alarmArray = new String[alarmList.size()];
        for (int i = 0; i < alarmList.size(); ++i) {
            alarmArray[i] = (String)alarmList.get(i);
        }
        return alarmArray;
    }

    private boolean checkselectiveFields(String[] selectiveFields) {
        log.trace((Object)"enter checkselectiveFields");
        if (VerifyUtil.isEmpty((Object[])selectiveFields)) {
            return false;
        }
        List<String> dbFields = Arrays.asList("severity", "alarmName", "alarmType", "source", "createTime", "clearStatus", "alarmDesc", "location");
        for (String fieldName : selectiveFields) {
            if (!VerifyUtil.isEmpty((String)fieldName) && dbFields.contains(fieldName)) continue;
            throw new LegoCheckedException(250L);
        }
        return true;
    }

    private String[] deviceSetToStrArray(Set<DeviceVo> deviceSet) {
        Iterator<DeviceVo> iterator = deviceSet.iterator();
        ArrayList<String> deviceList = new ArrayList<String>();
        while (iterator.hasNext()) {
            DeviceVo deviceVo = iterator.next();
            Long moid = deviceVo.getMoId();
            String name = deviceVo.getName();
            String mainType = deviceVo.getMainType();
            String subType = deviceVo.getSubType();
            String ipAddress = deviceVo.getIpAddress();
            CommUtils.checkParamEmpty((Object[])new Object[]{moid, name, mainType, subType, ipAddress});
            if (moid != this.managementSystemId) {
                this.checkUserMoAuthority("notificationServer_createNotificationRule_operateName", 1, new long[]{moid});
            }
            String deviceStr = moid.toString() + "\t" + name + "\t" + subType + "\t" + mainType + "\t" + ipAddress;
            deviceList.add(deviceStr);
        }
        String[] deviceArray = new String[deviceList.size()];
        for (int i = 0; i < deviceList.size(); ++i) {
            deviceArray[i] = (String)deviceList.get(i);
        }
        return deviceArray;
    }

    private String[] checkEmail(RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter checkEmail");
        Set<EmailVo> emailSet = vo.getEmailSet();
        if (emailSet == null) {
            return new String[0];
        }
        ArrayList<String> emailList = new ArrayList<String>();
        for (EmailVo emailVo : emailSet) {
            String emailAddress = emailVo.getEmailAddress();
            String desc = emailVo.getDesc();
            if (!Validator.checkStringLength((String)emailAddress, (int)254) || !Validator.checkStringLength((String)desc, (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.isEmail((String)emailAddress)) continue;
            if (desc != null) {
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
            }
            String emailStr = emailAddress + "###" + desc;
            emailList.add(emailStr);
        }
        if (VerifyUtil.isEmpty(emailList)) {
            return new String[0];
        }
        int size = emailList.size();
        if (size > 10) {
            throw new LegoCheckedException(250L);
        }
        String[] emailStrArray = new String[size];
        for (int i = 0; i < size; ++i) {
            emailStrArray[i] = (String)emailList.get(i);
        }
        return emailStrArray;
    }

    private String[] checkPhone(RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter checkPhone");
        Set<PhoneVo> phoneSet = vo.getPhoneSet();
        if (phoneSet == null) {
            return new String[0];
        }
        ArrayList<String> phoneList = new ArrayList<String>();
        for (PhoneVo phoneVo : phoneSet) {
            String tel = phoneVo.getPhoneNumber();
            String desc = phoneVo.getDesc();
            if (!Validator.checkStringLength((String)tel, (int)32) || !Validator.checkStringLength((String)desc, (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.isPhoneInternation((String)tel)) {
                throw new LegoCheckedException(250L);
            }
            if (desc != null) {
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
            }
            String phoneStr = tel + "###" + desc;
            phoneList.add(phoneStr);
        }
        if (VerifyUtil.isEmpty(phoneList)) {
            return new String[0];
        }
        int size = phoneList.size();
        if (size > 10) {
            throw new LegoCheckedException(250L);
        }
        String[] phoneStrArray = new String[size];
        for (int i = 0; i < size; ++i) {
            phoneStrArray[i] = (String)phoneList.get(i);
        }
        return phoneStrArray;
    }

    private void checkParam(RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter checkParam");
        if (VerifyUtil.isEmpty((Object)vo)) {
            throw new LegoCheckedException(1073947393L);
        }
        String ruleName = vo.getRuleName();
        Long startTime = vo.getStartTime();
        Long endTime = vo.getEndTime();
        String[] selectiveFields = vo.getSelectiveFields();
        Set<AlarmVO> alarmTypeSet = vo.getAlarmTypeSet();
        Set<DeviceVo> deviceSet = vo.getDeviceSet();
        Set<EmailVo> emailSet = vo.getEmailSet();
        Set<PhoneVo> phoneSet = vo.getPhoneSet();
        String description = vo.getDescription();
        Integer language = vo.getLanguage();
        boolean i = true;
        int j = 2;
        if (this.checkRuleName(ruleName, selectiveFields)) {
            throw new LegoCheckedException(250L);
        }
        if (VerifyUtil.isEmpty(alarmTypeSet) || VerifyUtil.isEmpty(deviceSet) || !Validator.checkStringLength((String)description, (int)128) || language != 1 && language != 2) {
            throw new LegoCheckedException(250L);
        }
        if (VerifyUtil.isEmpty(emailSet) && VerifyUtil.isEmpty(phoneSet)) {
            throw new LegoCheckedException(250L);
        }
        this.checkRuleTime(startTime, endTime);
    }

    private void checkRuleTime(Long startTime, Long endTime) {
        log.trace((Object)"enter checkRuleTime");
        Validator.checkLongTime((Long)startTime);
        if (VerifyUtil.isEmpty((Object)endTime)) {
            endTime = Long.MAX_VALUE;
        } else {
            Validator.checkLongTime((Long)endTime);
        }
        if (startTime > endTime) {
            throw new LegoCheckedException(250L);
        }
        long currentTime = new Date().getTime();
        if (endTime <= currentTime) {
            throw new LegoCheckedException(1565L);
        }
    }

    private boolean checkRuleName(String ruleName, String[] selectiveFields) {
        log.trace((Object)"enter checkRuleName");
        return Validator.stringNullTrim((String)ruleName) || !Validator.checkStringLength((String)ruleName, (int)32) || !Validator.regExpCheck((String)ruleName, (String)"^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$") || !this.checkselectiveFields(selectiveFields);
    }

    @Override
    public BatchOperationResult deleteRemoteNotifyRule(Long[] ruleIds) {
        log.trace((Object)"enter deleteRemoteNotifyRule");
        this.checkUserOperationAuthority("notificationServer_delNotificationRule_operateName", 2, "lego.event.notify.delete");
        BatchOperationResult batchOperationResult = null;
        try {
            batchOperationResult = this.dealRemoteNotifyRule(true, false, ruleIds);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_delNotificationRule_operateName", 2, "", e);
        }
        this.batchOptLog(batchOperationResult, "notificationServer_delNotificationRule_operateName", 2);
        return batchOperationResult;
    }

    private BatchOperationResult dealRemoteNotifyRule(boolean isDelete, boolean useStatus, Long[] ruleIds) {
        log.trace((Object)"enter dealRemoteNotifyRule");
        CommUtils.checkArrayEmpty((Object[])ruleIds);
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        ArrayList<BatchOperation> bathOprList = new ArrayList<BatchOperation>();
        Long userId = this.getCurrentUserId();
        boolean shouldCheckUserId = !ADMIN_ID.equals(userId);
        int length = ruleIds.length;
        for (int i = 0; i < length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(ruleIds[i].longValue());
            RemoteNotifyRule remoteNotifyRule = service.getRuleByID(String.valueOf(ruleIds[i]));
            if (shouldCheckUserId && !userId.equals(remoteNotifyRule.getCreateUserId())) {
                throw new LegoCheckedException(1073947400L);
            }
            if (remoteNotifyRule == null) {
                tempBatch.setTargetName("");
            } else {
                tempBatch.setTargetName(remoteNotifyRule.getRuleName());
            }
            bathOprList.add(tempBatch);
        }
        BatchOperationResult batchOperationResult = null;
        batchOperationResult = isDelete ? service.deleteRules(bathOprList) : service.setSwitchStatus(useStatus, bathOprList);
        return batchOperationResult;
    }

    @Override
    public BatchOperationResult enableRemoteNotifyRule(Long[] ruleIds) {
        log.trace((Object)"enter enableRemoteNotifyRule");
        this.checkUserOperationAuthority("notificationServer_enablelNotificationRule_operateName", 3, "lego.event.notify.start");
        BatchOperationResult batchOperationResult = null;
        try {
            batchOperationResult = this.dealRemoteNotifyRule(false, true, ruleIds);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_enablelNotificationRule_operateName", 3, "", e);
        }
        this.batchOptLog(batchOperationResult, "notificationServer_enablelNotificationRule_operateName", 3);
        return batchOperationResult;
    }

    @Override
    public BatchOperationResult disableRemoteNotifyRule(Long[] ruleIds) {
        log.trace((Object)"enter disableRemoteNotifyRule");
        this.checkUserOperationAuthority("notificationServer_disablelNotificationRule_operateName", 2, "lego.event.notify.start");
        BatchOperationResult batchOperationResult = null;
        try {
            batchOperationResult = this.dealRemoteNotifyRule(false, false, ruleIds);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_disablelNotificationRule_operateName", 2, "", e);
        }
        this.batchOptLog(batchOperationResult, "notificationServer_disablelNotificationRule_operateName", 2);
        return batchOperationResult;
    }

    @Override
    public RemoteNotifyRuleVo getRemoteNotifyRule(String ruleId) {
        log.trace((Object)"enter getRemoteNotifyRule");
        this.checkUserOperationAuthority("notificationServer_queryNotificationRule_operateName", 2, "lego.event.notify.scan");
        RemoteNotifyRuleVo vo = new RemoteNotifyRuleVo();
        RemoteNotifyRule remoteNotifyRulePO = this.getNotifyRule(ruleId);
        this.setVO(vo, remoteNotifyRulePO);
        return vo;
    }

    private RemoteNotifyRule getNotifyRule(String ruleId) {
        log.trace((Object)"enter getNotifyRule");
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.convertString2Integer((String)ruleId);
        RemoteNotifyRule remoteNotifyRulePO = service.getRuleByID(ruleId);
        return remoteNotifyRulePO;
    }

    private void setVO(RemoteNotifyRuleVo vo, RemoteNotifyRule po) {
        log.trace((Object)"enter setVO ");
        Set notifyResItems = po.getNotifyResItems();
        HashSet<DeviceVo> deviceSet = new HashSet<DeviceVo>();
        this.dealDeviceSet(notifyResItems, deviceSet);
        vo.setDeviceSet(deviceSet);
        Set notifyAlarmItems = po.getNotifyAlarmItems();
        HashSet<AlarmVO> alarmTypeSet = new HashSet<AlarmVO>();
        this.dealAlarmTypeSet(notifyAlarmItems, alarmTypeSet);
        vo.setAlarmTypeSet(alarmTypeSet);
        this.setFields(vo, po);
        String emailTo = po.getEmailTo();
        HashSet<EmailVo> emailVoSet = new HashSet<EmailVo>();
        if (emailTo != null) {
            this.getEmailVoSet(emailTo, emailVoSet);
        }
        vo.setEmailSet(emailVoSet);
        String smsPhone = po.getSmsPhone();
        HashSet<PhoneVo> phoneVoSet = new HashSet<PhoneVo>();
        if (smsPhone != null) {
            this.getPhoneVoSet(smsPhone, phoneVoSet);
        }
        vo.setPhoneSet(phoneVoSet);
        vo.setDescription(po.getDescription());
        vo.setIsUseEnable(po.isUseEnable());
        vo.setLanguage(po.getLanguage());
        vo.setRuleName(po.getRuleName());
        vo.setStartTime(po.getStartTime());
        long endTime = po.getEndTime();
        if (endTime == 253402271999000L) {
            endTime = -1L;
        }
        vo.setEndTime(endTime);
    }

    private void getEmailVoSet(String emailTo, Set<EmailVo> emailVoSet) {
        String[] emailList;
        log.trace((Object)"enter getEmailVoSet");
        for (String email : emailList = emailTo.split("===")) {
            if (VerifyUtil.isEmpty((String)email)) continue;
            String[] tmpStr = email.split("###");
            String remark = "";
            if (tmpStr.length > 1) {
                remark = tmpStr[1];
            }
            remark = remark.replaceAll("=k", "=");
            remark = remark.replaceAll("#k", "#");
            EmailVo emailVo = new EmailVo();
            emailVo.setEmailAddress(tmpStr[0]);
            emailVo.setDesc(remark);
            emailVoSet.add(emailVo);
        }
    }

    private void getPhoneVoSet(String smsPhone, Set<PhoneVo> phoneVoSet) {
        String[] phoneList;
        log.trace((Object)"enter getPhoneVoSet");
        for (String phone : phoneList = smsPhone.split("===")) {
            if (VerifyUtil.isEmpty((String)phone)) continue;
            String[] tmpStr = phone.split("###");
            String remark = "";
            if (tmpStr.length > 1) {
                remark = tmpStr[1];
            }
            remark = remark.replaceAll("=k", "=");
            remark = remark.replaceAll("#k", "#");
            PhoneVo phoneVo = new PhoneVo();
            phoneVo.setPhoneNumber(tmpStr[0]);
            phoneVo.setDesc(remark);
            phoneVoSet.add(phoneVo);
        }
    }

    private void dealAlarmTypeSet(Set<NotifyAlarmItem> notifyAlarmItems, Set<AlarmVO> alarmTypeSet) {
        log.trace((Object)"enter dealAlarmTypeSet");
        if (!VerifyUtil.isEmpty(notifyAlarmItems)) {
            for (NotifyAlarmItem item : notifyAlarmItems) {
                AlarmVO alarmVo = new AlarmVO();
                alarmVo.setId(item.getId());
                alarmVo.setAlarmId(item.getAlarmId());
                alarmVo.setSeverity(item.getAlarmLevel() + "");
                alarmVo.setAlarmName(item.getAlarmName());
                alarmVo.setAlarmType(item.getAlarmType() + "");
                alarmTypeSet.add(alarmVo);
            }
        }
    }

    private void dealDeviceSet(Set<NotifyResItem> notifyResItems, Set<DeviceVo> deviceSet) {
        log.trace((Object)"enter dealDeviceSet");
        if (!VerifyUtil.isEmpty(notifyResItems)) {
            for (NotifyResItem item : notifyResItems) {
                DeviceVo deviceVo = new DeviceVo();
                deviceVo.setId(item.getId());
                long moId = -1L;
                if (item.getAlarmSource() != null) {
                    moId = NumberUtil.convertToLong((Object)item.getAlarmSource());
                }
                deviceVo.setMoId(Long.valueOf(moId));
                deviceVo.setIpAddress(item.getMoIP());
                deviceVo.setMainType(item.getMoMainType());
                deviceVo.setName(item.getMoName());
                deviceVo.setSubType(item.getMoSubType());
                deviceSet.add(deviceVo);
            }
        }
    }

    private void setFields(RemoteNotifyRuleVo vo, RemoteNotifyRule po) {
        log.trace((Object)"enter setFields");
        String sendContent = po.getSendContent();
        String[] fields = null;
        if (sendContent != null) {
            fields = sendContent.split(",");
        }
        if (VerifyUtil.isEmpty(fields)) {
            return;
        }
        String[] selectiveFileds = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String[] fieldValue = fields[i].split(":");
            selectiveFileds[i] = fieldValue[0];
        }
        vo.setSelectiveFields(selectiveFileds);
    }

    @Override
    public Response modifyNotifyBaseInfo(String id, RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter modifyNotifyBaseInfo");
        this.checkUserOperationAuthority("notificationServer_modifyNotificationRule_operateName", 3, "lego.event.notify.modify");
        VerifyUtil.checkObject((Object)vo);
        this.checkParamForModifyNotifyBaseInfo(vo);
        String ruleName = "";
        try {
            IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
            RemoteNotifyRule rule = service.getRuleByID(id);
            CommUtils.checkObjectExists((Object[])new Object[]{rule});
            ruleName = rule.getRuleName();
            RemoteNotifyRule remoteNotifyRule = this.voToBean(vo);
            String[] startEndTime = new String[]{remoteNotifyRule.getStartTimeStr(), remoteNotifyRule.getEndTimeStr()};
            service.modifyNotifyBaseInfo(id, remoteNotifyRule.isUseEnable(), startEndTime, remoteNotifyRule.getDescription(), remoteNotifyRule.getLanguage(), this.setSendContent(vo));
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, ruleName, "notificationServer_modifyNotificationRule_operateDetail_1", null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_modifyNotificationRule_operateName", 3, ruleName, e);
        }
        return Response.ok().build();
    }

    private String setSendContent(RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter setSendContent");
        StringBuilder sendContent = new StringBuilder();
        Object[] selectiveFields = vo.getSelectiveFields();
        if (VerifyUtil.isEmpty((Object[])selectiveFields)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (Object field : selectiveFields) {
            String value = this.getSelectiveFields((String)field);
            sendContent.append(value);
            sendContent.append(",");
        }
        String content = sendContent.toString();
        if (0 != content.length()) {
            return content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String getSelectiveFields(String field) {
        return field + ":" + this.getText(SENDCONTENTMAP.get(field));
    }

    private void checkParamForModifyNotifyBaseInfo(RemoteNotifyRuleVo vo) {
        log.trace((Object)"enter checkParamForModifyNotifyBaseInfo");
        String ruleName = vo.getRuleName();
        Long startTime = vo.getStartTime();
        Long endTime = vo.getEndTime();
        String[] selectiveFields = vo.getSelectiveFields();
        String description = vo.getDescription();
        Integer language = vo.getLanguage();
        if (Validator.stringNullTrim((String)ruleName) || !Validator.checkStringLength((String)ruleName, (int)32) || !Validator.regExpCheck((String)ruleName, (String)"^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$")) {
            throw new LegoCheckedException(250L);
        }
        int i = 2;
        boolean j = true;
        if (!this.checkselectiveFields(selectiveFields) || !Validator.checkStringLength((String)description, (int)128) || language != 1 && language != 2) {
            throw new LegoCheckedException(250L);
        }
        this.checkRuleTime(startTime, endTime);
    }

    @Override
    public Response modifyNotifyObj(String id, RemoteNotifyRuleVo vo) {
        String desc;
        int size;
        int i;
        log.trace((Object)"enter modifyNotifyObj");
        this.checkUserOperationAuthority("notificationServer_modifyNotificationRule_operateName", 3, "lego.event.notify.modify");
        VerifyUtil.checkObject((Object)vo);
        if (VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(250L);
        }
        boolean phoneListFlag = false;
        boolean emailListFlag = false;
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Set<EmailVo> emailSet = vo.getEmailSet();
        Set<PhoneVo> phoneSet = vo.getPhoneSet();
        String[] phoneList = new String[]{""};
        String[] emailList = new String[]{""};
        int length = 32;
        if (!VerifyUtil.isEmpty(phoneSet)) {
            i = 0;
            size = phoneSet.size();
            if (size > 10) {
                throw new LegoCheckedException(250L);
            }
            phoneList = new String[size];
            for (PhoneVo phoneVo : phoneSet) {
                String phoneNumber = phoneVo.getPhoneNumber();
                desc = phoneVo.getDesc();
                this.checkPhoneSet(32, phoneNumber, desc);
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
                phoneList[i++] = phoneNumber + "###" + desc;
                phoneListFlag = true;
            }
        }
        if (!VerifyUtil.isEmpty(emailSet)) {
            i = 0;
            size = emailSet.size();
            if (size > 10) {
                throw new LegoCheckedException(250L);
            }
            emailList = new String[size];
            for (EmailVo emailVo : emailSet) {
                String emailAddress = emailVo.getEmailAddress();
                desc = emailVo.getDesc();
                this.checkEmailSet(32, emailAddress, desc);
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
                emailList[i++] = emailAddress + "###" + desc;
                emailListFlag = true;
            }
        }
        if (!phoneListFlag && !emailListFlag) {
            throw new LegoCheckedException(250L);
        }
        int paramInt = 2;
        RemoteNotifyRule oldNotifyRule = this.getNotifyRule(id);
        try {
            service.modifyNotifyObj(id, 2, phoneList, emailList);
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_2", null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), e);
        }
        return Response.ok().build();
    }

    private void checkEmailSet(int length, String emailAddress, String desc) {
        log.trace((Object)"enter checkEmailSet");
        if (null != emailAddress && !Validator.checkStringLength((String)emailAddress, (int)254)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.isEmail((String)emailAddress)) {
            throw new LegoCheckedException(250L);
        }
        if (null != desc && !Validator.checkStringLength((String)desc, (int)length)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkPhoneSet(int length, String phoneNumber, String desc) {
        log.trace((Object)"enter checkPhoneSet");
        if (null != phoneNumber && !Validator.checkStringLength((String)phoneNumber, (int)length)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.isPhoneInternation((String)phoneNumber)) {
            throw new LegoCheckedException(250L);
        }
        if (null != desc && !Validator.checkStringLength((String)desc, (int)length)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void writeOptLogAndDataErrExc() {
        throw new LegoCheckedException(250L);
    }

    @Override
    public Response addResource(String id, Set<DeviceVo> deviceList) {
        log.trace((Object)"enter addResource");
        this.checkUserOperationAuthority("notificationServer_modifyNotificationRule_operateName", 3, "lego.event.notify.modify");
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.convertString2Integer((String)id);
        if (this.checkDeviceEmpty(deviceList)) {
            throw new LegoCheckedException(250L);
        }
        RemoteNotifyRule oldNotifyRule = this.getNotifyRule(id);
        Set notifyResItems = oldNotifyRule.getNotifyResItems();
        HashSet<DeviceVo> addDeviceSet = new HashSet<DeviceVo>();
        HashSet<NotifyResItem> delDeviceSet = new HashSet<NotifyResItem>();
        this.filterDevice(notifyResItems, deviceList, addDeviceSet, delDeviceSet);
        int size = addDeviceSet.size();
        String[] deviceListStr = new String[size];
        int i = 0;
        for (DeviceVo device : addDeviceSet) {
            Long moId = device.getMoId();
            this.checkUserMoAuthority("notificationServer_modifyNotificationRule_operateName", 3, new long[]{moId});
            String name = device.getName();
            String subType = device.getSubType();
            String mainType = device.getMainType();
            String ipAddress = device.getIpAddress();
            deviceListStr[i] = moId + "\t" + name + "\t" + subType + "\t" + mainType;
            if (!VerifyUtil.isEmpty((String)ipAddress)) {
                int n = i;
                deviceListStr[n] = deviceListStr[n] + "\t" + ipAddress;
            }
            ++i;
        }
        ArrayList<BatchOperation> delResources = new ArrayList<BatchOperation>();
        for (NotifyResItem item : delDeviceSet) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetId(item.getId());
            delResources.add(batchOperation);
        }
        this.addResources(id, service, oldNotifyRule, deviceListStr);
        this.delResources(service, oldNotifyRule, delResources);
        if (this.checkDeviceList(deviceListStr, delResources)) {
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), null, null);
        }
        return Response.ok().build();
    }

    private void addResources(String id, IRemoteNotifyRuleService service, RemoteNotifyRule oldNotifyRule, String[] deviceListStr) {
        log.trace((Object)"enter addResource");
        if (!VerifyUtil.isEmpty((Object[])deviceListStr)) {
            try {
                service.addResource(id, deviceListStr);
                this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_5", null);
            }
            catch (Exception e) {
                this.writeFailedOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), e);
            }
        }
    }

    private void delResources(IRemoteNotifyRuleService service, RemoteNotifyRule oldNotifyRule, List<BatchOperation> delResources) {
        log.trace((Object)"enter delResources");
        if (!VerifyUtil.isEmpty(delResources)) {
            try {
                service.deleteResourceItem(delResources);
                this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_6", null);
            }
            catch (Exception e) {
                this.writeFailedOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), e);
            }
        }
    }

    private boolean checkDeviceEmpty(Set<DeviceVo> deviceList) {
        log.trace((Object)"enter checkDeviceEmpty");
        return null == deviceList || deviceList.size() <= 0;
    }

    private boolean checkDeviceList(String[] deviceListStr, List<BatchOperation> delResources) {
        log.trace((Object)"enter checkDeviceList");
        return VerifyUtil.isEmpty((Object[])deviceListStr) && VerifyUtil.isEmpty(delResources);
    }

    private void filterDevice(Set<NotifyResItem> oldNotifyResItems, Set<DeviceVo> newDeviceList, Set<DeviceVo> addDeviceSet, Set<NotifyResItem> delDeviceSet) {
        log.trace((Object)"enter filterDevice");
        ArrayList<Long> oldIds = new ArrayList<Long>();
        for (NotifyResItem item : oldNotifyResItems) {
            oldIds.add(item.getId());
        }
        ArrayList<Long> newIds = new ArrayList<Long>();
        for (DeviceVo vo : newDeviceList) {
            newIds.add(vo.getId());
            if (oldIds.contains(vo.getId())) continue;
            addDeviceSet.add(vo);
        }
        for (NotifyResItem item : oldNotifyResItems) {
            if (newIds.contains(item.getId())) continue;
            delDeviceSet.add(item);
        }
    }

    @Override
    public Response addAlarm(String id, Set<AlarmVO> alarmVoSet) {
        log.trace((Object)"enter addAlarm");
        this.checkUserOperationAuthority("notificationServer_modifyNotificationRule_operateName", 3, "lego.event.notify.modify");
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.convertString2Integer((String)id);
        if (VerifyUtil.isEmpty(alarmVoSet)) {
            this.writeOptLogAndDataErrExc();
        }
        RemoteNotifyRule oldNotifyRule = this.getNotifyRule(id);
        Set notifyAlarmItems = oldNotifyRule.getNotifyAlarmItems();
        HashSet<AlarmVO> addAlarmSet = new HashSet<AlarmVO>();
        HashSet<NotifyAlarmItem> delAlarmSet = new HashSet<NotifyAlarmItem>();
        this.filterAlarm(notifyAlarmItems, alarmVoSet, addAlarmSet, delAlarmSet);
        Object[] alarmTypeListStr = new String[addAlarmSet.size()];
        int i = 0;
        for (AlarmVO alarmVO : addAlarmSet) {
            String alarmId = alarmVO.getAlarmId();
            String alarmName = alarmVO.getAlarmName();
            String severity = alarmVO.getSeverity();
            String alarmType = alarmVO.getAlarmType();
            int level = 0;
            try {
                level = Integer.parseInt(severity);
                Integer.parseInt(alarmType);
                if (this.isLevelNotValid(level)) {
                    this.writeOptLogAndDataErrExc();
                }
            }
            catch (NumberFormatException e) {
                this.writeOptLogAndDataErrExc();
            }
            alarmTypeListStr[i++] = level + "\t" + alarmId + "\t" + alarmName + "\t" + alarmType;
        }
        ArrayList<BatchOperation> delAlarms = new ArrayList<BatchOperation>();
        for (NotifyAlarmItem item : delAlarmSet) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetId(item.getId());
            delAlarms.add(batchOperation);
        }
        if (!VerifyUtil.isEmpty((Object[])alarmTypeListStr)) {
            try {
                service.addAlarm(id, (String[])alarmTypeListStr);
                this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_3", null);
            }
            catch (Exception exception) {
                this.writeFailedOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), exception);
            }
        }
        this.delAlarmItem(service, oldNotifyRule, delAlarms);
        return Response.ok().build();
    }

    private void delAlarmItem(IRemoteNotifyRuleService service, RemoteNotifyRule oldNotifyRule, List<BatchOperation> delAlarms) {
        log.trace((Object)"enter delAlarmItem");
        if (!VerifyUtil.isEmpty(delAlarms)) {
            try {
                service.deleteAlarmItem(delAlarms);
                this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_4", null);
            }
            catch (Exception e) {
                this.writeFailedOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), e);
            }
        }
    }

    private boolean isLevelNotValid(int level) {
        log.trace((Object)"enter isLevelNotValid");
        return level != 1 && level != 2 && level != 3 && level != 4;
    }

    private void filterAlarm(Set<NotifyAlarmItem> oldNotifyAlarmItems, Set<AlarmVO> newAlarmVoSet, Set<AlarmVO> addAlarmSet, Set<NotifyAlarmItem> delAlarmSet) {
        log.trace((Object)"enter filterAlarm");
        ArrayList<Long> newIds = new ArrayList<Long>();
        for (AlarmVO vo : newAlarmVoSet) {
            newIds.add(vo.getId());
            if (vo.getId() >= 0L) continue;
            addAlarmSet.add(vo);
        }
        for (NotifyAlarmItem item : oldNotifyAlarmItems) {
            if (newIds.contains(item.getId())) continue;
            delAlarmSet.add(item);
        }
    }

    static {
        SENDCONTENTMAP.put("severity", "lego.lab.fault.alarmLevel");
        SENDCONTENTMAP.put("alarmName", "lego.lab.fault.saveAlarm.name");
        SENDCONTENTMAP.put("alarmType", "lego.dic.warningtype");
        SENDCONTENTMAP.put("source", "lego.lab.fault.saveAlarm.alarmSource");
        SENDCONTENTMAP.put("createTime", "lego.lab.fault.createTime");
        SENDCONTENTMAP.put("clearStatus", "lego.dic.clearstatus");
        SENDCONTENTMAP.put("alarmDesc", "lego.lab.com.description");
        SENDCONTENTMAP.put("location", "lego.lab.fault.location");
    }
}

