/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.sms.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.sms.service.ISmsRestService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sp.sdk.model.SmsConfig;
import com.huawei.lego.nem.fault.sdk.model.SmsServer;
import com.huawei.lego.nem.fault.sdk.service.ISmsServerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;

public class SmsRestServiceImpl
extends AbstractRestService
implements ISmsRestService {
    private static final Log log = FELogFactory.getInstance((String)"ui");
    private static final int MAX_LENGTH = 32;
    private static final Long DEFALT_ERROR_MSG = 1073947427L;
    private static Map<Integer, Long> errorMsgMap = new ConcurrentHashMap<Integer, Long>();

    @Override
    public Response modifySmsServer(SmsServer smsServerPO) {
        try {
            this.checkSmsServerParam(smsServerPO);
        }
        catch (Exception e) {
            log.info((Object)"Get wrong parameter when setSmsServer", 653110169305088L);
            throw new LegoCheckedException(250L, (Throwable)e);
        }
        this.checkUserOperationAuthority("notificationServer_setMessageServer_operateName", 3, "lego.sys.serverEdit");
        ISmsServerService smsServerService = (ISmsServerService)this.getBundleService("notify", "smsServerService");
        SmsServer oldSmsServer = this.querySmsServer();
        oldSmsServer.setBaudRate(smsServerPO.getBaudRate());
        oldSmsServer.setCountryCode(smsServerPO.getCountryCode());
        oldSmsServer.setPortName(smsServerPO.getPortName());
        oldSmsServer.setTestModemPhone(smsServerPO.getTestModemPhone());
        try {
            smsServerService.modifyModemServer(oldSmsServer);
            this.writeSucOperationLog("notificationServer_setMessageServer_operateName", 3, "messageServer_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_setMessageServer_operateName", 3, "messageServer_objectName", e);
        }
        return Response.ok().build();
    }

    private void checkSmsServerParam(SmsServer smsServerPO) {
        if (Validator.stringNullTrim((String)smsServerPO.getPortName()) || Validator.regCheckStr((String)smsServerPO.getPortName())) {
            throw new LegoCheckedException(250L);
        }
        if (smsServerPO.getPortName().endsWith(" ") || smsServerPO.getPortName().startsWith(" ")) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.checkStringLength((String)smsServerPO.getPortName(), (int)32)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.isDefaultName((String)smsServerPO.getPortName())) {
            throw new LegoCheckedException(250L);
        }
        this.validateServerPo(smsServerPO);
        this.checkTestModemPhone(smsServerPO);
    }

    private void validateServerPo(SmsServer smsServerPO) {
        if (Validator.stringNullTrim((String)smsServerPO.getBaudRate())) {
            throw new LegoCheckedException(250L);
        }
        if (!this.getRate().contains(smsServerPO.getBaudRate())) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.checkStringLength((String)smsServerPO.getCountryCode(), (int)32)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.regExpCheck((String)smsServerPO.getCountryCode(), (String)"^[\\+]{0,1}\\d+$")) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkTestModemPhone(SmsServer smsServerPO) {
        if (!VerifyUtil.isEmpty((String)smsServerPO.getTestModemPhone())) {
            if (!Validator.checkStringLength((String)smsServerPO.getTestModemPhone(), (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.isPhoneInternation((String)smsServerPO.getTestModemPhone())) {
                throw new LegoCheckedException(250L);
            }
        }
    }

    @Override
    public SmsServer querySmsServer() {
        this.checkUserOperationAuthority("notificationServer_queryNotifyServer_operateName", 2, "lego.sys.server.scan");
        ISmsServerService smsServerService = (ISmsServerService)this.getBundleService("notify", "smsServerService");
        SmsServer smsServerPO = smsServerService.getSmsServer();
        if (null == smsServerPO.getProxyIp() || 0 == smsServerPO.getProxyIp().length()) {
            smsServerPO.setProxyIp("");
        }
        if (null == smsServerPO.getIp() || 0 == smsServerPO.getIp().length()) {
            smsServerPO.setIp("");
        }
        if (null == smsServerPO.getProxyPort() || 0 == smsServerPO.getProxyPort().length()) {
            smsServerPO.setProxyPort("5002");
        }
        smsServerPO.setUserName("");
        smsServerPO.setPassword("");
        return smsServerPO;
    }

    private List<String> getRate() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("115200");
        list.add("57600");
        list.add("38400");
        list.add("19200");
        list.add("9600");
        list.add("4800");
        list.add("2400");
        list.add("1200");
        list.add("600");
        list.add("300");
        return list;
    }

    @Override
    @Permission(name={"lego.sys.serverEdit"})
    @Logging(name="notificationServer_sendTestMessage_operateName", object="$1?.testModemPhone", mask=true)
    public Response testSmsServer(SmsServer smsServerPO) {
        int errorCode;
        this.checkSmsServerParam(smsServerPO);
        int smsMode = 2;
        smsServerPO.setSmsMode(2);
        try {
            ISmsServerService smsServerService = (ISmsServerService)this.getBundleService("notify", "smsServerService");
            errorCode = smsServerService.testSendSms((SmsConfig)smsServerPO);
        }
        catch (Exception e) {
            errorCode = 19;
        }
        if (errorCode != 0) {
            Long msg = errorMsgMap.get(errorCode);
            if (msg == null) {
                msg = DEFALT_ERROR_MSG;
            }
            throw new LegoCheckedException(msg.longValue(), "");
        }
        return Response.ok().build();
    }

    static {
        errorMsgMap.put(18, 1073947411L);
        errorMsgMap.put(19, 1073947427L);
        errorMsgMap.put(23, 1073947427L);
        errorMsgMap.put(1000, 1073947410L);
        errorMsgMap.put(8, 1073947427L);
        errorMsgMap.put(9, 1073947427L);
        errorMsgMap.put(6, 1073947426L);
        errorMsgMap.put(7, 1073947427L);
        errorMsgMap.put(1, 1073947426L);
        errorMsgMap.put(2, 1073947427L);
        errorMsgMap.put(3, 1073947427L);
        errorMsgMap.put(4, 1073947427L);
        errorMsgMap.put(5, 1073947427L);
        errorMsgMap.put(10, 1073947427L);
        errorMsgMap.put(11, 1073947424L);
        errorMsgMap.put(12, 1073947427L);
        errorMsgMap.put(13, 1073947427L);
        errorMsgMap.put(14, 1073947427L);
        errorMsgMap.put(15, 1073947409L);
        errorMsgMap.put(16, 1073947427L);
        errorMsgMap.put(17, 1073947416L);
        errorMsgMap.put(20, 1073947415L);
        errorMsgMap.put(21, 1073947413L);
        errorMsgMap.put(22, 1073947412L);
    }
}

