/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.drm.rest.service.framework.system.service.BaseSystemRestServiceImpl;
import com.huawei.ism.drm.rest.service.framework.system.service.ISystemRestService;
import com.huawei.ism.drm.rest.service.framework.system.util.SystemFileUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.system.personaldata.sdk.service.IPersonalDataService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemRestServiceImpl
extends BaseSystemRestServiceImpl
implements ISystemRestService {
    private static final Log logger = FELogFactory.getInstance((String)"ui");
    private static final String EXPORT_CHECKED_TOKEN = "EXPORT_CHECKED_TOKEN";
    private static final String LOGGER_LEGO_NAME = "com.huawei.lego";
    private static final String LOGGER_ISM_NAME = "com.huawei.ism";
    private static final Map<String, Level> levels = ImmutableMap.of((Object)"DEBUG", (Object)Level.DEBUG, (Object)"INFO", (Object)Level.INFO, (Object)"WARN", (Object)Level.WARN, (Object)"ERROR", (Object)Level.ERROR);
    private static Object logExportLocker = new Object();

    @Override
    public Response exportSoftwareArchive() {
        this.checkUserOperationAuthority("dataMaintainence_exportSoftwareArchive_operateName", 1, "ism.drm.dump.software.doc.scan");
        ISoftwareInfoService softwareService = (ISoftwareInfoService)this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
        String templateFileName = "BCManager_template.xml";
        String downloadFileName = "SoftwareArchive.xml";
        String type = this.getText("ultraapm.rd.base.about.title");
        String version = this.getText("ultraapm.rd.base.about.version.value");
        String typePrefix = type + "_";
        try {
            boolean ret;
            SoftwareInfo info = softwareService.getSoftwareInfo();
            ClassLoader clsLoader = this.getClass().getClassLoader();
            if (clsLoader == null) {
                logger.error((Object)"Can not get the clas loader.", 653110170615808L);
                return Response.ok().build();
            }
            URL url = clsLoader.getResource("");
            if (url == null) {
                logger.error((Object)"Can not get the clas loader.", 653110170615808L);
                return Response.ok().build();
            }
            String fileName = url.toURI().getPath() + templateFileName;
            DocumentBuilder db = this.getDocumentBuilder();
            Document doc = db.parse(new File(fileName));
            Element docEle = doc.getDocumentElement();
            this.setNodeAttributeInfo(type, version, typePrefix, info, docEle);
            String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
            File file = new File(downloadPath);
            if (!file.exists() && !(ret = file.mkdir())) {
                logger.error((Object)"create export file directory failed");
                return Response.ok().build();
            }
            File f = new File(downloadPath + File.separator + downloadFileName);
            this.outputXml(doc, f);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            SystemFileUtil.downloadFile((HttpServletResponse)this.getResponse(), (File)f, null, null);
            this.writeSucOperationLog("dataMaintainence_exportSoftwareArchive_operateName", 1, "softwareInfo_objectName", null, null);
        }
        catch (Exception e) {
            logger.error((Object)"exportConfigData", 653110170615808L);
            this.writeFailedOperationLog("dataMaintainence_exportSoftwareArchive_operateName", 1, "softwareInfo_objectName", e);
        }
        return Response.ok().build();
    }

    private void setNodeAttributeInfo(String type, String version, String typePrefix, SoftwareInfo info, Element docEle) {
        HashMap<String, String> neInfoAttr = new HashMap<String, String>();
        neInfoAttr.put("Type", type);
        neInfoAttr.put("NE_ID", typePrefix + info.getSn());
        neInfoAttr.put("Name", typePrefix + info.getIpAddress());
        neInfoAttr.put("Version", version);
        this.setNodeAttribute(docEle, "NEInformation", neInfoAttr);
        HashMap<String, String> softwareVerAttr = new HashMap<String, String>();
        softwareVerAttr.put("Type", "HOSTVER");
        softwareVerAttr.put("SN", typePrefix + info.getSn());
        softwareVerAttr.put("Version", version);
        this.setNodeAttribute(docEle, "SoftwareVersion", softwareVerAttr);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> dateEndAttr = new HashMap<String, String>();
        dateEndAttr.put("datetime", format.format(new Date()));
        this.setNodeAttribute(docEle, "DataEnd", dateEndAttr);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return CommonUtil.createDocumentBuilder((boolean)false);
    }

    private void outputXml(Document doc, File file) {
        logger.trace((Object)"enter outputXml");
        OutputStreamWriter outputWriter = null;
        try {
            TransformerFactory tf = CommonUtil.newSecureTransformer();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset());
            StreamResult result = new StreamResult(outputWriter);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            try {
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.close(outputWriter);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)outputWriter);
    }

    private void setNodeAttribute(Element el, String nodeName, Map<String, String> attributes) {
        logger.trace((Object)"enter setNodeAttribute");
        NodeList neInfo = el.getElementsByTagName(nodeName);
        if (neInfo != null && neInfo.getLength() > 0) {
            Node node = neInfo.item(0);
            NamedNodeMap nnm = node.getAttributes();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                nnm.getNamedItem(entry.getKey()).setNodeValue(entry.getValue());
            }
        }
    }

    @Override
    public Response clearPersonalData() {
        logger.debug((Object)"personal data clearing...");
        this.checkUserOperationAuthority("dataMaintainence_clearPersonalData_operateName", 4, "ism.drm.personal.data.clear");
        IPersonalDataService personalDataService = (IPersonalDataService)this.getBundleService(IPersonalDataService.class);
        try {
            personalDataService.clearPersonalData();
            this.writeSucOperationLog("dataMaintainence_clearPersonalData_operateName", 4, "personalData_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("dataMaintainence_clearPersonalData_operateName", 4, "personalData_objectName", e);
        }
        return Response.ok().build();
    }
}

