/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.trapaddress.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.trapaddress.model.NorthNmsInfoVo;
import com.huawei.ism.drm.rest.service.framework.trapaddress.model.TrapSNMPV3VO;
import com.huawei.ism.drm.rest.service.framework.trapaddress.service.ITrapAddressRestService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.nms.north.sdk.model.NorthNmsInfo;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;

public class TrapAddressRestServiceImpl
extends AbstractRestService
implements ITrapAddressRestService {
    private static transient Log logger = LogFactory.getInstance(TrapAddressRestServiceImpl.class);
    private static final int SNMPV3NORTHTYPE = 1;
    private static final long DEFAULT_SNMPV3_ID = 0L;
    private static final int MAX_PORT = 65535;
    private static final String SPECIAL_STR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";
    private static final String CHINESE_STR = "[^\\x00-\\xff]";
    private static final String CHAR_STR_LOWER = "[a-z]+";
    private static final String CHAR_STR_UPPER = "[A-Z]+";
    private static final String NUM_STR = "[0-9]+";
    private static final String COMPLEX_TWO = "2";
    private static final String COMPLEX_THREE = "3";
    private static final String COMPLEX_FOUR = "4";

    @Override
    public List<NorthNmsInfoVo> queryTrapAddressList(String orderBy, String orderType) {
        INorthNmsService northService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        String orderField = "id";
        boolean orderByAscend = true;
        try {
            if (orderBy != null) {
                Validator.canOrderBy((String)orderBy);
                if ("desc".equalsIgnoreCase(orderType)) {
                    orderByAscend = false;
                }
                if (orderBy.equals("northIp")) {
                    orderField = "northIp";
                }
                if (orderBy.equals("port")) {
                    orderField = "port";
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("OrderBy is error! OrderBy=" + orderBy), 653110170615808L);
            throw e;
        }
        this.checkUserOperationAuthority("northTrap_queryTrapIPAddr_operateName", 2, "lego.sys.grademgr.northnms.scan");
        List nmsNorthList = northService.getNorthNms(orderField, orderByAscend);
        ArrayList<NorthNmsInfoVo> northNmsInfoVos = new ArrayList<NorthNmsInfoVo>();
        if (VerifyUtil.isEmpty((Collection)nmsNorthList)) {
            return northNmsInfoVos;
        }
        for (NorthNmsInfo info : nmsNorthList) {
            northNmsInfoVos.add(this.northNmsToVo(info));
        }
        return northNmsInfoVos;
    }

    private NorthNmsInfoVo northNmsToVo(NorthNmsInfo info) {
        logger.trace((Object)"enter northNmsToVo");
        if (info == null) {
            return null;
        }
        NorthNmsInfoVo vo = new NorthNmsInfoVo();
        vo.setId(info.getId());
        vo.setIp(info.getNorthIp());
        vo.setPort(info.getPort());
        vo.setDescription(info.getDescription());
        vo.setStatus(info.getStatus());
        return vo;
    }

    @Override
    public Response addTrapAddress(NorthNmsInfoVo vo) {
        logger.trace((Object)"enter addTrapAddress");
        this.checkUserOperationAuthority("northTrap_addTrapIPAddr_operateName", 3, "lego.sys.grademgr.northnms.add");
        if (VerifyUtil.isEmpty((Object)vo)) {
            throw new LegoCheckedException(1073947393L);
        }
        NorthNmsInfo info = new NorthNmsInfo();
        Object object = this.getBundleService("slave", "northNmsService");
        INorthNmsService northService = (INorthNmsService)object;
        try {
            if (!Ipv6AddressUtil.isIPv6Address((String)vo.getIp()) && !Validator.isProxyIp((String)vo.getIp())) {
                throw new LegoCheckedException(250L);
            }
            info.setNorthIp(vo.getIp());
            if (vo.getPort() <= 0 || vo.getPort() > 65535) {
                throw new LegoCheckedException(250L);
            }
            info.setPort(vo.getPort().intValue());
            northService.addNorthNms(info);
            this.writeSucOperationLog("northTrap_addTrapIPAddr_operateName", 3, vo.getIp() + ":" + vo.getPort(), null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("northTrap_addTrapIPAddr_operateName", 3, vo.getIp() + ":" + vo.getPort(), e);
        }
        return Response.ok().build();
    }

    @Override
    public NorthNmsInfoVo queryTrapAddress(Long id) {
        logger.trace((Object)"enter queryTrapAddress");
        this.checkUserOperationAuthority("northTrap_queryTrapIPAddr_operateName", 2, "lego.sys.grademgr.northnms.scan");
        Object obj = this.getBundleService("slave", "northNmsService");
        INorthNmsService nmsService = (INorthNmsService)obj;
        NorthNmsInfo nms = nmsService.getNorthNms(id.longValue());
        return this.northNmsToVo(nms);
    }

    @Override
    public BatchOperationResult deleteTrapAddress(Set<Long> ids) {
        logger.trace((Object)"enter deleteTrapAddress");
        this.checkUserOperationAuthority("northTrap_deleteTrapIPAddr_operateName", 2, "lego.sys.grademgr.northnms.delete");
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        List<BatchOperation> bathOprLst = this.getBathOprLst(ids, nmsService);
        BatchOperationResult batchOperationResult = null;
        try {
            if (bathOprLst != null) {
                batchOperationResult = nmsService.deleteNorthNms(bathOprLst);
            }
        }
        catch (Exception e) {
            this.writeFailedOperationLog("northTrap_deleteTrapIPAddr_operateName", 2, "", e);
        }
        this.batchOptLog(batchOperationResult, "northTrap_deleteTrapIPAddr_operateName", 2);
        return batchOperationResult;
    }

    private List<BatchOperation> getBathOprLst(Set<Long> ids, INorthNmsService nmsService) {
        logger.trace((Object)"enter getBathOprLst");
        if (nmsService == null) {
            throw new LegoCheckedException(1073947395L);
        }
        if (!VerifyUtil.isEmpty(ids)) {
            ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>(ids.size());
            for (long id : ids) {
                BatchOperation tempBatch = new BatchOperation();
                tempBatch.setTargetId(id);
                NorthNmsInfo nms = nmsService.getNorthNms(id);
                tempBatch.setTargetName(nms.getNorthIp() + ":" + nms.getPort());
                bathOprLst.add(tempBatch);
            }
            return bathOprLst;
        }
        throw new LegoCheckedException(250L);
    }

    @Override
    public Response modifyTrapAddress(NorthNmsInfoVo vo, Long id) {
        logger.trace((Object)"enter modifyTrapAddress");
        CommUtils.checkParamEmpty((Object[])new Object[]{vo, id});
        vo.setId(id);
        this.checkUserOperationAuthority("northTrap_modifyTrapIPAddr_operateName", 3, "lego.sys.grademgr.northnms.modify");
        Object obj = this.getBundleService("slave", "northNmsService");
        INorthNmsService nmsService = (INorthNmsService)obj;
        NorthNmsInfo nms = nmsService.getNorthNms(id.longValue());
        String oldIp = nms.getNorthIp();
        String oldPort = String.valueOf(nms.getPort());
        try {
            if ("IPV4".equals(AddressUtil.ipType((String)vo.getIp())) ? !Validator.isProxyIp((String)vo.getIp()) : !Ipv6AddressUtil.isIPv6Address((String)vo.getIp())) {
                throw new LegoCheckedException(250L);
            }
            if (vo.getPort() <= 0 || vo.getPort() > 65535) {
                throw new LegoCheckedException(250L);
            }
            this.voToNorthNms(vo, nms);
            nmsService.modifyNorthNms(nms);
            this.writeSucOperationLog("northTrap_modifyTrapIPAddr_operateName", 3, oldIp + ":" + oldPort, "northTrap_modifyTrapIPAddr_operateDetail", new String[]{oldIp, oldPort, nms.getNorthIp(), String.valueOf(nms.getPort())});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("northTrap_modifyTrapIPAddr_operateName", 3, oldIp + ":" + oldPort, e);
        }
        return Response.ok().build();
    }

    private void voToNorthNms(NorthNmsInfoVo vo, NorthNmsInfo northNmsInfo) {
        logger.trace((Object)"enter voToNorthNms");
        northNmsInfo.setNorthIp(vo.getIp());
        northNmsInfo.setPort(vo.getPort().intValue());
    }

    @Override
    public TrapSNMPV3VO getTrapParamConfig() {
        logger.trace((Object)"enter getTrapParamConfig");
        this.checkUserOperationAuthority("northTrap_queryTrapParams_operateName", 2, "lego.sys.grademgr.nms.trapConfig.scan");
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        SnmpV3Param temptrapConf = nmsService.getTrapConf(1);
        if (null != temptrapConf) {
            TrapSNMPV3VO northTrapConfVO = new TrapSNMPV3VO(temptrapConf);
            northTrapConfVO.setAuthPwd("");
            northTrapConfVO.setEncryptPwd("");
            northTrapConfVO.setType(temptrapConf.getType());
            return northTrapConfVO;
        }
        TrapSNMPV3VO northTrapConfVO = new TrapSNMPV3VO();
        northTrapConfVO.setId(0L);
        northTrapConfVO.setAuthProtocol("");
        northTrapConfVO.setAuthPwd("");
        northTrapConfVO.setContextEngineId("");
        northTrapConfVO.setContextName("");
        northTrapConfVO.setEncryptProtocol("");
        northTrapConfVO.setEncryptPwd("");
        northTrapConfVO.setSecurityName("");
        northTrapConfVO.setType(1);
        return northTrapConfVO;
    }

    @Override
    public Response saveNorthTrapConfig(TrapSNMPV3VO northTrapConfVO) {
        logger.trace((Object)"enter saveNorthTrapConfig");
        if (northTrapConfVO == null) {
            throw new LegoCheckedException(250L);
        }
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        long id = northTrapConfVO.getId();
        SnmpV3Param tempsnmpv3 = nmsService.getTrapConf(1);
        if (tempsnmpv3 != null) {
            long idExist = tempsnmpv3.getSnmpV3ParamId();
            this.checkNorthTrapConfVO(northTrapConfVO, id, idExist);
            if (Validator.stringisNull((String)northTrapConfVO.getAuthPwd()) || Validator.stringisNull((String)northTrapConfVO.getEncryptPwd())) {
                if (Validator.stringisNull((String)northTrapConfVO.getAuthPwd())) {
                    northTrapConfVO.setAuthPwd(tempsnmpv3.getAuthPwd());
                }
                if (Validator.stringisNull((String)northTrapConfVO.getEncryptPwd())) {
                    northTrapConfVO.setEncryptPwd(tempsnmpv3.getPrivPwd());
                }
            }
        } else {
            if (Validator.stringisNull((String)northTrapConfVO.getAuthPwd()) || Validator.stringisNull((String)northTrapConfVO.getEncryptPwd())) {
                throw new LegoCheckedException(250L);
            }
            this.checkNorthTrapConfVOPwdComplex(northTrapConfVO);
        }
        this.checkSnmpv3Para(northTrapConfVO);
        SnmpV3Param snmpv3 = this.trapVO2SNMPV3(northTrapConfVO);
        snmpv3.setType(Integer.valueOf(1));
        this.checkUserOperationAuthority("northTrap_modifyTrapParams_operateName", 3, "lego.sys.grademgr.nms.trapConfig.modify");
        try {
            if (null == tempsnmpv3) {
                snmpv3.setSnmpV3ParamId(null);
            }
            nmsService.saveTrapConf(snmpv3);
            this.writeSucOperationLog("northTrap_modifyTrapParams_operateName", 3, "northTrapParams_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("northTrap_modifyTrapParams_operateName", 3, "northTrapParams_objectName", e);
        }
        return Response.ok().build();
    }

    private void checkNorthTrapConfVO(TrapSNMPV3VO northTrapConfVO, long id, long idExist) {
        if (id != idExist) {
            logger.error((Object)"not exist!", 653110169305088L);
            throw new LegoCheckedException(250L);
        }
        this.checkNorthTrapConfVOPwdComplex(northTrapConfVO);
    }

    private void checkNorthTrapConfVOPwdComplex(TrapSNMPV3VO northTrapConfVO) {
        logger.trace((Object)"enter checkNorthTrapConfVOPwdComplex");
        if (!this.isPwdMatchComplex(northTrapConfVO.getAuthPwd())) {
            throw new LegoCheckedException(250L);
        }
        if (!this.isPwdMatchComplex(northTrapConfVO.getEncryptPwd())) {
            throw new LegoCheckedException(250L);
        }
    }

    private boolean isPwdMatchComplex(String password) {
        logger.trace((Object)"enter isPwdMatchComplex");
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        String complex = mgr.getSystemSecPolicy().getUserSecPolicy().getComplex();
        if (Validator.stringisNull((String)password)) {
            return true;
        }
        password = Normalizer.normalize(password, Normalizer.Form.NFKC);
        if (Pattern.compile(CHINESE_STR).matcher(password).find()) {
            return false;
        }
        return !(COMPLEX_TWO.equalsIgnoreCase(complex.trim()) ? !this.isPwdMatchComplexSecond(password) : (COMPLEX_THREE.equalsIgnoreCase(complex.trim()) ? !Pattern.compile(SPECIAL_STR).matcher(password).find() : COMPLEX_FOUR.equalsIgnoreCase(complex.trim()) && this.checkPwdComplexFour(password) == false));
    }

    private boolean isPwdMatchComplexSecond(String password) {
        boolean flag3;
        logger.trace((Object)"enter isPwdMatchComplexSecond");
        boolean flag1 = !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean flag2 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean bl = flag3 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        return !flag1 || !flag2 || !flag3;
    }

    private Boolean checkPwdComplexFour(String password) {
        logger.trace((Object)"enter checkPwdComplexFour");
        if (!(Pattern.compile(SPECIAL_STR).matcher(password).find() && Pattern.compile(CHAR_STR_LOWER).matcher(password).find() && Pattern.compile(CHAR_STR_UPPER).matcher(password).find() && Pattern.compile(NUM_STR).matcher(password).find())) {
            return false;
        }
        return true;
    }

    private SnmpV3Param trapVO2SNMPV3(TrapSNMPV3VO vo) {
        logger.trace((Object)"enter trapVO2SNMPV3");
        SnmpV3Param snmpv3 = new SnmpV3Param();
        snmpv3.setAuthPwd(vo.getAuthPwd());
        snmpv3.setPrivPwd(vo.getEncryptPwd());
        if ("HMACMD5".equals(vo.getAuthProtocol())) {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.MD5_AUTH);
        } else if ("HMAC_SHA1".equals(vo.getAuthProtocol())) {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.SHA1_AUTH);
        } else if ("HMAC_SHA2".equals(vo.getAuthProtocol())) {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.SHA2_AUTH);
        } else {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.NO_AUTH);
            snmpv3.setAuthPwd("");
        }
        if ("DES".equals(vo.getEncryptProtocol())) {
            snmpv3.setPrivProtocol(SnmpEnum.PrivProtocol.CBC_DES);
        } else if ("AES".equals(vo.getEncryptProtocol())) {
            snmpv3.setPrivProtocol(SnmpEnum.PrivProtocol.CFB_AES_128);
        } else {
            snmpv3.setPrivProtocol(SnmpEnum.PrivProtocol.NO_PRIV);
            snmpv3.setPrivPwd("");
        }
        if (!VerifyUtil.isEmpty((String)vo.getContextName())) {
            snmpv3.setContextName(vo.getContextName());
        }
        if (!VerifyUtil.isEmpty((String)vo.getContextEngineId())) {
            snmpv3.setContextEngineId(vo.getContextEngineId());
        }
        snmpv3.setSecurityName(vo.getSecurityName());
        snmpv3.setSnmpV3ParamId(vo.getId());
        return snmpv3;
    }

    private void checkSnmpv3Para(TrapSNMPV3VO snmpv3) {
        logger.trace((Object)"enter checkSnmpv3Para");
        ArrayList<String> authProtocolList = new ArrayList<String>();
        authProtocolList.add("HMACMD5");
        authProtocolList.add("HMAC_SHA1");
        authProtocolList.add("HMAC_SHA2");
        ArrayList<String> encryptProtocolList = new ArrayList<String>();
        encryptProtocolList.add("DES");
        encryptProtocolList.add("AES");
        if (Validator.stringisNull((String)snmpv3.getSecurityName()) || !Validator.checkStringLength((String)snmpv3.getSecurityName(), (int)64)) {
            throw new LegoCheckedException(250L);
        }
        if (!VerifyUtil.isEmpty((String)snmpv3.getContextName()) && !Validator.checkStringLength((String)snmpv3.getContextName(), (int)64)) {
            throw new LegoCheckedException(250L);
        }
        this.validateContextParams(snmpv3);
        this.checkSnmpv3Para2(snmpv3, authProtocolList, encryptProtocolList);
    }

    private void validateContextParams(TrapSNMPV3VO snmpv3) {
        logger.trace((Object)"enter validateContextParams");
        if (!VerifyUtil.isEmpty((String)snmpv3.getContextEngineId())) {
            if (!Validator.checkStringLength((String)snmpv3.getContextEngineId(), (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.checkMinStringLength((String)snmpv3.getContextEngineId(), (int)5)) {
                throw new LegoCheckedException(250L);
            }
        }
        if (Validator.stringisNull((String)snmpv3.getAuthProtocol()) && !Validator.stringisNull((String)snmpv3.getEncryptProtocol())) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkSnmpv3Para2(TrapSNMPV3VO snmpv3, List<String> authProtocolList, List<String> encryptProtocolList) {
        logger.trace((Object)"enter checkSnmpv3Para2");
        if (!Validator.stringisNull((String)snmpv3.getAuthProtocol())) {
            if (!authProtocolList.contains(snmpv3.getAuthProtocol())) {
                throw new LegoCheckedException(250L);
            }
            if (Validator.stringisNull((String)snmpv3.getAuthPwd())) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.checkStringLength((String)snmpv3.getAuthPwd(), (int)64)) {
                throw new LegoCheckedException(250L);
            }
        }
        this.validateEncryptProtocol(snmpv3, encryptProtocolList);
    }

    private void validateEncryptProtocol(TrapSNMPV3VO snmpv3, List<String> encryptProtocolList) {
        logger.trace((Object)"enter validateEncryptProtocol");
        if (!Validator.stringisNull((String)snmpv3.getEncryptProtocol())) {
            if (!encryptProtocolList.contains(snmpv3.getEncryptProtocol())) {
                throw new LegoCheckedException(250L);
            }
            if (Validator.stringisNull((String)snmpv3.getEncryptPwd())) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.checkStringLength((String)snmpv3.getEncryptPwd(), (int)64)) {
                throw new LegoCheckedException(250L);
            }
        }
    }
}

