/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.userauth.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.userauth.model.OneTimeTokenRequest;
import com.huawei.ism.drm.rest.service.framework.userauth.model.OneTimeTokenVo;
import com.huawei.ism.drm.rest.service.framework.userauth.model.TokenInfo;
import com.huawei.ism.drm.rest.service.framework.userauth.model.TokenLoginRequest;
import com.huawei.ism.drm.rest.service.framework.userauth.service.BaseUserAuthRestServiceImpl;
import com.huawei.ism.drm.rest.service.framework.userauth.service.IUserAuthRestService;
import com.huawei.ism.drm.rest.util.OneTimeTokenUtils;
import com.huawei.ism.drm.rest.util.RandCodeCheck;
import com.huawei.ism.drm.web.constants.OneTimeTokenConstants;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UserAuthRestServiceImpl
extends BaseUserAuthRestServiceImpl
implements IUserAuthRestService {
    private static final Log log = LogFactory.getInstance(UserAuthRestServiceImpl.class);
    private static final Map<Long, OneTimeTokenConstants> ONE_TIME_TOKEN_ERROR_MAP = Collections.unmodifiableMap(new HashMap<Long, OneTimeTokenConstants>(){
        private static final long serialVersionUID = -537863131016435963L;
        {
            this.put(308L, OneTimeTokenConstants.PASSWORD_EXPIRED_ERROR);
            this.put(282L, OneTimeTokenConstants.PASSWORD_OR_USERNAME_ERROR);
            this.put(1073947449L, OneTimeTokenConstants.SYNC_ADMIN_NOT_ALLOW_ERROR);
            this.put(1073947435L, OneTimeTokenConstants.PASSWORD_EXPIRED_ERROR);
            this.put(256L, OneTimeTokenConstants.PASSWORD_OR_USERNAME_ERROR);
            this.put(284L, OneTimeTokenConstants.ACCOUNT_IS_LOCK_ERROR);
            this.put(293L, OneTimeTokenConstants.ACCOUNT_IS_LOCK_ERROR);
            this.put(1073947448L, OneTimeTokenConstants.USER_ONLINE_NUM_ERROR);
            this.put(250L, OneTimeTokenConstants.PASSWORD_OR_USERNAME_ERROR);
        }
    });

    @Override
    public OneTimeTokenVo getOneTimeToken(OneTimeTokenRequest request) {
        OneTimeTokenVo oneTimeTokenVo;
        SysOptLog.Builder sysOptLogBuilder = SysOptLog.builder().operation("onetime_token_create_operateName").operator(request.getUsername()).target(request.getUsername()).terminalIp(UserAuthRestServiceImpl.getRemoteAddr((HttpServletRequest)this.getRequest()));
        try {
            log.info((Object)String.format(Locale.ROOT, "Method getOneTimeToken start,user:%s.", request.getUsername()));
            this.checkOneTimeParams(request);
            String token = OneTimeTokenUtils.createToken(request.getUsername(), request.getPassword());
            oneTimeTokenVo = new OneTimeTokenVo(OneTimeTokenConstants.SUCCESS, token);
            log.info((Object)String.format(Locale.ROOT, "Method getOneTimeToken end,user:%s.", request.getUsername()));
            sysOptLogBuilder.success().level(1);
        }
        catch (LegoCheckedException ex) {
            oneTimeTokenVo = this.createErrorMsg(ex);
            sysOptLogBuilder.fail().level(2).detail("lego.err." + ex.getErrorCode());
        }
        sysOptLogBuilder.build().writeOperateLog();
        return oneTimeTokenVo;
    }

    private OneTimeTokenVo createErrorMsg(LegoCheckedException ex) {
        OneTimeTokenVo oneTimeTokenVo;
        OneTimeTokenConstants constants = ONE_TIME_TOKEN_ERROR_MAP.get(ex.getErrorCode());
        if (constants == null) {
            log.error((Object)"LegoCheckedException errorCode is %s.", new Object[]{String.valueOf(ex.getErrorCode())});
            oneTimeTokenVo = new OneTimeTokenVo(OneTimeTokenConstants.TOKEN_MAX_NUM_ERROR, "");
        } else {
            oneTimeTokenVo = new OneTimeTokenVo(constants, "");
        }
        return oneTimeTokenVo;
    }

    private void checkOneTimeParams(OneTimeTokenRequest request) {
        Date passChangeDate;
        long betweenDate;
        if (VerifyUtil.isEmpty((Object)request) || VerifyUtil.isEmpty((String)request.getUsername()) || VerifyUtil.isEmpty((String)request.getPassword())) {
            log.error((Object)"Param request is null.");
            throw new LegoCheckedException(256L);
        }
        this.checkUserAndPassword(request.getUsername(), request.getPassword());
        HttpServletRequest servletRequest = this.getRequest();
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        User currentUser = mgr.validationForOneTimeToken(this.getUserObj(request.getUsername(), request.getPassword(), servletRequest));
        Date currentTime = new Date();
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        if (this.checkChangePolicy(currentUser, usrPolicy) && (betweenDate = ((passChangeDate = new Date(currentUser.getSetTime())).getTime() - currentTime.getTime()) / 86400000L + (long)usrPolicy.getUsefulLife().intValue()) <= 0L) {
            log.error((Object)"Parameter password is expired.");
            throw new LegoCheckedException(308L);
        }
    }

    @Override
    public String oneTimeTokenLogin(TokenLoginRequest request) {
        String result;
        String userName = "";
        try {
            if (VerifyUtil.isEmpty((String)request.getToken())) {
                log.error((Object)"Parameter token is null.");
                throw new LegoCheckedException(1073947393L);
            }
            Optional<TokenInfo> tokenInfoOptional = OneTimeTokenUtils.getTokenInfo(request.getToken());
            if (!tokenInfoOptional.isPresent()) {
                log.error((Object)"Parameter token is invalids.");
                throw new LegoCheckedException(1077949113L);
            }
            OneTimeTokenUtils.removeToken(request.getToken());
            TokenInfo tokenInfo = tokenInfoOptional.get();
            userName = tokenInfo.getName();
            String userPwd = tokenInfo.getPwd();
            log.info((Object)"Login start,user:%s.", new Object[]{userName});
            result = this.doOneTimeTokenLogin(userName, userPwd, request.getLang());
            RandCodeCheck.removeUserName((String)userName);
            this.writeSucOperationLog("user_login_operateName", 1, userName, null, null);
        }
        catch (Exception ex) {
            SysOptLog.Builder sysOptLogBuilder = SysOptLog.builder().fail().operation("user_login_operateName").operator(userName).level(2).target(userName).terminalIp(UserAuthRestServiceImpl.getRemoteAddr((HttpServletRequest)this.getRequest()));
            if (ex instanceof LegoCheckedException) {
                LegoCheckedException checkedException = (LegoCheckedException)((Object)ex);
                sysOptLogBuilder.detail("lego.err." + checkedException.getErrorCode()).detailPara(checkedException.getParameters());
            } else {
                sysOptLogBuilder.detail("lego.err.-1");
            }
            sysOptLogBuilder.build().writeOperateLog();
            throw ex;
        }
        log.info((Object)"Login end,user:%s.", new Object[]{userName});
        return result;
    }

    private String doOneTimeTokenLogin(String userName, String userPwd, String lang) {
        HttpServletRequest servletRequest = this.getRequest();
        HttpSession oldSession = servletRequest.getSession();
        oldSession.removeAttribute("rd_randomStr_HW");
        oldSession.removeAttribute("LOGIN_NEED_LIC ");
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        User currentUser = mgr.login(this.getUserObj(userName, userPwd, servletRequest), true);
        oldSession.invalidate();
        currentUser.setLoginTime(new Date().getTime());
        currentUser.setIpAdr(UserAuthRestServiceImpl.getRemoteAddr((HttpServletRequest)servletRequest));
        log.info((Object)"Invalid oldSession,user:%s .", new Object[]{userName});
        HttpSession currentSession = this.getRequest().getSession();
        currentSession.setAttribute("WW_TRANS_I18N_LOCALE", (Object)this.setLocale(lang));
        currentSession.setAttribute("user.login.mode", (Object)"local");
        CookieUtil.addCookie((HttpServletResponse)this.getResponse(), (String)"rd_language", (String)lang, (String)"/src/");
        Date date = new Date();
        currentUser.setLoginTime(date.getTime());
        currentUser.setLoginDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
        String randomToken = (String)TokenGenerator.getToken((int)32).orElseThrow(() -> new LegoCheckedException(1073947393L));
        CookieUtil.addCookie((HttpServletResponse)this.getResponse(), (String)"rd_randomStr_HW", (String)randomToken, (String)"/src/");
        this.getSession().setAttribute("rd_randomStr_HW", (Object)randomToken);
        this.getResponse().addHeader("rd_randomStr_HW", randomToken);
        this.getSession().setAttribute("currentUser", (Object)currentUser);
        this.getSession().setAttribute("passState", (Object)"ok");
        String username = currentUser.getUserName();
        try {
            URLEncoder.encode(username, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Encode username fail,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        CookieUtil.addCookie((HttpServletResponse)this.getResponse(), (String)"userName", (String)username, (String)"/src/");
        CookieUtil.addCookie((HttpServletResponse)this.getResponse(), (String)"user.login.mode", (String)"local", (String)"/src/");
        CookieUtil.addCookie((HttpServletResponse)this.getResponse(), (String)"isAdministrator", (String)String.valueOf(this.checkIsAdministrator(currentUser.getUserId())), (String)"/src/");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"userName", (Object)currentUser.getUserName());
        jsonObject.put((Object)"isAdmin", (Object)currentUser.getIsAdmin());
        jsonObject.put((Object)"isAdministrator", (Object)this.checkIsAdministrator(currentUser.getUserId()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)currentUser.getRolesIdsSet());
        jsonObject.put((Object)"rolesIds", (Object)jsonArray);
        log.info((Object)"Login success,user:%s .", new Object[]{userName});
        return jsonObject.toString();
    }
}

