/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.cloudresource;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.model.CloudRegion;
import com.huawei.ism.drm.backup.service.ICloudRegionService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.cloudresource.ICloudRegionRestService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.List;
import javax.ws.rs.core.Response;

public class CloudRegionRestServiceImpl
extends AbstractRestService
implements ICloudRegionRestService {
    private static final Log logger = LogFactory.getInstance(CloudRegionRestServiceImpl.class);

    @Override
    public Response createCloudRegion(CloudRegion cloudRegion) {
        if (VerifyUtil.isEmpty((Object)cloudRegion)) {
            logger.error((Object)"cloudRegion is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkCloudRegionParam(cloudRegion);
        try {
            this.getcloudRegionService().createCloudRegion(cloudRegion);
            this.writeSucOperationLog("cloudRegion_createCloudRegion_operateName", 3, cloudRegion.getName(), "cloudRegion_createCloudRegion_operateDetail", new String[]{cloudRegion.getName()});
        }
        catch (Exception e) {
            logger.error((Object)("Create cloudRegion failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("cloudRegion_createCloudRegion_operateName", 3, cloudRegion.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response updateCloudRegion(String uuid, CloudRegion cloudRegion) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)("uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        CloudRegion localCloudRegion = this.getcloudRegionService().getCloudRegion(uuid);
        if (null == localCloudRegion) {
            throw new LegoCheckedException(2117645L);
        }
        if (localCloudRegion.getIspreSet().booleanValue()) {
            throw new LegoCheckedException(1073947393L);
        }
        String oldName = localCloudRegion.getName();
        cloudRegion.setUuid(uuid);
        cloudRegion.setIspreSet(localCloudRegion.getIspreSet());
        this.checkCloudRegionParam(cloudRegion);
        try {
            this.getcloudRegionService().updateCloudRegion(cloudRegion);
            this.writeSucOperationLog("cloudRegion_modifyCloudRegion_operateName", 3, cloudRegion.getName(), "cloudRegion_modifyCloudRegion_operateDetail", new String[]{cloudRegion.getName()});
        }
        catch (Exception e) {
            logger.error((Object)("Modify cloudRegion failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("cloudRegion_modifyCloudRegion_operateName", 3, oldName, e);
        }
        return Response.ok().build();
    }

    @Override
    public Response deleteCloudRegion(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)("enter deleteCloudRegion. uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        CloudRegion localCloudRegion = this.getcloudRegionService().getCloudRegion(uuid);
        if (null == localCloudRegion) {
            throw new LegoCheckedException(2117645L);
        }
        if (localCloudRegion.getIspreSet().booleanValue()) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.getcloudRegionService().deleteCloudRegion(uuid);
            this.writeSucOperationLog("cloudRegion_deleteCloudRegion_operateName", 3, localCloudRegion.getName(), "cloudRegion_deleteCloudRegion_operateDetail", new String[]{localCloudRegion.getName()});
        }
        catch (Exception e) {
            logger.error((Object)("Delete cloudRegion failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("cloudRegion_deleteCloudRegion_operateName", 3, localCloudRegion.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public CloudRegion getCloudRegion(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)("parameter is null. uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        CloudRegion cloudRegion = this.getcloudRegionService().getCloudRegion(uuid);
        return cloudRegion;
    }

    @Override
    public String listCloudRegion() {
        List cloudRegionList = this.getcloudRegionService().listCloudRegion();
        JSONObject json = new JSONObject();
        json.put((Object)"totalCount", (Object)cloudRegionList.size());
        JSONArray listArray = JSONArray.fromObject((Object)cloudRegionList);
        json.put((Object)"records", (Object)listArray.toString());
        return json.toString();
    }

    private void checkCloudRegionParam(CloudRegion cloudRegion) {
        Boolean paramFlag1 = CommUtils.checkParam((String)cloudRegion.getName(), (int)256) && CommUtils.checkStr((String)cloudRegion.getName(), (String)"^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$") && CommUtils.checkParam((String)cloudRegion.getRegionId(), (int)256);
        if (!paramFlag1.booleanValue()) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private ICloudRegionService getcloudRegionService() {
        return (ICloudRegionService)this.getBundleService(ICloudRegionService.class.getName(), ICloudRegionService.class);
    }
}

