/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.rest.service.platform.protection.group.BaseProtectGroupRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.protection.group.IProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.BackupImage;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProtectGroupRestService
extends BaseProtectGroupRestServiceImpl
implements IProtectGroupRestService {
    private static Log log = LogFactory.getInstance(AbstractProtectGroupRestService.class);
    protected static final String TYPE_PARAM_KEY = "{type}";
    private static final int MAX_DELAY_TIME = 1410;
    private IStorageService storageService = null;

    protected IStorageService getStorageService() {
        if (this.storageService != null) {
            return this.storageService;
        }
        log.debug((Object)"getStorageService is invoked");
        this.storageService = (IStorageService)this.getBundleService(IStorageService.class);
        return this.storageService;
    }

    protected String responseJsonResult(Object object, String[] excludes) {
        log.debug((Object)("object:" + object));
        return JSONObject.fromObject((Object)object, (String[])excludes).toString();
    }

    protected boolean validateDbAuthInfo(Integer poType, ProtectObject po) {
        log.debug((Object)("poType:" + poType + ". po:" + po));
        IProtectObjectProviderDelegate poService = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        return poService.validateDbAuthInfo(poType.intValue(), po);
    }

    protected void checkCanBeRemoved(ProtectObject po) {
        if (po.getPoType() == 99) {
            log.error((Object)"potype is equals with DRM_PROTECTOBJ_REPLICATION_TYPE");
            throw new LegoCheckedException(-1L);
        }
    }

    protected boolean checkProtectGroupParam(String groupName, String pgAppType, String pgDesc, PolicyTemplate template) {
        return !CommUtils.checkDrmNameParam((String)groupName) || !this.checkDrmProtectObjectTypeParam(pgAppType) || !CommUtil.checkDrmDescParam((String)pgDesc) || VerifyUtil.isEmpty((Object)template) || "null".equals(groupName);
    }

    protected void checkScheduleCounts(Set<Schedule> scs, Schedule newSch) {
        for (Schedule schedule : scs) {
            if (schedule.getProtectLocation() != newSch.getProtectLocation() || schedule.getScheduleMode() != 0) continue;
            log.error((Object)("protectLocation:" + schedule.getProtectLocation() + ".new protectLocation:" + newSch.getProtectLocation() + ".scheduleMode:" + schedule.getScheduleMode()));
            throw new LegoCheckedException(-1L);
        }
    }

    protected void addProtectObject(Set<ProtectObject> protectObjectSet) {
        log.debug((Object)("protectObjectSet:" + protectObjectSet));
        for (ProtectObject po : protectObjectSet) {
            String uuid = po.getUuid();
            if (VerifyUtil.isEmpty((String)uuid)) {
                uuid = UUIDGenerator.getUUID();
            }
            po.setUuid(uuid);
        }
    }

    protected void checkHyperCloneProps(PolicyTemplate policyTemplate) {
        if (policyTemplate.getType() != 16) {
            return;
        }
        String cloneSplitCofig = (String)policyTemplate.getProps().get("CLONE_SPLIT");
        if (VerifyUtil.isEmpty((String)cloneSplitCofig)) {
            return;
        }
        JSONObject prJsonObj = JSONObject.fromObject((Object)cloneSplitCofig);
        if (prJsonObj.containsKey((Object)"split_delay_time")) {
            try {
                int splitDelayTime = Integer.parseInt(prJsonObj.getString("split_delay_time"));
                if (splitDelayTime < 1 || splitDelayTime > 1410) {
                    log.error((Object)("checkHyperCloneProps failed, delay_time=" + splitDelayTime));
                    throw new LegoCheckedException(1073947393L);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)"split_delay_time is error", (Throwable)e);
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
    }

    protected void checkSnapHostNumberStr(PolicyTemplate policyTemplate) {
        List<Integer> snapshotTypeList = Arrays.asList(2, 17, 28, 19);
        if (!snapshotTypeList.contains(policyTemplate.getType())) {
            return;
        }
        Map props = policyTemplate.getProps();
        if (VerifyUtil.isEmpty((Map)props)) {
            log.error((Object)"props is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (policyTemplate.getType() == 2) {
            int value = NumberUtil.convertToInteger(props.get("PP_SNAPSHOT_COUNT"));
            if (value < 1 || value > 2048) {
                log.error((Object)("the snapshot num is out of the limit:[1,2048], num:" + value), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            return;
        }
        this.checkMultiSnapShotNumber(policyTemplate);
    }

    private void checkMultiSnapShotNumber(PolicyTemplate policyTemplate) {
        int remoteCnt = NumberUtil.convertToInteger(policyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + DrmEnumDefine.ProtectLocation.B_B.getValue()));
        String localCntStr = (String)policyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + DrmEnumDefine.ProtectLocation.A_A.getValue());
        if (policyTemplate.getType() == 28) {
            if (remoteCnt < 3 || remoteCnt > 2048) {
                log.error((Object)("the snapshot num is out of the limit:[3,2048], num:" + remoteCnt), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            if (!VerifyUtil.isEmpty((String)localCntStr)) {
                log.error((Object)("lcoalCnt is not empty " + localCntStr), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            return;
        }
        int localCnt = NumberUtil.convertToInteger((Object)localCntStr);
        if (policyTemplate.getType() == 17) {
            if (localCnt < 3 || localCnt > 2048 || remoteCnt < 3 || remoteCnt > 2048) {
                log.error((Object)("the snapshot num is out of the limit:[3,2048], num:" + localCnt + " " + remoteCnt), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        } else if (policyTemplate.getType() == 19) {
            int localMaxNum = 2048;
            int remoteMaxNum = 2048;
            if (ProtectGroupValidator.isExistsSecondSchedule((PolicyTemplate)policyTemplate, (int)DrmEnumDefine.ProtectLocation.A_A.getValue())) {
                localMaxNum = 60000;
            }
            if (ProtectGroupValidator.isExistsSecondSchedule((PolicyTemplate)policyTemplate, (int)DrmEnumDefine.ProtectLocation.B_B.getValue())) {
                remoteMaxNum = 60000;
            }
            if (localCnt < 1 || localCnt > localMaxNum || remoteCnt < 1 || remoteCnt > remoteMaxNum) {
                log.error((Object)("the snapshot num is out of the limit:[3,2048], num:" + localCnt + " " + remoteCnt), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private void setStorageIp(Map<String, StorageUnit> storageCacheMap, JSONObject jsonObject, ProtectGroupReplica pgReplica) {
        if (!VerifyUtil.isEmpty((Object)pgReplica)) {
            StorageUnit storageUnit;
            String devSn;
            String pathStr;
            if (pgReplica.isBackUpReplica() && !VerifyUtil.isEmpty((String)(pathStr = (String)pgReplica.getProps().get("IMAGE_BACKUPPATH")))) {
                BackupImage.BackupPath path = (BackupImage.BackupPath)JSONObject.toBean((String)pathStr, BackupImage.BackupPath.class);
                jsonObject.put((Object)"storageIp", (Object)(path.getBricksIP() + ":" + path.getBricksBucket()));
                return;
            }
            IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
            String deviceId = replicaService.getDeviceId(pgReplica);
            String string = devSn = deviceId == null ? pgReplica.getRecoveryArray() : deviceId;
            if (storageCacheMap.containsKey(devSn)) {
                storageUnit = storageCacheMap.get(devSn);
            } else {
                storageUnit = ((IStorageService)ServiceLocator.getBundleService((String)"DRM_Base", (String)IStorageService.class.getName())).getStorageUnitBySn(devSn);
                storageCacheMap.put(devSn, storageUnit);
            }
            if (!VerifyUtil.isEmpty((Object)storageUnit)) {
                jsonObject.put((Object)"storageIp", (Object)storageUnit.getIpAddress());
            }
        }
    }

    protected String getHostName(Map<String, String> hostCacheMap, Map<String, String> ecsServers, String hostId, ProtectGroup pg, Site site) {
        if (VerifyUtil.isEmpty((String)hostId)) {
            return hostId;
        }
        if (hostCacheMap.containsKey(hostId)) {
            return hostCacheMap.get(hostId);
        }
        String hostName = hostId;
        if (pg.getPoType() == 10) {
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("uuid", hostId);
            List moLists = ((IResourceService)this.getBundleService(IResourceService.class)).queryMoList(ManagedObject.class, querys);
            if (!VerifyUtil.isEmpty((Collection)moLists)) {
                ManagedObject mo = (ManagedObject)moLists.get(0);
                hostName = mo.getName();
            }
            hostCacheMap.put(hostId, hostName);
            return hostName;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(hostId);
        if (drResource != null) {
            hostName = drResource.getName();
        }
        hostCacheMap.put(hostId, hostName);
        return hostName;
    }

    @Override
    public Response syncProtectGroupInfo(RestJsonRequest request) throws ClassNotFoundException {
        log.info((Object)"begin syncProtectGroupInfo between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_modifyPG_operateName", SysoplogLevel.NORMAL.getValue(), "ism.drm.protectgroup.auth.modify");
        ProtectGroup clonedProtectGroup = null;
        CommUtils.checkParamEmpty((Object[])new Object[]{request});
        ProtectGroup protectGroup = (ProtectGroup)request.toObject();
        this.checkUserBizObjAuthority("protectedGroup_modifyPG_operateName", SysoplogLevel.NORMAL.getValue(), protectGroup.getUuid());
        try {
            clonedProtectGroup = (ProtectGroup)protectGroup.clone();
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).syncProtectGroup(clonedProtectGroup);
            this.writeSucOperationLog("protectedGroup_modifyPG_operateName", SysoplogLevel.NORMAL.getValue(), clonedProtectGroup == null ? "" : clonedProtectGroup.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("syncProtectGroupInfo failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            this.writeFailedOperationLog("protectedGroup_modifyPG_operateName", SysoplogLevel.NORMAL.getValue(), clonedProtectGroup == null ? "" : clonedProtectGroup.getName(), e);
        }
        log.info((Object)"end syncProtectGroupInfo between two rd", 90160758786988L);
        return Response.ok().build();
    }

    @Override
    @GET
    @Path(value="/getProtectGroupStatisticInfo")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RestJsonRequest getProtectGroupStatisticInfo(@QueryParam(value="protectGroupId") String protectGroupId, @QueryParam(value="range") DrmEnumDefine.ReportTimeRangeE range, @QueryParam(value="userId") long userId) {
        log.info((Object)"begin getProtectGroupStatisticInfo between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        RestJsonRequest rjq = new RestJsonRequest();
        ProtectGroupStatisticInfo pgsi = ((IProtectGroupReportService)this.getBundleService("DRM_Report", IProtectGroupReportService.class.getName())).getProtectGroupExecutedInfo(protectGroupId, range, Long.valueOf(userId));
        rjq.setClasssName(ProtectGroupStatisticInfo.class.getName());
        rjq.setValue(ReverseObjectSerializableUtils.serializableObj((Object)pgsi));
        log.info((Object)"end getProtectGroupStatisticInfo between two rd", 90160758786988L);
        return rjq;
    }

    @Override
    public Response createSyncProtectGroupInfo(RestJsonRequest request) throws ClassNotFoundException {
        log.info((Object)"begin createSyncProtectGroupInfo between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_createPG_operateName", SysoplogLevel.INFO.getValue(), "ism.drm.protectgroup.auth.add");
        ProtectGroup clonedProtectGroup = null;
        CommUtils.checkParamEmpty((Object[])new Object[]{request});
        ProtectGroup protectGroup = (ProtectGroup)request.toObject();
        this.checkUserBizObjAuthority("protectedGroup_createPG_operateName", SysoplogLevel.INFO.getValue(), protectGroup.getProductSiteId());
        try {
            clonedProtectGroup = (ProtectGroup)protectGroup.clone();
            if (clonedProtectGroup == null) {
                log.error((Object)"clonedProtectGroup is null.", 653110170615808L);
                throw new LegoCheckedException(-1L);
            }
            clonedProtectGroup.setOwnerId(this.getCurrentUserId());
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).createSyncProtectGroup(clonedProtectGroup);
            this.writeSucOperationLog("protectedGroup_createPG_operateName", SysoplogLevel.INFO.getValue(), clonedProtectGroup.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("createSyncProtectGroupInfo failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            this.writeFailedOperationLog("protectedGroup_createPG_operateName", SysoplogLevel.NORMAL.getValue(), clonedProtectGroup == null ? "" : clonedProtectGroup.getName(), e);
        }
        return Response.ok().build();
    }

    protected void validatePolicyTemplate(PolicyTemplate policyTemplate, int pgAppType) {
        log.debug((Object)("method [validatePolicyTemplate] invoked. pgAppType:" + pgAppType + ", policyTemplate id:" + policyTemplate.getPtId()));
        IPolicyTemplateManager policyTemplateManager = (IPolicyTemplateManager)this.getBundleService(IPolicyTemplateManager.class);
        PolicyTemplate policyTemplateFromDB = policyTemplateManager.getPtByUuid(policyTemplate.getUuid());
        if (policyTemplateFromDB == null) {
            log.error((Object)("cannot get policyTemplate, policyTemplate.getUuid = " + policyTemplate.getUuid()), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
        policyTemplate.setType(policyTemplateFromDB.getType());
        this.checkHyperCloneProps(policyTemplate);
        ProtectGroupValidator.checkMountConfiguration(policyTemplate);
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).checkPolicyProps(pgAppType, policyTemplate);
    }

    protected void dealPgNameByTemplate(ProtectGroup protectGroup) {
        String newPgName;
        boolean isHyperMetro;
        if (protectGroup.getName().length() > 36) {
            log.error((Object)"ProtectGroup param name(%s) error", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        int templateType = protectGroup.getTemplate().getType();
        boolean bl = isHyperMetro = templateType == 38 || templateType == 53;
        if (isHyperMetro) {
            ProtectObject po = protectGroup.getPolist().stream().findFirst().orElse(new ProtectObject());
            String poName = StringUtils.isNotEmpty((CharSequence)po.getName()) && po.getName().length() > 30 ? po.getName().substring(0, 30) : po.getName();
            newPgName = CommUtil.combineString((String[])new String[]{protectGroup.getName(), poName, (String)po.getProps().get("vmId")});
            String createTime = "_@_" + System.currentTimeMillis();
            int maxLength = 255 - createTime.length();
            newPgName = newPgName.length() > maxLength ? newPgName.substring(0, maxLength) : newPgName;
            newPgName = newPgName + createTime;
        } else {
            newPgName = CommUtil.combineString((String[])new String[]{protectGroup.getName(), UUIDGenerator.getUUID()});
            newPgName = newPgName.length() > 255 ? newPgName.substring(0, 255) : newPgName;
        }
        protectGroup.setName(newPgName);
    }
}

