/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.model.QueryPOPage;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.service.platform.protection.group.AbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.BaseAbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupLogExcelOperator;
import com.huawei.ism.drm.rest.util.DownloadFileUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.ExcelUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class ProtectGroupBaseRestServiceImpl
extends AbstractProtectGroupRestService {
    private static Log log = LogFactory.getInstance(ProtectGroupBaseRestServiceImpl.class);

    public String getAvailableProtectObject(int poType, String deviceSn) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        Map queryParam = this.getExtParamInQueryParam();
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(deviceSn);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        if (resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.checkUserMoAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), new String[]{drHost.getDeviceSn()});
            }
        } else {
            this.checkUserMoAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), new String[]{deviceSn});
        }
        if (!this.checkDrmProtectObjectTypeParam(String.valueOf(poType))) {
            log.error((Object)"param[poType] is not number!");
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAvailableProtectObject(poType, deviceSn, queryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Override
    public String pageQueryAvailableProtectObject(int poType, String deviceSn, String orderBy, String orderType, String filterName, String filterValue) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceSn", deviceSn);
        Map paramsBack = poProvider.pretreatmentParams(poType, params);
        deviceSn = VerifyUtil.isEmpty((Map)paramsBack) || VerifyUtil.isEmpty(paramsBack.get("deviceSn")) ? deviceSn : (String)paramsBack.get("deviceSn");
        Map queryParam = this.getExtParamInQueryParam();
        PageParameter pageParame = this.getPageParameter();
        Integer startPage = pageParame.getStartPage();
        Integer pageSize = pageParame.getPageSize();
        if (!this.checkDrmProtectObjectTypeParam(String.valueOf(poType))) {
            log.error((Object)"Fail to get params, poType.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            log.error((Object)"Fail to get params, deviceSn.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), new String[]{deviceSn});
        queryParam.put("orderBy", orderBy);
        queryParam.put("pageSize", pageSize);
        queryParam.put("pageIndex", startPage);
        queryParam.put("orderType", orderType);
        queryParam.put("userId", this.getCurrentUserId());
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryParam.put("filterName", filterName);
            queryParam.put("filterValue", filterValue);
            queryParam.put(filterName, filterValue);
        }
        QueryPOPage page = poProvider.getAvailableProtectObjectPage(poType, deviceSn, queryParam);
        List poList = page.getPoList();
        int totalCount = page.getTotalCount();
        String records = this.protectObjectListToJsonStr(poList).toString();
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)records);
        return result.toString();
    }

    @Override
    public Response validateDatabaseAuthInfo(Integer poType, ProtectObject po) {
        this.checkUserOperationAuthority("protectedGroup_testAuthentication_operateName", SysoplogLevel.INFO.getValue(), "ism.drm.12.protectgroup.auth.management");
        if (VerifyUtil.isEmpty((Object)po)) {
            log.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        String moProviderSn = this.getMoProviderSn(po);
        if (VerifyUtil.isEmpty((String)moProviderSn)) {
            log.error((Object)"moProviderSn is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("protectedGroup_testAuthentication_operateName", SysoplogLevel.INFO.getValue(), new String[]{moProviderSn});
        try {
            this.validateDbAuthInfo(poType, po);
            this.writeSucOperationLog("protectedGroup_testAuthentication_operateName", 1, po.getName(), null, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_testAuthentication_operateName", SysoplogLevel.INFO.getValue(), po.getName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            this.writeFailedOperationLog("protectedGroup_testAuthentication_operateName", SysoplogLevel.INFO.getValue(), po.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response addProtectGroup(ProtectGroup protectGroup, boolean isAutoCreateRp) {
        PolicyTemplate template = this.checkAndgetPolicyTemplate(protectGroup, isAutoCreateRp);
        long taskId = -1L;
        try {
            if (isAutoCreateRp) {
                IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
                planService.getSuitablePlanType(protectGroup);
            }
            template.setPtId(template.getUuid());
            ProtectGroupValidator.dealScheduleWhenCreatingProtectGroup((PolicyTemplate)template);
            protectGroup.setOwnerId(this.getCurrentUserId());
            IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            taskId = pgServices.createProtectGroup(protectGroup, isAutoCreateRp);
            this.writeSucOperationLog("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), protectGroup.getName(), "", new String[0]);
        }
        catch (Exception le) {
            log.error((Object)("execute protectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)le)), -1L);
            this.writeFailedOperationLog("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), protectGroup.getName(), le);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"taskId", (Object)String.valueOf(taskId));
        return Response.ok((Object)result).build();
    }

    private PolicyTemplate checkAndgetPolicyTemplate(ProtectGroup protectGroup, boolean isAutoCreateRp) {
        this.checkUserOperationAuthority("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), "ism.drm.protectgroup.auth.add");
        if (isAutoCreateRp) {
            this.checkUserOperationAuthority("recoveryPlan_create_operateName", 1, "ism.drm.drp.auth.add");
        }
        String groupName = protectGroup.getName();
        String pgDescription = protectGroup.getDescription();
        String pgAppType = String.valueOf(protectGroup.getPoType());
        String pgSN = protectGroup.getPoProviderSN();
        String pgSiteId = protectGroup.getProductSiteId();
        String pgDesc = HtmlStringConverter.decodeByLength((String)pgDescription);
        ArrayList<String> verifyParaList = new ArrayList<String>();
        verifyParaList.add(pgAppType);
        verifyParaList.add(pgSN);
        verifyParaList.add(pgSiteId);
        CommUtils.verifyParameterList(verifyParaList);
        Map props = protectGroup.getProps();
        CommUtils.verifyParameterMap((Map)props);
        PolicyTemplate template = protectGroup.getTemplate();
        if (this.checkProtectGroupParam(groupName, pgAppType, pgDesc, template)) {
            log.error((Object)("params are not legal!groupName:" + groupName + ", pgAppType:" + pgAppType + ", pgDesc:" + pgDesc + ", tempalte:" + template));
            throw new LegoCheckedException(1073947393L);
        }
        this.validatePolicyTemplate(template, protectGroup.getPoType());
        if (template.getType() == 25) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkUserBizObjAuthority("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), pgSiteId);
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(pgSN);
        if (null != resource && resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.checkUserMoAuthority("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), new String[]{drHost.getDeviceSn()});
            }
        } else {
            this.checkUserMoAuthority("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), new String[]{pgSN});
        }
        return template;
    }

    @Override
    public BatchOperationResult batchCreateProtectGroup(List<ProtectGroup> protectGroups, boolean isAutoCreateRp) {
        BatchOperationResult batchOperationResult;
        if (protectGroups.size() > 200) {
            log.error((Object)"ProtectGroups is more than %s.", new Object[]{String.valueOf(200)});
            throw new SpecCheckedException("ProtectGroups_quantity", 64L, (long)protectGroups.size());
        }
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (ProtectGroup pg : protectGroups) {
            PolicyTemplate template = this.checkAndgetPolicyTemplate(pg, isAutoCreateRp);
            this.dealPgNameByTemplate(pg);
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetName(pg.getName());
            batchOperation.setTargetObject((Object)pg);
            if (isAutoCreateRp) {
                IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
                planService.getSuitablePlanType(pg);
                pg.getProps().put("isAutoCreateRp", "true");
            }
            template.setPtId(template.getUuid());
            ProtectGroupValidator.dealScheduleWhenCreatingProtectGroup((PolicyTemplate)template);
            pg.setOwnerId(this.getCurrentUserId());
            bathOprLst.add(batchOperation);
        }
        try {
            IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            batchOperationResult = pgServices.batchCreateProtectGroup(bathOprLst);
        }
        catch (Exception le) {
            log.error((Object)"Execute protectGroup error,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)le)});
            this.writeFailedOperationLog("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), "", le);
            batchOperationResult = null;
        }
        this.batchOptLog(batchOperationResult, "protectedGroup_create_operateName", SysoplogLevel.INFO.getValue());
        return batchOperationResult;
    }

    @Override
    public Response addProtectObjects(String protectgroupId, Set<ProtectObject> protectObjectSet) {
        this.checkUserOperationAuthority("protectedGroup_addProtectedObject_operateName", SysoplogLevel.NORMAL.getValue(), "ism.drm.protectgroup.auth.modify");
        if (VerifyUtil.isEmpty(protectObjectSet) || VerifyUtil.isEmpty((String)protectgroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        CommUtils.checkObjectExists((Object[])new Object[]{pg});
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkUserBizObjAuthority("protectedGroup_addProtectedObject_operateName", SysoplogLevel.NORMAL.getValue(), pg.getUuid());
        this.checkProviderSn(protectObjectSet, pg);
        try {
            this.addProtectObject(protectObjectSet);
            pgServices.addProtectObjects(protectgroupId, protectObjectSet);
            StringBuffer buffer = new StringBuffer();
            if (!VerifyUtil.isEmpty(protectObjectSet)) {
                for (ProtectObject protectObjectItem : protectObjectSet) {
                    if (null == protectObjectItem) continue;
                    buffer.append(protectObjectItem.getName()).append(',');
                }
            }
            log.info((Object)("Add protect objects:" + buffer), 653110170550272L);
            for (ProtectObject po : protectObjectSet) {
                this.writeSucOperationLog("protectedGroup_addProtectedObject_operateName", SysoplogLevel.NORMAL.getValue(), po.getName(), "protectedGroup_addProtectedObject_operateDetail", new String[]{po.getName(), pg.getName()});
            }
        }
        catch (Exception le) {
            this.writeFailedOperationLogForPo("protectedGroup_addProtectedObject_operateName", SysoplogLevel.NORMAL.getValue(), le, protectObjectSet);
        }
        return Response.ok().build();
    }

    private void checkProviderSn(Collection<ProtectObject> protectObjectSet, ProtectGroup pg) {
        if (pg.getPoType() == 12) {
            for (ProtectObject po : protectObjectSet) {
                this.getMoProviderSn(po);
            }
            return;
        }
        String pgProviderSN = pg.getPoProviderSN();
        DrResource pgResource = ((IResourceService)this.getBundleService(IResourceService.class)).getDrResourceBySn(pgProviderSN);
        if (null == pgResource) {
            log.warn((Object)("Cannot find DR resource with protect group provider sn -> " + pgProviderSN), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
        for (ProtectObject po : protectObjectSet) {
            String poProvideSn = this.getMoProviderSn(po);
            if (poProvideSn != null) continue;
            log.warn((Object)("Cannot find NE with MO UUID -> " + pgProviderSN), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    @Override
    public Response removeProtectObjects(String protectgroupId, Set<ProtectObject> pos) {
        this.checkUserOperationAuthority("protectedGroup_removeProtectedObject_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.modify");
        CommUtils.checkParamEmpty((Object[])new Object[]{protectgroupId, pos});
        this.checkUserBizObjAuthority("protectedGroup_removeProtectedObject_operateName", SysoplogLevel.WARNING.getValue(), protectgroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        try {
            this.checkProviderSn(pos, pg);
        }
        catch (LegoCheckedException ex) {
            log.warn((Object)"Check provider sn with warning.", ex.getErrorCode());
        }
        try {
            CommUtils.checkObjectExists((Object[])new Object[]{pg});
            HashSet<ProtectObject> poSet = new HashSet<ProtectObject>();
            for (ProtectObject po : pos) {
                ProtectObject pobject = pgServices.getProtectObjectByMoUUID(protectgroupId, po.getMoUuid());
                this.checkCanBeRemoved(pobject);
                poSet.add(pobject);
                po.setName(pobject.getName());
            }
            pgServices.removeProtectObjects(protectgroupId, poSet);
            for (ProtectObject po : pos) {
                this.writeSucOperationLog("protectedGroup_removeProtectedObject_operateName", SysoplogLevel.WARNING.getValue(), po.getName(), "protectedGroup_removeProtectedObject_operateDetail", new String[]{po.getName(), pg.getName()});
            }
        }
        catch (Exception e) {
            this.writeFailedOperationLogForPo("protectedGroup_removeProtectedObject_operateName", SysoplogLevel.WARNING.getValue(), e, pos);
        }
        return Response.ok().build();
    }

    @Override
    public Response updateProtectObjectProps(String protectgroupId, List<ProtectObject> protectObjects) {
        this.checkUserOperationAuthority("protectedGroup_modifyAuthentication_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.modify");
        CommUtils.checkParamEmpty((Object[])new Object[]{protectgroupId, protectObjects});
        this.checkUserBizObjAuthority("protectedGroup_modifyAuthentication_operateName", SysoplogLevel.WARNING.getValue(), protectgroupId);
        IProtectGroupService pgServices = null;
        ProtectGroup pg = null;
        try {
            pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        }
        catch (Exception e) {
            this.writeMultiPoUpdateFailedOperationLog(protectObjects, e);
        }
        this.checkProviderSn(protectObjects, pg);
        ArrayList<ProtectObject> failedProtectObjects = new ArrayList<ProtectObject>();
        Throwable failedException = new LegoCheckedException(-1L);
        for (ProtectObject po : protectObjects) {
            try {
                pgServices.updateProtectObjectProps(protectgroupId, po.getUuid(), po.getProps());
                this.writeSucOperationLog("protectedGroup_modifyAuthentication_operateName", SysoplogLevel.WARNING.getValue(), po.getName(), "protectedGroup_modifyAuthentication_operateDetail", new String[]{pg.getName(), po.getName()});
            }
            catch (Exception e) {
                log.error((Object)("updateProtectObjectProps error!protectgroupId:" + protectgroupId));
                failedProtectObjects.add(po);
                failedException = e;
            }
        }
        this.writeMultiPoUpdateFailedOperationLog(failedProtectObjects, (Exception)failedException);
        return Response.ok().build();
    }

    @Override
    public Response exportProtectGroupLog(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserOperationAuthority("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.INFO.getValue(), "ism.drm.protectgroup.auth.export");
        this.checkUserBizObjAuthority("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.INFO.getValue(), protectGroupId);
        BatchOperationResult result = new BatchOperationResult();
        ProtectGroup protectGroup = null;
        try {
            protectGroup = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
            CommUtils.checkObjectExists((Object[])new Object[]{protectGroup});
            if (this.validateIsHypermetro(protectGroup) || this.validateIsReplication(protectGroup)) {
                throw new LegoCheckedException(1073947453L);
            }
            int pageSize = 20001;
            Page pageQueryProtectGroupLogs = this.getService().pageQueryHistoryLogFromAll(0, pageSize, "startTime", false, protectGroupId);
            List protectGroupLogs = pageQueryProtectGroupLogs.getResult();
            CommUtils.checkObjectExists((Object[])new Object[]{protectGroupLogs});
            if (protectGroupLogs.size() > 20000) {
                throw new LegoCheckedException(1575L);
            }
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            this.exportLogHelper(protectGroupLogs, result, protectGroup);
            this.writeSucOperationLog("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.INFO.getValue(), protectGroup.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("Export protectGroup log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.INFO.getValue(), protectGroup == null ? "" : protectGroup.getName(), e);
        }
        return Response.ok((Object)result).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportLogHelper(List<ProtectGroupLog> protectGroupLogs, BatchOperationResult result, ProtectGroup protectGroup) {
        ProtectGroupLogExcelOperator operator = new ProtectGroupLogExcelOperator((BaseAbstractProtectGroupRestService)this);
        FileOutputStream fileOutputStream = null;
        SXSSFWorkbook wb = null;
        try {
            wb = operator.createExportExcel(protectGroupLogs, result);
            File excelFile = new File(FileExcelUtil.createTempDownloadPath((HttpSession)this.getSession(), (String)protectGroup.getName(), null, (String)"xlsx"));
            fileOutputStream = new FileOutputStream(excelFile);
            wb.write((OutputStream)fileOutputStream);
            DownloadFileUtil.downloadLogFile((HttpServletResponse)this.getResponse(), (HttpServletRequest)this.getRequest(), (File)excelFile);
        }
        catch (LegoCheckedException e) {
            try {
                log.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                throw e;
                catch (Exception ex) {
                    log.error((Object)("Export protectGroup log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
                    throw new LegoCheckedException(1073948423L, (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                ExcelUtil.closeExcelExport((SXSSFWorkbook)wb, fileOutputStream);
                throw throwable;
            }
        }
        ExcelUtil.closeExcelExport((SXSSFWorkbook)wb, (FileOutputStream)fileOutputStream);
    }

    private void writeMultiPoUpdateFailedOperationLog(List<ProtectObject> protectObjects, Exception e) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            return;
        }
        for (ProtectObject po : protectObjects) {
            this.writeFailedOperationLogNoException("protectedGroup_modifyAuthentication_operateName", SysoplogLevel.WARNING.getValue(), po.getName(), e);
        }
        if (e instanceof LegoCheckedException) {
            log.error((Object)"update po props failed.", (Throwable)e, 90160758784001L);
            throw (LegoCheckedException)((Object)e);
        }
        log.error((Object)("operation failed. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        throw new LegoCheckedException(-1L);
    }
}

