/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ProtectActionVo;
import com.huawei.ism.drm.protection.action.service.IProtectActionService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.UpdateDiskRequest;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupBaseRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.util.DrmStorageUtil;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

public class ProtectGroupRestServiceImpl
extends ProtectGroupBaseRestServiceImpl {
    private static Log log = LogFactory.getInstance(ProtectGroupRestServiceImpl.class);
    private static final String PROTECTION_RELATION = "protectionRelation";
    private List<Integer> manulAutoSplit = Arrays.asList(1, 0);

    @Override
    public Response disableProtectAction(String protectGroupId, String actionId) {
        this.checkUserOperationAuthority("protectedAction_disableStep_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.validateProtectGroupId(actionId);
        ProtectActionVo vo = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).queryProtectAction(protectGroupId, actionId);
        if (null == vo) {
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(vo.getProtectGroupId(), false);
        if (null == pg) {
            throw new LegoCheckedException(2117645L);
        }
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkUserBizObjAuthority("protectedAction_disableStep_operateName", SysoplogLevel.WARNING.getValue(), vo.getProtectGroupId());
        try {
            ((IProtectActionService)this.getBundleService(IProtectActionService.class)).disableAction(protectGroupId, actionId);
            this.writeSucOperationLog("protectedAction_disableStep_operateName", 2, vo.getName(), "protectedGroup_disableStep_operateDetail", new String[]{pg.getName(), vo.getName()});
        }
        catch (LegoCheckedException e) {
            log.error((Object)"disable action error", (Throwable)e, -1L);
            this.writeFailedOperationLog("protectedAction_disableStep_operateName", 2, vo.getName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)("disable action error" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.writeFailedOperationLog("protectedAction_disableStep_operateName", 2, vo.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response enableProtectAction(String protectGroupId, String actionId) {
        this.checkUserOperationAuthority("protectedAction_enableStep_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.validateProtectGroupId(actionId);
        ProtectActionVo vo = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).queryProtectAction(protectGroupId, actionId);
        if (null == vo) {
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(vo.getProtectGroupId(), false);
        if (null == pg) {
            throw new LegoCheckedException(2117645L);
        }
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkUserBizObjAuthority("protectedAction_enableStep_operateName", SysoplogLevel.WARNING.getValue(), vo.getProtectGroupId());
        try {
            ((IProtectActionService)this.getBundleService(IProtectActionService.class)).enableAction(protectGroupId, actionId);
            this.writeSucOperationLog("protectedAction_enableStep_operateName", 2, vo.getName(), "protectedGroup_enableStep_operateDetail", new String[]{pg.getName(), vo.getName()});
        }
        catch (LegoCheckedException e) {
            log.error((Object)"enable action error", (Throwable)e, e.getErrorCode());
            this.writeFailedOperationLog("protectedAction_enableStep_operateName", 2, vo.getName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)("enable action error" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.writeFailedOperationLog("protectedAction_enableStep_operateName", 2, vo.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response modifyProtectAction(String protectGroupId, String actionId, Map<String, String> params) {
        this.checkUserOperationAuthority("protectedAction_modifyStep_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(actionId);
        ProtectActionVo vo = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).queryProtectAction(protectGroupId, actionId);
        if (null == vo) {
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(vo.getProtectGroupId(), false);
        if (null == pg) {
            throw new LegoCheckedException(2117645L);
        }
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkUserBizObjAuthority("protectedAction_modifyStep_operateName", SysoplogLevel.WARNING.getValue(), vo.getProtectGroupId());
        try {
            ((IProtectActionService)this.getBundleService(IProtectActionService.class)).modifyAction(protectGroupId, actionId, params);
            this.writeSucOperationLog("protectedAction_modifyStep_operateName", 2, vo.getName(), "protectedGroup_modifyStep_operateDetail", new String[]{pg.getName(), vo.getName()});
        }
        catch (LegoCheckedException e) {
            log.error((Object)"modify action error", (Throwable)e, -1L);
            this.writeFailedOperationLog("protectedAction_modifyStep_operateName", 2, vo.getName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)("modify action error" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.writeFailedOperationLog("protectedAction_modifyStep_operateName", 2, vo.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public String getStorageLunsStatistic(int poType, int templateType, List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects) || null == DrmEnumDefine.AppType.getType((int)poType) || null == PolicyTemplateType.PolicyTemplateE.getType((int)templateType)) {
            log.error((Object)("poType:" + poType + ", tempalteType:" + templateType));
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        IProtectGroupService protectGroupService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        List storageResources = protectGroupService.getUsedStorageLunsByProtectObject(protectObjects, poType, templateType);
        return DrmStorageUtil.getStorageResourceStatisticByLun(storageResources, templateType);
    }

    @Override
    public String getStorageResources(int poType, int templateType, List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects) || null == DrmEnumDefine.AppType.getType((int)poType) || null == PolicyTemplateType.PolicyTemplateE.getType((int)templateType)) {
            log.error((Object)("poType:" + poType + ", tempalteType:" + templateType));
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        IProtectGroupService protectGroupService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        List storageResources = protectGroupService.getUsedStorageLunsByProtectObject(protectObjects, poType, templateType);
        JSONArray response = new JSONArray();
        for (StorageResource storageResource : storageResources) {
            JSONObject record = new JSONObject();
            record.put((Object)"uuid", (Object)storageResource.getUuid());
            record.put((Object)"name", (Object)storageResource.getName());
            record.put((Object)"devSn", (Object)storageResource.getDevSn());
            record.put((Object)"resourceId", (Object)storageResource.getResourceId());
            String identifier = storageResource.getResourceIndentifier();
            record.put((Object)"resourceIndentifier", (Object)(null != identifier ? identifier : ""));
            double totalCapacity = UnitConvert.convert((double)storageResource.getTotalCapacity(), (IUnitType)CapabilityUnitType.valueOf((String)storageResource.getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.MB, (int)3);
            record.put((Object)"totalCapacity", (Object)totalCapacity);
            String displayTotalCapacity = CapacityUnitUtil.getCapacityAndUnit((Double)totalCapacity, (CapabilityUnitType)CapabilityUnitType.MB);
            record.put((Object)"totalCapacityDisplayValue", (Object)displayTotalCapacity);
            if (storageResource instanceof XveLun) {
                XveLun xveLun = (XveLun)storageResource;
                record.put((Object)"poolId", (Object)xveLun.getStoragePoolId());
                record.put((Object)"poolName", (Object)xveLun.getStoragePoolName());
            }
            response.add((Object)record);
        }
        return response.toString();
    }

    @Override
    public Response modifyProtectGroupPolicyTemplate(String protectgroupId, PolicyTemplate policyTemplate) {
        this.checkUserOperationAuthority("protectedGroup_modifyPolicy_operateName", 2, "ism.drm.protectgroup.auth.modify");
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_modifyPolicy_operateName", 2, protectgroupId);
        try {
            pg = this.getService().getProtectGroupByID(protectgroupId, false);
            if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
                throw new LegoCheckedException(1073947453L);
            }
            PolicyTemplate pt = this.checkModifyProtectGroupParam(policyTemplate, pg);
            this.validatePolicyTemplate(pt, pg.getPoType());
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).updateProtectGroupTemplate(protectgroupId, pt);
            this.writeSucOperationLog("protectedGroup_modifyPolicy_operateName", 2, pg.getName(), "", new String[0]);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_modifyPolicy_operateName", 2, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)("protectgroupId:" + protectgroupId));
            this.writeFailedOperationLog("protectedGroup_modifyPolicy_operateName", 2, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
        }
        return Response.ok().build();
    }

    private PolicyTemplate checkModifyProtectGroupParam(PolicyTemplate policyTemplate, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate pt = pg.getTemplate();
        if (VerifyUtil.isEmpty((Object)pt) || VerifyUtil.isEmpty((Collection)pt.getSchedules())) {
            log.error((Object)("pt may be empty!pt:" + pt));
            throw new LegoCheckedException(1073947394L);
        }
        this.setProps(policyTemplate, pt);
        return pt;
    }

    private void setProps(PolicyTemplate policyTemplate, PolicyTemplate pt) {
        String protectionRelation = (String)pt.getProps().get(PROTECTION_RELATION);
        pt.getProps().clear();
        pt.setProps(policyTemplate.getProps());
        pt.getProps().put(PROTECTION_RELATION, protectionRelation);
    }

    private void checkScheduleParam(Set<Schedule> dataBaseSchedules, Set<Schedule> newSchedules) {
        HashMap<String, Schedule> allDataBaseSceduleInfo = new HashMap<String, Schedule>();
        for (Schedule dataBaseSchedule : dataBaseSchedules) {
            allDataBaseSceduleInfo.put(dataBaseSchedule.getScheduleId(), dataBaseSchedule);
        }
        for (Schedule newSchedule : newSchedules) {
            if (!allDataBaseSceduleInfo.containsKey(newSchedule.getScheduleId())) {
                log.error((Object)(newSchedule.getScheduleId() + "not exist in data base"), 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            if (newSchedule.getProtectLocation() == ((Schedule)allDataBaseSceduleInfo.get(newSchedule.getScheduleId())).getProtectLocation()) continue;
            log.error((Object)(newSchedule.getScheduleId() + "not exist in data base"), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkSchedule(PolicyTemplate pt, Schedule newSch) {
        Set schedules = pt.getSchedules();
        log.error((Object)"checkSchedule is invoked!");
        this.checkManulOrAuto(schedules, newSch);
    }

    private void checkManulOrAuto(Set<Schedule> scs, Schedule newSch) {
        String scheduleId = newSch.getScheduleId();
        int newScheduleMode = newSch.getScheduleMode();
        if (VerifyUtil.isEmpty((String)scheduleId) || !this.manulAutoSplit.contains(newScheduleMode)) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator<Schedule> scheduleIterator = scs.iterator();
        HashSet<Schedule> toAddSchedule = new HashSet<Schedule>();
        while (scheduleIterator.hasNext()) {
            Schedule sc = scheduleIterator.next();
            if (!scheduleId.equals(sc.getScheduleId())) continue;
            if (1 == newScheduleMode && 0 == sc.getScheduleMode()) {
                scheduleIterator.remove();
                break;
            }
            if (0 == newScheduleMode && 1 == sc.getScheduleMode()) {
                this.checkScheduleCounts(scs, newSch);
                ProtectGroupValidator.checkScheduleDetailForModifyPolicy((Schedule)newSch);
                newSch.setScheduleId(UUIDGenerator.getUUID());
                toAddSchedule.add(newSch);
                break;
            }
            try {
                ProtectGroupValidator.checkScheduleDetailForModifyPolicy((Schedule)newSch);
                BeanUtils.copyProperties((Object)sc, (Object)newSch);
            }
            catch (LegoCheckedException e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters(), (Log)log);
            }
            catch (Exception ex) {
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Update schedule infos failed!", (long)-1L, (String[])new String[0], (Log)log);
            }
            break;
        }
        scs.addAll(toAddSchedule);
    }

    @Override
    public String queryUseHypermetroStorage(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            log.error((Object)"queryUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        List list = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getUseHypermetroStorage(protectGroupId);
        JSONArray array = JSONArray.fromObject((Object)list);
        return array.toString();
    }

    @Override
    public String queryDiskInfo(String protectGroupId) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        List diskInfos = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).queryDiskInfo(protectGroupId);
        JSONArray diskJSONArray = new JSONArray();
        diskInfos.stream().map(diskInfo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"devSn", (Object)diskInfo.getDevSn());
            jsonObject.put((Object)"resourceId", (Object)diskInfo.getResourceId());
            jsonObject.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            jsonObject.put((Object)"poolId", (Object)diskInfo.getPoolId());
            jsonObject.put((Object)"poolName", (Object)diskInfo.getPoolName());
            jsonObject.put((Object)"status", (Object)diskInfo.getStatus());
            jsonObject.put((Object)"name", (Object)diskInfo.getName());
            JSONArray poArray = new JSONArray();
            diskInfo.getProtectObjects().stream().map(po -> {
                JSONObject poJsonObj = new JSONObject();
                poJsonObj.put((Object)"moUuid", (Object)po.getMoUuid());
                poJsonObj.put((Object)"name", (Object)this.getPoName(diskInfo.getProtectObjects()));
                return poJsonObj;
            }).forEach(o -> poArray.add(o));
            jsonObject.put((Object)"protectObjects", (Object)poArray);
            jsonObject.put((Object)"recoveryPools", (Object)JSONArray.fromObject((Object)diskInfo.getRecoveryPools()));
            return jsonObject;
        }).forEach(o -> diskJSONArray.add(o));
        return diskJSONArray.toString();
    }

    private String getPoName(List<ProtectObject> protectObjects) {
        List list = Optional.ofNullable(protectObjects).orElseGet(ArrayList::new).stream().map(ProtectObject::getName).collect(Collectors.toList());
        return StringUtils.join(list, (String)"/");
    }

    @Override
    public String updateDiskProtect(String protectGroupId, UpdateDiskRequest updateDiskRequest) {
        this.checkUserOperationAuthority("protectedGroup_updateDiskProtect_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.refresh");
        this.checkUserBizObjAuthority("protectedGroup_updateDiskProtect_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        this.validateProtectGroupId(protectGroupId);
        long taskId = 0L;
        try {
            taskId = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).updateDiskProtect(protectGroupId, updateDiskRequest);
            this.writeSucOperationLog("protectedGroup_updateDiskProtect_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId, "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("update disk protect error" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.writeFailedOperationLog("protectedGroup_updateDiskProtect_operateName", 2, protectGroupId, e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"taskId", (Object)taskId);
        return jsonObject.toString();
    }

    @Override
    public Response addSchedule(String protectGroupId, Schedule schedule) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        ProtectGroupValidator.checkSchedule((Schedule)schedule);
        try {
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).addSchedule(protectGroupId, schedule);
            this.writeSucOperationLog("protectedGroup_schedule_add_operateName", 2, pg.getName(), "", new String[0]);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_schedule_add_operateName", 2, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), (Exception)((Object)e));
            throw e;
        }
        return Response.ok().build();
    }

    private void checkScheduleAuthority(String protectGroupId) {
        this.checkUserOperationAuthority("protectedGroup_modifyPolicy_operateName", 2, "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_modifyPolicy_operateName", 2, protectGroupId);
    }

    @Override
    public Response updateSchedule(String protectGroupId, String scheduleId, Schedule schedule) {
        if (null == schedule) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroupValidator.checkSchedule((Schedule)schedule);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        try {
            schedule.setScheduleId(scheduleId);
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).updateSchedule(protectGroupId, schedule);
            this.writeSucOperationLog("protectedGroup_schedule_update_operateName", 2, pg.getName(), "protectedGroup_schedule_update_operateDetail", new String[]{pg.getName(), scheduleId});
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_schedule_update_operateName", 2, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), (Exception)((Object)e));
            throw e;
        }
        return Response.ok().build();
    }

    @Override
    public Response disableSchedule(String protectGroupId, String scheduleId) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        try {
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).disableSchedule(protectGroupId, scheduleId);
            this.writeSucOperationLog("protectedGroup_schedule_disable_operateName", 2, pg.getName(), "protectedGroup_schedule_disable_operateDetail", new String[]{pg.getName(), scheduleId});
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_schedule_disable_operateName", 2, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), (Exception)((Object)e));
            throw e;
        }
        return Response.ok().build();
    }

    @Override
    public Response enableSchedule(String protectGroupId, String scheduleId) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        try {
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).enableSchedule(protectGroupId, scheduleId);
            this.writeSucOperationLog("protectedGroup_schedule_enable_operateName", 2, pg.getName(), "protectedGroup_schedule_enable_operateDetail", new String[]{pg.getName(), scheduleId});
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_schedule_enable_operateName", 2, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), (Exception)((Object)e));
            throw e;
        }
        return Response.ok().build();
    }

    @Override
    public Response runSchedule(String protectGroupId, String scheduleId, Map<String, Object> parameter) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        try {
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).runSchedule(protectGroupId, scheduleId, parameter);
            this.writeSucOperationLog("protectedGroup_enablePGExecution_operateName", 3, pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("Run schedule error! schedule is :" + scheduleId + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.writeFailedOperationLog("protectedGroup_enablePGExecution_operateName", 3, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
            throw e;
        }
        return Response.ok().build();
    }

    @Override
    public Response offlineTransfer(String protectGroupId, String scheduleId, Map<String, String> status) {
        if (null == status) {
            throw new LegoCheckedException(1073947393L, "status is null");
        }
        String statusValue = status.get("status");
        if (!Validator.isNum((String)statusValue)) {
            throw new LegoCheckedException(1073947393L, "Cannot get status value from status parameter");
        }
        List validValues = Stream.of(BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.ENABLE.getStatus(), BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.DISABLE.getStatus(), BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.SUSPEND.getStatus()).collect(Collectors.toList());
        if (!validValues.contains(Integer.valueOf(statusValue))) {
            throw new LegoCheckedException(1073947393L, "Status value[%s] is invalid");
        }
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        int iStatus = NumberUtil.parseInteger((Object)statusValue);
        BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM eStaus = BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.getStatus((int)iStatus);
        String operationName = String.format("protectedGroup_schedule_offline_%s_operateName", eStaus.name());
        String operationDetail = String.format("protectedGroup_schedule_offline_%s_operateName", eStaus.name());
        try {
            ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).offlineTransfer(protectGroupId, scheduleId, iStatus);
            this.writeSucOperationLog(operationName, 3, pg.getName(), operationDetail, new String[]{pg.getName(), scheduleId});
        }
        catch (Exception e) {
            log.error((Object)("Run schedule error! schedule is :" + scheduleId + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.writeFailedOperationLog(operationName, 3, pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
            throw e;
        }
        return Response.ok().build();
    }
}

