/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.rest.service.platform.protection.group.BaseProtectGroupValidator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.List;

public class ProtectGroupValidator
extends BaseProtectGroupValidator {
    private static final Log log = LogFactory.getInstance(ProtectGroupValidator.class);

    public static void checkMountConfiguration(PolicyTemplate policyTemplate) {
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(policyTemplate.getType())) {
            return;
        }
        String mountCfgString = (String)policyTemplate.getProps().get("AUTOMOUNTCONFIGS");
        if (VerifyUtil.isEmpty((String)mountCfgString)) {
            return;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)mountCfgString);
        boolean enabled = jsonObject.getBoolean("enabled");
        if (!enabled) {
            return;
        }
        String jsonString = jsonObject.getString("mountConfigs");
        if (VerifyUtil.isEmpty((String)jsonString)) {
            log.error((Object)"Auto mount configs is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        List mountCfgs = JSONArray.toCollection((JSONArray)array, MountConfiguration.class);
        if (mountCfgs == null) {
            log.error((Object)"Auto mount configs is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (MountConfiguration mountConfiguration : mountCfgs) {
            if (!VerifyUtil.isEmpty((String)mountConfiguration.getSiteId()) && !VerifyUtil.isEmpty((String)mountConfiguration.getHostOrGroupSn()) && !VerifyUtil.isEmpty((String)mountConfiguration.getEndTime()) && !VerifyUtil.isEmpty((String)mountConfiguration.getStartTime())) continue;
            log.error((Object)"Auto mount configs's param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static boolean checkIsModifyMountConfiguration(PolicyTemplate newPt) {
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(newPt.getType()) && newPt.getType() != 2 && newPt.getType() != 19) {
            return false;
        }
        String mountCfgString = (String)newPt.getProps().get("AUTOMOUNTCONFIGS");
        JSONObject jsonObject = JSONObject.fromObject((Object)mountCfgString);
        boolean isModify = false;
        if (jsonObject.containsKey((Object)"modifyMountConfigs")) {
            isModify = jsonObject.getBoolean("modifyMountConfigs");
        }
        jsonObject.remove((Object)"modifyMountConfigs");
        newPt.getProps().put("AUTOMOUNTCONFIGS", jsonObject.toString());
        return isModify;
    }
}

