/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.template;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.service.platform.protection.template.BasePolicyTemplateRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.protection.template.IPolicyTemplateRestService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.List;

public class PolicyTemplateRestServiceImpl
extends BasePolicyTemplateRestServiceImpl
implements IPolicyTemplateRestService {
    @Override
    public String getAvailablePolicyTemplateList(int poType, int replicationType, List<ProtectObject> pos) {
        if (poType == -1) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        if (VerifyUtil.isEmpty(pos)) {
            return "[]";
        }
        IProtectObjectProviderDelegate protectObjectService = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        for (ProtectObject po : pos) {
            if (po.getPoType() != 0) continue;
            po.setPoType(poType);
        }
        List templates = protectObjectService.getAvailablePolicyTemplate(poType, pos, replicationType);
        return this.policyTemplateListToJsonStr(templates);
    }

    @Override
    public String getScheduleSiteInfo(int poType, String ptUuid, List<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        if (VerifyUtil.isEmpty(poList)) {
            return null;
        }
        IProtectObjectProviderDelegate protectObjectService = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        for (ProtectObject po : poList) {
            po.setPoType(poType);
        }
        List paths = protectObjectService.getScheduleSiteInfo(poType, ptUuid, poList);
        return this.protectLocationPathToJsonStr(paths);
    }

    private String protectLocationPathToJsonStr(List<ProtectLocationPath> paths) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(paths)) {
            return jsonArray.toString();
        }
        for (ProtectLocationPath path : paths) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"protectLocation", (Object)path.getProtectLocation());
            JSONObject subObject = new JSONObject();
            subObject.put((Object)"protectedSiteName", (Object)path.getProtectedSiteName());
            subObject.put((Object)"protectedSiteId", (Object)path.getProtectedSiteId());
            subObject.put((Object)"protectedStorageSN", (Object)path.getProtectedStorageSN());
            subObject.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            subObject.put((Object)"recoverySiteId", (Object)path.getRecoverySiteId());
            subObject.put((Object)"recoveryStorageSN", (Object)path.getRecoveryStorageSN());
            jsonObject.put((Object)"detail", (Object)subObject);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    private String policyTemplateListToJsonStr(List<PolicyTemplate> templates) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(templates)) {
            return jsonArray.toString();
        }
        for (PolicyTemplate pt : templates) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"uuid", (Object)pt.getUuid());
            jsonObject.put((Object)"ptId", (Object)pt.getPtId());
            jsonObject.put((Object)"name", (Object)pt.getName());
            jsonObject.put((Object)"description", (Object)pt.getDescription());
            jsonObject.put((Object)"type", (Object)pt.getType());
            jsonObject.put((Object)"sketch", (Object)pt.getSketch());
            jsonObject.put((Object)"viewTemplateUrl", (Object)pt.getViewTemplateUrl());
            jsonObject.put((Object)"editTemplateUrl", (Object)pt.getEditTemplateUrl());
            jsonObject.put((Object)"isSystemDefine", (Object)pt.getIsSystemDefine());
            jsonObject.put((Object)"replicationType", (Object)pt.getReplicationType());
            jsonObject.put((Object)"props", (Object)pt.getProps());
            jsonObject.put((Object)"isAvailable", (Object)pt.isAvailable());
            jsonObject.put((Object)"errorCode", (Object)pt.getErrorCode());
            jsonObject.put((Object)"parameters", (Object)pt.getParameters());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }
}

