/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCustomStepService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.ism.drm.rest.service.platform.recovery.BaseRecoveryPlanRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.recovery.IRecoveryPlanRestService;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractRecoveryPlanRestService
extends BaseRecoveryPlanRestServiceImpl
implements IRecoveryPlanRestService {
    protected static final String IP_ADDRESS_REGEX = "(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
    protected static final long CONERR = 51L;
    private static final Log logger = LogFactory.getInstance(AbstractRecoveryPlanRestService.class);
    private static final List<Integer> SIMPLE_LIC_CHECK_POLICY_TYPES = Collections.unmodifiableList(Arrays.asList(2, 30, 31, 32));

    @Override
    public void syncCreateRecoveryPlan(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)request.toObject();
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_create_operateName", 1, "ism.drm.drp.auth.add");
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_create_operateName", 1, ((ProtectGroup)iterator.next()).getUuid());
        try {
            ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncCreateRecoveryPlan(this.getCurrentUserId().longValue(), recoveryPlan);
            this.writeSucOperationLog("recoveryPlan_create_operateName", 1, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_create_operateName", 1, recoveryPlan.getName(), e);
        }
    }

    @Override
    public void syncUpdateRecoveryPlan(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestObj = (Map)request.toObject();
        RecoveryPlan recoveryPlan = (RecoveryPlan)requestObj.get("plan");
        if (recoveryPlan == null) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_modifyRP_operateName", 3, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRP_operateName", 3, recoveryPlan.getPlanId());
        RecoveryPlan oldRecoveryPlan = null;
        try {
            oldRecoveryPlan = ((IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class)).getRecoveryPlan(recoveryPlan.getPlanId());
            if (oldRecoveryPlan == null) {
                throw new LegoCheckedException(1073947394L);
            }
            Map poRecoveryStatusMap = (Map)requestObj.get("poRecoveryStatusMap");
            ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncUpdateRecoveryPlan(recoveryPlan, poRecoveryStatusMap);
            this.writeSucOperationLog("recoveryPlan_modifyRP_operateName", 3, oldRecoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_modifyRP_operateName", 3, oldRecoveryPlan == null ? "" : oldRecoveryPlan.getName(), e);
        }
    }

    @Override
    @ParamValidator
    public void syncSaveReprotectUpdate(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)request.toObject();
        this.checkUserOperationAuthority("recoveryPlan_reProtect_operateName", 2, "ism.drm.drp.auth.reprotect");
        this.checkUserBizObjAuthority("recoveryPlan_reProtect_operateName", 2, recoveryPlan.getPlanId());
        try {
            ((IReprotectService)this.getBundleService(IReprotectService.class)).syncSaveReprotectUpdate(recoveryPlan);
            this.writeSucOperationLog("recoveryPlan_reProtect_operateName", 2, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_reProtect_operateName", 2, recoveryPlan.getName(), e);
        }
    }

    @Override
    public void syncRecoverySettings(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestObj = (Map)request.toObject();
        String planId = String.valueOf(requestObj.get("planId"));
        this.checkUserOperationAuthority("recoveryPlan_modifyRP_operateName", 3, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRP_operateName", 3, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = ((IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
            if (recoveryPlan == null) {
                throw new LegoCheckedException(1073947394L);
            }
            List settings = (List)requestObj.get("settings");
            ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncSaveOrUpdateRecoverySettings(planId, settings);
            this.writeSucOperationLog("recoveryPlan_modifyRP_operateName", 3, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_modifyRP_operateName", 3, recoveryPlan == null ? "" : recoveryPlan.getName(), e);
        }
    }

    @Override
    public void syncGlobalSettings(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestObj = (Map)request.toObject();
        String planId = String.valueOf(requestObj.get("planId"));
        this.checkPlanId(planId);
        this.checkUserOperationAuthority("recoveryPlan_modifyRecoveryStartSetting_operateName", 2, "ism.drm.drp.auth.recoverysetting.modify.operateID");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRecoveryStartSetting_operateName", 2, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanExtendService().getRecoveryPlan(planId);
            if (recoveryPlan == null) {
                throw new LegoCheckedException(1073947394L);
            }
            Map settings = (Map)requestObj.get("settings");
            this.getRecoveryPlanExtendService().saveOrUpdateGlobalSettings(planId, settings);
            this.writeSucOperationLog("recoveryPlan_modifyRecoveryStartSetting_operateName", 2, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_modifyRecoveryStartSetting_operateName", 2, recoveryPlan == null ? "" : recoveryPlan.getName(), e);
        }
    }

    @Override
    public void syncModifyRecoveryPlan(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)request.toObject();
        this.checkUserOperationAuthority("recoveryPlan_modifyRP_operateName", 3, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRP_operateName", 3, recoveryPlan.getPlanId());
        RecoveryPlan oldPlan = null;
        try {
            IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class);
            oldPlan = planService.queryRecoveryPlan(recoveryPlan.getPlanId(), false, false);
            if (oldPlan == null) {
                throw new LegoCheckedException(1073947394L);
            }
            ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncModifyRecoveryPlan(recoveryPlan);
            this.writeSucOperationLog("recoveryPlan_modifyRP_operateName", 3, oldPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_modifyRP_operateName", 3, oldPlan == null ? "" : oldPlan.getName(), e);
        }
    }

    @Override
    public void syncRemoveRecoveryPlan(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String recoveryPlanId = (String)request.toObject();
        this.checkUserOperationAuthority("recoveryPlan_delete_operateName", 2, "ism.drm.drp.auth.delete");
        this.checkUserBizObjAuthority("recoveryPlan_delete_operateName", 2, recoveryPlanId);
        IRecoveryPlanService rpService = (IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = rpService.getRecoveryPlan(recoveryPlanId);
        try {
            ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncRemoveRecoveryPlan(recoveryPlanId);
            this.writeSucOperationLog("recoveryPlan_delete_operateName", 2, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_delete_operateName", 2, recoveryPlan == null ? "" : recoveryPlan.getName(), e);
        }
    }

    @Override
    public String getRecoveryPlanProgress(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        List planIds = (List)request.toObject();
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        for (String planId : planIds) {
            this.checkPlanId(planId);
            this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        }
        Map planAndProgressMap = ((IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class)).getRecoveryPlansInfo(planIds);
        return this.constructResponseData(planAndProgressMap);
    }

    @Override
    public String getRecoveryPlanProcesses(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map params = (Map)request.toObject();
        String recoveryPlanId = (String)params.get("planId");
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, recoveryPlanId);
        String execTypeStr = (String)params.get("execType");
        DrmEnumDefine.RecoveryPlanExecuteTypeE execType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)NumberUtil.convertToInteger((Object)execTypeStr));
        List details = ((IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class)).getRecoveryProcessorDetailsByPlanId(recoveryPlanId, execType);
        return this.constructResponseData(details);
    }

    @Override
    public String getRecoveryProcessorDetail(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map params = (Map)request.toObject();
        String recoveryPlanId = (String)params.get("planId");
        this.checkPlanId(recoveryPlanId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, recoveryPlanId);
        String detailId = (String)params.get("detailId");
        RecoveryProcessorDetail detail = this.getRecoveryPlanExtendService().getRecoveryProcessorDetail(recoveryPlanId, detailId);
        if (detail == null) {
            throw new LegoCheckedException(1073947394L);
        }
        return this.constructResponseData(detail);
    }

    @Override
    public String getRecoveryProcessorDetails(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map params = (Map)request.toObject();
        String recoveryPlanId = (String)params.get("planId");
        this.checkPlanId(recoveryPlanId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, recoveryPlanId);
        String recoveryLogId = (String)params.get("logId");
        List details = ((IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class)).getRecoveryProcessorDetailsByLogId(recoveryPlanId, recoveryLogId);
        return this.constructResponseData(details);
    }

    @Override
    public String getRecoveryLogsByPlanId(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String recoveryPlanId = (String)request.toObject();
        this.checkPlanId(recoveryPlanId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, recoveryPlanId);
        List details = this.getRecoveryPlanExtendService().getHistoryReocveryLogsByPlanId(recoveryPlanId);
        return this.constructResponseData(details);
    }

    @Override
    public String getLatestHistoryRecoveryLog(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String recoveryPlanId = (String)request.toObject();
        this.checkPlanId(recoveryPlanId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, recoveryPlanId);
        RecoveryLog recoveryLog = this.getRecoveryPlanExtendService().getLatestHistoryRecoveryLog(recoveryPlanId);
        if (recoveryLog == null) {
            throw new LegoCheckedException(100L);
        }
        return this.constructResponseData(recoveryLog);
    }

    @Override
    public String getDrillingStatisticsInfo(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String recoveryPlanId = (String)request.toObject();
        this.checkPlanId(recoveryPlanId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, recoveryPlanId);
        Map statisticsInfo = this.getRecoveryPlanExtendService().getDrillingStatisticsInfo(recoveryPlanId);
        return this.constructResponseData(statisticsInfo);
    }

    @Override
    public String pageQueryRecoveryLogs(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String params = (String)request.toObject();
        JSONObject jsonObject = JSONObject.fromObject((Object)params);
        String planId = jsonObject.getString("planId");
        this.checkPlanId(planId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        int pageNum = jsonObject.getInt("pageNum");
        int pageSize = jsonObject.getInt("pageSize");
        String orderBy = jsonObject.getString("orderBy");
        Boolean isAsc = jsonObject.getBoolean("isAsc");
        Page page = this.getRecoveryPlanExtendService().pageQueryRecoveryLog(planId, pageNum, pageSize, orderBy, isAsc.booleanValue());
        return this.constructResponseData(page);
    }

    @Override
    public void syncRecoveryLogs(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String operationName = "recoveryPlan_updateRecoveryHistory_operateName";
        this.checkUserOperationAuthority(operationName, 1, "ism.drm.drp.auth.modify");
        List recoveryLogs = (List)request.toObject();
        if (VerifyUtil.isEmpty((Collection)recoveryLogs)) {
            return;
        }
        String planId = ((RecoveryLog)recoveryLogs.get(0)).getPlanId();
        this.checkUserBizObjAuthority(operationName, 1, planId);
        IRecoveryPlanService rpService = (IRecoveryPlanService)this.getBundleService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = rpService.getRecoveryPlan(planId);
        String name = recoveryPlan.getName();
        try {
            ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncRecoveryLogs(recoveryLogs);
            this.writeSucOperationLog(operationName, 1, name, "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog(operationName, 1, name, e);
        }
    }

    @Override
    public void syncAddCustomRecoveryProcessor(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestMsg = (Map)request.toObject();
        String planId = String.valueOf(requestMsg.get("planId"));
        this.checkPlanId(planId);
        this.checkUserOperationAuthority("recoveryPlan_addRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_addRecoveryStep_operateName", 2, planId);
        DrmEnumDefine.RecoveryPlanExecuteTypeE procType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)requestMsg.get("procType");
        Map params = (Map)requestMsg.get("params");
        if (params == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String indexProcId = String.valueOf(requestMsg.get("indexProcId"));
        boolean isBefore = Boolean.parseBoolean(String.valueOf(requestMsg.get("isBefore")));
        RecoveryPlan rp = this.getRecoveryPlanExtendService().getRecoveryPlan(planId);
        String stepName = String.valueOf(params.get("CUSTOM_PROCESSOR_NAME"));
        try {
            this.getCustomStepService().syncAddCustomRecoveryProcessor(planId, procType, params, indexProcId, isBefore);
            this.writeSucOperationLog("recoveryPlan_addRecoveryStep_operateName", 2, stepName, "recoveryPlan_addRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(procType)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_addRecoveryStep_operateName", 2, stepName, e);
        }
    }

    @Override
    public void syncUpdateRecoveryProcessorEnableStatus(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestMsg = (Map)request.toObject();
        String planId = String.valueOf(requestMsg.get("planId"));
        this.checkPlanId(planId);
        DrmEnumDefine.RecoveryPlanExecuteTypeE procType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)requestMsg.get("procType");
        String procId = String.valueOf(requestMsg.get("procId"));
        boolean isEnable = Boolean.parseBoolean(String.valueOf(requestMsg.get("isEnable")));
        RecoveryPlan rp = this.getRecoveryPlanExtendService().getRecoveryPlan(planId);
        RecoveryProcessor recoveryProcessor = this.getRecoveryPlanExtendService().getRecoveryProcessor(procId);
        if (isEnable) {
            this.checkUserOperationAuthority("recoveryPlan_enableRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
            this.checkUserBizObjAuthority("recoveryPlan_enableRecoveryStep_operateName", 2, planId);
            try {
                ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncEnableRecoveryProcessor(planId, procType, procId);
                this.writeSucOperationLog("recoveryPlan_enableRecoveryStep_operateName", 2, recoveryProcessor.getProcName(), "recoveryPlan_enableRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(procType)});
            }
            catch (Exception e) {
                this.writeFailedOperationLog("recoveryPlan_enableRecoveryStep_operateName", 2, recoveryProcessor == null ? "" : recoveryProcessor.getProcName(), e);
            }
        } else {
            this.checkUserOperationAuthority("recoveryPlan_disableRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
            this.checkUserBizObjAuthority("recoveryPlan_disableRecoveryStep_operateName", 2, planId);
            try {
                ((IRecoveryPlanSyncService)this.getBundleService(IRecoveryPlanSyncService.class)).syncDisableRecoveryProcessor(planId, procType, procId);
                this.writeSucOperationLog("recoveryPlan_disableRecoveryStep_operateName", 2, recoveryProcessor.getProcName(), "recoveryPlan_disableRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(procType)});
            }
            catch (Exception e) {
                this.writeFailedOperationLog("recoveryPlan_disableRecoveryStep_operateName", 2, recoveryProcessor == null ? "" : recoveryProcessor.getProcName(), e);
            }
        }
    }

    @Override
    public void syncDeleteRecoveryProcessor(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestMsg = (Map)request.toObject();
        String planId = String.valueOf(requestMsg.get("planId"));
        this.checkPlanId(planId);
        this.checkUserOperationAuthority("recoveryPlan_delRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_delRecoveryStep_operateName", 2, planId);
        DrmEnumDefine.RecoveryPlanExecuteTypeE procType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)requestMsg.get("procType");
        String procId = String.valueOf(requestMsg.get("procId"));
        RecoveryPlan rp = this.getRecoveryPlanExtendService().getRecoveryPlan(planId);
        RecoveryProcessor recoveryProcessor = this.getRecoveryPlanExtendService().getRecoveryProcessor(procId);
        try {
            this.getCustomStepService().syncDeleteRecoveryProcessor(planId, procType, procId);
            this.writeSucOperationLog("recoveryPlan_delRecoveryStep_operateName", 2, recoveryProcessor.getProcName(), "recoveryPlan_delRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(procType)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_delRecoveryStep_operateName", 2, recoveryProcessor == null ? "" : recoveryProcessor.getProcName(), e);
        }
    }

    @Override
    public void syncModifyCustomRecoveryProcessor(RestJsonRequest request) throws ClassNotFoundException {
        if (request == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestMsg = (Map)request.toObject();
        String planId = String.valueOf(requestMsg.get("planId"));
        this.checkPlanId(planId);
        this.checkUserOperationAuthority("recoveryPlan_modifyRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRecoveryStep_operateName", 2, planId);
        DrmEnumDefine.RecoveryPlanExecuteTypeE procType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)requestMsg.get("procType");
        String procId = String.valueOf(requestMsg.get("procId"));
        Map params = (Map)requestMsg.get("params");
        String oldProcName = null;
        try {
            IRecoveryPlanService planService = this.getRecoveryPlanExtendService();
            RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
            if (recoveryPlan == null) {
                throw new LegoCheckedException(1073947394L);
            }
            RecoveryProcessor processor = planService.getRecoveryProcessor(procId);
            if (processor == null) {
                throw new LegoCheckedException(1073947394L);
            }
            oldProcName = processor.getProcName();
            this.getCustomStepService().syncModifyCustomRecoveryProcessor(planId, procType, procId, params);
            this.writeSucOperationLog("recoveryPlan_modifyRecoveryStep_operateName", 2, oldProcName, "recoveryPlan_modifyRecoveryStep_operateDetail", new String[]{recoveryPlan.getName(), this.getKeyByType(procType)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_modifyRecoveryStep_operateName", 2, oldProcName == null ? "" : oldProcName, e);
        }
    }

    protected String getKeyByType(DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        switch (procType) {
            case DISASTER_RECOVERY: {
                return "recovery.term.abstact.excute.type.disaster_recovery";
            }
            case PLANED_MOTION: {
                return "recovery.term.abstact.excute.type.planed_motion";
            }
            case DRILLING: {
                return "recovery.term.abstact.excute.type.drilling";
            }
            case CLEAN_DRILLING: {
                return "recovery.term.abstact.excute.type.clean_drilling";
            }
            case SNAPSHOT_ROLLBACK: {
                return "recovery.term.abstact.excute.type.snapshot_rollback";
            }
            case REPROTECT: {
                return "recovery.term.abstact.excute.type.reprotect";
            }
        }
        return "recovery.term.abstact.excute.type.-1";
    }

    protected IRecoveryPlanCustomStepService getCustomStepService() {
        return (IRecoveryPlanCustomStepService)this.getBundleService("DRM_Base", IRecoveryPlanCustomStepService.class.getName());
    }

    protected void checkLicenseControl(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE rpOptType) {
        if (recoveryPlan == null || recoveryPlan.getProtectGroup() == null) {
            logger.error((Object)"recoveryPlan is null or recoveryPlan.getProtectGroups() is null ");
            throw new LegoCheckedException(1073947394L);
        }
        ILicenseControl licenseControl = (ILicenseControl)this.getBundleService("DRM_Base", ILicenseControl.class.getSimpleName(), ILicenseControl.class);
        if (licenseControl == null) {
            logger.error((Object)"licenseControl is null  ");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (pg == null) {
            logger.error((Object)"ProtectGroup is null.");
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate policyTemplate = pg.getTemplate();
        if (SIMPLE_LIC_CHECK_POLICY_TYPES.contains(policyTemplate.getType()) && DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK == rpOptType && pg.getPoType() == DrmEnumDefine.AppType.LUN.getValue()) {
            licenseControl.checkHasOneLic(pg);
            return;
        }
        licenseControl.isEnableRecoveryPlan(pg);
    }

    protected IRecoveryPlanService getRecoveryPlanExtendService() {
        return (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
    }
}

