/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.rest.service.platform.recovery.AbstractRecoveryPlanRestService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class RecoveryPlanQueryRestServiceImpl
extends AbstractRecoveryPlanRestService {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanQueryRestServiceImpl.class);

    protected void refactorGlobalSettings(RecoveryPlan rp) {
        Map globalSettings = rp.getGlobalSettings();
        HashMap<String, String> newGlobalSettings = new HashMap<String, String>();
        if (RecoveryPlan.MOUNT_PLAN.equals(rp.getUse())) {
            String replicaId = (String)globalSettings.get("REPLICA_ID");
            if (VerifyUtil.isEmpty((String)replicaId)) {
                return;
            }
            IReplicaService replicaService = (IReplicaService)this.getBundleService("DRM_Base", IReplicaService.class.getName());
            ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
            newGlobalSettings.put("ReplicaId", replicaId);
            if (VerifyUtil.isEmpty((Object)replica)) {
                return;
            }
            newGlobalSettings.put("ReplicaName", replica.getName());
            if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) {
                Date date = new Date(NumberUtil.convertToLong((Object)replica.getTimeStamp()));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String timeContent = dateFormat.format(date);
                String timeZoneStr = " " + TimeUtil.getDefaultTimeZone((Date)date);
                timeContent = timeContent + timeZoneStr;
                newGlobalSettings.put("timeStamp", timeContent);
            } else {
                newGlobalSettings.put("timeStamp", "--");
            }
            newGlobalSettings.put("ReplicaType", String.valueOf(replica.getType()));
            String mountConfigs = (String)replica.getProps().get("mountConfigs");
            MountConfiguration configuration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
            newGlobalSettings.put("StartTime", configuration.getStartTime());
            newGlobalSettings.put("UmountPreReplica", String.valueOf(configuration.isUnmountPreviousCopy()));
            newGlobalSettings.put("StartDB", String.valueOf(configuration.isStartDB()));
            newGlobalSettings.put("DeleteReplica", String.valueOf(configuration.isDeleteReplica()));
            newGlobalSettings.put("Description", String.valueOf(configuration.getDescription()));
            ISiteService siteService = (ISiteService)this.getBundleService(ISiteService.class);
            String siteId = configuration.getSiteId();
            Site site = siteService.getSiteById(siteId);
            newGlobalSettings.put("SiteId", siteId);
            newGlobalSettings.put("SiteName", site.getName());
            newGlobalSettings.put("isCloudSite", String.valueOf(site.getIsCloudSite()));
            String hostSnInGol = (String)globalSettings.get("PG_DISASTER_HOST");
            String hostSn = hostSnInGol == null ? configuration.getHostOrGroupSn() : hostSnInGol;
            String hostName = this.getRecoveryPlanService().getHostName(hostSn, site, rp.getProtectGroup());
            newGlobalSettings.put("MountHostName", hostName);
        }
        rp.setGlobalSettings(newGlobalSettings);
    }

    private RelicaStorageInfo getRelicaStorageInfo(ProtectGroup pg) {
        ProtectGroupReplica pgRep = pg.getAnyoneReplicationReplica();
        if (pgRep == null) {
            logger.error((Object)"The pgRep is null, pgName: %s.", new Object[]{pg.getName()});
            return null;
        }
        ProtectObjectReplica poRep = (ProtectObjectReplica)CommonUtil.getFirstElement((Collection)pgRep.getReplicas());
        if (poRep == null) {
            logger.error((Object)"The poRep is null, pgName: %s.", new Object[]{pg.getName()});
            return null;
        }
        return (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)poRep.getStorageInfos());
    }

    protected List<Site> getRecoverySiteList(ProtectGroup pg) {
        List<Site> siteList = new ArrayList<Site>();
        ISiteService siteService = (ISiteService)this.getBundleService(ISiteService.class);
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        if (pg.getTemplate().getType() == 20 || pg.getTemplate().getType() == 24 || pg.getTemplate().getType() == 27 || pg.getTemplate().getType() == 32) {
            RelicaStorageInfo storageInfo = this.getRelicaStorageInfo(pg);
            ProtectGroupReplica pgRep = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)pg.getReplicaList());
            if (pgRep == null) {
                logger.error((Object)"The pgRep is null,pgName:%s.", new Object[]{pg.getName()});
                return siteList;
            }
            Site recoverySite = siteService.getSiteById(pgRep.getRecoverySite());
            if (storageInfo == null) {
                logger.error((Object)"The storageInfo is null,pgName:%s.", new Object[]{pg.getName()});
                return siteList;
            }
            if (RecoveryPlanQueryRestServiceImpl.isProtectGroupUseNasFileSystem(pg)) {
                siteList = this.getNasSiteList(recoverySite, pg, storageInfo);
                if (VerifyUtil.isEmpty(siteList)) {
                    throw new LegoCheckedException(2117645L);
                }
                return siteList;
            }
            Lun lun = storageService.getLunBySnAndLunId(storageInfo.getStorageProviderSN(), storageInfo.getStorageId());
            if (lun == null) {
                logger.error((Object)"The lun is null,sn:%s, lunId:%s.", new Object[]{storageInfo.getStorageProviderSN(), storageInfo.getStorageId()});
                return siteList;
            }
            HashSet<String> wwnSet = new HashSet<String>();
            wwnSet.add(lun.getWwn());
            ArrayList<StorageResource> lunList = new ArrayList<StorageResource>(storageService.getStorageResourceByWwn(wwnSet.toArray(new String[0])));
            this.getSiteInfo(siteList, siteService, lunList);
            return siteList;
        }
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            if (ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)pgr)) continue;
            String recoverySiteId = pgr.getRecoverySite();
            Site recoverySite = siteService.getSiteById(recoverySiteId);
            CommUtils.checkObjectExists((Object[])new Object[]{recoverySite});
            siteList.add(recoverySite);
        }
        return siteList;
    }

    private static boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        logger.debug((Object)"Enter isProtectGroupUseNasFileSystem.");
        boolean isNas = false;
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)((ProtectObject)pg.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next();
        if (DrmEnumDefine.ResourceTypeE.NAS.getValue() == storageInfo.getResourceType().intValue()) {
            isNas = true;
        }
        return isNas;
    }

    private List<Site> getNasSiteList(Site recoverySite, ProtectGroup pg, RelicaStorageInfo storageInfo) {
        VstoreHyperMetroPair pair;
        HvsUnit hvsUnit;
        IStorageResourceService storageResourceService = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        String vStorePairId = (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        VstoreHyperMetroPair vstoreHyperMetroPair = storageResourceService.getVstoreHyperMetroPairById(storageInfo.getStorageProviderSN(), vStorePairId, Boolean.valueOf(false));
        if (vstoreHyperMetroPair == null) {
            return null;
        }
        String srcSn = storageInfo.getStorageProviderSN();
        List remotePairs = storageResourceService.getVstoreHyperPair(recoverySite.getServerUuid(), vstoreHyperMetroPair.getVstorePairId(), vstoreHyperMetroPair.getLocalVstoreId(), vstoreHyperMetroPair.getRemoteVstoreId());
        String remoteSn = null;
        Iterator iterator = remotePairs.iterator();
        while (iterator.hasNext() && srcSn.equals(remoteSn = (hvsUnit = (HvsUnit)(pair = (VstoreHyperMetroPair)iterator.next()).getParentMo()).getDevSn())) {
        }
        ArrayList<Site> siteList = new ArrayList<Site>();
        siteList.add(this.getSiteBySn(srcSn));
        siteList.add(this.getSiteBySn(remoteSn));
        return siteList;
    }

    private Site getSiteBySn(String devSn) {
        IResourceService resouceService = (IResourceService)this.getBundleService(IResourceService.class);
        ISiteService siteService = (ISiteService)this.getBundleService(ISiteService.class);
        DrResource drResource = resouceService.getDrResourceBySn(devSn);
        if (drResource != null) {
            Site site = siteService.getSiteById(drResource.getSiteId());
            CommUtils.checkObjectExists((Object[])new Object[]{site});
            return site;
        }
        return null;
    }

    private void getSiteInfo(List<Site> siteList, ISiteService siteService, List<StorageResource> lunList) {
        IResourceService resouceService = (IResourceService)this.getBundleService(IResourceService.class);
        for (StorageResource resource : lunList) {
            if (!(resource instanceof Lun)) continue;
            String devSn = resource.getDevSn();
            DrResource drResource = resouceService.getDrResourceBySn(devSn);
            if (drResource == null) {
                logger.error((Object)"The drResouce is null,devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                continue;
            }
            Site site = siteService.getSiteById(drResource.getSiteId());
            CommUtils.checkObjectExists((Object[])new Object[]{site});
            siteList.add(site);
        }
    }

    protected JSONObject buildRecoveryStepsJson(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, PolicyTemplate policyTemplate, RecoveryProcessor step) {
        JSONObject jsonObject = new JSONObject();
        boolean isEnable = step.getIsEnabled();
        boolean isEditable = step.getIsEditable();
        if (!isEnable && !isEditable) {
            logger.debug((Object)String.format(Locale.ROOT, "The stepId= %s ; stepName= %s is not view.", step.getProcId(), step.getProcName()));
            return null;
        }
        jsonObject.put((Object)"stepId", (Object)step.getProcId());
        jsonObject.put((Object)"stepName", (Object)step.getProcName());
        jsonObject.put((Object)"stepDescription", (Object)step.getDescription());
        jsonObject.put((Object)"name", (Object)step.getName());
        jsonObject.put((Object)"scriptName", (Object)"");
        String scriptSchemeId = (String)policyTemplate.getProps().get("scriptSchemeId");
        if (!VerifyUtil.isEmpty((String)scriptSchemeId)) {
            logger.info((Object)"Step use custom script scheme: %s", new Object[]{scriptSchemeId});
            jsonObject.put((Object)"scriptSchemeId", (Object)scriptSchemeId);
        }
        for (Schedule schedule : policyTemplate.getSchedules()) {
            logger.info((Object)String.format(Locale.ROOT, "Check schedule, type: %s, name: %s.", schedule.getProtectedType(), schedule.getName()));
            if (ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
                logger.debug((Object)"Schedule is not snapshot.");
                continue;
            }
            logger.info((Object)"Resolve public params for schedule: %s.", new Object[]{schedule.getName()});
            String publicParams = (String)schedule.getExtParameters().get("publicParam");
            jsonObject.put((Object)"publicParam", (Object)publicParams);
        }
        if (!step.getIsPreset().booleanValue()) {
            boolean isUserDefined;
            boolean bl = isUserDefined = !"false".equals(step.getProps().get("isUserDefined"));
            if (!isUserDefined) {
                jsonObject.put((Object)"recoveryScriptSchemeId", step.getProps().get("recoveryScriptSchemeId"));
            }
            Map stepSetting = this.getCustomStepService().getCustomRecoveryProcessorInfos(planId, type, step.getProcId());
            jsonObject.put((Object)"isContinueIfFailed", stepSetting.get("EXECUTE_POLICY"));
            jsonObject.put((Object)"stepName", stepSetting.get("CUSTOM_PROCESSOR_NAME"));
            jsonObject.put((Object)"scriptName", stepSetting.get("EXECUTE_SCRIPT_NAME"));
            jsonObject.put((Object)"executeParams", step.getProps().get("STEP_PARAMS"));
            jsonObject.put((Object)"isUserDefined", (Object)isUserDefined);
            jsonObject.put((Object)"position", step.getProps().get("position"));
        }
        jsonObject.put((Object)"isEnabled", (Object)step.getIsEnabled());
        jsonObject.put((Object)"isEditable", (Object)step.getIsEditable());
        jsonObject.put((Object)"isPresetled", (Object)step.getIsPreset());
        return jsonObject;
    }

    protected String toRecoveryPlanJson(RecoveryPlan recoveryPlan, String logId) {
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.debug((Object)"Param is null.");
            return "";
        }
        JSONObject rpJsonObj = new JSONObject();
        rpJsonObj.put((Object)"uuid", (Object)recoveryPlan.getUuid());
        rpJsonObj.put((Object)"name", (Object)recoveryPlan.getName());
        rpJsonObj.put((Object)"description", (Object)recoveryPlan.getDescription());
        rpJsonObj.put((Object)"planStatus", (Object)recoveryPlan.getPlanStatus());
        rpJsonObj.put((Object)"lastExecuteType", (Object)recoveryPlan.getLastExecuteType());
        rpJsonObj.put((Object)"lastTestStatus", (Object)recoveryPlan.getLastTestStatus());
        rpJsonObj.put((Object)"planProgress", (Object)recoveryPlan.getPlanProgress());
        rpJsonObj.put((Object)"planType", (Object)recoveryPlan.getPlanType());
        rpJsonObj.put((Object)"processStatus", (Object)recoveryPlan.getProcessStatus());
        if (logId == null) {
            rpJsonObj.put((Object)"logId", (Object)"");
        } else {
            rpJsonObj.put((Object)"logId", (Object)logId);
        }
        String protectGroupsJson = this.toProtectGroupJson(new ArrayList(recoveryPlan.getProtectGroups()));
        rpJsonObj.put((Object)"protectGroups", (Object)protectGroupsJson);
        rpJsonObj.put((Object)"isAllowExecute", (Object)this.isAllowExecuteRecoveryPlan(recoveryPlan));
        if (RecoveryPlan.MOUNT_PLAN.equals(recoveryPlan.getUse())) {
            rpJsonObj.put((Object)"globalSettings", (Object)recoveryPlan.getGlobalSettings());
        }
        rpJsonObj.put((Object)"isConfirmDelProdVm", (Object)LegoConfig.getInstance().getBoolean("is_confirm_del_prod_vm", Boolean.valueOf(true)));
        return rpJsonObj.toString();
    }
}

