/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.service.platform.recovery.ExecuteStepBean;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanQueryRestServiceImpl;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public class RecoveryPlanRestServiceImpl
extends RecoveryPlanQueryRestServiceImpl {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanRestServiceImpl.class);

    @Override
    public Response test(String planId, String disasterHostSn, String replicaId, String productSiteId, Map<String, String> recoveryContext) {
        this.checkTestParams(planId, disasterHostSn, replicaId, productSiteId);
        IResourceService resourceService = (IResourceService)this.getBundleService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(disasterHostSn);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserOperationAuthority("recoveryPlan_enableTest_operateName", 3, "ism.drm.drp.auth.test");
        this.checkUserBizObjAuthority("recoveryPlan_enableTest_operateName", 3, planId);
        this.checkUserBizObjAuthority("recoveryPlan_enableTest_operateName", 3, productSiteId);
        this.checkUserBizObjAuthority("recoveryPlan_enableTest_operateName", 3, resource.getSiteId());
        if (resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.checkUserMoAuthority("recoveryPlan_enableTest_operateName", 3, new String[]{drHost.getDeviceSn()});
            }
        } else {
            this.checkUserMoAuthority("recoveryPlan_enableTest_operateName", 3, new String[]{resource.getDeviceSn()});
        }
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRPService().getRecoveryPlan(planId, false, false);
            this.checkLicenseControl(recoveryPlan);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            recoveryContext.put("REPLICA_ID", replicaId);
            recoveryContext.put("DISASTER_SITE_ID", productSiteId);
            recoveryContext.put("PG_DISASTER_HOST", disasterHostSn);
            recoveryContext.put("disasterHostSn", disasterHostSn);
            ILocalRecoveryManager drpLocalService = (ILocalRecoveryManager)this.getBundleService(ILocalRecoveryManager.class.getName(), ILocalRecoveryManager.class);
            drpLocalService.startMountSnapshot(planId, recoveryContext, this.getCurrentUser());
            this.writeSucOperationLog("recoveryPlan_enableTest_operateName", 3, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Test failed, planId:%s, error: %s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.writeFailedOperationLog("recoveryPlan_enableTest_operateName", 3, recoveryPlan == null ? "" : recoveryPlan.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response testLocalCleanup(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_enableClear_operateName", 3, planId);
        this.checkUserOperationAuthority("recoveryPlan_enableClear_operateName", 3, "ism.drm.drp.auth.cleartest");
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRPService().getRecoveryPlan(planId, false, false);
            this.checkLicenseControl(recoveryPlan);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            ILocalRecoveryManager drpLocalService = (ILocalRecoveryManager)this.getBundleService(ILocalRecoveryManager.class.getName(), ILocalRecoveryManager.class);
            User currentUser = this.getCurrentUser();
            drpLocalService.startUmountSnapshot(planId, currentUser);
            this.writeSucOperationLog("recoveryPlan_enableClear_operateName", 3, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Clean failed. PlanId:%s, error: %s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.writeFailedOperationLog("recoveryPlan_enableClear_operateName", 3, recoveryPlan == null ? "" : recoveryPlan.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response executePlan(String planId, String disasterSiteId, String replicaId, String restoreSpeed) {
        logger.debug((Object)"Enter executePlan");
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)disasterSiteId) || VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)"Param null. planId:[%s], disasterSiteId:[%s], replicaId:[%s]", new Object[]{planId, disasterSiteId, replicaId});
            throw new LegoCheckedException(1073947393L);
        }
        if (restoreSpeed.length() > 1) {
            logger.error((Object)"Param restoreSpeed size larger than 1. expect 1.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)this.getBundleService(ISiteService.class)).getSiteById(disasterSiteId, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)site) || site.getSiteType() != 0) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_do_operateName", 2, planId);
        this.checkUserOperationAuthority("recoveryPlan_do_operateName", 2, "ism.drm.drp.local.auth.rollback");
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRPService().getRecoveryPlan(planId, false, false);
            this.checkLicenseControl(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            HashMap<String, String> drpSetting = new HashMap<String, String>();
            drpSetting.put("DISASTER_SITE_ID", disasterSiteId);
            drpSetting.put("REPLICA_ID", replicaId);
            drpSetting.put("ROLLBACK_RATE", restoreSpeed);
            ((ILocalRecoveryManager)this.getBundleService(ILocalRecoveryManager.class)).startRollBackSnapshot(planId, drpSetting, this.getCurrentUser());
            this.writeSucOperationLog("recoveryPlan_do_operateName", 2, recoveryPlan.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_do_operateName", 2, recoveryPlan == null ? "" : recoveryPlan.getName(), e);
        }
        return Response.ok().build();
    }

    private boolean isAutoExe() {
        String autoRecoveryValue;
        boolean result = true;
        ICloudConfigService cloudService = (ICloudConfigService)this.getBundleService(ICloudConfigService.class);
        CloudConfig config = cloudService.getCloudConfigBy("system");
        if (config != null && config.getProps() != null && !VerifyUtil.isEmpty((String)(autoRecoveryValue = (String)config.getProps().get("system_autorecovery")))) {
            result = Boolean.parseBoolean(autoRecoveryValue);
        }
        return result;
    }

    protected void checkConfirmReprotection(Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty(recoveryContext)) {
            return;
        }
        if (!recoveryContext.containsKey("is_confirm_del_prod_vm")) {
            return;
        }
        String confirmDelProdVm = recoveryContext.get("is_confirm_del_prod_vm");
        if (!Boolean.FALSE.toString().equals(confirmDelProdVm) && !Boolean.TRUE.toString().equals(confirmDelProdVm)) {
            logger.error((Object)"Parameter isConfirmDelProdVm of recoveryContext is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!recoveryContext.containsKey("is_confirm_reprotection")) {
            recoveryContext.put("is_confirm_reprotection", Boolean.TRUE.toString());
        } else {
            String confirmReprotectionSwitch = recoveryContext.get("is_confirm_reprotection");
            if (!Boolean.FALSE.toString().equalsIgnoreCase(confirmReprotectionSwitch) && !Boolean.TRUE.toString().equalsIgnoreCase(confirmReprotectionSwitch)) {
                logger.error((Object)"Parameter isConfirmReprotection  of recoveryContext is incorrect.");
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    @Override
    public String addStep(String planId, int procType, ExecuteStepBean stepBean) {
        logger.debug((Object)"Enter addStep.");
        if (VerifyUtil.isEmpty((String)planId) || stepBean == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String stepId = stepBean.getSibStepId();
        String stepName = stepBean.getName();
        String scriptName = stepBean.getScriptName();
        Boolean isBefore = stepBean.getIsBefore();
        Boolean execPolicy = stepBean.getIsContinueIfFailed();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, stepName, scriptName, isBefore, type, execPolicy});
        if (this.isStepBeanUnValid(stepName, scriptName)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_addRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_addRecoveryStep_operateName", 2, planId);
        try {
            RecoveryPlan rp = this.getRPService().getRecoveryPlan(planId);
            if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
                throw new LegoCheckedException(1073947453L);
            }
            HashMap<String, Object> steps = new HashMap<String, Object>();
            steps.put("CUSTOM_PROCESSOR_NAME", stepName);
            steps.put("EXECUTE_SCRIPT_NAME", scriptName);
            steps.put("EXECUTE_POLICY", execPolicy);
            steps.put("isUserDefined", Boolean.TRUE);
            stepId = this.getCustomStepService().addCustomRecoveryProcessor(planId, type, steps, stepId, isBefore.booleanValue());
            this.writeSucOperationLog("recoveryPlan_addRecoveryStep_operateName", 2, stepName, "recoveryPlan_addRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(type)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_addRecoveryStep_operateName", 2, stepName, e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"stepId", (Object)stepId);
        return jsonObject.toString();
    }

    @Override
    public Response disableStep(String planId, int procType, String stepId) {
        logger.debug((Object)"Enter disableStep.");
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, type});
        this.checkUserOperationAuthority("recoveryPlan_disableRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_disableRecoveryStep_operateName", 2, planId);
        try {
            IRecoveryPlanService rpService = this.getRPService();
            RecoveryPlan rp = rpService.getRecoveryPlan(planId);
            if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
                throw new LegoCheckedException(1073947453L);
            }
            RecoveryProcessor recoveryProcessor = rpService.getRecoveryProcessor(stepId);
            rpService.disableRecoveryProcessor(planId, type, stepId);
            this.writeSucOperationLog("recoveryPlan_disableRecoveryStep_operateName", 2, recoveryProcessor.getProcName(), "recoveryPlan_disableRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(type)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_addRecoveryStep_operateName", 2, "", e);
        }
        return Response.ok().build();
    }

    @Override
    public Response enableStep(String planId, int procType, String stepId) {
        logger.debug((Object)"Enter enableStep.");
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, type});
        this.checkUserOperationAuthority("recoveryPlan_enableRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_enableRecoveryStep_operateName", 2, planId);
        try {
            IRecoveryPlanService rpService = this.getRPService();
            RecoveryPlan rp = rpService.getRecoveryPlan(planId);
            if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
                throw new LegoCheckedException(1073947453L);
            }
            RecoveryProcessor recoveryProcessor = rpService.getRecoveryProcessor(stepId);
            rpService.enableRecoveryProcessor(planId, type, stepId);
            this.writeSucOperationLog("recoveryPlan_enableRecoveryStep_operateName", 2, recoveryProcessor.getProcName(), "recoveryPlan_enableRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(type)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_enableRecoveryStep_operateName", 2, "", e);
        }
        return Response.ok().build();
    }

    @Override
    public Response deleteStep(String planId, int procType, String stepId) {
        logger.debug((Object)"Enter deleteStep.");
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, type});
        this.checkUserOperationAuthority("recoveryPlan_delRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_delRecoveryStep_operateName", 2, planId);
        try {
            RecoveryPlan rp = this.getRPService().getRecoveryPlan(planId);
            if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
                throw new LegoCheckedException(1073947453L);
            }
            RecoveryProcessor recoveryProcessor = this.getRPService().getRecoveryProcessor(stepId);
            this.getCustomStepService().deleteRecoveryProcessor(planId, type, stepId);
            this.writeSucOperationLog("recoveryPlan_delRecoveryStep_operateName", 2, recoveryProcessor.getProcName(), "recoveryPlan_delRecoveryStep_operateDetail", new String[]{rp.getName(), this.getKeyByType(type)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_delRecoveryStep_operateName", 2, "", e);
        }
        return Response.ok().build();
    }

    @Override
    public Response editStep(String planId, int procType, String stepId, ExecuteStepBean stepBean) {
        logger.debug((Object)"Enter editStep.");
        if (stepBean == null || VerifyUtil.isEmpty((String)stepId)) {
            throw new LegoCheckedException(1073947393L);
        }
        String stepName = stepBean.getName();
        String scriptName = stepBean.getScriptName();
        Boolean execPolicy = stepBean.getIsContinueIfFailed();
        Map params = stepBean.getExecuteParams();
        Boolean isUserDefined = stepBean.getIsUserDefined();
        isUserDefined = isUserDefined != null ? isUserDefined : Boolean.TRUE;
        IRecoveryPlanService planService = this.getRPService();
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        this.editStepPreCheck(planId, type, stepBean, recoveryPlan);
        String oldProcName = null;
        JSONObject json = new JSONObject();
        try {
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            RecoveryProcessor processor = planService.getRecoveryProcessor(stepId);
            if (processor == null) {
                throw new LegoCheckedException(1073947394L);
            }
            oldProcName = processor.getProcName();
            HashMap<String, Object> steps = new HashMap<String, Object>();
            steps.put("CUSTOM_PROCESSOR_NAME", stepName);
            steps.put("EXECUTE_SCRIPT_NAME", scriptName);
            steps.put("EXECUTE_POLICY", execPolicy);
            steps.put("isUserDefined", isUserDefined);
            steps.put("recoveryScriptSchemeId", stepBean.getRecoveryScriptSchemeId());
            steps.put("STEP_PARAMS", params);
            steps.put("publicParam", stepBean.getPublicParams());
            json.putAll((Map)this.getCustomStepService().modifyCustomRecoveryProcessor(planId, type, stepId, steps));
            this.writeSucOperationLog("recoveryPlan_modifyRecoveryStep_operateName", 2, oldProcName, "recoveryPlan_modifyRecoveryStep_operateDetail", new String[]{recoveryPlan.getName(), this.getKeyByType(type)});
        }
        catch (Exception e) {
            this.writeFailedOperationLog("recoveryPlan_modifyRecoveryStep_operateName", 2, oldProcName == null ? "" : oldProcName, e);
        }
        return Response.ok().entity((Object)json.toString()).build();
    }

    private void editStepPreCheck(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, ExecuteStepBean stepBean, RecoveryPlan recoveryPlan) {
        boolean updatePublicParams;
        String stepName = stepBean.getName();
        String scriptName = stepBean.getScriptName();
        Boolean execPolicy = stepBean.getIsContinueIfFailed();
        Boolean isUserDefined = stepBean.getIsUserDefined();
        isUserDefined = isUserDefined != null ? isUserDefined : Boolean.TRUE;
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, type, stepName, scriptName, execPolicy});
        if (this.isStepBeanUnValid(stepName, scriptName)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_modifyRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRecoveryStep_operateName", 2, planId);
        if (recoveryPlan == null) {
            logger.error((Object)"Not find recovery plan, plan id is %s.", new Object[]{planId});
            this.writeFailedOperationLog("recoveryPlan_modifyRecoveryStep_operateName", 2, "", (Exception)((Object)new LegoCheckedException(1073948693L)));
        }
        if (!isUserDefined.booleanValue()) {
            IProtectGroupService protectGroupService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
            updatePublicParams = protectGroupService.checkPublicParamsChanged(recoveryPlan.getProtectGroup().getUuid(), stepBean.getPublicParams());
        } else {
            updatePublicParams = false;
        }
        if (updatePublicParams) {
            this.checkUserOperationAuthority("protectedGroup_modifyPolicy_operateName", 2, "ism.drm.protectgroup.auth.modify");
            this.checkUserBizObjAuthority("protectedGroup_modifyPolicy_operateName", 2, recoveryPlan.getProtectGroup().getUuid());
        }
    }

    @Override
    public Response swap(String planId) {
        return Response.ok().build();
    }

    private IRecoveryPlanService getRPService() {
        return (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
    }
}

