/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.replication;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.replication.IReplicationRestService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageReplicationService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.topo.sdk.model.ReplicationLinkTopoData;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.util.ObjectWrapper;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class ReplicationRestServiceImpl
extends AbstractRestService
implements IReplicationRestService {
    private static final String REPLICATION_SERVICE = IStorageReplicationService.class.getName();
    private static final Class<IStorageReplicationService> CLAZZ = IStorageReplicationService.class;
    private transient Log log = LogFactory.getInstance((Object)this);

    private IStorageService getStorageService() {
        this.log.trace((Object)"enter getStorageService");
        return (IStorageService)this.getBundleService("DRM_Base", IStorageService.class.getName());
    }

    @Override
    public String getReplicationTargetLun(String srcSN, String tgtSn, String tgtLunId) {
        if (VerifyUtil.isEmpty((String)tgtLunId) || VerifyUtil.isEmpty((String)srcSN) || VerifyUtil.isEmpty((String)tgtSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{srcSN});
        IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
        List tgtLunList = service.getTargetLunList(srcSN, tgtSn, tgtLunId.split(";"));
        if (null == tgtLunList || tgtLunList.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray array = new JSONArray();
        for (ReplicationTargetLun tgtLun : tgtLunList) {
            ReplicationPair parentMo = new ReplicationPair();
            ManagedObject mo = tgtLun.getParentMo();
            if (mo instanceof ReplicationPair) {
                parentMo = (ReplicationPair)mo;
            } else {
                this.log.info((Object)("Converting failed. ManagedObject:" + mo));
            }
            JSONObject object = new JSONObject();
            object.put((Object)"tgtDeviceName", (Object)tgtLun.getTgtDeviceName());
            object.put((Object)"dataStatus", (Object)tgtLun.getDataStatus());
            object.put((Object)"endTime", (Object)tgtLun.getEndTime());
            object.put((Object)"pairStatus", (Object)tgtLun.getPairStatus());
            object.put((Object)"progressRatio", (Object)(tgtLun.getProgressRatio() == null ? Integer.valueOf(-1) : tgtLun.getProgressRatio()));
            object.put((Object)"replicationPairId", (Object)tgtLun.getReplicationPairId());
            object.put((Object)"startTime", (Object)tgtLun.getStartTime());
            object.put((Object)"tgtDevSN", (Object)tgtLun.getTgtDevSN());
            object.put((Object)"tgtLunId", (Object)tgtLun.getTgtLunId());
            object.put((Object)"devSn", (Object)tgtLun.getDevSn());
            object.put((Object)"tgtLunName", (Object)tgtLun.getTgtLunName());
            object.put((Object)"isNeedInitSync", (Object)tgtLun.getIsNeedInitSync());
            object.put((Object)"resumePolicy", (Object)tgtLun.getResumePolicy());
            object.put((Object)"slientTime", (Object)tgtLun.getSlientTime());
            object.put((Object)"speedLevel", (Object)tgtLun.getSpeedLevel());
            object.put((Object)"syncMode", (Object)parentMo.getReplicationMode());
            object.put((Object)"syncType", (Object)tgtLun.getSyncType());
            object.put((Object)"name", (Object)parentMo.getName());
            object.put((Object)"timing", (Object)tgtLun.getTiming());
            object.put((Object)"consistentGroupId", (Object)parentMo.getConsistentGroupId());
            object.put((Object)"replicationMode", (Object)parentMo.getReplicationMode());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    public String getReplicationLinks(String srcSN, String tgtSn) {
        this.log.trace((Object)"enter getReplicationLinks");
        if (VerifyUtil.isEmpty((String)srcSN) || VerifyUtil.isEmpty((String)tgtSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{srcSN});
        IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
        List linkDetails = topoService.getLinkDetailInfo(srcSN, tgtSn);
        JSONArray array = new JSONArray();
        if (null == linkDetails || linkDetails.isEmpty()) {
            return array.toString();
        }
        for (ReplicationLinkTopoData link : linkDetails) {
            JSONObject object = new JSONObject();
            object.put((Object)"linkId", (Object)link.getLinkId());
            object.put((Object)"productArrayName", (Object)link.getProductArrayName());
            object.put((Object)"deviceId", (Object)link.getDeviceId());
            object.put((Object)"recoveryArrayName", (Object)link.getRecoveryArrayName());
            object.put((Object)"remoteArrayId", (Object)link.getRemoteArrayId());
            object.put((Object)"linkType", (Object)link.getLinkType());
            object.put((Object)"linkStatus", (Object)link.getLinkStatus());
            object.put((Object)"linkIp", (Object)(link.getLinkIp() != null ? link.getLinkIp() : ""));
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    public ObjectWrapper groupReplicationPairStatus(String srcSN, String tgtSn) {
        this.log.trace((Object)"enter groupReplicationPairStatus");
        if (VerifyUtil.isEmpty((String)srcSN) || VerifyUtil.isEmpty((String)tgtSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{srcSN});
        IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
        List resultList = service.groupReplicationPairStatus(srcSN, tgtSn);
        ObjectWrapper objWrapper = new ObjectWrapper();
        objWrapper.setClasssName(List.class.getName());
        objWrapper.setValue(ReverseObjectSerializableUtils.serializableObj((Object)resultList));
        return objWrapper;
    }

    @Override
    public String syncReplication(RestJsonRequest request) throws ClassNotFoundException {
        this.log.info((Object)"syncReplication begin.", 90160758786988L);
        Map params = (Map)request.toObject();
        String isConsistentGroup = (String)params.get("isConsistentGroup");
        String srcDeviceId = (String)params.get("srcDeviceId");
        String tgtDeviceId = (String)params.get("tgtDeviceId");
        String replicationId = (String)params.get("replicationId");
        if (VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId) || VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)isConsistentGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("site_resource_syncronizeStorage_operateName", SysoplogLevel.NORMAL.getValue(), "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("site_resource_syncronizeStorage_operateName", SysoplogLevel.NORMAL.getValue(), new String[]{srcDeviceId});
        StorageNE storage = this.getStorageService().getStorageBySn(srcDeviceId, this.getCurrentUserId());
        String storageName = storage == null ? srcDeviceId : storage.getName();
        OperationResult operationResult = null;
        try {
            IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
            operationResult = service.syncReplication(srcDeviceId, tgtDeviceId, replicationId, Boolean.valueOf(isConsistentGroup).booleanValue());
            this.log.info((Object)"syncReplication success.", 90160758786988L);
            this.writeSucOperationLog("site_resource_syncronizeStorage_operateName", SysoplogLevel.NORMAL.getValue(), storageName, null, null);
        }
        catch (Exception e) {
            this.log.error((Object)("syncReplication error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.writeFailedOperationLogNoException("site_resource_syncronizeStorage_operateName", SysoplogLevel.NORMAL.getValue(), storageName, e);
        }
        return this.constructResponseData(operationResult);
    }

    @Override
    public void refreshStorage(RestJsonRequest request) throws ClassNotFoundException {
        this.log.info((Object)"refreshStorage begin.", 90160758786988L);
        Map params = (Map)request.toObject();
        String deviceId = (String)params.get("deviceId");
        if (VerifyUtil.isEmpty((String)deviceId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("site_resource_refreshStorage_operateName", SysoplogLevel.NORMAL.getValue(), "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("site_resource_refreshStorage_operateName", SysoplogLevel.NORMAL.getValue(), new String[]{deviceId});
        StorageNE storage = this.getStorageService().getStorageBySn(deviceId, this.getCurrentUserId());
        String storageName = storage == null ? deviceId : storage.getName();
        try {
            IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
            service.refreshStorage(deviceId);
            this.log.info((Object)"refreshStorage success.", 90160758786988L);
            this.writeSucOperationLog("site_resource_refreshStorage_operateName", SysoplogLevel.NORMAL.getValue(), storageName, null, null);
        }
        catch (Exception e) {
            this.log.error((Object)("refreshStorage error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.writeFailedOperationLogNoException("site_resource_refreshStorage_operateName", SysoplogLevel.NORMAL.getValue(), storageName, e);
        }
    }

    @Override
    public String getReplication(RestJsonRequest request) throws ClassNotFoundException {
        this.log.trace((Object)"enter getReplication");
        Map params = (Map)request.toObject();
        String isConsistentGroup = (String)params.get("isConsistentGroup");
        String srcDeviceId = (String)params.get("srcDeviceId");
        String tgtDeviceId = (String)params.get("tgtDeviceId");
        String replicationId = (String)params.get("replicationId");
        if (VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId) || VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)isConsistentGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{srcDeviceId});
        IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
        ReplicationRelation relation = service.getReplication(srcDeviceId, tgtDeviceId, replicationId, Boolean.valueOf(isConsistentGroup).booleanValue());
        return this.constructResponseData(relation);
    }

    @Override
    public String querySyncStatus(RestJsonRequest request) throws ClassNotFoundException {
        this.log.trace((Object)"enter querySyncStatus");
        Map params = (Map)request.toObject();
        String isConsistentGroup = (String)params.get("isConsistentGroup");
        String srcDeviceId = (String)params.get("srcDeviceId");
        String tgtDeviceId = (String)params.get("tgtDeviceId");
        String replicationId = (String)params.get("replicationId");
        if (VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId) || VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)isConsistentGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{srcDeviceId});
        IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
        List targetLuns = service.querySyncStatus(srcDeviceId, tgtDeviceId, replicationId, Boolean.valueOf(isConsistentGroup).booleanValue());
        return this.constructResponseData(targetLuns);
    }

    @Override
    public Response modifyReplication(String devSn, String replicationId, boolean isConsistentGroup, JSONObject messageBody) {
        this.log.debug((Object)("Enter modify, sn=" + devSn + ", id=" + replicationId + "isCg=" + isConsistentGroup + ", params=" + messageBody));
        this.checkUserOperationAuthority("site_storage_modifyReplication_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        VerifyUtil.checkStrs((String[])new String[]{devSn, replicationId});
        if (null == messageBody || messageBody.isEmpty()) {
            this.log.error((Object)"params is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("site_storage_modifyReplication_operateName", 1, new String[]{devSn});
        try {
            Class type = isConsistentGroup ? ReplicationGroup.class : ReplicationPair.class;
            Map<String, Object> params = this.jsonObj2Map(messageBody);
            IStorageReplicationService replicationService = (IStorageReplicationService)this.getBundleService(IStorageReplicationService.class);
            replicationService.modifyReplication(devSn, replicationId, isConsistentGroup, params);
            this.writeSucOperationLog("site_storage_modifyReplication_operateName", 1, replicationId, "site_storage_modifyReplication_operateDetail", new String[]{replicationId, devSn, type.getSimpleName()});
        }
        catch (Exception ex) {
            this.log.error((Object)("modify replication failed, sn=" + devSn + ", id=" + replicationId + "isCg=" + isConsistentGroup + ", params=" + messageBody), (Throwable)ex);
            this.writeFailedOperationLog("site_storage_modifyReplication_operateName", 1, replicationId, ex);
        }
        this.log.debug((Object)"Exit modify.");
        return Response.ok().build();
    }

    private Map<String, Object> jsonObj2Map(JSONObject json) {
        this.log.trace((Object)"enter jsonObj2Map");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == json || json.isEmpty()) {
            return map;
        }
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Map<String, Object> value = json.get(key);
            if (value instanceof JSONObject) {
                value = this.jsonObj2Map((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.jsonArray2List((JSONArray)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private List<Object> jsonArray2List(JSONArray jsonArr) {
        this.log.trace((Object)"enter jsonArray2List");
        ArrayList<Object> list = new ArrayList<Object>();
        if (null == jsonArr || jsonArr.isEmpty()) {
            return list;
        }
        for (int i = 0; i < jsonArr.size(); ++i) {
            Map<String, Object> value = jsonArr.get(i);
            if (value instanceof JSONObject) {
                value = this.jsonObj2Map((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.jsonArray2List((JSONArray)value);
            }
            list.add(value);
        }
        return list;
    }
}

