/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.storage;

import com.huawei.ism.array.sdk.model.DeleteLunRequest;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.util.RestJsonRequest;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface IStorageRestService {
    @GET
    @Path(value="/getSerializableLunByStorageSnAndLunID")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RestJsonRequest getSerializableLunByStorageSnAndLunID(@QueryParam(value="storageSN") String var1, @QueryParam(value="lunId") String var2);

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getStorageList(@QueryParam(value="siteId") String var1, @QueryParam(value="deviceSn") String var2, @QueryParam(value="deviceType") @DefaultValue(value="-1") int var3);

    @GET
    @Path(value="/{devSn}/action/getReplicationPairBySrcLunIds")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getReplicationPairBySrcLunIds(@PathParam(value="devSn") String var1, @QueryParam(value="lunIds") String var2, @QueryParam(value="isFromDevice") boolean var3);

    @GET
    @Path(value="/{devSn}/luns/action/getBatchByLunIds")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getLunByIds(@PathParam(value="devSn") String var1, @QueryParam(value="lunIds") String var2, @QueryParam(value="isFromDevice") @DefaultValue(value="false") boolean var3);

    @GET
    @Path(value="/action/getStorageResourceByWwn")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getStorageResourceByWwn(@QueryParam(value="wwn") String var1);

    @POST
    @Path(value="/action/getStorageResourceByWwn")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String queryStorageResourceByWwn(RestJsonRequest var1) throws ClassNotFoundException;

    @POST
    @Path(value="/storageresources/")
    public String getStorageResourcesByDeviceSnAndResourceIds(RestJsonRequest var1) throws ClassNotFoundException;

    @PUT
    @Path(value="/{devSn}/action/refresh")
    public Response refreshStorage(@PathParam(value="devSn") String var1);

    @GET
    @Path(value="/{devSn}/action/getStorageUnitInfo")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getStorageUnitInfo(@PathParam(value="devSn") String var1);

    @GET
    @Path(value="/action/getSrcLunByReplicationUUID")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getSrcLunByReplicationUUID(@QueryParam(value="replicationId") String var1);

    @GET
    @Path(value="/{devSn}/storageResource")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getStorageResources(@PathParam(value="devSn") String var1, @QueryParam(value="ids") String var2, @QueryParam(value="isFromDevice") boolean var3);

    @GET
    @Path(value="/{devSn}/initiators")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getInitiatorsByDevsn(@PathParam(value="devSn") String var1);

    @GET
    @Path(value="/{devSn}/hostinitiators")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getHostInitiators(@PathParam(value="devSn") String var1, @QueryParam(value="hostSn") String var2);

    @PUT
    @Path(value="/{deviceSn}/action/getStorageResourcesStatistic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getStorageResourcesStatistic(@PathParam(value="deviceSn") String var1, @QueryParam(value="templateType") int var2, List<StorageResource> var3);

    @GET
    @Path(value="/{devSn}/quorumserverlinks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getQuorumServerlinks(@PathParam(value="devSn") String var1, @QueryParam(value="quorumServerId") String var2);

    @GET
    @Path(value="/{devSn}/quorumdomains")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getQuorumDomains(@PathParam(value="devSn") String var1);

    @GET
    @Path(value="/{devSn}/quorumservers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getQuorumServers(@PathParam(value="devSn") String var1);

    @GET
    @Path(value="/{deviceSn}/action/getSupportedCapabilities")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getSupportedCapabilities(@PathParam(value="deviceSn") String var1);

    @GET
    @Path(value="/{devSn}/remoteDevices")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getRemoteDevices(@PathParam(value="devSn") String var1, @QueryParam(value="siteId") String var2);

    @GET
    @Path(value="/{devSn}/action/getHyperVaultTargetFs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getHyperVaultCandidateTargetFs(@PathParam(value="devSn") String var1, @QueryParam(value="srcFileSystemId") String var2, @QueryParam(value="remoteDeviceSn") String var3);

    @GET
    @Path(value="/{devSn}/hyperMetroConsistentGroup/{cgId}")
    public String getHyperMetroConsistentGroup(@PathParam(value="devSn") String var1, @PathParam(value="cgId") String var2, @QueryParam(value="isRealTime") @DefaultValue(value="false") boolean var3);

    @GET
    @Path(value="/hyperMetroPair")
    public String getHyperMetroPairsByWwns(@QueryParam(value="wwns") String var1, @QueryParam(value="roleType") int var2, @QueryParam(value="devSn") String var3, @QueryParam(value="isRealTime") @DefaultValue(value="false") boolean var4);

    @GET
    @Path(value="/nasHyperMetroPair")
    public String getHyperMetroPairsBySystem(@QueryParam(value="fileIds") String var1, @QueryParam(value="roleType") int var2, @QueryParam(value="devSn") String var3, @QueryParam(value="vstoreId") String var4, @QueryParam(value="isRealTime") @DefaultValue(value="false") boolean var5);

    @PUT
    @Path(value="/{devSn}/hyperMetros/{hyperMetroId}/action/sync")
    public Response synchronize(@PathParam(value="devSn") String var1, @PathParam(value="hyperMetroId") String var2, @QueryParam(value="isCg") boolean var3, @QueryParam(value="vstoreId") String var4);

    @PUT
    @Path(value="/{devSn}/hyperMetros/{hyperMetroId}/action/disable")
    public Response disable(@PathParam(value="devSn") String var1, @PathParam(value="hyperMetroId") String var2, @QueryParam(value="role") Integer var3, @QueryParam(value="isCg") boolean var4, @QueryParam(value="vstoreId") String var5);

    @GET
    @Path(value="/filesystem")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getFileSystemByVstoreUUID(@QueryParam(value="vstoreuuid") String var1);

    @GET
    @Path(value="/{devSn}/filesystem/realtime/{vstoreId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getFileSystemByVstoreId(@PathParam(value="devSn") String var1, @PathParam(value="vstoreId") String var2);

    @GET
    @Path(value="/{devSn}/vstore_hypermetro_pair/{isAssociate}/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getVstoreHyperMetroPair(@PathParam(value="devSn") String var1, @PathParam(value="isAssociate") Boolean var2, @PathParam(value="id") String var3);

    @GET
    @Path(value="/vstore_hypermetro_pair/remote")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getRemoteVstoreHyperMetroPair(@QueryParam(value="vstorePairId") String var1, @QueryParam(value="localVstoreId") String var2, @QueryParam(value="remoteVstoreId") String var3);

    @POST
    @Path(value="/{devSn}/vstore_hypermetro_pair/swap/{vstorePairId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response swapVstoreHyperMetroPair(@PathParam(value="devSn") String var1, @PathParam(value="vstorePairId") String var2);

    @GET
    @Path(value="/{devSn}/vstore/{vstoreId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getVstoreById(@PathParam(value="devSn") String var1, @PathParam(value="vstoreId") String var2);

    @GET
    @Path(value="/{devSn}/replicationpairs")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getReplicationPairsByResourceIds(@PathParam(value="devSn") String var1, @QueryParam(value="resIds") String var2, @QueryParam(value="isPrimary") @DefaultValue(value="true") boolean var3);

    @GET
    @Path(value="/{storageSn}/licenses")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public StorageLicense getStorageAllLicense(@PathParam(value="storageSn") String var1);

    @GET
    @Path(value="/{devSn}/targetStorages")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String queryTargetStorages(@PathParam(value="devSn") String var1);

    @POST
    @Path(value="/{devSn}/lun")
    public Response createLun(@PathParam(value="devSn") String var1, Lun var2);

    @PUT
    @Path(value="/{devSn}/lun/{lunName}")
    public Response updateLun(@PathParam(value="devSn") String var1, @PathParam(value="lunName") String var2, Lun var3);

    @DELETE
    @Path(value="/{devSn}/lun")
    public Response deleteLun(@PathParam(value="devSn") String var1, DeleteLunRequest var2);

    @GET
    @Path(value="/storagepools")
    public String queryStoragePools(@QueryParam(value="siteId") String var1);

    @GET
    @Path(value="/{devSn}/lun/{lunName}")
    public String queryLunByName(@PathParam(value="devSn") String var1, @PathParam(value="lunName") String var2);

    @GET
    @Path(value="/{devSn}/hypermetroDomain")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String gethypermetroDomain(@PathParam(value="devSn") String var1, @QueryParam(value="remoteSn") String var2, @QueryParam(value="controlClusterId") String var3);

    @GET
    @Path(value="{devSn}/controlClusters")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getControlClusters(@PathParam(value="devSn") String var1);
}

