/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.storage;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.DeleteLunRequest;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.ResultListVo;
import com.huawei.ism.drm.constant.DeviceType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.storage.IStorageRestService;
import com.huawei.ism.drm.rest.util.DrmStorageUtil;
import com.huawei.ism.drm.rest.util.ManualRefreshManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourcePoolService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;

public class StorageRestServiceImpl
extends AbstractRestService
implements IStorageRestService {
    private static transient Log logger = LogFactory.getInstance(StorageRestServiceImpl.class);
    private static final String STORAGE_SERVICE_NAME = IStorageService.class.getName();
    private static final String RESULT_NAME = "name";
    private static final String RESULT_STATUS = "status";
    private static final String RESULT_CAPACITY = "capacity";

    private IStorageService getStorageService() {
        return (IStorageService)this.getBundleService("DRM_Base", IStorageService.class.getName());
    }

    @Override
    public RestJsonRequest getSerializableLunByStorageSnAndLunID(String storageSN, String lunId) {
        logger.trace((Object)"enter getSerializableLunByStorageSnAndLunID");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)storageSN) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)lunId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{storageSN});
        RestJsonRequest rjq = new RestJsonRequest();
        Lun lun = this.getStorageService().getLunBySnAndLunId(storageSN, lunId);
        lun.setChildMos(null);
        lun.setLunMappings(null);
        lun.setParentMo(null);
        rjq.setClasssName(Lun.class.getName());
        rjq.setValue(ReverseObjectSerializableUtils.serializableObj((Object)lun));
        return rjq;
    }

    @Override
    public String getStorageList(String siteId, String deviceSn, int deviceType) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        Optional deviceTypeOptional = DeviceType.getDeviceType((int)deviceType);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)siteId) && com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn) && !deviceTypeOptional.isPresent()) {
            logger.error((Object)"Get storage list failed, param error.");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService storageService = this.getStorageService();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)siteId)) {
            this.checkUserBizObjAuthority("resource_queryRes_operateName", 2, siteId);
            List storages = storageService.getStorageListBySiteId(siteId, this.getCurrentUserId());
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)storages)) {
                return "[]";
            }
            return this.toJsonStr(this.filterBySn(deviceSn, storages));
        }
        if (deviceTypeOptional.isPresent() && com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn)) {
            List storageList = storageService.queryStorageList((DeviceType)deviceTypeOptional.get());
            return this.filterStoragesByUserAuthority(storageList).toString();
        }
        List storageList = storageService.getStorageList(deviceSn.split(";"));
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)storageList)) {
            return array.toString();
        }
        for (StorageNE storageNE : storageList) {
            try {
                this.checkUserAuthorityByMoIds(new long[]{storageNE.getMoId()});
                JSONObject object = new JSONObject();
                object.put((Object)"deviceSn", (Object)storageNE.getSn());
                object.put((Object)RESULT_NAME, (Object)storageNE.getName());
                object.put((Object)"IpAddress", (Object)storageNE.getIpAddress());
                object.put((Object)"productModel", (Object)storageNE.getProductModel());
                object.put((Object)RESULT_STATUS, (Object)storageNE.getStatus());
                object.put((Object)"version", (Object)storageNE.getVersion());
                array.add((Object)object);
            }
            catch (LegoCheckedException ex) {
                logger.info((Object)("sn=" + storageNE.getSn() + " checkUserAuthority failed."), 90160758784000L);
            }
        }
        return array.toString();
    }

    private JSONArray filterStoragesByUserAuthority(List<StorageUnit> storageList) {
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(storageList)) {
            logger.info((Object)"Jump over filter storages by user authority, storage list is Empty.");
            return array;
        }
        this.filterMoListByUserAuthority(storageList).stream().map(this::translateStorageJson).forEach(arg_0 -> ((JSONArray)array).add(arg_0));
        return array;
    }

    private JSONObject translateStorageJson(StorageUnit storageUnit) {
        JSONObject object = new JSONObject();
        object.put((Object)"deviceSn", (Object)storageUnit.getDevSn());
        object.put((Object)RESULT_NAME, (Object)storageUnit.getName());
        object.put((Object)"productModel", (Object)storageUnit.getProductModel());
        object.put((Object)RESULT_STATUS, (Object)storageUnit.getStatus());
        object.put((Object)"IpAddress", (Object)storageUnit.getIpAddress());
        return object;
    }

    private List<DrStorage> filterBySn(String sns, List<DrStorage> storages) {
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)sns)) {
            ArrayList<DrStorage> storagesBySn = new ArrayList<DrStorage>();
            ArrayList<String> snList = new ArrayList<String>(Arrays.asList(sns.split(";")));
            for (DrStorage storage : storages) {
                if (!snList.contains(storage.getDeviceSn())) continue;
                storagesBySn.add(storage);
            }
            return storagesBySn;
        }
        return storages;
    }

    @Override
    public String getLunByIds(String devSn, String lunIds, boolean isFromDevice) {
        logger.trace((Object)"enter getLunByIds");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)StringUtil.trim((String)devSn)) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)StringUtil.trim((String)lunIds))) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        List list = null;
        if (isFromDevice) {
            list = this.getStorageService().queryLunByDevSnAndLunIds(devSn, Arrays.asList(lunIds.split(";")));
        } else {
            ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
            QueryCondition cond = new QueryCondition("lunId", (Object)lunIds.split(";"));
            queryCondition.add(cond);
            list = this.getStorageService().queryLunByStorageSn(devSn, null, true, queryCondition);
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
            return this.lunListToJsonArray(list);
        }
        throw new LegoCheckedException(1073947394L);
    }

    @Override
    public String getStorageResourceByWwn(String wwn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)wwn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService service = (IStorageService)this.getBundleService(STORAGE_SERVICE_NAME, IStorageService.class);
        List resource = service.getStorageResourceByWwn(wwn.split(";"));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray array = new JSONArray();
        for (StorageResource each : resource) {
            try {
                this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{each.getDevSn()});
            }
            catch (Exception e) {
                logger.info((Object)("StorageResource(" + each.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            if (!(each instanceof Lun)) continue;
            Lun lun = (Lun)each;
            JSONObject object = this.converLunToJsonObj(lun);
            object.put((Object)"moId", (Object)lun.getMoId());
            object.put((Object)"resourceType", (Object)DrmEnumDefine.ResourceTypeE.LUN.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    private String lunListToJsonArray(List<Lun> lunList) {
        logger.trace((Object)"enter lunListToJsonArray");
        JSONArray array = new JSONArray();
        for (Lun lun : lunList) {
            JSONObject object = this.converLunToJsonObj(lun);
            array.add((Object)object);
        }
        return array.toString();
    }

    private JSONObject converLunToJsonObj(Lun lun) {
        logger.trace((Object)"enter converLunToJsonObj");
        JSONObject object = new JSONObject();
        object.put((Object)"resourceId", (Object)lun.getResourceId());
        object.put((Object)"lunId", (Object)lun.getLunId());
        object.put((Object)"devSn", (Object)lun.getDevSn());
        object.put((Object)RESULT_NAME, (Object)lun.getName());
        object.put((Object)"mapped", (Object)lun.getMapped());
        object.put((Object)"usedCapacity", (Object)lun.getUsedCapacity());
        object.put((Object)"totalCapacity", (Object)lun.getTotalCapacity());
        object.put((Object)"totalCapacityUnit", (Object)lun.getTotalCapacityUnit());
        object.put((Object)"wwn", (Object)lun.getWwn());
        object.put((Object)"runningStatus", (Object)lun.getRunningStatus());
        object.put((Object)"healthStatus", (Object)lun.getHealthStatus());
        return object;
    }

    @Override
    public String queryStorageResourceByWwn(RestJsonRequest request) throws ClassNotFoundException {
        Map params = (Map)request.toObject();
        String wwn = (String)params.get("wwn");
        return this.constructResponseData(this.getStorageResourceByWwn(wwn));
    }

    @Override
    public String getStorageResourcesByDeviceSnAndResourceIds(RestJsonRequest request) throws ClassNotFoundException {
        logger.trace((Object)"enter getStorageResourcesByDeviceSnAndResourceIds");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)request)) {
            throw new LegoCheckedException(1073947393L);
        }
        Map requestObj = (Map)request.toObject();
        String deviceSn = String.valueOf(requestObj.get("deviceSn"));
        ArrayList resourceIds = (ArrayList)requestObj.get("ResourceIds");
        ArrayList resourceNames = (ArrayList)requestObj.get("resourceNames");
        List<StorageResource> storageResources = null;
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)resourceIds)) {
            storageResources = this.getStorageResources(deviceSn, resourceIds, false);
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)resourceNames)) {
            storageResources = this.getStorageResources(deviceSn, resourceNames, true);
        }
        return this.constructResponseData(storageResources);
    }

    private List<StorageResource> getStorageResources(String deviceSn, List<String> resourceIdOrNames, boolean isUseName) {
        logger.trace((Object)"enter getStorageResources");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService storageService = (IStorageService)this.getBundleService(STORAGE_SERVICE_NAME, IStorageService.class);
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{deviceSn});
        List resources = null;
        resources = isUseName ? storageService.getStorageResources(deviceSn, resourceIdOrNames, true) : storageService.getStorageResources(deviceSn, resourceIdOrNames);
        return resources;
    }

    @Override
    public String getReplicationPairBySrcLunIds(String devSn, String lunIds, boolean isFromDevice) {
        logger.trace((Object)"enter getReplicationPairBySrcLunIds");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)lunIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        String[] strLunArray = lunIds.split(";");
        ArrayList<String> listSrcLunIds = new ArrayList<String>(Arrays.asList(strLunArray));
        List listPairs = this.getStorageService().queryReplicationPairsByMasterLunId(devSn, listSrcLunIds, isFromDevice);
        return this.replicationPairListToJsonArray(listPairs);
    }

    private String replicationPairListToJsonArray(List<ReplicationPair> listPairs) {
        logger.trace((Object)"enter replicationPairListToJsonArray");
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(listPairs)) {
            return array.toString();
        }
        for (ReplicationPair rpPair : listPairs) {
            JSONObject object = new JSONObject();
            object.put((Object)"consistentGroupId", (Object)rpPair.getConsistentGroupId());
            object.put((Object)"srcLunId", (Object)rpPair.getSrcLunId());
            object.put((Object)"srcLunName", (Object)rpPair.getSrcLunName());
            object.put((Object)"srcLunStatus", (Object)rpPair.getSrcLunStatus());
            object.put((Object)"tgtDevName", (Object)rpPair.getTgtDevName());
            object.put((Object)"srcDevSN", (Object)rpPair.getSrcDevSN());
            object.put((Object)"replicationMode", (Object)rpPair.getReplicationMode());
            object.put((Object)"replicationId", (Object)rpPair.getReplicationId());
            object.put((Object)"replicationName", (Object)rpPair.getReplicationName());
            object.put((Object)"repStatus", (Object)rpPair.getRepStatus());
            object.put((Object)"devSn", (Object)rpPair.getDevSn());
            object.put((Object)"srcLocation", (Object)rpPair.getSrcLocation());
            object.put((Object)"localResType", (Object)rpPair.getLocalResType());
            object.put((Object)"isPrimary", (Object)rpPair.getIsPrimary());
            object.put((Object)"drRingId", (Object)rpPair.getDrRingId());
            JSONArray repTgtLunArray = this.replicationTargetLunListToJsonArray(rpPair);
            object.put((Object)"repTgtLuns", (Object)repTgtLunArray);
            array.add((Object)object);
        }
        return array.toString();
    }

    private JSONArray replicationTargetLunListToJsonArray(ReplicationPair rpPair) {
        logger.trace((Object)"enter replicationTargetLunListToJsonArray");
        List repTgtLuns = rpPair.getRepTgtLuns();
        JSONArray repTgtLunArray = new JSONArray();
        for (ReplicationTargetLun oneRepTgtLun : repTgtLuns) {
            JSONObject repTgtLunJson = new JSONObject();
            repTgtLunJson.put((Object)"dataStatus", (Object)oneRepTgtLun.getDataStatus());
            repTgtLunJson.put((Object)"devSn", (Object)oneRepTgtLun.getDevSn());
            repTgtLunJson.put((Object)"isNeedInitSync", (Object)oneRepTgtLun.getIsNeedInitSync());
            repTgtLunJson.put((Object)"isPrimary", (Object)oneRepTgtLun.getIsPrimary());
            repTgtLunJson.put((Object)"pairStatus", (Object)oneRepTgtLun.getPairStatus());
            repTgtLunJson.put((Object)"replicationPairId", (Object)oneRepTgtLun.getReplicationPairId());
            repTgtLunJson.put((Object)"syncMode", (Object)oneRepTgtLun.getSyncMode());
            repTgtLunJson.put((Object)"tgtDeviceName", (Object)oneRepTgtLun.getTgtDeviceName());
            repTgtLunJson.put((Object)"tgtDevSN", (Object)oneRepTgtLun.getTgtDevSN());
            repTgtLunJson.put((Object)"tgtLunId", (Object)oneRepTgtLun.getTgtLunId());
            repTgtLunJson.put((Object)"tgtLunName", (Object)oneRepTgtLun.getTgtLunName());
            repTgtLunArray.add((Object)repTgtLunJson);
        }
        return repTgtLunArray;
    }

    private String toJsonStr(List<DrStorage> resultList) {
        logger.trace((Object)"enter toJsonStr");
        JSONArray resultArray = new JSONArray();
        for (DrStorage ds : resultList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)RESULT_NAME, (Object)ds.getName());
            jsonObject.put((Object)"deviceSn", (Object)ds.getDeviceSn());
            jsonObject.put((Object)"ipAddress", (Object)ds.getIpAddress());
            jsonObject.put((Object)"productModel", (Object)ds.getProductModel());
            jsonObject.put((Object)RESULT_STATUS, (Object)ds.getStatus());
            resultArray.add((Object)jsonObject);
        }
        return resultArray.toString();
    }

    @Override
    public Response refreshStorage(String devSn) {
        logger.trace((Object)"enter refreshStorage");
        this.checkUserOperationAuthority("resource_refresh_operateName", 3, "ism.drm.site.resource.auth.management.operateID");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_refresh_operateName", 3, new String[]{devSn});
        StorageNE storage = this.getStorageService().getStorageBySn(devSn, this.getCurrentUserId());
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)storage)) {
            throw new LegoCheckedException(1073947394L);
        }
        try {
            ManualRefreshManager.getInstance().refresh((NetworkEntity)storage, this.refreshCall(storage));
            this.writeSucOperationLog("resource_refresh_operateName", 3, storage.getName(), "resource_refresh_operateDetail", new String[]{storage.getName(), storage.getLinkIp()});
        }
        catch (Exception ex) {
            this.writeFailedOperationLog("resource_refresh_operateName", 3, storage.getName(), ex);
        }
        return Response.ok().build();
    }

    private Callable<Boolean> refreshCall(final StorageNE arrayMo) {
        logger.trace((Object)"enter refreshCall");
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                IStorageService storageService = StorageRestServiceImpl.this.getStorageService();
                storageService.refreshStorage(arrayMo.getMoId(), StorageRestServiceImpl.this.getCurrentUser().getUserName());
                return true;
            }
        };
    }

    @Override
    public String getStorageUnitInfo(String devSn) {
        logger.trace((Object)"enter getStorageUnitInfo");
        this.checkUserOperationAuthority("site_redirectToStorage_operateName", 3, "ism.drm.site.resource.auth.management.operateID");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource drResource = ((IResourceService)this.getBundleService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            throw new LegoCheckedException(2117645L);
        }
        Site site = ((ISiteService)this.getBundleService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (0 == site.getSiteType()) {
            this.checkUserMoAuthority("site_redirectToStorage_operateName", 3, new String[]{devSn});
        } else if (1 == site.getSiteType()) {
            this.checkUserBizObjAuthority("site_redirectToStorage_operateName", 3, drResource.getSiteId());
        } else {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject json = new JSONObject();
        try {
            Map info = ((IStorageService)this.getBundleService(IStorageService.class)).getStorageAddressInfo(devSn);
            if (info.containsKey("linkIp")) {
                json.put((Object)"linkIp", info.get("linkIp"));
                logger.info((Object)("linkIp: " + info.get("linkIp")));
            }
            if (info.containsKey("linkPort")) {
                json.put((Object)"linkPort", info.get("linkPort"));
                logger.info((Object)("linkPort: " + info.get("linkPort")));
            }
        }
        catch (Exception e) {
            this.writeFailedOperationLog("site_redirectToStorage_operateName", 3, drResource.getName(), e);
        }
        this.writeSucOperationLog("site_redirectToStorage_operateName", 3, drResource.getName(), "site_redirectToStorage_operateDetail", new String[]{drResource.getIpAddress()});
        return json.toString();
    }

    @Override
    public String getSrcLunByReplicationUUID(String replicationId) {
        logger.trace((Object)"enter getSrcLunByReplicationUUID");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)replicationId)) {
            throw new LegoCheckedException(1073947393L);
        }
        List lunList = this.getStorageService().getSrcLunByReplicasionUuid(replicationId);
        JSONArray array = new JSONArray();
        if (null == lunList || lunList.isEmpty()) {
            return array.toString();
        }
        for (Lun lun : lunList) {
            try {
                this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{lun.getDevSn()});
            }
            catch (Exception e) {
                logger.info((Object)("StorageResource(" + lun.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            JSONObject object = new JSONObject();
            object.put((Object)RESULT_NAME, (Object)lun.getName());
            object.put((Object)RESULT_STATUS, (Object)lun.getStatus());
            object.put((Object)RESULT_CAPACITY, (Object)lun.getTotalCapacityAndUnit());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    public String getStorageResources(String devSn, String ids, boolean isFromDevice) {
        logger.trace((Object)"enter getStorageResources");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)ids)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List<String> idList = Arrays.asList(ids.split(";"));
        List resources = service.getStorageResources(devSn, idList, StorageResource.class);
        JSONArray array = new JSONArray();
        for (StorageResource resource : resources) {
            JSONObject obj = this.convertStorageResourceToJsonObject(resource);
            array.add((Object)obj);
        }
        return array.toString();
    }

    private JSONObject convertStorageResourceToJsonObject(StorageResource resource) {
        logger.trace((Object)"enter convertStorageResourceToJsonObject");
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)resource.getResourceId());
        obj.put((Object)"resourceId", (Object)resource.getResourceId());
        obj.put((Object)RESULT_NAME, (Object)resource.getName());
        obj.put((Object)"totalCapacity", (Object)resource.getTotalCapacity());
        obj.put((Object)"totalCapacityUnit", (Object)resource.getTotalCapacityUnit());
        obj.put((Object)"usedCapacity", (Object)resource.getUsedCapacity());
        obj.put((Object)"usedCapacityUnit", (Object)resource.getUsedCapacityUnit());
        obj.put((Object)"devSn", (Object)resource.getDevSn());
        obj.put((Object)"healthStatus", (Object)NumberUtil.convertToInteger((Object)resource.getHealthStatus()));
        obj.put((Object)"runningStatus", (Object)NumberUtil.convertToInteger((Object)resource.getRunningStatus()));
        if (resource instanceof Lun) {
            obj.put((Object)"mapped", (Object)((Lun)resource).getMapped());
            obj.put((Object)"wwn", (Object)((Lun)resource).getWwn());
            obj.put((Object)"resourceType", (Object)DrmEnumDefine.ResourceTypeE.LUN.getValue());
        } else if (resource instanceof NasFileSystem) {
            obj.put((Object)"resourceType", (Object)DrmEnumDefine.ResourceTypeE.NAS.getValue());
            obj.put((Object)"vstoreId", (Object)((NasFileSystem)resource).getVstoreId());
        }
        return obj;
    }

    @Override
    public String getStorageResourcesStatistic(String deviceSn, int templateType, List<StorageResource> excludedResources) {
        logger.trace((Object)"enter getStorageResourcesStatistic");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn) || null == PolicyTemplateType.PolicyTemplateE.getType((int)templateType)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{deviceSn});
        IStorageResourcePoolService storagePoolService = (IStorageResourcePoolService)this.getBundleService("DRM_Base", IStorageResourcePoolService.class.getName());
        List storageResources = storagePoolService.getMatchedStorageResources(deviceSn, DrmEnumDefine.ResourceTypeE.LUN);
        HashMap<String, StorageResource> excludedResourceMap = new HashMap<String, StorageResource>();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(excludedResources)) {
            for (StorageResource resource : excludedResources) {
                excludedResourceMap.put(resource.getUuid(), resource);
            }
        }
        ArrayList<StorageResource> filteredStorageResources = new ArrayList<StorageResource>();
        for (StorageResource storageResource : storageResources) {
            if (null != excludedResourceMap.get(storageResource.getUuid())) continue;
            filteredStorageResources.add(storageResource);
        }
        return DrmStorageUtil.getStorageResourceStatisticByLun(filteredStorageResources, templateType);
    }

    @Override
    public String getInitiatorsByDevsn(String devSn) {
        logger.trace((Object)"enter getInitiatorsByDevsn");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List initiators = service.getArrayInitiators(devSn, null);
        JSONArray array = new JSONArray();
        for (Initiator initiator : initiators) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"uuid", (Object)initiator.getUuid());
            obj.put((Object)RESULT_NAME, (Object)initiator.getName());
            obj.put((Object)"identity", (Object)initiator.getIdentity());
            obj.put((Object)"healthStatus", (Object)initiator.getHealthStatus());
            obj.put((Object)"runningStatus", (Object)initiator.getRunningStatus());
            obj.put((Object)"hbaType", (Object)initiator.getHbaType());
            obj.put((Object)"model", (Object)initiator.getModel());
            obj.put((Object)"initiatorIp", (Object)initiator.getInitiatorIp());
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    public String getHostInitiators(String devSn, String hostSn) {
        logger.trace((Object)"enter getHostInitiators");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)hostSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{hostSn});
        JSONArray array = new JSONArray();
        IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
        List filtInitiators = topoService.getConnectInitiators(devSn, hostSn);
        for (Initiator initiator : filtInitiators) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"uuid", (Object)initiator.getUuid());
            obj.put((Object)RESULT_NAME, (Object)initiator.getName());
            obj.put((Object)"identity", (Object)initiator.getIdentity());
            obj.put((Object)"healthStatus", (Object)initiator.getHealthStatus());
            obj.put((Object)"runningStatus", (Object)initiator.getRunningStatus());
            obj.put((Object)"hbaType", (Object)initiator.getHbaType());
            obj.put((Object)"model", (Object)initiator.getModel());
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    public String getQuorumServerlinks(String devSn, String quorumServerId) {
        logger.trace((Object)"enter getQuorumServerlinks");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)quorumServerId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List quorumServerLinks = service.getQuorumServerLink(devSn, quorumServerId);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)quorumServerLinks)) {
            return array.toString();
        }
        for (QuorumServerLink eachLink : quorumServerLinks) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)eachLink.getId());
            obj.put((Object)"localControllerId", (Object)eachLink.getLocalControllerId());
            obj.put((Object)"localPortId", (Object)eachLink.getLocalPortId());
            obj.put((Object)"localControllerName", (Object)eachLink.getLocalControllerName());
            obj.put((Object)"localPortName", (Object)eachLink.getLocalPortName());
            obj.put((Object)"quorumServerId", (Object)eachLink.getQuorumServerId());
            obj.put((Object)"quorumServerIp", (Object)eachLink.getQuorumServerIp());
            obj.put((Object)"runningState", (Object)eachLink.getRunningState());
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    public String getSupportedCapabilities(String devSn) {
        logger.trace((Object)"enter getSupportedCapabilities");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayUnit arrayUnit = this.getStorageService().getStorageBySn(devSn);
        if (null == arrayUnit) {
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        JSONArray array = new JSONArray();
        if (arrayUnit instanceof HvsUnit) {
            array.add((Object)DrmEnumDefine.DeviceCapabilityE.HYPER_CLONE.getValue());
            array.add((Object)DrmEnumDefine.DeviceCapabilityE.HYPER_REPLIATION_RATE.getValue());
        }
        return array.toString();
    }

    @Override
    public String getRemoteDevices(String devSn, String siteId) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        List remoteDevices = storageService.queryRemoteDevices(devSn);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)remoteDevices)) {
            return array.toString();
        }
        this.filterRemoteDeviceBySite(remoteDevices, siteId);
        for (RemoteDevice remoteDevice : remoteDevices) {
            try {
                this.checkUserAuthorityByMoSN(remoteDevice.getSn());
            }
            catch (LegoCheckedException ex) {
                logger.debug((Object)("current user has no right, sn=" + remoteDevice.getSn() + " " + (Object)((Object)ex)));
                continue;
            }
            JSONObject json = new JSONObject();
            json.put((Object)"id", (Object)remoteDevice.getId());
            json.put((Object)RESULT_NAME, (Object)remoteDevice.getName());
            json.put((Object)"sn", (Object)remoteDevice.getSn());
            json.put((Object)"arrayType", (Object)remoteDevice.getArrayType());
            array.add((Object)json);
        }
        return array.toString();
    }

    private void filterRemoteDeviceBySite(List<RemoteDevice> remoteDevices, String siteId) {
        logger.trace((Object)"enter filterRemoteDeviceBySite");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)siteId)) {
            return;
        }
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        List storageListBySiteId = storageService.getStorageListBySiteId(siteId, this.getCurrentUserId());
        Iterator<RemoteDevice> iterator = remoteDevices.iterator();
        while (iterator.hasNext()) {
            RemoteDevice temp = iterator.next();
            boolean find = false;
            for (DrStorage drStorage : storageListBySiteId) {
                if (!drStorage.getDeviceSn().equals(temp.getSn())) continue;
                find = true;
                break;
            }
            if (find) continue;
            iterator.remove();
        }
    }

    @Override
    public String getHyperVaultCandidateTargetFs(String devSn, String srcFileSystemId, String remoteDeviceSn) {
        logger.trace((Object)"enter getHyperVaultCandidateTargetFs");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, srcFileSystemId, remoteDeviceSn});
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{remoteDeviceSn});
        IStorageResourceService storageResourceService = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List list = storageResourceService.queryHyperVaultCandidateTargetFs(devSn, srcFileSystemId, remoteDeviceSn);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
            return array.toString();
        }
        for (NasFileSystem fs : list) {
            JSONObject obj = this.convertStorageResourceToJsonObject((StorageResource)fs);
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    public String getHyperMetroConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        logger.debug((Object)("Enter getHyperMetroConsistentGroup, sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService storageResourceService = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        HyperMetroConsistentGroup cg = storageResourceService.getHyperMetroConsistentGroup(devSn, cgId, isRealTime);
        logger.debug((Object)cg);
        JSONObject obj = this.hmCgToJsonObject(cg);
        logger.debug((Object)"Exit getHyperMetroConsistentGroup.");
        return obj.toString();
    }

    @Override
    public String getHyperMetroPairsByWwns(String wwns, int roleType, String devSn, boolean isRealtime) {
        logger.debug((Object)("Enter getHyperMetroPairsByWwns, wwns=" + wwns + ", roleType=" + roleType + ", isRealTime=" + isRealtime + ", devSn = " + devSn));
        return this.getAllHyperMetroPairs(wwns, roleType, devSn, null, isRealtime, false);
    }

    @Override
    public String getHyperMetroPairsBySystem(String fileIds, int roleType, String devSn, String vstoreId, boolean isRealtime) {
        logger.debug((Object)("Enter getHyperMetroPairsBySystem, fileIds=" + fileIds + ", roleType=" + roleType + ", isRealTime=" + isRealtime + ", devSn = " + devSn));
        return this.getAllHyperMetroPairs(fileIds, roleType, devSn, vstoreId, isRealtime, true);
    }

    private String getAllHyperMetroPairs(String resourceIds, int roleType, String devSn, String vstoreId, boolean isRealtime, boolean isNas) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        List pairs = null;
        IStorageResourceService storageResourceService = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)vstoreId) && !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) && isNas) {
            pairs = storageResourceService.getHyperMetroPairByVstore(devSn, vstoreId);
            return this.getJsonArrayAfterPairUserAuthority(pairs);
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)resourceIds)) {
            logger.error((Object)"resourceIds is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String[] splits = resourceIds.split(";");
        List<String> list = Arrays.asList(splits);
        Boolean isPrimary = null;
        if (roleType == 0) {
            isPrimary = true;
        } else if (roleType == 1) {
            isPrimary = false;
        }
        pairs = isNas ? storageResourceService.getHyperMetroPairByFileSystems(devSn, list, isPrimary, Boolean.valueOf(isRealtime)) : storageResourceService.getHyperMetroPairByWwn(list, isPrimary, devSn, isRealtime);
        return this.getJsonArrayAfterPairUserAuthority(pairs);
    }

    private JSONObject hmCgToJsonObject(HyperMetroConsistentGroup cg) {
        JSONObject obj = new JSONObject();
        if (null != cg) {
            obj.put((Object)"uuid", (Object)cg.getUuid());
            obj.put((Object)"devSn", (Object)cg.getDevSn());
            obj.put((Object)"id", (Object)cg.getId());
            obj.put((Object)RESULT_NAME, (Object)cg.getName());
            obj.put((Object)"healthState", (Object)cg.getHealthState());
            obj.put((Object)"runningState", (Object)cg.getRunningState());
            obj.put((Object)"priorityStationType", (Object)cg.getPriorityStationType());
            obj.put((Object)"domainId", (Object)cg.getDomainId());
            obj.put((Object)"resourceType", (Object)cg.getResourceType());
            obj.put((Object)"isEmpty", (Object)cg.getIsEmpty());
            obj.put((Object)"syncDirection", (Object)cg.getSyncDirection());
        }
        logger.debug((Object)obj);
        return obj;
    }

    private JSONObject hmPairToJsonObject(HyperMetroPair pair) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"uuid", (Object)pair.getUuid());
        obj.put((Object)"devSn", (Object)pair.getDevSn());
        obj.put((Object)"id", (Object)pair.getId());
        obj.put((Object)RESULT_NAME, (Object)pair.getName());
        obj.put((Object)"healthState", (Object)pair.getHealthState());
        obj.put((Object)"runningState", (Object)pair.getRunningState());
        obj.put((Object)"domainId", (Object)pair.getDomainId());
        obj.put((Object)"resourceType", (Object)pair.getResourceType());
        obj.put((Object)"localObjId", (Object)pair.getLocalObjId());
        obj.put((Object)"remoteObjId", (Object)pair.getRemoteObjId());
        obj.put((Object)"isPrimary", (Object)pair.getIsPrimary());
        obj.put((Object)"resourceWwn", (Object)pair.getResourceWwn());
        obj.put((Object)"syncDirection", (Object)pair.getSyncDirection());
        obj.put((Object)"cgId", (Object)pair.getCgId());
        obj.put((Object)"vstorePairId", (Object)pair.getVstorePairId());
        logger.debug((Object)obj);
        return obj;
    }

    @Override
    public String getQuorumDomains(String devSn) {
        logger.debug((Object)("Enter getQuorumDomains, devSn=" + devSn));
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"sn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List domainList = service.getHyperMetroDomains(devSn);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)domainList)) {
            logger.debug((Object)"domainList is empty.");
            return array.toString();
        }
        for (HyperMetroDomain eachDomain : domainList) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)eachDomain.getId());
            obj.put((Object)"domainType", (Object)eachDomain.getDomainType());
            obj.put((Object)"cpsId", (Object)eachDomain.getCpsId());
            obj.put((Object)"cpsName", (Object)eachDomain.getCpsName());
            obj.put((Object)"cpType", (Object)eachDomain.getCpType());
            obj.put((Object)"devSn", (Object)eachDomain.getDevSn());
            logger.debug((Object)obj);
            array.add((Object)obj);
        }
        logger.debug((Object)("Exit getQuorumDomains, devSn=" + devSn));
        return array.toString();
    }

    @Override
    public String getQuorumServers(String devSn) {
        logger.debug((Object)("Enter getQuorumServers, devSn=" + devSn));
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List serverList = service.getQuorumServers(devSn);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)serverList)) {
            logger.debug((Object)"serverList is empty.");
            return array.toString();
        }
        for (QuorumServer eachServer : serverList) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)eachServer.getId());
            obj.put((Object)"serverIpA", (Object)eachServer.getServerIpA());
            obj.put((Object)"serverIpB", (Object)eachServer.getServerIpB());
            obj.put((Object)"sn", (Object)eachServer.getSn());
            obj.put((Object)"serverPortA", (Object)eachServer.getServerPortA());
            obj.put((Object)"serverPortB", (Object)eachServer.getServerPortB());
            obj.put((Object)"runningState", (Object)eachServer.getRunningState());
            obj.put((Object)"healthState", (Object)eachServer.getHealthState());
            obj.put((Object)"devSn", (Object)eachServer.getDevSn());
            logger.debug((Object)obj);
            array.add((Object)obj);
        }
        logger.debug((Object)"Exit getQuorumServers.");
        return array.toString();
    }

    @Override
    public Response synchronize(String devSn, String hyperMetroId, boolean isCg, String vstoreId) {
        logger.debug((Object)("Enter synchronize, devSn=" + devSn + ", id=" + hyperMetroId + ", isCg=" + isCg));
        this.checkUserOperationAuthority("recoveryPlan_syncHyperMetor_operateName", 3, "ism.drm.drp.auth.planed.motion");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, hyperMetroId});
        this.checkUserMoAuthority("recoveryPlan_syncHyperMetor_operateName", 3, new String[]{devSn});
        try {
            ManagedObject mo = this.getHyperMetroInfo(devSn, hyperMetroId, isCg, vstoreId);
            IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
            srSvc.synchronize(devSn, hyperMetroId, isCg, vstoreId);
            this.writeSucOperationLog("recoveryPlan_syncHyperMetor_operateName", 3, hyperMetroId, "recoveryPlan_syncHyperMetor_operateDetail", new String[]{hyperMetroId, devSn, mo.getClass().getSimpleName()});
        }
        catch (Exception ex) {
            logger.error((Object)("synchronize failed, devSn=" + devSn + ", id=" + hyperMetroId + ", isCg=" + isCg), (Throwable)ex);
            this.writeFailedOperationLog("recoveryPlan_syncHyperMetor_operateName", 3, hyperMetroId, ex);
        }
        logger.debug((Object)"Exit synchronize.");
        return Response.ok().build();
    }

    private ManagedObject getHyperMetroInfo(String devSn, String hyperMetroId, boolean isCg, String vstoreId) {
        Object mo = null;
        IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        mo = isCg ? srSvc.getHyperMetroConsistentGroup(devSn, hyperMetroId, true) : srSvc.getHyperMetroPair(devSn, hyperMetroId, true, vstoreId);
        if (null == mo) {
            logger.error((Object)("hyperMetro not exist, devSn=" + devSn + ", id=" + hyperMetroId + ", isCg=" + isCg));
            throw new LegoCheckedException(2117645L);
        }
        return mo;
    }

    @Override
    public Response disable(String devSn, String hyperMetroId, Integer role, boolean isCg, String vstoreId) {
        logger.debug((Object)("Enter disable, devSn=" + devSn + ", id=" + hyperMetroId + ", role=" + role + ", isCg=" + isCg));
        this.checkUserOperationAuthority("recoveryPlan_pauseHyperMetor_operateName", 3, "ism.drm.drp.auth.planed.motion");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, hyperMetroId});
        this.checkUserMoAuthority("recoveryPlan_pauseHyperMetor_operateName", 3, new String[]{devSn});
        ManagedObject mo = null;
        try {
            mo = this.getHyperMetroInfo(devSn, hyperMetroId, isCg, vstoreId);
            IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
            DrmEnumDefine.RoleType roleType = null == role ? DrmEnumDefine.RoleType.DEFAULT : DrmEnumDefine.RoleType.getType((int)role);
            srSvc.disable(devSn, hyperMetroId, roleType, isCg, vstoreId);
            this.writeSucOperationLog("recoveryPlan_pauseHyperMetor_operateName", 3, hyperMetroId, "recoveryPlan_pauseHyperMetor_operateDetail", new String[]{hyperMetroId, devSn, mo.getClass().getSimpleName(), roleType.name()});
        }
        catch (Exception ex) {
            logger.error((Object)("disable failed, devSn=" + devSn + ", id=" + hyperMetroId + ", isCg=" + isCg), (Throwable)ex);
            this.writeFailedOperationLog("recoveryPlan_pauseHyperMetor_operateName", 3, hyperMetroId, ex);
        }
        logger.debug((Object)"Exit disable.");
        return Response.ok().build();
    }

    private String getJsonArrayAfterPairUserAuthority(List<HyperMetroPair> pairs) {
        JSONArray arr = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(pairs)) {
            logger.debug((Object)"pairs is empty.");
            return arr.toString();
        }
        for (HyperMetroPair next : pairs) {
            logger.debug((Object)("sn=" + next.getDevSn() + ", id=" + next.getId()));
            try {
                this.checkUserAuthorityByMoSN(next.getDevSn());
            }
            catch (LegoCheckedException ex) {
                logger.debug((Object)ex);
                continue;
            }
            arr.add((Object)this.hmPairToJsonObject(next));
        }
        logger.debug((Object)"Exit getHyperMetroPairsByWwns.");
        return arr.toString();
    }

    @Override
    public String getFileSystemByVstoreUUID(String vstoreuuid) {
        logger.trace((Object)"enter getFileSystemByVstoreUUID");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)vstoreuuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        List nasFileSystemList = this.getStorageService().getFileSystemByVstoreUuid(vstoreuuid);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)nasFileSystemList)) {
            return array.toString();
        }
        for (NasFileSystem fileSystem : nasFileSystemList) {
            try {
                this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{fileSystem.getDevSn()});
            }
            catch (LegoCheckedException e) {
                logger.info((Object)("StorageResource(" + fileSystem.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            JSONObject object = new JSONObject();
            object.put((Object)RESULT_NAME, (Object)fileSystem.getName());
            object.put((Object)RESULT_STATUS, (Object)fileSystem.getStatus());
            object.put((Object)RESULT_CAPACITY, (Object)fileSystem.getTotalCapacityAndUnit());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    public String getFileSystemByVstoreId(String devSn, String vstoreId) {
        logger.trace((Object)"enter getFileSystemByVstoreId");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)vstoreId) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List nasFileSystemList = srSvc.getFileSystemsByVstore(devSn, vstoreId);
        JSONArray array = new JSONArray();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)nasFileSystemList)) {
            return array.toString();
        }
        for (NasFileSystem fileSystem : nasFileSystemList) {
            try {
                this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{fileSystem.getDevSn()});
            }
            catch (LegoCheckedException e) {
                logger.info((Object)("StorageResource(" + fileSystem.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            JSONObject object = new JSONObject();
            object.put((Object)RESULT_NAME, (Object)fileSystem.getName());
            object.put((Object)RESULT_STATUS, (Object)fileSystem.getStatus());
            object.put((Object)"devSn", (Object)fileSystem.getDevSn());
            object.put((Object)"resourceId", (Object)fileSystem.getResourceId());
            object.put((Object)"vstoreId", (Object)fileSystem.getVstoreId());
            object.put((Object)"resourceType", (Object)fileSystem.getResourceType());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    public String getVstoreHyperMetroPair(String devSn, Boolean isAssociate, String id) {
        logger.trace((Object)"enter getVstoreHyperMetroPair");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)isAssociate) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        VstoreHyperMetroPair vstoreHyperMetroPair = srSvc.getVstoreHyperMetroPairById(devSn, id, isAssociate);
        JSONObject obj = this.constructVstoreHyperMetroPair(vstoreHyperMetroPair);
        logger.debug((Object)obj);
        return obj.toString();
    }

    @Override
    public String getRemoteVstoreHyperMetroPair(String vstorePairId, String localVstoreId, String remoteVstoreId) {
        logger.trace((Object)"enter getRemoteVstoreHyperMetroPair");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List list = srSvc.getRemoteVstoreHyperMetroPair(vstorePairId, localVstoreId, remoteVstoreId);
        JSONArray array = new JSONArray();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
            for (VstoreHyperMetroPair pair : list) {
                JSONObject obj = this.constructVstoreHyperMetroPair(pair);
                array.add((Object)obj);
            }
        }
        return array.toString();
    }

    private JSONObject constructVstoreHyperMetroPair(VstoreHyperMetroPair vstoreHyperMetroPair) {
        JSONObject obj = new JSONObject();
        if (null != vstoreHyperMetroPair) {
            obj.put((Object)"localVstoreId", (Object)vstoreHyperMetroPair.getLocalVstoreId());
            obj.put((Object)"vstorePairId", (Object)vstoreHyperMetroPair.getVstorePairId());
            obj.put((Object)"remoteVstoreId", (Object)vstoreHyperMetroPair.getRemoteVstoreId());
            obj.put((Object)"healthStatus", (Object)vstoreHyperMetroPair.getHealthStatus());
            obj.put((Object)"activeOrPassive", (Object)vstoreHyperMetroPair.getActiveOrPassive());
            obj.put((Object)"runningStatus", (Object)vstoreHyperMetroPair.getRunningStatus());
            obj.put((Object)"linkStatus", (Object)vstoreHyperMetroPair.getLinkStatus());
            obj.put((Object)"configStatus", (Object)vstoreHyperMetroPair.getConfigStatus());
            ManagedObject managedObject = vstoreHyperMetroPair.getParentMo();
            if (managedObject instanceof HvsUnit) {
                HvsUnit hvsUnit = (HvsUnit)managedObject;
                obj.put((Object)"expendField", (Object)hvsUnit.getDevSn());
            }
        }
        return obj;
    }

    @Override
    public Response swapVstoreHyperMetroPair(String devSn, String vstorePairId) {
        logger.debug((Object)("Enter swapVstorePair, devSn=" + devSn + ", id=" + vstorePairId));
        this.checkUserOperationAuthority("recoveryPlan_pauseHyperMetor_operateName", 3, "ism.drm.drp.auth.planed.motion");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, vstorePairId});
        this.checkUserMoAuthority("recoveryPlan_pauseHyperMetor_operateName", 3, new String[]{devSn});
        try {
            IStorageResourceService srSvc = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
            srSvc.swapVstoreHyperMetroPair(devSn, vstorePairId);
            this.writeSucOperationLog("recoveryPlan_swapVstorePair_operateName", 3, vstorePairId, "", new String[0]);
        }
        catch (Exception ex) {
            logger.error((Object)("disable failed, devSn=" + devSn + ", id=" + vstorePairId), (Throwable)ex);
            this.writeFailedOperationLog("recoveryPlan_swapVstorePair_operateName", 3, vstorePairId, ex);
        }
        logger.debug((Object)"Exit swapVstorePair.");
        return Response.ok().build();
    }

    @Override
    public String getVstoreById(String devSn, String vstoreId) {
        logger.trace((Object)"enter getVstoreById");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)vstoreId) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("vstoreId", (Object)vstoreId);
        condition.setCoType(1);
        condition.setWholeWorld(true);
        conditions.add(condition);
        List vstoreInfos = storageService.queryVstoreInfoByStorageSn(devSn, null, Boolean.TRUE.booleanValue(), conditions);
        JSONObject object = new JSONObject();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)vstoreInfos)) {
            return object.toString();
        }
        VstoreInfo info = (VstoreInfo)vstoreInfos.iterator().next();
        object.put((Object)RESULT_NAME, (Object)info.getName());
        object.put((Object)"vstoreId", (Object)info.getVstoreId());
        object.put((Object)"devSn", (Object)info.getDevSn());
        return object.toString();
    }

    @Override
    public String getReplicationPairsByResourceIds(String devSn, String resIds, boolean isPrimary) {
        logger.trace((Object)"enter getReplicationPairBySrcLunIds");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)resIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        String[] strResArray = resIds.split(";");
        ArrayList<String> listSrcResIds = new ArrayList<String>(Arrays.asList(strResArray));
        List listPairs = this.getStorageService().getReplicationPairsByResourceIds(devSn, listSrcResIds, isPrimary);
        return this.replicationPairListToJsonArray(listPairs);
    }

    @Override
    public StorageLicense getStorageAllLicense(String storageSn) {
        if (VerifyUtil.isEmpty((String)storageSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        logger.trace((Object)"enter getVstoreById");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        return ((IStorageService)this.getBundleService(IStorageService.class)).getStorageAllLicense(storageSn);
    }

    @Override
    public String queryTargetStorages(String devSn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        JSONObject jSONObject = this.getStorageService().queryTargetStorages(devSn);
        return jSONObject.toString();
    }

    @Override
    public Response createLun(String devSn, Lun lun) {
        this.checkUserOperationAuthority("site_storage_createlun_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)lun);
        this.checkUserMoAuthority("site_storage_createlun_operateName", 2, new String[]{devSn});
        try {
            IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
            Lun rtnLun = storageService.createLun(devSn, lun);
            this.writeSucOperationLog("site_storage_createlun_operateName", 2, lun.getName(), "", new String[0]);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)RESULT_NAME, (Object)rtnLun.getName());
            jSONObject.put((Object)RESULT_CAPACITY, (Object)rtnLun.getCapacity());
            jSONObject.put((Object)RESULT_STATUS, (Object)rtnLun.getStatus());
            jSONObject.put((Object)"storagePoolId", (Object)rtnLun.getStoragePoolId());
            jSONObject.put((Object)"lunId", (Object)rtnLun.getLunId());
            jSONObject.put((Object)"wwn", (Object)rtnLun.getWwn());
            return Response.ok((Object)jSONObject.toString()).build();
        }
        catch (Exception ex) {
            logger.error((Object)("create lun error, devSn=" + devSn + ", lunName=" + lun.getName()), (Throwable)ex);
            this.writeFailedOperationLog("site_storage_createlun_operateName", 2, lun.getName(), ex);
            throw ex;
        }
    }

    @Override
    public Response updateLun(String devSn, String lunName, Lun lun) {
        this.checkUserOperationAuthority("site_storage_expandlun_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)lun);
        this.checkUserMoAuthority("site_storage_expandlun_operateName", 2, new String[]{devSn});
        try {
            IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
            storageService.expandLun(devSn, lun);
            this.writeSucOperationLog("site_storage_expandlun_operateName", 2, lun.getName(), "", new String[0]);
            return Response.ok().build();
        }
        catch (Exception ex) {
            logger.error((Object)("expand lun error, devSn=" + devSn + ", lunName=" + lun.getName()), (Throwable)ex);
            this.writeFailedOperationLog("site_storage_expandlun_operateName", 2, lun.getName(), ex);
            throw ex;
        }
    }

    @Override
    public Response deleteLun(String devSn, DeleteLunRequest request) {
        this.checkUserOperationAuthority("site_storage_deletelun_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)request);
        this.checkUserMoAuthority("site_storage_deletelun_operateName", 2, new String[]{devSn});
        try {
            IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
            storageService.deleteLun(devSn, request.getVolIds(), request.getVolNames());
            this.writeSucOperationLog("site_storage_deletelun_operateName", 2, request.getVolNames().toString(), "", new String[0]);
            return Response.ok().build();
        }
        catch (Exception ex) {
            logger.error((Object)("delete lun error, devSn=" + devSn + ", volNames=" + request.getVolNames()), (Throwable)ex);
            this.writeFailedOperationLog("site_storage_deletelun_operateName", 2, request.getVolNames().toString(), ex);
            throw ex;
        }
    }

    @Override
    public String queryStoragePools(String siteId) {
        logger.trace((Object)"enter queryStoragePools");
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("resource_queryRes_operateName", 2, siteId);
        List pools = this.getStorageService().queryStoragePools();
        JSONArray array = new JSONArray();
        for (StoragePool storagePool : pools) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"neSN", (Object)storagePool.getNeSN());
            jSONObject.put((Object)"poolId", (Object)storagePool.getPoolId());
            jSONObject.put((Object)RESULT_NAME, (Object)storagePool.getName());
            array.add((Object)jSONObject);
        }
        return array.toString();
    }

    @Override
    public String queryLunByName(String devSn, String lunName) {
        this.checkUserOperationAuthority("site_storage_deletelun_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{lunName});
        this.checkUserMoAuthority("site_storage_deletelun_operateName", 2, new String[]{devSn});
        try {
            IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
            Lun lun = storageService.queryLunByName(devSn, lunName);
            this.writeSucOperationLog("site_storage_deletelun_operateName", 2, lunName, "", new String[0]);
            JSONObject jSONObject = new JSONObject();
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)lun)) {
                return jSONObject.toString();
            }
            jSONObject.put((Object)RESULT_NAME, (Object)lun.getName());
            jSONObject.put((Object)RESULT_CAPACITY, (Object)lun.getCapacity());
            jSONObject.put((Object)RESULT_STATUS, (Object)lun.getStatus());
            jSONObject.put((Object)"storagePoolId", (Object)lun.getStoragePoolId());
            jSONObject.put((Object)"lunId", (Object)lun.getLunId());
            jSONObject.put((Object)"wwn", (Object)lun.getWwn());
            return jSONObject.toString();
        }
        catch (Exception ex) {
            logger.error((Object)("delete lun error, devSn=" + devSn + ", volNames=" + lunName), (Throwable)ex);
            this.writeFailedOperationLog("site_storage_deletelun_operateName", 2, lunName, ex);
            throw ex;
        }
    }

    @Override
    public String gethypermetroDomain(String devSn, String remoteSn, String controlClusterId) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        ResultListVo resultListVo = storageService.getHyperMetroDomain(devSn, remoteSn, controlClusterId);
        JSONObject jsonObject = JSONObject.fromObject((Object)resultListVo);
        return jsonObject.toString();
    }

    @Override
    public String getControlClusters(String devSn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{devSn});
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        ResultListVo resultListVo = storageService.getControlClusters(devSn);
        JSONObject jsonObject = JSONObject.fromObject((Object)resultListVo);
        return jsonObject.toString();
    }
}

