/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.topo;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.topo.ITopoRestService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.topo.sdk.utils.TopoUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.twaver.SerializationSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class TopoService
extends AbstractRestService
implements ITopoRestService {
    private static Log log = LogFactory.getInstance(TopoService.class);
    private static final String TOPO_BUNDLE_NAME = "DRM_Base";
    private static final List<String> LOCAL_LANG_BOUND = new ArrayList<String>(Arrays.asList("en_US", "zh_CN", "zh", "CN", "en", "EN"));
    private static long userId;

    private static void init() {
        TopoUtil.registerGlobalClientCommonPropties();
        SerializationSettings.registerGlobalClient((String)"linkToXOffset", (String)"number");
        SerializationSettings.registerGlobalClient((String)"maxSonWidth", (String)"number");
        SerializationSettings.registerGlobalClient((String)"maxSonHeight", (String)"number");
        SerializationSettings.registerGlobalClient((String)"isUpdataLinkTag", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"netWorkPrimalName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"visExchangeTargetWWN", (String)"string");
    }

    @Override
    public String queryProtectgroupTopo(String localeString, String protectgroupId) {
        log.info((Object)"TopoAction:queryProtectgroupTopo. ", 90160758784000L);
        if (!LOCAL_LANG_BOUND.contains(localeString)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.validateProtectGroupId(protectgroupId);
        this.checkUserOperationAuthority("protectedGroup_query_operateName", 2, "ism.drm.protectgroup.auth.scan");
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", 2, protectgroupId);
        List topodataList = null;
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService(TOPO_BUNDLE_NAME, IDrmTopoService.class.getName());
            topodataList = topoService.createProtectGroupTopoData(protectgroupId, userId, localeString);
        }
        catch (Exception e) {
            log.error((Object)("Get ProtectGroup topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return this.toJson(topodataList);
    }

    @Override
    public String getGloabelSiteTopo(String localeString) {
        log.info((Object)"TopoAction:getGloabelSiteTopo.");
        if (!LOCAL_LANG_BOUND.contains(localeString)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("topology_queryOverallTopology_operateName", 2, "ism.drm.monitor.gloable.topo.auth.scan");
        List topodataList = null;
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService(TOPO_BUNDLE_NAME, IDrmTopoService.class.getName());
            topodataList = topoService.createGlobalTopoData(this.getCurrentUserId().longValue(), localeString);
        }
        catch (Exception e) {
            log.error((Object)("Get global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return this.toJson(topodataList);
    }

    @Override
    public String modifyPollPeriod(String topoPeriodIndex) {
        String status;
        log.info((Object)"TopoAction:modifyPollPeriod.");
        if (VerifyUtil.isEmpty((String)topoPeriodIndex)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "ism.drm.monitor.gloable.topo.auth.set.operateID");
        JSONObject data = JSONObject.fromObject((Object)topoPeriodIndex);
        String strPeriod = (String)data.get("topoPeriodIndex");
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService(TOPO_BUNDLE_NAME, IDrmTopoService.class.getName());
            topoService.updatePollPeriod(strPeriod);
            status = "success";
            this.writeSucOperationLog("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "overallTopologyRefreshPeriod_objectName", "", null);
        }
        catch (LegoCheckedException legoException) {
            status = legoException.getErrorCode() == 1073947404L ? "busy" : "failed";
            log.error((Object)"Save global topo failed. ", (Throwable)legoException, 90160758787071L);
            this.writeFailedOperationLogNoException("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "overallTopologyRefreshPeriod_objectName", (Exception)((Object)legoException));
        }
        catch (Exception e) {
            status = "failed";
            log.error((Object)("Save global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.writeFailedOperationLogNoException("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "overallTopologyRefreshPeriod_objectName", e);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"result", (Object)status);
        return result.toString();
    }

    @Override
    public Response modifyTopodata(String topoData) {
        log.info((Object)"TopoAction:modifyTopodata.");
        if (VerifyUtil.isEmpty((String)topoData)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject data = JSONObject.fromObject((Object)topoData);
        String topoXml = (String)data.get("topoXml");
        String clientURL = (String)data.get("clientURL");
        if (VerifyUtil.isEmpty((String)topoXml) || VerifyUtil.isEmpty((String)clientURL)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("topology_saveOverallTopology_operateName", 1, "ism.drm.monitor.gloable.topo.auth.set.operateID");
        String urlImageHead = "<p n='image'>";
        String strTopoXml = topoXml;
        strTopoXml = strTopoXml.replace(urlImageHead + clientURL, urlImageHead);
        String status = "failed";
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService(TOPO_BUNDLE_NAME, IDrmTopoService.class.getName());
            topoService.updateTopo(strTopoXml);
            status = "success";
            this.writeSucOperationLog("topology_saveOverallTopology_operateName", 1, "overallTopology_objectName", "", null);
        }
        catch (LegoCheckedException legoException) {
            log.error((Object)"Save global topo failed. ", (Throwable)legoException, 90160758787071L);
            this.writeFailedOperationLogNoException("topology_saveOverallTopology_operateName", 1, "overallTopology_objectName", (Exception)((Object)legoException));
        }
        catch (Exception e) {
            log.error((Object)("Save global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.writeFailedOperationLogNoException("topology_saveOverallTopology_operateName", 1, "overallTopology_objectName", e);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)"result", (Object)status);
        return Response.ok((Object)obj.toString()).build();
    }

    private void validateProtectGroupId(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            log.debug((Object)"pgId is empty!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private String toJson(List<String> detail) {
        JSONObject result = new JSONObject();
        result.put((Object)"topodataList", detail);
        return result.toString();
    }

    static {
        TopoService.init();
    }
}

