/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.userauth.model.TokenInfo;
import com.huawei.ism.drm.web.constants.OneTimeTokenConstants;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class OneTimeTokenUtils {
    private static final Log LOGGER = LogFactory.getInstance(OneTimeTokenUtils.class);
    private static final Map<String, TokenInfo> TOKEN_MAP = new ConcurrentHashMap<String, TokenInfo>();
    private static final int TOKEN_MAX_NUM = 1000;
    private static final long TOKEN_VALIDITY_DURATION = 60000L;
    private static final String ERROR_MSG = "TOKEN_MAP is empty.";

    private OneTimeTokenUtils() {
    }

    private static void removeExpiredTokenMap() {
        if (VerifyUtil.isEmpty(TOKEN_MAP)) {
            LOGGER.error((Object)ERROR_MSG);
            return;
        }
        long cuTime = System.currentTimeMillis();
        for (String key : TOKEN_MAP.keySet()) {
            TokenInfo value = TOKEN_MAP.get(key);
            if (value != null && cuTime < value.getStartTime() + 60000L && cuTime >= value.getStartTime()) continue;
            OneTimeTokenUtils.removeToken(key);
        }
    }

    public static Optional<TokenInfo> getTokenInfo(String token) {
        if (VerifyUtil.isEmpty((String)token) || VerifyUtil.isEmpty(TOKEN_MAP)) {
            LOGGER.error((Object)"Parameter token is null or TOKEN_MAP is empty.");
            return Optional.empty();
        }
        TokenInfo tokenInfo = TOKEN_MAP.get(token).clone();
        long cuTime = System.currentTimeMillis();
        if (tokenInfo == null || cuTime >= tokenInfo.getStartTime() + 60000L || cuTime < tokenInfo.getStartTime()) {
            LOGGER.error((Object)"Parameter token is expired.");
            OneTimeTokenUtils.removeToken(token);
            return Optional.empty();
        }
        return Optional.of(TOKEN_MAP.get(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createToken(String name, String pwd) {
        String randomToken;
        OneTimeTokenUtils.removeExpiredTokenMap();
        Map<String, TokenInfo> map = TOKEN_MAP;
        synchronized (map) {
            int size = TOKEN_MAP.size();
            if (size >= 1000) {
                LOGGER.error((Object)"Number of effective OneTimeToken is greater than %s,size is %s.", new Object[]{String.valueOf(1000), size});
                throw new LegoCheckedException((long)OneTimeTokenConstants.TOKEN_MAX_NUM_ERROR.getValueCode());
            }
            randomToken = (String)TokenGenerator.getToken((int)32).orElseThrow(() -> new LegoCheckedException(1073947393L));
            TOKEN_MAP.put(randomToken, new TokenInfo(name, pwd, System.currentTimeMillis()));
        }
        return randomToken;
    }

    public static void removeToken(String token) {
        if (VerifyUtil.isEmpty((String)token) || VerifyUtil.isEmpty(TOKEN_MAP)) {
            LOGGER.error((Object)"Parameter token is null or TOKEN_MAP is empty.");
            return;
        }
        TOKEN_MAP.remove(token);
    }
}

