/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.rest.service.framework.user.service.model.RuleNameEnum;
import com.huawei.ism.drm.rest.service.framework.userauth.model.TokenInfo;
import com.huawei.ism.drm.rest.util.OneTimeTokenUtils;
import com.huawei.ism.drm.rest.util.RandCodeCheck;
import com.huawei.ism.drm.web.filter.ParameterizedFilterConfig;
import com.huawei.ism.drm.web.filter.SystemSecurityFilter;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.ism.drm.web.util.FilterUtil;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.SessionUtil;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.jasig.cas.client.util.ReflectUtils;

public class SSOIntegrateFilter
implements Filter {
    public static final String PAGE_INDEX = "/src/index.html";
    public static final String WRAPPED_FILTER_CLASS = "wrappedFilterClass";
    public static final String SESSION_LANGUAGE = "WW_TRANS_I18N_LOCALE";
    public static final long FORBIDDEN = 403L;
    public static final String TINY_LANGUAGE = "tiny_language";
    private static final String SSO_ERROR = "SSO-Error: ";
    private static final String EN = "en";
    private static final String ZH = "zh";
    private static final Log log = LogFactory.getInstance(SSOIntegrateFilter.class);
    private static final String COOKIE_PATH = "/src/";
    private static final Long ADMINISTRATOR_ROLE_ID = 1L;
    private boolean ssoDeployMode;
    private Map<String, String> loginMap = null;
    private List<String> noAuthResources = null;
    private Filter filter = null;

    public void destroy() {
        this.noAuthResources = null;
        this.loginMap = null;
        if (this.filter != null) {
            this.filter.destroy();
            this.filter = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        uri = UriUtil.canonicalPath((String)uri);
        String method = httpRequest.getMethod();
        if (this.uriFromDme(uri)) {
            this.setLoginInfo(httpRequest, httpResponse);
            this.redirectToHomePage(httpResponse);
            return;
        }
        if ("/".equals(uri) && "GET".equalsIgnoreCase(method)) {
            this.setLanguage(httpRequest, httpResponse);
            this.redirectToHomePage(httpResponse);
            return;
        }
        boolean ignore = !this.ssoDeployMode;
        boolean bl = ignore = ignore || SystemSecurityFilter.checkNoAuthResources(this.noAuthResources, uri, method);
        if (SessionUtil.isLocalLoginMode(httpRequest)) {
            ignore = true;
        } else if (SessionUtil.isSSOLoginMode(httpRequest)) {
            if (this.redirectToHomePageWhenNativeLogin(uri, method, httpResponse)) {
                return;
            }
        } else {
            boolean miVisited;
            boolean login = SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method);
            boolean cloud = SystemSecurityFilter.isCloudRestService(uri);
            boolean bl2 = miVisited = SystemSecurityFilter.getMachineInterfaceVisitorName(httpRequest, uri) != null;
            if (SystemSecurityFilter.isRestRequest(uri) && !login && !cloud && !miVisited) {
                String userLoginMode = httpRequest.getHeader("user.login.mode");
                if ("sso".equals(userLoginMode)) {
                    UriUtil.writeSSORedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                } else {
                    UriUtil.writeLocalRedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                }
                return;
            }
            ignore = ignore || login;
            ignore = ignore || cloud;
            boolean bl3 = ignore = ignore || miVisited;
        }
        if (ignore) {
            chain.doFilter(request, response);
        } else {
            this.doSSOFilter(httpRequest, httpResponse, chain);
        }
    }

    private void setLanguage(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String language = httpRequest.getParameter("locale");
        if (VerifyUtil.isEmpty((String)language)) {
            return;
        }
        log.debug((Object)("get language is " + language));
        HttpSession session = httpRequest.getSession();
        if ("zh-cn".equalsIgnoreCase(language)) {
            session.setAttribute(SESSION_LANGUAGE, (Object)Locale.SIMPLIFIED_CHINESE);
            CookieUtil.addCookie((HttpServletResponse)httpResponse, (String)"rd_language", (String)ZH);
            CookieUtil.addCookie((HttpServletResponse)httpResponse, (String)TINY_LANGUAGE, (String)ZH);
        } else {
            session.setAttribute(SESSION_LANGUAGE, (Object)Locale.ENGLISH);
            CookieUtil.addCookie((HttpServletResponse)httpResponse, (String)"rd_language", (String)EN);
            CookieUtil.addCookie((HttpServletResponse)httpResponse, (String)TINY_LANGUAGE, (String)EN);
        }
    }

    private void doSSOFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        catch (LegoCheckedException e) {
            HttpSession session = request.getSession(false);
            String message = e.getMessage();
            if (e.getErrorCode() == 403L && message != null && message.contains("SSO-Error: permission denied")) {
                if (session != null) {
                    Locale language = (Locale)session.getAttribute(SESSION_LANGUAGE);
                    if (!VerifyUtil.isEmpty((Object)language)) {
                        String tempLanguage = Locale.ENGLISH.equals(language) ? EN : ZH;
                        CookieUtil.addCookie((HttpServletResponse)response, (String)"rd_language", (String)tempLanguage, (String)"/pages/");
                    }
                    session.invalidate();
                }
                response.sendRedirect("/pages/forbidden.html");
            }
            if (message != null && message.startsWith(SSO_ERROR)) {
                response.getWriter().append("{\"status\": 403}");
                if (session != null) {
                    session.invalidate();
                }
                response.sendError(403);
            }
            throw e;
        }
    }

    private void redirectToHomePage(HttpServletResponse response) throws IOException {
        response.sendRedirect(PAGE_INDEX);
    }

    private boolean redirectToHomePageWhenNativeLogin(String uri, String method, HttpServletResponse response) throws IOException {
        boolean matched = SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method);
        if (!matched || !uri.endsWith("/login.html")) {
            return false;
        }
        this.redirectToHomePage(response);
        return true;
    }

    public void init(FilterConfig config) throws ServletException {
        this.ssoDeployMode = "true".equalsIgnoreCase(config.getServletContext().getInitParameter("SSODeployMode"));
        String validUris = FilterUtil.getInitParameter((FilterConfig)config, SystemSecurityFilter.class, (String)"validUris");
        this.noAuthResources = SystemSecurityFilter.addNoAuthResources(new ArrayList<String>());
        this.loginMap = FilterUtil.initSpecialUriMap((String)validUris, new HashMap());
        String clazz = config.getInitParameter(WRAPPED_FILTER_CLASS);
        this.filter = (Filter)ReflectUtils.newInstance((String)clazz, (Object[])new Object[0]);
        this.filter.init((FilterConfig)new ParameterizedFilterConfig(config));
    }

    private boolean uriFromDme(String uri) {
        return "/src/login/view/login.html".equals(uri);
    }

    private void setLoginInfo(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getParameter("token");
        TokenInfo tokenInfo = this.getTokenInfo(token);
        OneTimeTokenUtils.removeToken(token);
        User currentUser = this.getUser(request, tokenInfo.getName(), tokenInfo.getPwd());
        String randomToken = (String)TokenGenerator.getToken((int)32).orElseThrow(() -> new LegoCheckedException(1073947393L));
        HttpSession currentSession = request.getSession();
        currentSession.setAttribute(SESSION_LANGUAGE, (Object)Locale.SIMPLIFIED_CHINESE);
        currentSession.setAttribute("user.login.mode", (Object)"local");
        currentSession.setAttribute("rd_randomStr_HW", (Object)randomToken);
        currentSession.setAttribute("currentUser", (Object)currentUser);
        currentSession.setAttribute("passState", (Object)"ok");
        response.addHeader("rd_randomStr_HW", randomToken);
        String username = currentUser.getUserName();
        try {
            URLEncoder.encode(username, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Encode username fail,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        CookieUtil.addCookie((HttpServletResponse)response, (String)"rd_randomStr_HW", (String)randomToken, (String)COOKIE_PATH);
        CookieUtil.addCookie((HttpServletResponse)response, (String)"rd_language", (String)"zh_CN", (String)COOKIE_PATH);
        CookieUtil.addCookie((HttpServletResponse)response, (String)"userName", (String)username, (String)COOKIE_PATH);
        CookieUtil.addCookie((HttpServletResponse)response, (String)"user.login.mode", (String)"local", (String)COOKIE_PATH);
        CookieUtil.addCookie((HttpServletResponse)response, (String)"isAdministrator", (String)String.valueOf(this.checkIsAdministrator(currentUser.getUserId())), (String)COOKIE_PATH);
        RandCodeCheck.removeUserName((String)username);
    }

    private TokenInfo getTokenInfo(String token) {
        Optional<TokenInfo> tokenInfoOptional = OneTimeTokenUtils.getTokenInfo(token);
        if (!tokenInfoOptional.isPresent()) {
            log.error((Object)"Parameter token is invalids.");
            throw new LegoCheckedException(1077949113L);
        }
        return tokenInfoOptional.get();
    }

    private User getUser(HttpServletRequest request, String userName, String userPwd) {
        IUserMgrBaseService mgr = null;
        Object obj = ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (obj instanceof IUserMgrBaseService) {
            mgr = (IUserMgrBaseService)obj;
        }
        User currentUser = mgr.login(this.getUserObj(userName, userPwd, request), true);
        currentUser.setLoginTime(new Date().getTime());
        currentUser.setIpAdr(RequestUtil.getClientIpAddress((HttpServletRequest)request));
        Date date = new Date();
        currentUser.setLoginTime(date.getTime());
        currentUser.setLoginDate(TimeUtil.toLocalString((Date)date));
        return currentUser;
    }

    private User getUserObj(String userName, String userPwd, HttpServletRequest request) {
        User userObj = new User();
        userObj.setUserName(userName);
        userObj.setUserPassword(userPwd);
        userObj.setIpAdr(RequestUtil.getClientIpAddress((HttpServletRequest)request));
        return userObj;
    }

    private boolean checkIsAdministrator(long currentUserId) {
        Object obj = ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (obj instanceof IUserMgrBaseService) {
            IUserMgrBaseService mgr = (IUserMgrBaseService)obj;
            Set curroleset = mgr.getUserInfo(currentUserId).getRolesSet();
            if (CollectionUtils.isEmpty((Collection)curroleset)) {
                return false;
            }
            Iterator iterator = curroleset.iterator();
            if (iterator.hasNext()) {
                Role temprole = (Role)iterator.next();
                return temprole.getRoleId() == ADMINISTRATOR_ROLE_ID || RuleNameEnum.ADMINISTRATOR.getRuleName().equals(temprole.getRoleName());
            }
        }
        return false;
    }
}

