/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.listener.SessionListener;
import com.huawei.ism.drm.web.util.FilterUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SystemSecurityFilter
implements Filter {
    public static final String VALID_URIS = "validUris";
    public static final String VALID_REFRESH_URIS = "validRefreshUris";
    public static final String CURRENT_USER_SESSION = "currentUser";
    private static final Log logger = LogFactory.getInstance(SystemSecurityFilter.class);
    private static final Log RESTCLIENTLOG = LogFactory.getInstance((Object)"3rd_rest_client_log");
    private static final String PAGE_ROOT_URL = "/src";
    private static final String PAGE_INDEX = "/src/index.html";
    private static final String FIRST_LOGIN_REDIRECT_PAGE = "/src/firstlogin/view/firstLogin.html";
    private static final String LOGOUT_URI = "/ws/auth/logout";
    private static final String HTTP_METHOD_GET = "GET";
    private static final List<String> CLOUD_URIS = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om", "/ws/dcs");
    private static Map<String, String> sessionIdMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> loginMap = new HashMap<String, String>();
    private Map<String, String> refreshMap = new HashMap<String, String>();
    private Map<String, String> firstLoginMap = new HashMap<String, String>();
    private List<String> noAuthResources = new ArrayList<String>();

    public void destroy() {
        this.loginMap.clear();
        this.refreshMap.clear();
        this.firstLoginMap.clear();
        this.noAuthResources.clear();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if (SystemSecurityFilter.isCloudRestService(uri = UriUtil.canonicalPath((String)uri))) {
            RESTCLIENTLOG.info((Object)String.format(Locale.getDefault(), "ipaddress %s send request uri %s:%s.", httpRequest.getRemoteAddr(), httpRequest.getMethod(), uri), 653110170615808L);
            chain.doFilter(request, response);
            return;
        }
        String authUser = SystemSecurityFilter.getMachineInterfaceVisitorName(httpRequest, uri);
        if (null != authUser) {
            RESTCLIENTLOG.info((Object)String.format(Locale.getDefault(), "User name %s send request uri %s:%s.", authUser, httpRequest.getMethod(), uri), 653110170615808L);
            chain.doFilter(request, response);
            return;
        }
        if (SystemSecurityFilter.checkNoAuthResources(this.noAuthResources, uri, httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        if (SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (!uri.startsWith("/help")) {
            httpResponse.setHeader("content-type", "application/json;charset=UTF-8");
        }
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setHeader("Cache", "no-cache");
        httpResponse.setHeader("Expires", "0");
        httpResponse.setHeader("Cache-Control", "no-store, must-revalidate");
        httpResponse.setHeader("Content-Security-Policy", "connect-src 'self';object-src 'self';frame-src 'self';media-src 'self';font-src 'self'");
        httpResponse.setHeader("Content-Security-Policy-Report-Only", "''");
        httpResponse.setHeader("X-Frame-Options", "SAMEORIGIN");
        if (SystemSecurityFilter.isRestRequest(uri)) {
            String clientIp = httpRequest.getRemoteAddr();
            if (session != null && !this.checkSessionId(clientIp, session.getId())) {
                logger.warn((Object)"check session ID failed, ip=%s.", new Object[]{clientIp});
                if (null != session && "sso".equals(session.getAttribute("user.login.mode"))) {
                    UriUtil.writeSSORedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (boolean)true);
                    return;
                }
                httpResponse.getWriter().write("{\"status\": 401}");
                return;
            }
            if (!this.checkSessionTime(httpRequest.getMethod(), session, uri)) {
                logger.warn((Object)"Invalid session access, uri: %s.", new Object[]{uri});
                if (null != session && "sso".equals(session.getAttribute("user.login.mode"))) {
                    UriUtil.writeSSORedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (boolean)true);
                    return;
                }
                httpResponse.getWriter().write("{\"status\": 401}");
                return;
            }
            if (this.checkFirstLogin(session, uri, httpRequest.getMethod()) && !LOGOUT_URI.equals(uri)) {
                httpResponse.getWriter().write("{\"status\": \"211\"}");
                logger.warn((Object)"Redirect user to modify password, uri: %s.", new Object[]{uri});
                return;
            }
            chain.doFilter(request, response);
            return;
        }
        if (!this.checkSessionTime(httpRequest.getMethod(), session, uri)) {
            logger.warn((Object)"Invalid session access, uri: %s.", new Object[]{uri});
            if (null != session && "sso".equals(session.getAttribute("user.login.mode"))) {
                UriUtil.writeSSORedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (boolean)true);
                return;
            }
        }
        if (uri.equals(PAGE_ROOT_URL)) {
            httpResponse.sendRedirect(httpRequest.getContextPath() + PAGE_INDEX);
            return;
        }
        chain.doFilter(request, response);
    }

    public static boolean isCloudRestService(String uri) {
        for (String curi : CLOUD_URIS) {
            if (!uri.startsWith(curi)) continue;
            return true;
        }
        return false;
    }

    public static String getMachineInterfaceVisitorName(HttpServletRequest httpRequest, String uri) {
        String authUser = httpRequest.getHeader("x-auth-user");
        String authPwd = httpRequest.getHeader("x-auth-key");
        if (uri.startsWith("/ws") && null != authUser && null != authPwd) {
            return authUser;
        }
        return null;
    }

    private void updateSessionMap() {
        Set sList = SessionListener.getSessionIdList();
        Set<String> map = sessionIdMap.keySet();
        if (VerifyUtil.isEmpty(map)) {
            return;
        }
        map.removeIf(m -> !sList.contains(m));
    }

    private boolean checkSessionId(String ip, String sessionId) {
        boolean status = true;
        this.updateSessionMap();
        String existIp = sessionIdMap.get(sessionId);
        if (VerifyUtil.isEmpty((String)existIp)) {
            sessionIdMap.put(sessionId, ip);
        } else if (!existIp.equals(ip)) {
            status = false;
        }
        return status;
    }

    public static boolean checkNoAuthResources(List<String> noAuthResources, String uri, String method) {
        if (!HTTP_METHOD_GET.equalsIgnoreCase(method)) {
            return false;
        }
        for (String type : noAuthResources) {
            if (!uri.endsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRestRequest(String uri) {
        if (null == uri || uri.isEmpty()) {
            return false;
        }
        return uri.startsWith("/ws/");
    }

    private boolean checkFirstLogin(HttpSession session, String uri, String method) {
        if (session == null) {
            logger.warn((Object)"Exit system time: HttpSession  is null", 653110170615808L);
            return true;
        }
        User currentUser = (User)session.getAttribute(CURRENT_USER_SESSION);
        if (currentUser == null) {
            logger.info((Object)"Exit system time: currentUser is null .uri is \uff1a%s.", new Object[]{uri});
            return true;
        }
        if (SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method) || SystemSecurityFilter.checkUriAndMethod(this.firstLoginMap, uri, method)) {
            return false;
        }
        return currentUser.isMustModifyPwd();
    }

    public static boolean checkUriAndMethod(Map<String, String> map, String uri, String method) {
        if (null == map || map.isEmpty()) {
            return false;
        }
        if (null == map.get(uri)) {
            return false;
        }
        return method.equalsIgnoreCase(map.get(uri));
    }

    private boolean checkSessionTime(String method, HttpSession session, String uri) throws IOException, ServletException {
        if (session == null) {
            logger.warn((Object)"Exit system time: HttpSession  is null", 653110170615808L);
            return false;
        }
        Object object = session.getAttribute(CURRENT_USER_SESSION);
        if (object == null || !(object instanceof User)) {
            logger.info((Object)("Exit system time: currentUser session is invalid .uri is \uff1a" + uri), 653110170615808L);
            return false;
        }
        User currentUser = (User)object;
        String sessId = currentUser.getSession();
        try {
            ServiceContext context = ServiceContext.getInstance();
            IUserMgr mgr = (IUserMgr)context.lookup("user/usermgr");
            if (this.checkTimeoutRefresh(method, uri, sessId, mgr)) {
                logger.info((Object)("Backend timeout ,exit system time:" + currentUser.getLoginDate() + ", uri is : " + uri), 653110170615808L);
                return false;
            }
            if (mgr.checkTimeOut(sessId, true).booleanValue()) {
                logger.info((Object)("Backend timeout ,exit system time:" + currentUser.getLoginDate() + ", uri is : " + uri), 653110170615808L);
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("exception Exit system time:" + currentUser.getLoginDate() + ExceptionUtil.getErrorMessage((Throwable)ex)), 653110170615808L);
            return false;
        }
        return true;
    }

    private boolean checkTimeoutRefresh(String method, String uri, String sessionId, IUserMgr mgr) {
        if (SystemSecurityFilter.checkUriAndMethod(this.refreshMap, uri, method)) {
            return mgr.checkTimeOut(sessionId);
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        SystemSecurityFilter.addNoAuthResources(this.noAuthResources);
        if (null == filterConfig) {
            logger.warn((Object)"System security filter config is null", 653110170615808L);
            return;
        }
        FilterUtil.initSpecialUriMap((String)filterConfig.getInitParameter(VALID_URIS), this.loginMap);
        FilterUtil.initSpecialUriMap((String)filterConfig.getInitParameter(VALID_REFRESH_URIS), this.refreshMap);
        FilterUtil.initSpecialUriMap((String)filterConfig.getInitParameter("firstLoginUris"), this.firstLoginMap);
    }

    public static List<String> addNoAuthResources(List<String> noAuthResources) {
        noAuthResources.add(".css");
        noAuthResources.add(".png");
        noAuthResources.add(".gif");
        noAuthResources.add(".jpg");
        noAuthResources.add(".ico");
        noAuthResources.add(".svg");
        return noAuthResources;
    }
}

