/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;

public class TicketValidationFilter
extends Cas20ProxyReceivingTicketValidationFilter {
    public static final String FORBIDDEN_STRING = "SSO-Error: permission denied";
    public static final String SSO_SESSION_TIME = "SSOSessionTime";
    public static final String SSO_REFREASH_TOUCH_NUM = "SSORefreashTouchNum";
    private static final String USER_INFO = "userInfo";
    private static final String USER_ID = "userId";
    private static final String ROLE_NAMES = "roleNames";

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
        this.validateSession(request, response, assertion);
        super.onSuccessfulValidation(request, response, assertion);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private void validateSession(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
        JSONObject userInfo = this.validateAssertion(assertion);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        String username = assertion.getPrincipal().getName();
        StringBuilder fullname = new StringBuilder(username).append("(OCAdmin)");
        String userId = this.getUserId(userInfo);
        if (!VerifyUtil.isEmpty((String)userId)) {
            fullname.append('#').append(userId);
        }
        String ip = AbstractRestService.getRemoteAddr((HttpServletRequest)request);
        try {
            IUserMgrBaseService mgr = (IUserMgrBaseService)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
            User user = mgr.login(ip, fullname.toString(), "", false);
            if (user == null) {
                throw new LegoCheckedException("SSO-Error: user is not exists");
            }
            this.initTicketInfo(request, response, user, session, mgr);
            SysOptLog.builder().operation("user_login_operateName").operator(user.getUserName()).level(1).target(user.getUserName()).terminalIp(ip).build().writeOperateLog();
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() != 1073947429L) {
                SysOptLog.builder().operation("user_login_operateName").operator(fullname.toString()).level(2).detail("lego.err." + ex.getErrorCode()).target(fullname.toString()).terminalIp(ip).detailPara(ex.getParameters()).build().writeOperateLog();
            }
            throw ex;
        }
    }

    private void initTicketInfo(HttpServletRequest request, HttpServletResponse response, User user, HttpSession session, IUserMgrBaseService mgr) {
        String randomToken = (String)TokenGenerator.getToken((int)32).orElseThrow(() -> new LegoCheckedException(1073947393L));
        String userName = user.getUserName();
        try {
            userName = URLEncoder.encode(userName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error("encode username fail", (Object)e, (Object)1L);
        }
        String ticketValue = this.retrieveTicketFromRequest(request);
        long ticketTime = System.currentTimeMillis();
        AbstractMap.SimpleEntry<String, Long> ticket = new AbstractMap.SimpleEntry<String, Long>(ticketValue, ticketTime);
        session.setAttribute("SSO_TICKET", ticket);
        UserLoginPolicy usrLogPolicy = mgr.getLoginPolicy();
        session.setAttribute(SSO_SESSION_TIME, (Object)usrLogPolicy.getSessionTimeOut());
        session.setAttribute(SSO_REFREASH_TOUCH_NUM, (Object)0);
        session.setAttribute("rd_randomStr_HW", (Object)randomToken);
        session.setAttribute("currentUser", (Object)user);
        session.setAttribute("user.login.mode", (Object)"sso");
        response.addHeader("rd_randomStr_HW", randomToken);
        CookieUtil.addCookie((HttpServletResponse)response, (String)"rd_randomStr_HW", (String)randomToken);
        if (VerifyUtil.isEmpty((Object)session.getAttribute("WW_TRANS_I18N_LOCALE"))) {
            session.setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.SIMPLIFIED_CHINESE);
            CookieUtil.addCookie((HttpServletResponse)response, (String)"rd_language", (String)"zh");
            CookieUtil.addCookie((HttpServletResponse)response, (String)"tiny_language", (String)"zh");
        }
        CookieUtil.addCookie((HttpServletResponse)response, (String)"userName", (String)userName);
        CookieUtil.addCookie((HttpServletResponse)response, (String)"isAdministrator", (String)String.valueOf(true));
        CookieUtil.addCookie((HttpServletResponse)response, (String)"user.login.mode", (String)"sso");
    }

    private String getUserId(JSONObject userInfo) {
        if (userInfo == null) {
            return "";
        }
        Object id = userInfo.get(USER_ID);
        if (!(id instanceof Number)) {
            throw new LegoCheckedException("SSO-Error: user id is incorrect");
        }
        if (((Number)Number.class.cast(id)).longValue() < 0L) {
            throw new LegoCheckedException("SSO-Error: user id is negative number");
        }
        return id.toString();
    }

    private JSONObject validateAssertion(Assertion assertion) {
        Map attributes = assertion.getPrincipal().getAttributes();
        if (!attributes.containsKey(USER_INFO)) {
            throw new LegoCheckedException("SSO-Error: no user info, ticket validate failed.");
        }
        Object userInfo = attributes.get(USER_INFO);
        JSONObject json = JSONObject.fromObject(userInfo);
        JSONArray roles = json.getJSONArray(ROLE_NAMES);
        if (roles != null && roles.contains((Object)"Administrators")) {
            return json;
        }
        throw new LegoCheckedException(403L, FORBIDDEN_STRING);
    }
}

