/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.entity;

import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.resource.manager.common.MaintainVmUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.pg.model.HostMgrInfoBase;
import com.huawei.ism.drm.galax.storage.entity.HostMgrInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class DsMgrInfo
extends DsMgrInfoBase {
    private static Log log = LogFactory.getInstance(MaintainVmUtil.class);
    private static String trace = "trace";

    public DsMgrInfo() {
        log.trace((Object)(trace + " trace message"));
    }

    public DsMgrInfo(DsMgrInfoBase base) {
        this.setDsName(base.getDsName());
        this.setDsUri(base.getDsUri());
        this.setDsUrn(base.getDsUrn());
        this.setHosts(base.getHosts());
        this.setWwns(base.getWwns());
        this.setPrimaryLunWwn(base.getPrimaryLunWwn());
        this.setUseLocalDs(base.getUseLocalDs());
        this.setStorageType(base.getStorageType());
        this.setConfidentialityLevel(base.getConfidentialityLevel());
    }

    public DsMgrInfo(DataStore ds) {
        super(ds);
        log.trace((Object)(trace + " trace message"));
        List<HostMgrInfo> hostMgrInfos = this.getHosts(ds.getHosts());
        ArrayList<HostMgrInfo> baseHosts = new ArrayList<HostMgrInfo>();
        for (HostMgrInfo host : hostMgrInfos) {
            baseHosts.add(host);
        }
        this.setHosts(baseHosts);
    }

    public List<HostMgrInfo> queryRecoveryHostMgrInfo(String productSiteId, String recoverySiteId) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<HostMgrInfo> recHosts = new ArrayList<HostMgrInfo>();
        ArrayList<String> usedCluster = new ArrayList<String>();
        for (HostMgrInfoBase host : this.getHosts()) {
            if (null == host.getClusterUrn()) {
                ComputeNode cn = this.computeRecComputeNode(host.getHostUrn(), productSiteId, recoverySiteId);
                if (null == cn) continue;
                HostMgrInfo mgrInfo = new HostMgrInfo(cn);
                recHosts.add(mgrInfo);
                continue;
            }
            if (usedCluster.contains(host.getClusterUrn())) continue;
            List<ComputeNode> computeNodeList = this.computeRecComputeNodes(host.getClusterUrn(), productSiteId, recoverySiteId);
            for (ComputeNode cn : computeNodeList) {
                HostMgrInfo mgrInfo = new HostMgrInfo(cn);
                recHosts.add(mgrInfo);
            }
            usedCluster.add(host.getClusterUrn());
        }
        return recHosts;
    }

    private ComputeNode computeRecComputeNode(String hostUrn, String productSiteId, String recoverySiteId) {
        log.trace((Object)(trace + " trace message"));
        ResourceMapping rm = FsRecoveryUtil.getResourceMapping((String)hostUrn, (boolean)true, (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        if (null == rm) {
            return null;
        }
        ComputeNode cn = (ComputeNode)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ComputeNode.class, "urn", (Object)rm.getRecoveryResourceId());
        return cn;
    }

    private List<ComputeNode> computeRecComputeNodes(String clusterUrn, String productSiteId, String recoverySiteId) {
        log.trace((Object)(trace + " trace message"));
        List<Object> cnList = new ArrayList<ComputeNode>();
        ResourceMapping rm = FsRecoveryUtil.getResourceMapping((String)clusterUrn, (boolean)false, (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        if (null == rm) {
            return cnList;
        }
        cnList = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getListMo(ComputeNode.class, "computeClusterUrn", (Object)rm.getRecoveryResourceId());
        return cnList;
    }

    private List<HostMgrInfo> getHosts(String hostsStr) {
        String[] hostStrs;
        log.trace((Object)(trace + " trace message"));
        ArrayList<HostMgrInfo> hostMgrs = new ArrayList<HostMgrInfo>();
        for (String hostUrn : hostStrs = hostsStr.split(";")) {
            ComputeNode cn = (ComputeNode)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ComputeNode.class, "urn", (Object)hostUrn);
            HostMgrInfo hostMgr = new HostMgrInfo(cn);
            hostMgrs.add(hostMgr);
        }
        return hostMgrs;
    }
}

