/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.entity;

import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.pg.model.PgMgrInfoBase;
import com.huawei.ism.drm.galax.storage.entity.DsMgrInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PgMgrInfo
extends PgMgrInfoBase {
    public PgMgrInfo() {
    }

    public PgMgrInfo(ProtectGroup pg) {
        if (null == pg) {
            return;
        }
        this.updatePgExtendParams(pg);
    }

    private void updatePgExtendParams(ProtectGroup pg) {
        this.setPgId(pg.getUuid());
        String groupIdStr = (String)pg.getProps().get(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
        this.setGroupId(groupIdStr);
        String fcSn = this.getPgFcSn(groupIdStr);
        if (null == fcSn) {
            fcSn = pg.getPoProviderSN();
        }
        if (null != fcSn) {
            this.setPgFcSn(fcSn);
        }
        List<DsMgrInfo> dsMgrInfos = this.getDsMgrInfos(pg);
        ArrayList<DsMgrInfo> baseDsMgrInfos = new ArrayList<DsMgrInfo>();
        for (DsMgrInfo ds : dsMgrInfos) {
            baseDsMgrInfos.add(ds);
        }
        this.setDsInfos(baseDsMgrInfos);
    }

    private List<DsMgrInfo> getDsMgrInfos(ProtectGroup pg) {
        ArrayList<DsMgrInfo> listDsMgr = new ArrayList<DsMgrInfo>();
        List dss = RecoveryPlanUtil.getDataStoreFromPg((ProtectGroup)pg);
        if (null == dss) {
            return listDsMgr;
        }
        for (DataStore ds : dss) {
            DsMgrInfo dsMgr = new DsMgrInfo(ds);
            listDsMgr.add(dsMgr);
        }
        return listDsMgr;
    }

    private String getPgFcSn(String dsgId) {
        if (null == dsgId) {
            return null;
        }
        VirtualDataStoreGroup dsg = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getDataStoreGroupByDsgId(dsgId);
        if (null != dsg) {
            return dsg.getVmProviderUuid();
        }
        List listDsg = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getDataStoreGroupByIds(dsgId.split(";"), ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue());
        if (!VerifyUtil.isEmpty((Collection)listDsg)) {
            return ((VirtualDataStoreGroup)listDsg.get(0)).getVmProviderUuid();
        }
        return null;
    }
}

