/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.entity;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.galax.constant.cloudenum.CloudParamType;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.OsOptionsType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class VmMgrInfo
extends VmMgrInfoBase {
    private static final Log logger = LogFactory.getInstance(VmMgrInfo.class);

    public VmMgrInfo() {
    }

    public VmMgrInfo(GalaxVM vm) {
        super(vm);
    }

    public VmMgrInfo(GalaxVM vm, ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo) {
        if (null == vm) {
            return;
        }
        this.setVmInfo(vm);
        if (!GalaxVM.VMProviderType.FM.getValue().equals(vm.getProviderID()) || null == vmInfo) {
            return;
        }
        this.getExtendParams().put(CloudParamType.VPC_ID.getValue(), vmInfo.getVpcID());
        this.setVmUriOrId(vmInfo.getVmID());
        String vmConfig = CommonUtil.beanToJson((Object)vmInfo.getVmConfig());
        String osOption = CommonUtil.beanToJson((Object)vmInfo.getOsOptions());
        this.setVmConfig(vmConfig);
        this.setOsOption(osOption);
    }

    public Object generateVmConfig() {
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.getVmType())) {
            VmConfigType vmConfigType = (VmConfigType)CommonUtil.jsonToBean((String)this.getVmConfig(), VmConfigType.class);
            return vmConfigType;
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.getVmType())) {
            ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfigType = (ResourcepoolVMServiceV2Stub.VmConfigSetE)CommonUtil.jsonToBean((String)this.getVmConfig(), ResourcepoolVMServiceV2Stub.VmConfigSetE.class);
            return vmConfigType;
        }
        logger.error((Object)("VmType is Wrong:" + this.getVmType()), 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    public Object generateVmOsOption() {
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.getVmType())) {
            OsOptionsType osOptions = (OsOptionsType)CommonUtil.jsonToBean((String)this.getOsOption(), OsOptionsType.class);
            return osOptions;
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.getVmType())) {
            try {
                ResourcepoolVMServiceV2Stub.OsOptions vmConfigType = (ResourcepoolVMServiceV2Stub.OsOptions)CommonUtil.jsonToBean((String)this.getOsOption(), ResourcepoolVMServiceV2Stub.OsOptions.class);
                return vmConfigType;
            }
            catch (LegoCheckedException e) {
                ResourcepoolVMServiceV2Stub.OsOptions vmConfigType = (ResourcepoolVMServiceV2Stub.OsOptions)CommonUtil.jsonToBean((String)this.getOsOption(), ResourcepoolVMServiceV2Stub.OsOptions.class);
                return vmConfigType;
            }
        }
        logger.error((Object)("VmType is Wrong:" + this.getVmType()), 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }
}

