/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.common;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class ProtectGroupCommon {
    private static final Log logger = LogFactory.getInstance(ProtectGroupCommon.class);

    public boolean isStorageProtectGroup(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            logger.error((Object)"protectGroup is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        if (12 != protectGroup.getPoType()) {
            return false;
        }
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        return ProtectTypeEnum.STORAGE_ARRAY.getType().equals(protectType) || ProtectTypeEnum.SAN_HYPER_ACTIVE.getType().equals(protectType) || ProtectTypeEnum.STORAGE_SNAP_ACTIVE.getType().equals(protectType);
    }

    public void checkIsHostPo(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            return;
        }
        List assignedVmUuIds = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("Select vmUuid from AssignedVm", new Object[0]);
        if (VerifyUtil.isEmpty((Collection)assignedVmUuIds)) {
            return;
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            if (!assignedVmUuIds.contains(po.getMoUuid())) continue;
            logger.error((Object)("po(" + po.getName() + ") is a assignedVm"), 90160758787071L);
            throw new LegoCheckedException(1073948352L);
        }
    }
}

