/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.dsg;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.fs.service.IFsDsgService;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IBeforeVrmSaveSerice;
import com.huawei.ism.drm.galax.sdk.service.IDsgService;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualMachineStorageInfo;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IDsgService", desc="", interfaceClass=IDsgService.class)
public class DsgServiceImpl
extends BaseService
implements IDsgService,
IBeforeVrmSaveSerice,
IFsDsgService {
    private static final Log LOGGER = LogFactory.getInstance(DsgServiceImpl.class);

    public boolean process(AbstractContext context) {
        VRM vrm = (VRM)context.getAttribute("DRMVRM");
        this.checkExist(vrm, null);
        context.setAttribute("cloudServerObj", (Object)vrm);
        List<GalaxVM> vmList = this.getVmList(vrm);
        List<VirtualMachineStorageInfo> dataStorageInfos = this.getVmStorageInfo(vmList);
        context.setAttribute("vmStorageObj", dataStorageInfos);
        List<DataStore> dsListInVrm = this.getLunPomeDatastore(vrm);
        Map<String, com.huawei.ism.drm.virtualization.sdk.model.DataStore> dsMap = this.getStorageDs(dsListInVrm);
        context.setAttribute("storageDataStoreObj", dsMap);
        context.setAttribute("cloudServerTypeObj", (Object)12);
        return true;
    }

    private List<GalaxVM> getVmList(VRM vrm) {
        ArrayList<GalaxVM> listVm = new ArrayList<GalaxVM>();
        for (ManagedObject mo : vrm.getChildMos()) {
            if (mo.getClass() != GalaxVM.class) continue;
            listVm.add((GalaxVM)mo);
        }
        return listVm;
    }

    private List<DataStore> getLunPomeDatastore(VRM vrm) {
        ArrayList<DataStore> listDs = new ArrayList<DataStore>();
        for (ManagedObject mo : vrm.getChildMos()) {
            String storageType;
            if (!mo.getClass().equals(DataStore.class) || !(storageType = ((DataStore)mo).getStorageType()).equals("LUNPOME") && !storageType.equals("NAS") && !storageType.equals("LUN")) continue;
            listDs.add((DataStore)mo);
        }
        return listDs;
    }

    public List<VirtualDataStoreGroup> getUnusedDataStoreGroupListByCloudSn(String cloudSn, boolean isavailable, Integer protectionType) {
        GalaxVM.VMProviderType vmType;
        LOGGER.info((Object)("Begin to get unused DataStoreGroup By cloudSn:" + cloudSn), 90160758786816L);
        if (VerifyUtil.isEmpty((String)cloudSn) || VerifyUtil.isEmpty((Object)protectionType)) {
            LOGGER.error((Object)(cloudSn + " dosen't exist.Failed to get."), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> cloudSns = new ArrayList<String>();
        if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(cloudSn)) {
            vmType = GalaxVM.VMProviderType.FC;
            cloudSns.add(cloudSn);
        } else {
            vmType = GalaxVM.VMProviderType.FM;
            List vrmList = ((IFmService)ServiceLocator.getInstance().getService(IFmService.class)).getRegistedFcOfSpecfiedFm(cloudSn);
            if (!VerifyUtil.isEmpty((Collection)vrmList)) {
                for (VRM vrm : vrmList) {
                    cloudSns.add(vrm.getSn());
                }
            }
        }
        List dsgs = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getDataStoreStoreGroupsByProvider(cloudSns, protectionType.intValue());
        if (protectionType.intValue() == ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue()) {
            this.filterDataStoreGroupForStorageSnapshot(dsgs);
        } else {
            this.filterDataStoreGroup(dsgs, vmType);
        }
        if (isavailable) {
            ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).removeInvalidDatastoreGroup(protectionType.intValue(), dsgs);
        }
        LOGGER.info((Object)("End to get unused DataStoreGroup List By cloudSn. cloudSn=" + cloudSn), 90160758786816L);
        return dsgs;
    }

    private void filterDataStoreGroupForStorageSnapshot(List<VirtualDataStoreGroup> dsgs) {
        List tmpList = dsgs.stream().filter(dsg -> VerifyUtil.isEmpty((String)dsg.getDataStores())).collect(Collectors.toList());
        dsgs.removeAll(tmpList);
    }

    private void filterDataStoreGroup(List<VirtualDataStoreGroup> dsgs, GalaxVM.VMProviderType cloudType) {
        if (VerifyUtil.isEmpty(dsgs)) {
            this.warnLog("dataStoreGroupList", "", "");
            return;
        }
        ArrayList<VirtualDataStoreGroup> dsgDelList = new ArrayList<VirtualDataStoreGroup>();
        for (VirtualDataStoreGroup dsg : dsgs) {
            if (cloudType.getValue().equals(dsg.getVmProviderType())) continue;
            dsgDelList.add(dsg);
        }
        dsgs.removeAll(dsgDelList);
    }

    private void checkExist(Object obj, String logParam) {
        if (null == obj) {
            LOGGER.error((Object)("the object is null:" + logParam), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    public List<DataStore> getDssByDsgId(String dsgId) {
        ArrayList<VirtualDataStoreGroup> allDsgs = new ArrayList<VirtualDataStoreGroup>();
        VirtualDataStoreGroup dsg = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getDataStoreGroupByDsgId(dsgId);
        if (null != dsg && (dsg.getGroupType().intValue() == ProtectionTypeEnum.STORAGE_REPLICATION.getValue() || dsg.getGroupType().intValue() == ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue())) {
            allDsgs.add(dsg);
        }
        HashSet<String> dsUuidSet = new HashSet<String>();
        for (VirtualDataStoreGroup tmpDsg : allDsgs) {
            for (DataStoreInfo dsInfo : tmpDsg.getDataStoreSet()) {
                dsUuidSet.add(dsInfo.getDataStoreUuid());
            }
        }
        if (VerifyUtil.isEmpty(dsUuidSet)) {
            return new ArrayList<DataStore>();
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)dsUuidSet.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        return CommonDAOLocator.getMoDao().findMoBy(DataStore.class, qcList);
    }

    private void warnLog(String nullParam, String inParam, Object param) {
        StringBuilder bui = new StringBuilder();
        bui.append(nullParam).append(" is null or empty in(for) ").append(inParam).append(":").append(param);
        LOGGER.warn((Object)bui.toString(), 90160758786816L);
    }

    private List<VirtualMachineStorageInfo> getVmStorageInfo(List<GalaxVM> vms) {
        ArrayList<VirtualMachineStorageInfo> vmStorageInfos = new ArrayList<VirtualMachineStorageInfo>();
        if (VerifyUtil.isEmpty(vms)) {
            LOGGER.error((Object)"there is no galax vms.", 90160758787071L);
            return vmStorageInfos;
        }
        for (GalaxVM vm : vms) {
            Set dsUrns = CommonUtil.stringArray2Set((String)vm.getDataStoreUrns(), (String)",");
            if (VerifyUtil.isEmpty((Collection)dsUrns)) {
                LOGGER.warn((Object)("vm has no datastore, vmUuid=" + vm.getUuid()), 90160758787071L);
                continue;
            }
            for (String dsUrn : dsUrns) {
                DataStore ds = (DataStore)CommonDAOLocator.getMoDao().getMo(DataStore.class, "urn", (Object)dsUrn);
                if (null == ds) {
                    LOGGER.error((Object)("can not find the datastore, urn=" + dsUrn), 90160758787071L);
                    VirtualMachineStorageInfo vmStorageInfo = new VirtualMachineStorageInfo();
                    vmStorageInfo.setDataStoreUuid(dsUrn);
                    vmStorageInfo.setVmUuid(vm.getUuid());
                    vmStorageInfo.setStorageUuid("--");
                    vmStorageInfos.add(vmStorageInfo);
                    continue;
                }
                Set storageWWns = DsgUtil.getDataStoreStorageWwns((DataStore)ds);
                if (VerifyUtil.isEmpty((Collection)storageWWns)) {
                    VirtualMachineStorageInfo vmStorageInfo = new VirtualMachineStorageInfo();
                    vmStorageInfo.setDataStoreUuid(dsUrn);
                    vmStorageInfo.setVmUuid(vm.getUuid());
                    vmStorageInfo.setStorageUuid("--");
                    vmStorageInfos.add(vmStorageInfo);
                    continue;
                }
                for (String wwn : storageWWns) {
                    VirtualMachineStorageInfo vmStorageInfo = new VirtualMachineStorageInfo();
                    vmStorageInfo.setDataStoreUuid(dsUrn);
                    vmStorageInfo.setVmUuid(vm.getUuid());
                    vmStorageInfo.setStorageUuid(wwn);
                    vmStorageInfos.add(vmStorageInfo);
                }
            }
        }
        return vmStorageInfos;
    }

    private Map<String, com.huawei.ism.drm.virtualization.sdk.model.DataStore> getStorageDs(List<DataStore> dataStores) {
        HashMap<String, com.huawei.ism.drm.virtualization.sdk.model.DataStore> storageDsMap = new HashMap<String, com.huawei.ism.drm.virtualization.sdk.model.DataStore>();
        for (DataStore ds : dataStores) {
            Set wwnSet = DsgUtil.getDataStoreStorageWwns((DataStore)ds);
            for (String wwn : wwnSet) {
                com.huawei.ism.drm.virtualization.sdk.model.DataStore dataStore = VrmUtil.changeFsDataStore((DataStore)ds);
                if ("NAS".equals(ds.getStorageType())) {
                    dataStore.setVolumeType(DrmEnumDefine.ResourceTypeE.NAS.name());
                } else {
                    List storageRes = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResourceByWwn(new String[]{wwn});
                    if (VerifyUtil.isEmpty((Collection)storageRes)) {
                        LOGGER.warn((Object)("can not find the storage resource, wwn=" + wwn), 90160758787071L);
                        continue;
                    }
                    StorageResource storageDev = (StorageResource)storageRes.get(0);
                    if (storageDev instanceof Lun) {
                        dataStore.setVolumeType(DrmEnumDefine.ResourceTypeE.LUN.name());
                    }
                }
                storageDsMap.put(wwn, dataStore);
            }
        }
        return storageDsMap;
    }

    public boolean checkDataStoreCapacity(String wwn, Lun lun) {
        DataStore dataStore = (DataStore)CommonDAOLocator.getMoDao().getMo(DataStore.class, "wwn", (Object)wwn);
        if (dataStore == null) {
            LOGGER.info((Object)"There is no data storage in the small lun scene.");
            return true;
        }
        double capacity = UnitConvert.convert((Double)lun.getTotalCapacity(), (IUnitType)CapabilityUnitType.valueOf((String)lun.getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.GB);
        if ("LOCALPOME".equals(dataStore.getStorageType()) || "LUNPOME".equals(dataStore.getStorageType())) {
            capacity -= 1.0;
        }
        return Double.valueOf(dataStore.getCapacityGB()).equals(capacity);
    }
}

