/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.observer;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.storage.support.dao.BaseStoragePgDao;
import com.huawei.ism.drm.galax.util.cloud.JudgeHandler;
import com.huawei.ism.drm.galax.util.cloud.VrmJudgeDefine;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.hypermetro.builder.StorageHypermetroGroupFactory;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.replication.builder.StorageReplicationGroupFactory;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.service.impl.DrmStorageBaseServiceImpl;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshDelegate;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.springframework.beans.factory.InitializingBean;

public class ProtectGroupOperateObserver
implements IObjectObserver,
InitializingBean {
    private static final Log logger = LogFactory.getInstance(ProtectGroupOperateObserver.class);
    private static final long VM_HASROLLBACKTASK = 1073948118L;
    private static final String VM_RUNNING = "running";
    private static final String VM_STOPPED = "stopped";
    private static final int IO_HANG_TIMEOUT_MAX_SIZE = 65535;
    private static final Set<Integer> NEED_CHECK_PROTECT_OBJECT_TYPE_SET = Collections.unmodifiableSet(new HashSet<Integer>(){
        {
            this.add(39);
            this.add(33);
            this.add(38);
            this.add(52);
            this.add(51);
            this.add(53);
        }
    });
    private static final String EVOL_URL_PREFIX = "scsi-3";
    private static ArrayBlockingQueue<RefreshItem> refreshQueue = new ArrayBlockingQueue(100, true);

    private static void addToRefreashQueue(RefreshItem refreshItem) {
        if (!refreshQueue.contains(refreshItem)) {
            try {
                refreshQueue.offer(refreshItem, 60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Add refresh storage error:", (Throwable)e);
            }
        } else {
            logger.warn((Object)"The refreshQueue contains refreshItem, refreshItem type is %s, id is %s, pgNmae is %s.", new Object[]{refreshItem.type, refreshItem.id, refreshItem.pg.getName()});
        }
    }

    private static void refreshStorage(String devSn) {
        StorageNE storage = (StorageNE)CommonDAOLocator.getMoDao().getMo(StorageNE.class, "sn", (Object)devSn);
        CommonTemplate template = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType(storage.getManagementProtocol());
        if (template == null) {
            logger.error((Object)"Can not find template, templateKey=%s.", new Object[]{storage.getManagementProtocol()});
            throw new LegoCheckedException(127402L);
        }
        RefreshContext context = new RefreshContext((ManagedObject)storage);
        context.setAttribute("refreshTask", null);
        template.process((AbstractContext)context);
    }

    private void refreshStorage(ProtectGroup protectGroup) {
        String poolMapStr = (String)protectGroup.getProps().get("storagePoolMapping");
        JSONArray poolArray = JSONArray.fromObject((Object)poolMapStr);
        List storagePairList = JSONArray.toCollection((JSONArray)poolArray, StoragePair.class);
        for (StoragePair storagePair : storagePairList) {
            ProtectGroupOperateObserver.addToRefreashQueue(new RefreshItem("storage", storagePair.getSrcDevSN(), protectGroup));
            ProtectGroupOperateObserver.addToRefreashQueue(new RefreshItem("storage", storagePair.getTgtDevSN(), protectGroup));
        }
    }

    public void before(MessageEvent event) {
        logger.info((Object)"Enter before.");
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup;
            if (!(object instanceof ProtectGroup) || !this.checkParam(protectGroup = (ProtectGroup)object)) continue;
            switch (messageType) {
                case 0: {
                    this.createHandle(messageType, protectGroup);
                    break;
                }
                case 3: {
                    this.checkVmHA(protectGroup);
                    this.handleAddMessage(messageType, protectGroup);
                    break;
                }
                case 2: {
                    this.checkVmHA(protectGroup);
                    this.deleteHandle(messageType, protectGroup);
                    break;
                }
                case 4: {
                    this.checkVmHA(protectGroup);
                    this.checkPos(protectGroup, messageType);
                    break;
                }
            }
        }
    }

    private void deleteHandle(int messageType, ProtectGroup protectGroup) {
        switch (protectGroup.getTemplate().getType()) {
            case 33: 
            case 39: 
            case 51: 
            case 52: {
                this.handleDeleteMessage(protectGroup);
                break;
            }
            case 38: 
            case 53: {
                this.handleDeleteHyperMetroMessage(protectGroup);
                break;
            }
            default: {
                logger.error((Object)"Not support templateType,type=%s.", new Object[]{String.valueOf(messageType)});
            }
        }
    }

    private void createHandle(int messageType, ProtectGroup protectGroup) {
        int templateType = protectGroup.getTemplate().getType();
        CreateProtectGroupRefineService.checkProtectGroupTotalCount((int)templateType);
        switch (templateType) {
            case 33: 
            case 39: 
            case 51: 
            case 52: {
                this.handleCreateMessage(messageType, protectGroup);
                break;
            }
            case 38: 
            case 53: {
                this.handleCreateHyperMetroMessage(messageType, protectGroup);
                break;
            }
            default: {
                logger.error((Object)"Not support templateType,type=%s.", new Object[]{String.valueOf(messageType)});
            }
        }
    }

    private void handleDeleteHyperMetroMessage(ProtectGroup protectGroup) {
        List<GalaxVM> galaxVms = this.checkVMPoVmStatus(protectGroup);
        galaxVms.forEach(galaxVm -> this.buildProtectStorage(protectGroup, (GalaxVM)galaxVm, (List<ProtectObjectStorageInfo>)new ArrayList<ProtectObjectStorageInfo>()));
        StorageHypermetroGroupFactory storageHypermetroFactory = StorageHypermetroGroupFactory.newFactory();
        storageHypermetroFactory.deleteHypermetroGroup(protectGroup);
    }

    private void buildProtectStorage(ProtectGroup protectGroup, GalaxVM galaxVm, List<ProtectObjectStorageInfo> needReleaseStorage) {
        if (VerifyUtil.isEmpty((String)galaxVm.getVmConfig())) {
            logger.warn((Object)"Can not find vmConfig for vm: %s.", new Object[]{galaxVm.getName()});
            return;
        }
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)galaxVm.getVmConfig(), VmConfigType.class);
        if (VerifyUtil.isEmpty((Object)vmConfig) || VerifyUtil.isEmpty((Collection)vmConfig.getDisks())) {
            logger.warn((Object)"Can not find disk for vm:%s.", new Object[]{galaxVm.getName()});
            return;
        }
        HashMap<String, List<VmConfigDiskType>> storageDiskMap = new HashMap<String, List<VmConfigDiskType>>();
        this.buildStorageDisk(storageDiskMap, vmConfig);
        Optional<ProtectObject> protectObjectOptional = protectGroup.getPolist().stream().filter(item -> item.getMoUuid().equals(galaxVm.getUuid())).findAny();
        if (!protectObjectOptional.isPresent()) {
            logger.warn((Object)"Can not find vm %s in poList.", new Object[]{galaxVm.getUuid()});
            return;
        }
        ProtectObject protectObject = protectObjectOptional.get();
        Map<String, StorageResource> storageMap = this.getStorageResourceMap(storageDiskMap, protectObject.getUsedStorageResourceSet().stream().map(ProtectObjectStorageInfo::getResourceProviderSN).findFirst().orElse(""));
        this.checkSameDevice(storageMap.values());
        ArrayList<String> needReleaseVolumeIds = new ArrayList<String>();
        if (!VerifyUtil.isEmpty(needReleaseStorage)) {
            needReleaseStorage.forEach(storageInfo -> needReleaseVolumeIds.add(storageInfo.getLunWWN()));
        }
        protectObject.clearUsedStorageResource();
        this.buildStorageInfo(vmConfig, storageMap, protectObject, needReleaseVolumeIds);
    }

    private void checkSameDevice(Collection<StorageResource> storageResourceList) {
        Set devList = storageResourceList.stream().map(StorageResource::getDevSn).collect(Collectors.toSet());
        if (VerifyUtil.isEmpty(devList)) {
            logger.error((Object)"Check same device fail, devList is empty.");
            throw new LegoCheckedException(201L);
        }
        if (devList.size() > 1) {
            logger.error((Object)"Vm disk is not belonged to same device, devList: %s.", new Object[]{devList});
            throw new LegoCheckedException(1073948192L);
        }
    }

    private void buildStorageInfo(VmConfigType vmConfig, Map<String, StorageResource> storageMap, ProtectObject protectObject, List<String> needReleaseVolumeIds) {
        for (VmConfigDiskType disk : vmConfig.getDisks()) {
            StorageResource storageResource = storageMap.get(disk.getVolumeUrl());
            if (VerifyUtil.isEmpty((Object)storageResource) || !(storageResource instanceof Lun)) {
                logger.warn((Object)"Can not find storageResource: %s.", new Object[]{disk.getVolumeUrl()});
                continue;
            }
            Lun lun = (Lun)storageResource;
            ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
            if (VerifyUtil.isEmpty((String)info.getId())) {
                info.setId(UUIDGenerator.getUUID());
            }
            info.setLunWWN(lun.getWwn());
            info.setResourceProviderSN(lun.getDevSn());
            info.setResourceId(lun.getResourceId());
            info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
            info.setDeviceName(disk.getDiskName());
            if (needReleaseVolumeIds.contains(lun.getWwn())) {
                info.setNeedRelease(true);
            }
            info.setResourceName(lun.getName());
            protectObject.addHostStorageResourceInfo(info);
        }
    }

    private void buildStorageDisk(Map<String, List<VmConfigDiskType>> storageDiskMap, VmConfigType vmConfig) {
        for (VmConfigDiskType disk : vmConfig.getDisks()) {
            if (!disk.getPersistentDisk().booleanValue()) continue;
            String dsMgntIp = null;
            String drExtParams = disk.getDrExtParams();
            if (!VerifyUtil.isEmpty((String)drExtParams)) {
                Map drExtParamMap = (Map)JSONObject.toBean((String)drExtParams, Map.class);
                dsMgntIp = (String)drExtParamMap.get("dsMgntIp");
            }
            String dataStorUrn = disk.getDatastoreUrn();
            if (!VerifyUtil.isEmpty(dsMgntIp) && "DSWARE".equals(disk.getStorageType())) {
                CommUtil.addToMap(storageDiskMap, (String)dsMgntIp, (Object)disk);
                continue;
            }
            if (!VerifyUtil.isEmpty((String)dataStorUrn) && "advanceSan".equals(disk.getStorageType())) {
                CommUtil.addToMap(storageDiskMap, (String)dataStorUrn, (Object)disk);
                continue;
            }
            logger.debug((Object)"Can not find dsMgntIp for disk: %s.", new Object[]{disk.getDiskName()});
        }
    }

    private Map<String, StorageResource> getStorageResourceMap(Map<String, List<VmConfigDiskType>> storageDiskMap, String providerSN) {
        List disks = storageDiskMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List urlList = disks.stream().map(VmConfigDiskType::getVolumeUrl).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(urlList)) {
            return Collections.emptyMap();
        }
        IStorageLunBaseManager manager = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(providerSN);
        boolean isEVol = manager.getStorageType().equals(HvsUnit.class.getName());
        HashMap<String, StorageResource> storageMap = new HashMap<String, StorageResource>();
        for (String volumeUrl : urlList) {
            Lun lun = isEVol ? manager.getLunByWWN(providerSN, volumeUrl.replace(EVOL_URL_PREFIX, "")) : manager.getLunByName(providerSN, volumeUrl);
            if (VerifyUtil.isEmpty((Object)lun)) {
                logger.warn((Object)"Can not find storage for:%s.", new Object[]{volumeUrl});
                continue;
            }
            String key = isEVol ? EVOL_URL_PREFIX + lun.getWwn() : lun.getName();
            storageMap.put(key, (StorageResource)lun);
        }
        return storageMap;
    }

    private List<GalaxVM> checkVMPoVmStatus(ProtectGroup protectGroup) {
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject((String)protectGroup.getPoProviderSN());
        List vmList = FusionSphereServiceManager.getInstance().getVirResourceService().queryVMByDataStore(vrmInfo);
        List<String> vmStatusList = Arrays.asList(VM_RUNNING, VM_STOPPED);
        ArrayList<GalaxVM> protectVmList = new ArrayList<GalaxVM>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            GalaxVM galaxVm = vmList.stream().filter(vm -> vm.getUuid().equals(protectObject.getMoUuid()) && vmStatusList.contains(vm.getVmStatus())).findFirst().orElseThrow(() -> {
                logger.error((Object)"The protected group (%s) cannot be deleted because the protected object is not in the running or stopped state.", new Object[]{protectGroup.getName()});
                throw new LegoCheckedException(1073948476L);
            });
            protectVmList.add(galaxVm);
        }
        return protectVmList;
    }

    private void handleCreateHyperMetroMessage(int messageType, ProtectGroup protectGroup) {
        this.checkPos(protectGroup, messageType);
        if (!this.isTemplateMatchStage(protectGroup).booleanValue()) {
            this.checkPgCount(protectGroup);
            this.checkPoolMapped(protectGroup);
        }
    }

    private void checkPgCount(ProtectGroup protectGroup) {
        if (protectGroup.getPolist().size() != 1) {
            logger.debug((Object)"ProtectGroup has vm count(%s)", new Object[]{String.valueOf(protectGroup.getPolist().size())});
            throw new LegoCheckedException(1073948163L);
        }
    }

    private void handleDeleteMessage(ProtectGroup protectGroup) {
        HashMap storageMap = new HashMap();
        HashMap<String, Set<String>> cgidMap = new HashMap<String, Set<String>>();
        HashSet<String> replicationPairSet = new HashSet<String>();
        Set replicasList = protectGroup.getReplicaList();
        replicasList.stream().flatMap(replicas -> replicas.getReplicas().stream()).flatMap(replica -> replica.getStorageInfos().stream()).map(storageInfo -> (RemoteStorageReplica)storageInfo).forEach(remoteStorageReplica -> {
            replicationPairSet.add(CommUtil.combineString((String[])new String[]{remoteStorageReplica.getSrcStorageProviderSN(), remoteStorageReplica.getReplicationPairId()}));
            CommUtil.addSetToMap((Map)storageMap, (Object)remoteStorageReplica.getSrcStorageProviderSN(), (Object)remoteStorageReplica.getSrcStorageId());
            CommUtil.addSetToMap((Map)cgidMap, (Object)remoteStorageReplica.getSrcStorageProviderSN(), (Object)remoteStorageReplica.getConsistentGroupId());
        });
        StorageReplicationGroupFactory storageFactory = StorageReplicationGroupFactory.newFactory();
        Stack pairStack = new Stack();
        for (Map.Entry items : storageMap.entrySet()) {
            String devSn = (String)items.getKey();
            ArrayList storageValueList = new ArrayList((Collection)items.getValue());
            storageFactory.retrieveAllReplicationPair(pairStack, devSn, storageValueList);
            while (!pairStack.isEmpty()) {
                List oneList = (List)pairStack.pop();
                Map pairMap = storageFactory.groupReplicationPair(oneList);
                for (Map.Entry entry : pairMap.entrySet()) {
                    if (entry == null || ((Set)cgidMap.get(devSn)).contains(entry.getKey()) && replicationPairSet.containsAll(this.parsePairId(devSn, (List)entry.getValue()))) continue;
                    logger.error((Object)"Some pair not belong the pg.");
                    throw new LegoCheckedException(1073947729L);
                }
            }
        }
        this.checkPairsSameWithProtectObject(cgidMap, replicationPairSet);
        storageFactory.deleteReplicationGroup(protectGroup);
    }

    private void checkPairsSameWithProtectObject(Map<String, Set<String>> cgidMap, Set<String> replicationPairSet) {
        HashSet<String> pairList = new HashSet<String>();
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        for (Map.Entry<String, Set<String>> items : cgidMap.entrySet()) {
            String devSn = items.getKey();
            for (String cgId : items.getValue()) {
                if (proxy.getReplicationGroup(devSn, cgId) == null) {
                    logger.warn((Object)"The cg not exist:%s.", new Object[]{cgId});
                    continue;
                }
                List replicationPairList = proxy.queryReplicationPairByCgId(devSn, cgId);
                pairList.addAll(this.parsePairId(devSn, replicationPairList));
            }
        }
        if (replicationPairSet.addAll(pairList)) {
            logger.error((Object)"Some pair not belong the pg.");
            throw new LegoCheckedException(1073947729L);
        }
    }

    private void handleAddMessage(int messageType, ProtectGroup protectGroup) {
        this.mergeStorageMapping(protectGroup);
        List newStorageInfoSet = protectGroup.distinctStorageInfo();
        List needReleaseStorage = newStorageInfoSet.stream().filter(ProtectObjectStorageInfo::isNeedRelease).collect(Collectors.toList());
        if (!needReleaseStorage.isEmpty() && ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)protectGroup)) {
            List<GalaxVM> galaxVms = this.checkVMPoVmStatus(protectGroup);
            galaxVms.forEach(galaxVm -> this.buildProtectStorage(protectGroup, (GalaxVM)galaxVm, needReleaseStorage));
        }
        this.checkPos(protectGroup, messageType);
        if (!this.isTemplateMatchStage(protectGroup).booleanValue()) {
            this.checkPoolMapped(protectGroup);
            this.checkTargetExistLun(protectGroup);
        }
    }

    private void mergeStorageMapping(ProtectGroup protectGroup) {
        List originalPairs = JSONArray.fromObject((Object)protectGroup.getProperty("storagePoolMapping")).toBean(StoragePair.class);
        List newPairs = protectGroup.getPolist().stream().map(po -> JSONArray.fromObject((Object)po.getProperty("storagePoolMapping")).toBean(StoragePair.class)).flatMap(Collection::stream).collect(Collectors.toList());
        Map devPairMap = originalPairs.stream().collect(Collectors.toMap(this::getDevSnIdx, Function.identity()));
        for (StoragePair newPair : newPairs) {
            String devSnIdx = this.getDevSnIdx(newPair);
            StoragePair originalPair = (StoragePair)devPairMap.get(devSnIdx);
            if (originalPair == null) {
                originalPairs.add(newPair);
                devPairMap.put(devSnIdx, newPair);
                continue;
            }
            this.mergeStoragePool(originalPair.getStoragePools(), newPair.getStoragePools());
        }
        protectGroup.setProperty("storagePoolMapping", (Object)JSONArray.fromObject((Object)originalPairs).toString());
    }

    private void mergeStoragePool(Map<String, String> originalPoolMap, Map<String, String> newPoolMap) {
        for (Map.Entry<String, String> newPool : newPoolMap.entrySet()) {
            String src = newPool.getKey();
            String tgt = newPool.getValue();
            String originalTgt = originalPoolMap.get(src);
            if (!VerifyUtil.isEmpty((String)originalTgt) && originalTgt.equals(tgt)) continue;
            boolean isSrcUsed = originalPoolMap.containsKey(src);
            boolean isTgtUsed = originalPoolMap.containsValue(tgt);
            if (!isSrcUsed && !isTgtUsed) {
                originalPoolMap.put(src, tgt);
            }
            if (isSrcUsed == isTgtUsed) continue;
            logger.error((Object)"Merge storage pool fail, wrong pool mapping.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private String getDevSnIdx(StoragePair pair) {
        return pair.getSrcDevSN() + ":" + pair.getTgtDevSN();
    }

    private void handleCreateMessage(int messageType, ProtectGroup protectGroup) {
        this.checkPos(protectGroup, messageType);
        if (!this.isTemplateMatchStage(protectGroup).booleanValue()) {
            this.checkSite(protectGroup);
            this.checkPoolMapped(protectGroup);
            this.checkTargetExistLun(protectGroup);
        }
    }

    private void checkSite(ProtectGroup protectGroup) {
        String poolMapping = protectGroup.getProperty("storagePoolMapping");
        JSONArray jsonArray = JSONArray.fromObject((Object)poolMapping);
        List storagePairs = JSONArray.toCollection((JSONArray)jsonArray, StoragePair.class);
        for (StoragePair storagePair : storagePairs) {
            String tgtDevSn = storagePair.getTgtDevSN();
            HashSet<String> snList = new HashSet<String>();
            snList.add(tgtDevSn);
            HashMap<String, String[]> storageProps = new HashMap<String, String[]>();
            storageProps.put("deviceSn", snList.toArray(new String[0]));
            List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(storageProps);
            List drStorageList = CommonDAOLocator.getBaseDao().createCriteria(DrStorage.class, criterionList.toArray(new Criterion[0]));
            if (VerifyUtil.isEmpty((Collection)drStorageList)) {
                logger.error((Object)"Query drStorage failed.");
                throw new LegoCheckedException(1073948258L);
            }
            for (DrStorage drStorage : drStorageList) {
                if (!drStorage.getSiteId().equals(protectGroup.getProductSiteId())) continue;
                logger.error((Object)"The production site and DR site must be different.");
                throw new LegoCheckedException(1073948258L);
            }
        }
    }

    private Set<String> parsePairId(String devSn, List<ReplicationPair> replications) {
        HashSet<String> pairList = new HashSet<String>();
        for (ReplicationPair replication : replications) {
            pairList.add(CommUtil.combineString((String[])new String[]{devSn, replication.getReplicationId()}));
        }
        return pairList;
    }

    public void after(MessageEvent event) {
        logger.info((Object)"Enter after.");
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup;
            if (!(object instanceof ProtectGroup) || !this.checkParam(protectGroup = (ProtectGroup)object)) continue;
            switch (messageType) {
                case 0: {
                    this.refreshResource(protectGroup);
                    return;
                }
                case 2: {
                    try {
                        this.refreshStorage(protectGroup);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Refresh pg error, pgid:%s, error: %s.", new Object[]{protectGroup.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
                    }
                    return;
                }
                case 3: 
                case 4: {
                    if (ProtectGroupUtil.isReplicaOfSmallLun((ProtectGroup)protectGroup)) {
                        this.cleanPoolMess(protectGroup);
                    }
                    this.refreshResource(protectGroup);
                    return;
                }
            }
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    public void afterPropertiesSet() {
        FixedProtectionThreadPool.submit((FixedProtectionThreadPool.FixedProtectionThreadPoolEnum)FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.PROTECT_MONITOR_EXECUTOR, (Callable)new RefreashCallable());
    }

    private boolean checkParam(ProtectGroup protectGroup) {
        if (!protectGroup.isPrimary()) {
            return false;
        }
        if (!NEED_CHECK_PROTECT_OBJECT_TYPE_SET.contains(protectGroup.getTemplate().getType())) {
            return false;
        }
        Set poList = protectGroup.getPolist();
        for (ProtectObject po : poList) {
            if (po.getPoType() == DrmEnumDefine.AppType.GALAX_VM.getValue()) continue;
            return false;
        }
        return true;
    }

    private void checkPos(ProtectGroup protectGroup, int messageType) {
        boolean isHyperMetro;
        Set polist = protectGroup.getPolist();
        HashSet<ProtectObject> polistNew = new HashSet<ProtectObject>();
        for (ProtectObject protectObject : polist) {
            if (protectObject.getPoStatus() != ProtectObjectStatusEnum.VALID.getValue()) continue;
            polistNew.add(protectObject);
        }
        int templateType = protectGroup.getTemplate().getType();
        boolean bl = isHyperMetro = templateType == 38 || templateType == 53;
        if (isHyperMetro && messageType == 3) {
            polistNew = polist;
        }
        if (NEED_CHECK_PROTECT_OBJECT_TYPE_SET.contains(templateType) && messageType == 3) {
            this.checkVmHasNofDisk(protectGroup);
        }
        if (VerifyUtil.isEmpty(polistNew)) {
            logger.debug((Object)"End checkPos, cause param empty.");
            return;
        }
        HashSet<String> poSn = new HashSet<String>();
        Set<String> vmUuids = this.buildVmUUids(polistNew, poSn);
        List<GalaxVM> vmList = BaseStoragePgDao.getInstance().queryGalaxVMByVmUuids(vmUuids);
        this.checkPoSNAndVm(polistNew, poSn, vmList);
        this.checkVmIoHangTimeout(isHyperMetro, vmList);
        this.checkVmHasRollBackTask(vmUuids);
        Iterator<GalaxVM> iterator = vmList.iterator();
        List<GalaxVM> fcVmList = ProtectGroupOperateObserver.getFcVmList(polistNew);
        if (!isHyperMetro) {
            this.checkShareVmList(polist, messageType, fcVmList);
        }
        List<JudgeHandler.JudgeUnit<GalaxVM>> judgeList = this.buildJudgeList(isHyperMetro);
        while (iterator.hasNext()) {
            GalaxVM glVm = iterator.next();
            this.checkGalaxVm(glVm, judgeList);
        }
        if (!ProtectGroupHelper.getInstance().checkProtectGroupDatastoreBelong(protectGroup)) {
            logger.error((Object)"Not from same storage, protect group name: %s.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948192L);
        }
    }

    private static List<GalaxVM> getFcVmList(Set<ProtectObject> polistNew) {
        ProtectObject po = polistNew.iterator().next();
        HashMap<String, Boolean> extendCondition = new HashMap<String, Boolean>();
        extendCondition.put("isPoAllow", true);
        extendCondition.put("isTemplateAllow", true);
        return FsRecoveryUtil.getFilterVms((String)po.getProviderSN(), extendCondition);
    }

    private void checkVmHasRollBackTask(Set<String> vmUuids) {
        List uuidList = VrmUtil.vmExistRollBackTask(vmUuids);
        if (!VerifyUtil.isEmpty((Collection)uuidList)) {
            logger.error((Object)"CheckPos failed, cause vm has roll back task.");
            throw new LegoCheckedException(1073948118L);
        }
    }

    private void checkVmHasNofDisk(ProtectGroup protectGroup) {
        Set<String> vmUuids = protectGroup.getPolist().stream().map(ProtectObject::getMoUuid).collect(Collectors.toSet());
        List<GalaxVM> vmList = BaseStoragePgDao.getInstance().queryGalaxVMByVmUuids(vmUuids);
        String nofVmsName = vmList.stream().filter(VrmUtil::isVmHasNofDIsk).map(ManagedObject::getName).collect(Collectors.joining(","));
        if (!VerifyUtil.isEmpty((String)nofVmsName)) {
            logger.error((Object)"CheckPos failed,vm has nof volume:%s", new Object[]{nofVmsName});
            throw new LegoCheckedException(1073949752L, new String[]{nofVmsName});
        }
    }

    private Set<String> buildVmUUids(Set<ProtectObject> polistNew, Set<String> poSn) {
        HashSet<String> vmUuids = new HashSet<String>();
        for (ProtectObject protectObject : polistNew) {
            String moUuid = protectObject.getMoUuid();
            vmUuids.add(moUuid);
            String poProviderSn = protectObject.getProviderSN();
            poSn.add(poProviderSn);
        }
        return vmUuids;
    }

    private void checkVmIoHangTimeout(boolean isHyperMetro, List<GalaxVM> vmList) {
        if (!isHyperMetro) {
            return;
        }
        for (GalaxVM vm : vmList) {
            VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vm.getVmConfig(), VmConfigType.class);
            if (VerifyUtil.isEmpty((Object)vmConfig) || VerifyUtil.isEmpty((Object)vmConfig.getProperties())) {
                logger.error((Object)"Param vmConfig or vmProperties is null.");
                throw new LegoCheckedException(1073947393L);
            }
            Integer timeout = vmConfig.getProperties().getBlockIoHangTimeout();
            if (timeout != null && timeout > 0 && timeout <= 65535) continue;
            logger.error((Object)"BlockIoHangTimeout is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkShareVmList(Set<ProtectObject> polist, int messageType, List<GalaxVM> fcVmList) {
        List shareVmList = messageType == 4 ? VrmUtil.findVmShareAllInGroup(polist, fcVmList) : VrmUtil.findVmShareNotAllInGroup(polist, fcVmList);
        HashSet shareVmSet = new HashSet(shareVmList);
        if (!shareVmSet.isEmpty()) {
            StringBuilder vmStr = new StringBuilder();
            for (GalaxVM vm : shareVmSet) {
                vmStr.append(vm.getName()).append("\uff0c");
            }
            logger.error((Object)"The vm has share volume, vmStr is %s.", new Object[]{vmStr});
            throw new LegoCheckedException(1073947682L, new String[]{vmStr.substring(0, vmStr.length() - 1)});
        }
    }

    private void checkPoSNAndVm(Set<ProtectObject> polistNew, Set<String> poSn, List<GalaxVM> vmList) {
        if (poSn.size() != 1) {
            logger.error((Object)"Some vm do not belong to the same FC.");
            throw new LegoCheckedException(1073948403L);
        }
        if (vmList.size() != polistNew.size()) {
            logger.error((Object)"Some vm can not find.");
            throw new LegoCheckedException(2117645L);
        }
    }

    private void checkGalaxVm(GalaxVM glVm, List<JudgeHandler.JudgeUnit<GalaxVM>> judgeList) {
        glVm.setVmConfigType((VmConfigType)CommonUtil.jsonToBean((String)glVm.getVmConfig(), VmConfigType.class));
        JudgeHandler handler = JudgeHandler.build((Object)glVm).recordMessage(true);
        if (!handler.judge(judgeList)) {
            logger.error((Object)"Vm not support dr: %s.", new Object[]{glVm.getName()});
            long errorCode = (Long)handler.failureMessageFirst((Object)1073948403L, Long.class);
            throw new LegoCheckedException(errorCode, new String[]{glVm.getName()});
        }
    }

    private List<JudgeHandler.JudgeUnit<GalaxVM>> buildJudgeList(boolean isHyperMetro) {
        ArrayList<JudgeHandler.JudgeUnit<GalaxVM>> judgeList = new ArrayList<JudgeHandler.JudgeUnit<GalaxVM>>();
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NIC, (boolean)true));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NON_PERSISTENT_DISK, (boolean)false));
        if (isHyperMetro) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_SMALL_LUN_DISK_TYPE, (boolean)true));
        } else {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_FS_DISK_TYPE, (boolean)true));
        }
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_LINK_CLONE, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VRM, (boolean)false));
        if (!isHyperMetro) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_LOCAL_HOST_VM, (boolean)false, (Object)1073949740L));
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_GPU_GROUP, (boolean)false));
        }
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PASS_THROUGH_GPU, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_USB, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PCIS, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_DR_SUPPORT, (boolean)true));
        if (isHyperMetro) {
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.HAS_SHARE_VOLUME, (boolean)false, (Object)1073949738L));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_SCSI, (boolean)false, (Object)1073949741L));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_IDE, (boolean)false, (Object)1073949743L));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_SECURITY_VM, (boolean)false));
        }
        return judgeList;
    }

    private void checkPoolMapped(ProtectGroup protectGroup) {
        String poolMapStr = (String)protectGroup.getProps().get("storagePoolMapping");
        JSONArray poolArray = JSONArray.fromObject((Object)poolMapStr);
        if (VerifyUtil.isEmpty((Collection)poolArray)) {
            logger.error((Object)"Some resource pools are not mapped.");
            throw new LegoCheckedException(1073948403L);
        }
        Set<String> devSnSet = this.getDevSn(protectGroup);
        if (VerifyUtil.isEmpty(devSnSet)) {
            logger.debug((Object)"The pg usedStorageResourceSet is empty.");
            return;
        }
        HashSet<String> srcDevSn = new HashSet<String>();
        List collection = JSONArray.toCollection((JSONArray)poolArray, StoragePair.class);
        for (StoragePair storagePair : collection) {
            srcDevSn.add(storagePair.getSrcDevSN());
            if (!this.isPoolMapped(storagePair)) {
                logger.error((Object)"some resource pools are mapped error.");
                throw new LegoCheckedException(1073948403L);
            }
            if (!ProtectGroupUtil.isReplicaOfSmallLun((ProtectGroup)protectGroup) || devSnSet.contains(storagePair.getSrcDevSN())) continue;
            logger.error((Object)"DevSnSet do not contains\uff1a%s.", new Object[]{storagePair.getSrcDevSN()});
            throw new LegoCheckedException(1073948403L);
        }
        if (devSnSet.size() != srcDevSn.size()) {
            logger.error((Object)"pg params error.");
            throw new LegoCheckedException(1073948403L);
        }
    }

    public boolean isPoolMapped(StoragePair storagePair) {
        Map poolPairMap = storagePair.getStoragePools();
        HashSet poolKey = new HashSet();
        HashSet poolValue = new HashSet();
        for (Map.Entry entry : poolPairMap.entrySet()) {
            poolKey.add(entry.getKey());
            poolValue.add(entry.getValue());
            if (!VerifyUtil.isEmpty((String)storagePair.getTgtStoragePool((String)entry.getKey()))) continue;
            return false;
        }
        return poolKey.size() == poolValue.size();
    }

    public Set<String> getDevSn(ProtectGroup protectGroup) {
        HashSet<String> devSnSet = new HashSet<String>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
                devSnSet.add(poStorageInfo.getResourceProviderSN());
            }
        }
        return devSnSet;
    }

    private void cleanPoolMess(ProtectGroup protectGroup) {
        Set<String> existPoolSet = this.getExistPoolID(protectGroup);
        String poolMapStr = (String)protectGroup.getProps().get("storagePoolMapping");
        JSONArray poolArray = JSONArray.fromObject((Object)poolMapStr);
        List collection = JSONArray.toCollection((JSONArray)poolArray, StoragePair.class);
        for (StoragePair storagePair : collection) {
            Map poolPairMap = storagePair.getStoragePools();
            poolPairMap.entrySet().removeIf(entry -> !existPoolSet.contains(entry.getKey()));
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)collection);
        protectGroup.getProps().put("storagePoolMapping", jsonArray.toString());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
    }

    public Set<String> getExistPoolID(ProtectGroup protectGroup) {
        HashSet<String> existPoolSet = new HashSet<String>();
        HashMap deviceStorageMap = new HashMap();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
                CommUtil.addToMap(deviceStorageMap, (String)poStorageInfo.getResourceProviderSN(), (Object)poStorageInfo.getResourceId());
            }
        }
        for (Map.Entry entry : deviceStorageMap.entrySet()) {
            String deviceSn = (String)entry.getKey();
            List idList = (List)entry.getValue();
            List storageRes = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResources(deviceSn, idList);
            for (StorageResource storageResource : storageRes) {
                if (!(storageResource instanceof Lun)) continue;
                Lun lun = (Lun)storageResource;
                existPoolSet.add(lun.getStoragePoolId());
            }
        }
        return existPoolSet;
    }

    private Boolean isTemplateMatchStage(ProtectGroup protectGroup) {
        try {
            Optional<Map> propsMap = Optional.of(protectGroup.getProps());
            if (Boolean.parseBoolean((String)propsMap.get().get("PROP_IS_TEMPLATE_FILTER_PG"))) {
                Map props = protectGroup.getProps();
                props.remove("PROP_IS_TEMPLATE_FILTER_PG");
                protectGroup.setProps(props);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Method isTemplateMatchStage fail, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        return false;
    }

    private void checkTargetExistLun(ProtectGroup protectGroup) {
        if (!ProtectGroupUtil.isReplicaOfSmallLun((ProtectGroup)protectGroup)) {
            return;
        }
        if ("false".equals(LegoBaseConfig.getInstance().getKeyValue("fc.fsb.checklun"))) {
            logger.debug((Object)"No check lun exist.");
            return;
        }
        Set poList = protectGroup.getPolist();
        HashSet<String> nameList = new HashSet<String>();
        HashMap<String, String> deviceStorageMap = new HashMap<String, String>();
        for (ProtectObject po : poList) {
            Set protectObjectStorageInfos = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObjectStorageInfos) {
                deviceStorageMap.put(protectObjectStorageInfo.getResourceName(), protectObjectStorageInfo.getResourceId());
                nameList.add(protectObjectStorageInfo.getResourceName());
            }
        }
        String poolMapStr = (String)protectGroup.getProps().get("storagePoolMapping");
        JSONArray poolArray = JSONArray.fromObject((Object)poolMapStr);
        if (VerifyUtil.isEmpty((Collection)poolArray)) {
            logger.error((Object)"Some resource pools are not mapped.");
            throw new LegoCheckedException(1073948403L);
        }
        List storagePairs = JSONArray.toCollection((JSONArray)poolArray, StoragePair.class);
        List<String> needDeleLun = this.getNeedDeleteLun(storagePairs, nameList, deviceStorageMap);
        if (!VerifyUtil.isEmpty(needDeleLun)) {
            logger.error((Object)"Target lun exist: %s", new Object[]{needDeleLun.toString()});
            throw new LegoCheckedException(1073947467L, new String[]{needDeleLun.toString()});
        }
    }

    private List<String> getNeedDeleteLun(Collection<StoragePair> storagePairs, Set<String> nameList, Map<String, String> deviceStorageMap) {
        ArrayList<String> needDeleteLun = new ArrayList<String>();
        for (StoragePair storagePair : storagePairs) {
            ArrayList<String> volNames = new ArrayList<String>();
            ArrayList existPairLun = new ArrayList();
            DrmStorageBaseServiceImpl drmStorageService = (DrmStorageBaseServiceImpl)ServiceLocator.getInstance().getService(DrmStorageBaseServiceImpl.class);
            List storageResources = drmStorageService.getStorageResources(storagePair.getTgtDevSN(), new ArrayList<String>(nameList), true);
            ArrayList<String> lunIds = new ArrayList<String>();
            if (VerifyUtil.isEmpty((Collection)storageResources)) continue;
            for (StorageResource storageResource : storageResources) {
                lunIds.add(deviceStorageMap.get(storageResource.getName()));
                volNames.add(storageResource.getName());
            }
            List replicationPairList = drmStorageService.queryReplicationPairsByMasterLunId(storagePair.getSrcDevSN(), lunIds, false);
            for (ReplicationPair replicationPair : replicationPairList) {
                existPairLun.addAll(replicationPair.getRepTgtLuns().stream().filter(a -> a.getTgtDevSN().equals(storagePair.getTgtDevSN())).map(ReplicationTargetLun::getTgtLunName).collect(Collectors.toList()));
            }
            volNames.removeAll(existPairLun);
            if (VerifyUtil.isEmpty(volNames)) continue;
            needDeleteLun.addAll(volNames);
        }
        return needDeleteLun;
    }

    private void refreshResource(ProtectGroup protectGroup) {
        this.refreshStorage(protectGroup);
        IProtectGroupRefreshDelegate delegate = (IProtectGroupRefreshDelegate)ServiceLocator.getInstance().getService(IProtectGroupRefreshDelegate.class);
        delegate.refreshProtectGroup(protectGroup);
    }

    private void checkVmHA(ProtectGroup protectGroup) {
        if (!ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)protectGroup)) {
            return;
        }
        IDaoAdapter daoAdapter = (IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class);
        IVirtualResourceManager virtualResourceManager = (IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class);
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            GalaxVM vmInDb = (GalaxVM)daoAdapter.getMo(GalaxVM.class, "uuid", (Object)protectObject.getMoUuid());
            if (vmInDb == null) {
                throw new LegoCheckedException(2117645L);
            }
            VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)protectObject.getProviderSN());
            GalaxVM currentVm = virtualResourceManager.queryVmDetailInfo(vmInDb.getUri(), vrmInfo);
            if (!ProtectGroupOperateObserver.dataStoreChanged(vmInDb.getDataStoreUrns(), currentVm.getDataStoreUrns())) continue;
            logger.error((Object)"The datastore used by VM is changed, and resources need to be refresh. pgName: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948990L);
        }
    }

    private static boolean dataStoreChanged(String urnsInDbStr, String currentUrnsStr) {
        String[] currentUrns;
        if (Objects.equals(urnsInDbStr, currentUrnsStr)) {
            return false;
        }
        if (VerifyUtil.isEmpty((String)urnsInDbStr)) {
            return !VerifyUtil.isEmpty((String)currentUrnsStr);
        }
        if (VerifyUtil.isEmpty((String)currentUrnsStr)) {
            return true;
        }
        String[] urnsInDb = urnsInDbStr.split(",\\s*");
        if (urnsInDb.length != (currentUrns = currentUrnsStr.split(",\\s*")).length) {
            return true;
        }
        HashSet<String> currentUrnSet = new HashSet<String>(Arrays.asList(currentUrns));
        return Arrays.stream(urnsInDb).anyMatch(urnInDb -> !currentUrnSet.contains(urnInDb));
    }

    private static class RefreashCallable
    implements Callable {
        private RefreashCallable() {
        }

        public Object call() throws Exception {
            while (true) {
                RefreshItem refreshItem = (RefreshItem)refreshQueue.take();
                try {
                    this.refresh(refreshItem);
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)"Refresh error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    continue;
                }
                break;
            }
        }

        private void refresh(RefreshItem refreshItem) {
            switch (refreshItem.type) {
                case "storage": {
                    ProtectGroupOperateObserver.refreshStorage(refreshItem.id);
                    break;
                }
                case "pg": {
                    IProtectGroupRefreshDelegate delegate = (IProtectGroupRefreshDelegate)ServiceLocator.getInstance().getService(IProtectGroupRefreshDelegate.class);
                    delegate.refreshProtectGroup(refreshItem.pg);
                    break;
                }
                default: {
                    logger.error((Object)"Error refresh type: %s.", new Object[]{refreshItem.type});
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public static class RefreshItem {
        static final String REFRESH_TYPE_STORAGE = "storage";
        static final String REFRESH_TYPE_PG = "pg";
        String type;
        String id;
        ProtectGroup pg;

        public RefreshItem(String type, String id, ProtectGroup pg) {
            this.type = type;
            this.id = id;
            this.pg = pg;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefreshItem)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            RefreshItem refreshItem = (RefreshItem)o;
            return refreshItem.type.equals(this.type) && refreshItem.id.equals(this.id);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }
}

