/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.protectgroup.check;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingCheckService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PgResMappingCheckService
implements IResourceMappingCheckService {
    private static Log logger = LogFactory.getInstance(PgResMappingCheckService.class);
    private String trace = "trace";

    public void checkPgResMapping(ProtectGroup protectGroup, List<VmMgrInfo> vmMgrInfoList, String priderSn) {
        String productSiteId = protectGroup.getProductSiteId();
        Set<Object> recoverySiteIdSet = new HashSet();
        boolean isRepHyper = false;
        if (!VerifyUtil.isEmpty((Object)protectGroup.getTemplate()) && !VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules())) {
            recoverySiteIdSet = this.getRecoverySiteIds(productSiteId, protectGroup.getTemplate());
            recoverySiteIdSet.remove(productSiteId);
            int templateType = protectGroup.getTemplate().getType();
            if (PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO.getValue() == templateType || PolicyTemplateType.PolicyTemplateE.ARRAY_SYNC_HYPER_METRO.getValue() == templateType || PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO_RING.getValue() == templateType) {
                isRepHyper = true;
            }
        }
        if (!isRepHyper && !VerifyUtil.isEmpty(recoverySiteIdSet)) {
            for (String string : recoverySiteIdSet) {
                this.checkResMapping(vmMgrInfoList, priderSn, productSiteId, string);
            }
        } else {
            this.checkResMapping(vmMgrInfoList, priderSn, null, null);
        }
    }

    private Set<String> getRecoverySiteIds(String productSiteId, PolicyTemplate template) {
        Set schedules = template.getSchedules();
        HashSet<String> recoverySiteIdSet = new HashSet<String>();
        for (Schedule schedule : schedules) {
            String targetSiteId = schedule.getTargetSiteId();
            if (VerifyUtil.isEmpty((String)targetSiteId) || template.getType() == 6 && !productSiteId.equals(targetSiteId)) continue;
            recoverySiteIdSet.add(targetSiteId);
        }
        return recoverySiteIdSet;
    }

    public void checkResMapping(List<VmMgrInfo> vmInfoList, String providerSn, String productSiteId, String recoverySiteId) {
        logger.trace((Object)(this.trace + "checkResMapping"));
        this.checkHostOrClustor(vmInfoList, productSiteId, recoverySiteId);
        if (providerSn.startsWith("Dr_Vrm")) {
            this.checkPortGroup(vmInfoList, productSiteId, recoverySiteId);
        } else {
            this.checkNetWorkAndSecurityGroup(vmInfoList, providerSn, productSiteId, recoverySiteId);
        }
    }

    private void checkNetWorkAndSecurityGroup(List<VmMgrInfo> vmInfoList, String fmSn, String productSiteId, String recoverySiteId) {
        logger.trace((Object)(this.trace + "checkNetWorkAndSecurityGroup"));
        for (VmMgrInfo vmMgr : vmInfoList) {
            String vmConfig = vmMgr.getVmConfig();
            Object[] nics = PgResMappingCheckService.getFmListNic(vmConfig);
            if (VerifyUtil.isEmpty((Object[])nics)) {
                logger.info((Object)("Nics is null,vmConfig is:" + vmConfig), 90160758786816L);
                continue;
            }
            for (Object nic : nics) {
                if (null == nic) continue;
                this.checkNetwork(fmSn, (ResourcepoolVMServiceV2Stub.Nic)nic, productSiteId, recoverySiteId);
                if (null == nic.getSgId() || nic.getSgId().equals("-1")) continue;
                this.checkSecurityGroup(fmSn, (ResourcepoolVMServiceV2Stub.Nic)nic, productSiteId, recoverySiteId);
            }
        }
    }

    private void checkNetwork(String fmSn, ResourcepoolVMServiceV2Stub.Nic nic, String productSiteId, String recoverySiteId) {
        logger.trace((Object)(this.trace + "checkNetwork"));
        ResourceMapping res = null;
        String productResourceId = null;
        if (!VerifyUtil.isEmpty((String)nic.getNetworkid())) {
            productResourceId = FmUtils.getFmResourceUrn((String)fmSn, (String)FmNetwork.class.getSimpleName(), (String)nic.getNetworkid());
            res = FsRecoveryUtil.getResourceMapping((String)productResourceId, (int)ResTypeEnum.NETWORK.getResType(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        }
        if (null == res || null == res.getRecoverySiteId()) {
            logger.error((Object)("Network has not enough resmapping:" + nic.getNetworkid()), 90160758786816L);
            FmNetwork network = (FmNetwork)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(FmNetwork.class, "uuid", (Object)productResourceId);
            String name = "";
            if (null != network && !VerifyUtil.isEmpty((String)network.getName())) {
                name = network.getName();
            }
            String resType = ResTypeEnum.NETWORK.getResTag();
            throw new LegoCheckedException(1073948451L, new String[]{resType, name});
        }
    }

    private void checkSecurityGroup(String fmSn, ResourcepoolVMServiceV2Stub.Nic nic, String productSiteId, String recoverySiteId) {
        logger.trace((Object)(this.trace + "checkSecurityGroup"));
        String productResourceId = FmUtils.getFmResourceUrn((String)fmSn, (String)SecurityGroup.class.getSimpleName(), (String)nic.getSgId());
        ResourceMapping res = FsRecoveryUtil.getResourceMapping((String)productResourceId, (int)ResTypeEnum.SECURITY_GROUP.getResType(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        if (null == res || null == res.getRecoverySiteId()) {
            logger.error((Object)("SecurityGroup has not enough resmapping:" + nic.getSgId()), 90160758786816L);
            SecurityGroup sg = (SecurityGroup)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(SecurityGroup.class, "uuid", (Object)productResourceId);
            boolean nameIsExist = null != sg && !VerifyUtil.isEmpty((String)sg.getName());
            String resType = ResTypeEnum.SECURITY_GROUP.getResTag();
            String name = nameIsExist ? sg.getName() : "";
            throw new LegoCheckedException(1073948451L, new String[]{resType, name});
        }
    }

    private void checkPortGroup(List<VmMgrInfo> vmInfoList, String productSiteId, String recoverySiteId) {
        logger.trace((Object)(this.trace + "checkPortGroup"));
        for (VmMgrInfo vmMgr : vmInfoList) {
            List<VmConfigNicType> nics = PgResMappingCheckService.getListNic(vmMgr.getVmConfig());
            if (VerifyUtil.isEmpty(nics)) continue;
            for (VmConfigNicType nic : nics) {
                ResourceMapping res = FsRecoveryUtil.getResourceMapping((String)nic.getPortGroupUrn(), (int)ResTypeEnum.PORT_GROUP.getResType(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
                if (null != res && null != res.getRecoverySiteId()) continue;
                logger.error((Object)("ProtectGroup has not enough resmapping:" + nic.getPortGroupUrn()), 90160758787071L);
                String resType = ResTypeEnum.PORT_GROUP.getResTag();
                String name = nic.getPortGroupName();
                throw new LegoCheckedException(1073948451L, new String[]{resType, name});
            }
        }
    }

    private void checkHostOrClustor(List<VmMgrInfo> vmInfoList, String productSiteId, String recoverySiteId) {
        logger.trace((Object)(this.trace + "checkHostOrClustor"));
        for (VmMgrInfo vmMgr : vmInfoList) {
            ResourceMapping res = FsRecoveryUtil.getResourceMapping((String)vmMgr.getLocation(), (boolean)vmMgr.isHostLoc(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
            if (null != res && null != res.getRecoverySiteId()) continue;
            logger.error((Object)("HostOrClustor has not enough resmapping:" + vmMgr.getLocation()), 90160758787071L);
            String resType = PgResMappingCheckService.getResType(vmMgr.isHostLoc());
            ManagedObject obj = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ManagedObject.class, "uuid", (Object)vmMgr.getLocation());
            String name = VerifyUtil.isEmpty((Object)obj) ? "" : obj.getName();
            throw new LegoCheckedException(1073948451L, new String[]{resType, name});
        }
    }

    private static String getResType(boolean isBindingHost) {
        String resType = isBindingHost ? ResTypeEnum.COMPUTE_NODE.getResTag() : ResTypeEnum.CLUSTER_RESOURCE.getResTag();
        return resType;
    }

    private static List<VmConfigNicType> getListNic(String vmConfig) {
        try {
            VmConfigType vmConfigType = (VmConfigType)CommonUtil.jsonToBean((String)vmConfig, VmConfigType.class);
            List nics = vmConfigType.getNics();
            return nics;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to exchange vmConfig infomation from string to vmConfigType", (long)-1L, null, (Log)logger);
            return new ArrayList<VmConfigNicType>();
        }
    }

    private static ResourcepoolVMServiceV2Stub.Nic[] getFmListNic(String vmConfig) {
        ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfigE = (ResourcepoolVMServiceV2Stub.VmConfigSetE)CommonUtil.jsonToBean((String)vmConfig, ResourcepoolVMServiceV2Stub.VmConfigSetE.class);
        if (null == vmConfigE) {
            logger.error((Object)"Failed to exchange vmConfig infomation from string to VmConfigSetE", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        return vmConfigE.getNics();
    }

    public void checkCanDelete(ResourceMapping resourceMapping) {
        logger.info((Object)("Start to check resourceMapping,its product site id:" + resourceMapping.getProductSiteId()), 90160758786816L);
        int resType = resourceMapping.getResourceType();
        if (ResTypeEnum.CLUSTER_RESOURCE.getResType() == resType || ResTypeEnum.COMPUTE_NODE.getResType() == resType) {
            this.checkHostOrClustorResMappingDeleting(resourceMapping);
        }
        if (ResTypeEnum.PORT_GROUP.getResType() == resType) {
            this.checkPortGroupResMappingDeleting(resourceMapping);
        }
        if (ResTypeEnum.SECURITY_GROUP.getResType() == resType || ResTypeEnum.NETWORK.getResType() == resType) {
            this.checkFmResMappingDeleting(resourceMapping);
        }
    }

    private void checkFmResMappingDeleting(ResourceMapping resourceMapping) {
        logger.trace((Object)(this.trace + "checkFmResMappingDeleting"));
        List allPg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByType(12, Long.valueOf(1L));
        if (VerifyUtil.isEmpty((Collection)allPg)) {
            return;
        }
        for (ProtectGroup pg : allPg) {
            if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(pg.getPoProviderSN()) || !this.isArrayProtectGroup(pg)) continue;
            for (ProtectObject po : pg.getPolist()) {
                ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
                VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
                String vmConfig = vmMgr.getVmConfig();
                if (VerifyUtil.isEmpty((String)vmConfig)) continue;
                ResourcepoolVMServiceV2Stub.Nic[] nics = PgResMappingCheckService.getFmListNic(vmConfig);
                this.checkFmNic(nics, pg.getPoProviderSN(), resourceMapping);
            }
        }
    }

    private void checkFmNic(ResourcepoolVMServiceV2Stub.Nic[] nics, String fmSn, ResourceMapping resourceMapping) {
        logger.trace((Object)(this.trace + "checkFmNic"));
        if (null == nics) {
            return;
        }
        for (ResourcepoolVMServiceV2Stub.Nic nic : nics) {
            if (ResTypeEnum.NETWORK.getResType() == resourceMapping.getResourceType()) {
                String networkUuid = FmUtils.getFmResourceUrn((String)fmSn, (String)FmNetwork.class.getSimpleName(), (String)nic.getNetworkid());
                this.checkRmIsUsed(resourceMapping, networkUuid);
                continue;
            }
            String sgUuid = FmUtils.getFmResourceUrn((String)fmSn, (String)SecurityGroup.class.getSimpleName(), (String)nic.getSgId());
            this.checkRmIsUsed(resourceMapping, sgUuid);
        }
    }

    private void checkRmIsUsed(ResourceMapping resourceMapping, String resourceId) {
        logger.trace((Object)(this.trace + "checkRmIsUsed"));
        if (resourceId.equals(resourceMapping.getProductResourceId()) || resourceId.equals(resourceMapping.getRecoveryResourceId())) {
            logger.info((Object)("Resource mapping is used:" + resourceId), 90160758787071L);
            throw new LegoCheckedException(1073947666L);
        }
    }

    private void checkPortGroupResMappingDeleting(ResourceMapping resourceMapping) {
        logger.trace((Object)(this.trace + "checkPortGroupResMappingDeleting"));
        List allPg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByType(12, Long.valueOf(1L));
        if (VerifyUtil.isEmpty((Collection)allPg)) {
            return;
        }
        String productResourceId = resourceMapping.getProductResourceId();
        String recoveryResourceId = resourceMapping.getRecoveryResourceId();
        for (ProtectGroup pg : allPg) {
            if (!this.isArrayProtectGroup(pg)) continue;
            for (ProtectObject po : pg.getPolist()) {
                ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
                VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
                List<VmConfigNicType> nics = PgResMappingCheckService.getListNic(vmMgr.getVmConfig());
                this.checkNic(nics, productResourceId, recoveryResourceId);
            }
        }
    }

    private void checkNic(List<VmConfigNicType> nics, String productResourceId, String recoveryResourceId) {
        logger.trace((Object)(this.trace + "checkNic"));
        if (null == nics) {
            return;
        }
        for (VmConfigNicType nic : nics) {
            if (!productResourceId.equals(nic.getPortGroupUrn()) && !recoveryResourceId.equals(nic.getPortGroupUrn())) continue;
            logger.info((Object)("PortGroup's resource mapping is used:" + nic.getName()), 90160758787071L);
            throw new LegoCheckedException(1073947666L);
        }
    }

    private void checkHostOrClustorResMappingDeleting(ResourceMapping resourceMapping) {
        logger.trace((Object)(this.trace + "checkHostOrClustorResMappingDeleting"));
        List allPg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByType(12, Long.valueOf(1L));
        if (VerifyUtil.isEmpty((Collection)allPg)) {
            return;
        }
        String productResourceId = resourceMapping.getProductResourceId();
        String recoveryResourceId = resourceMapping.getRecoveryResourceId();
        for (ProtectGroup pg : allPg) {
            if (!this.isArrayProtectGroup(pg)) continue;
            for (ProtectObject po : pg.getPolist()) {
                this.checkPo(po, productResourceId, recoveryResourceId);
            }
        }
    }

    private boolean isArrayProtectGroup(ProtectGroup protectGroup) {
        logger.trace((Object)(this.trace + "isArrayProtectGroup"));
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        return ProtectTypeEnum.STORAGE_ARRAY.getType().equals(protectType);
    }

    private void checkPo(ProtectObject po, String productResourceId, String recoveryResourceId) {
        logger.trace((Object)(this.trace + "checkPo"));
        ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
        VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
        String location = vmMgr.getLocation();
        if (productResourceId.equals(location) || recoveryResourceId.equals(location)) {
            logger.info((Object)("HostOrClustor's resource mapping is used:" + location), 90160758787071L);
            throw new LegoCheckedException(1073947666L);
        }
    }
}

