/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.protectgroup.maintain;

import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.constant.cloudenum.ObserverManagerEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PgTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.PgAlarmInfo;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IAfterVrmSaveSerice;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MaintainVISPgProcessor
extends BaseService
implements IAfterVrmSaveSerice {
    private static final Log logger = LogFactory.getInstance(MaintainVISPgProcessor.class);

    public boolean process(AbstractContext context) {
        String recType = (String)context.getAttribute("GALAX_RECOVERY_TYPE");
        if (!VerifyUtil.isEmpty((String)recType) && !"GALAX_STORAGE_RECOVERY".equals(recType)) {
            logger.info((Object)"the process is not invoked by GALAX_STORAGE_RECOVERY", 90160758786816L);
            return true;
        }
        VRM vrm = (VRM)context.getAttribute("DRMVRM");
        List<ProtectObject> listVisPo = this.getAllVisPo(vrm);
        if (VerifyUtil.isEmpty(listVisPo)) {
            logger.info((Object)("There is no vis protectObject for vrm " + vrm.getName()), 90160758786816L);
            return true;
        }
        ArrayList<GalaxVM> listNewVms = new ArrayList<GalaxVM>();
        ArrayList<DataStore> listNewDss = new ArrayList<DataStore>();
        this.getVrmMo(vrm, listNewVms, listNewDss);
        ArrayList<ProtectObject> listDelPo = new ArrayList<ProtectObject>();
        HashMap<ProtectObject, GalaxVM> mapUpdatePo = new HashMap<ProtectObject, GalaxVM>();
        this.getDelPoAndUpdatePo(listVisPo, listNewVms, listDelPo, mapUpdatePo);
        List<PgAlarmInfo> listWarningResult = this.getWarningList(context);
        this.processVisPo(mapUpdatePo, listDelPo, listNewDss, listWarningResult);
        this.printVmListLog("vm removed in pg", listDelPo);
        ObserverManager.getInstance((String)ObserverManagerEnum.MAINTION_GROUP_MANAGER.name()).asyncNotifyAllObservers((Object)context);
        return true;
    }

    private void getDelPoAndUpdatePo(List<ProtectObject> listVisPo, List<GalaxVM> listNewVms, List<ProtectObject> listDelPo, Map<ProtectObject, GalaxVM> mapUpdatePo) {
        for (ProtectObject po : listVisPo) {
            GalaxVM galaxVM = null;
            for (GalaxVM vm : listNewVms) {
                if (!vm.getUuid().equals(po.getMoUuid())) continue;
                galaxVM = vm;
                break;
            }
            if (galaxVM == null) {
                listDelPo.add(po);
                continue;
            }
            if (!this.checkVmVolume(galaxVM)) {
                logger.warn((Object)("vm has no disk, vm name is " + galaxVM.getName()), 90160758786816L);
                listDelPo.add(po);
                continue;
            }
            mapUpdatePo.put(po, galaxVM);
        }
    }

    private void getVrmMo(VRM vrm, List<GalaxVM> listNewVms, List<DataStore> listNewDss) {
        for (ManagedObject mo : vrm.getChildMos()) {
            if (mo instanceof GalaxVM) {
                listNewVms.add((GalaxVM)mo);
                continue;
            }
            if (!(mo instanceof DataStore)) continue;
            listNewDss.add((DataStore)mo);
        }
    }

    private void processVisPo(Map<ProtectObject, GalaxVM> mapUpdatePo, List<ProtectObject> listDelPo, List<DataStore> dsList, List<PgAlarmInfo> listWarningResult) {
        HashMap<String, ProtectGroup> pgs = new HashMap<String, ProtectGroup>();
        for (Map.Entry<ProtectObject, GalaxVM> entry : mapUpdatePo.entrySet()) {
            ProtectObject po = entry.getKey();
            GalaxVM vm = entry.getValue();
            ProtectGroup protectGroup = po.getProtectGroup();
            if (!pgs.containsKey(protectGroup.getUuid())) {
                pgs.put(protectGroup.getUuid(), protectGroup);
            }
            this.processPoDs(vm, po, dsList, protectGroup.getPoProviderSN());
        }
        for (Map.Entry<Object, Object> entry : pgs.entrySet()) {
            ProtectGroup pg = (ProtectGroup)entry.getValue();
            PgAlarmInfo pgAlarmInfo = this.getPgAlarmInfoFromList(listWarningResult, pg);
            ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
            for (ProtectObject protectObject : pg.getPolist()) {
                if (listDelPo.contains(protectObject)) continue;
                protectObjects.add(protectObject);
            }
            if (VerifyUtil.isEmpty(protectObjects)) continue;
            if (this.checkPolicyTemplate(protectObjects, pg)) {
                pgAlarmInfo.setType(PgTypeEnum.PG_NORMAL.toString());
                pg.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
                continue;
            }
            pgAlarmInfo.setType(PgTypeEnum.PG_INVILID.toString());
            pg.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
        }
        this.processRemovePoWarning(pgs, listDelPo, listWarningResult);
    }

    private boolean checkPolicyTemplate(List<ProtectObject> protectObjects, ProtectGroup pg) {
        boolean result = false;
        try {
            IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(pg.getTemplate().getType());
            if (filter.isMatch(protectObjects)) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format(Locale.ROOT, "Check Protected group validity failed! cause: PolicyTemplate match fail, pg name:%s,%s", pg.getName(), ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786897L);
        }
        return result;
    }

    private void processRemovePoWarning(Map<String, ProtectGroup> pgs, List<ProtectObject> listDelPo, List<PgAlarmInfo> listWarningResult) {
        for (ProtectObject po : listDelPo) {
            ProtectGroup protectGroup = po.getProtectGroup();
            PgAlarmInfo pgAlarmInfo = this.getPgAlarmInfoFromList(listWarningResult, protectGroup);
            if (PgTypeEnum.PG_INVILID.toString().equals(pgAlarmInfo.getType())) continue;
            pgAlarmInfo.getListDelete().add(po);
            if (pgs.containsKey(protectGroup.getUuid())) {
                protectGroup = pgs.get(protectGroup.getUuid());
                protectGroup.getPolist().remove(po);
                continue;
            }
            protectGroup.getPolist().remove(po);
            pgs.put(protectGroup.getUuid(), protectGroup);
        }
        for (ProtectGroup pg : pgs.values()) {
            ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)pg);
        }
    }

    private void printVmListLog(String title, Collection<ProtectObject> removePo) {
        StringBuilder sb = new StringBuilder();
        sb.append(title).append("[");
        for (ProtectObject po : removePo) {
            sb.append(po.getMoUuid()).append(",");
        }
        sb.append("]");
        logger.info((Object)sb.toString(), 90160758786816L);
    }

    private void processPoDs(GalaxVM galaxVm, ProtectObject po, List<DataStore> dsList, String providerSn) {
        String[] dsUrns;
        po.setName(galaxVm.getName());
        po.setProviderSN(providerSn);
        po.clearUsedStorageResource();
        block0: for (String urn : dsUrns = galaxVm.getDataStoreUrns().split(",")) {
            for (DataStore ds : dsList) {
                if (!urn.equals(ds.getUrn())) continue;
                this.setPoStorage(ds, po);
                continue block0;
            }
        }
    }

    private void setPoStorage(DataStore ds, ProtectObject po) {
        Set wwns = DsgUtil.getDataStoreStorageWwns((DataStore)ds);
        for (String wwn : wwns) {
            ProtectObjectStorageInfo sInfo = this.constructStorageInfo(wwn, ds);
            po.addHostStorageResourceInfo(sInfo);
        }
    }

    private ProtectObjectStorageInfo constructStorageInfo(String wwn, DataStore ds) {
        ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
        if (VerifyUtil.isEmpty((String)info.getId())) {
            info.setId(UUIDGenerator.getUUID());
        }
        info.setLunWWN(wwn);
        info.setResourceId(wwn);
        info.setResourceProviderSN(ds.getUuid());
        info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.VIS.getValue()));
        info.setDeviceName(ds.getName());
        return info;
    }

    private PgAlarmInfo getPgAlarmInfoFromList(List<PgAlarmInfo> listWarningResult, ProtectGroup pg) {
        PgAlarmInfo target = null;
        for (PgAlarmInfo alarmInfo : listWarningResult) {
            if (!alarmInfo.getPg().getUuid().equals(pg.getUuid())) continue;
            target = alarmInfo;
            break;
        }
        if (null == target) {
            target = new PgAlarmInfo();
            target.setType(PgTypeEnum.PG_NORMAL.toString());
            target.setPg(pg);
            listWarningResult.add(target);
        }
        return target;
    }

    private boolean checkVmVolume(GalaxVM vm) {
        VmConfigType vmConfig = (VmConfigType)CommonUtil.json2Bean((String)vm.getVmConfig(), VmConfigType.class);
        for (VmConfigDiskType disk : vmConfig.getDisks()) {
            if (0 == disk.getSequenceNum()) continue;
            return true;
        }
        return false;
    }

    private List<ProtectObject> getAllVisPo(VRM vrm) {
        ArrayList<ProtectObject> visPoList = new ArrayList<ProtectObject>();
        List listPg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByType(12, Long.valueOf(1L));
        for (ProtectGroup pg : listPg) {
            String protectType = (String)pg.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
            if (!ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType().equals(protectType)) continue;
            this.addPo2List(pg, vrm, visPoList);
        }
        return visPoList;
    }

    private void addPo2List(ProtectGroup pg, VRM vrm, List<ProtectObject> poList) {
        for (ProtectObject po : pg.getPolist()) {
            if (!vrm.getSn().equals(po.getProviderSN())) continue;
            poList.add(po);
        }
    }

    private List<PgAlarmInfo> getWarningList(AbstractContext context) {
        ArrayList listWarningResult = (ArrayList)context.getAttribute("maintainExchangedPgs");
        if (null == listWarningResult) {
            listWarningResult = new ArrayList();
            context.setAttribute("maintainExchangedPgs", listWarningResult);
        }
        return listWarningResult;
    }
}

