/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.protectgroup.provider;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.util.concurrent.ThreadPoolConfig;
import com.huawei.ism.drm.base.util.concurrent.ThreadPoolHelper;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.ProtectObjectExtendUtils;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.pg.service.IBaseStoragePgService;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectProvider;
import com.huawei.ism.drm.galax.sdk.pg.service.IProtectObjectStorageInfoService;
import com.huawei.ism.drm.galax.sdk.vrm.model.OsOptionsType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.protection.common.ProtectGroupCommon;
import com.huawei.ism.drm.galax.storage.protection.protectgroup.check.PgResMappingCheckService;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectGroupProxy;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.galax.storage.support.dao.BaseStoragePgDao;
import com.huawei.ism.drm.galax.util.cloud.JudgeHandler;
import com.huawei.ism.drm.galax.util.cloud.VrmJudgeDefine;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.util.ProtectGroupBlockingQueue;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.util.Base64;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupDelegate;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BaseStorageVmProvider
implements IGalaxProtectObjectProvider {
    private static final Log logger = LogFactory.getInstance(BaseStorageVmProvider.class);
    private static final String VM_FILTER_KEY = "threadCount.vm.filter";
    private static final int VM_FILTER_DEFAULT = 16;
    private static final Set<Integer> SMALL_LUN_TEMPLATE_TYPES = ImmutableSet.of((Object)33, (Object)39, (Object)38, (Object)51, (Object)52, (Object)53, (Object[])new Integer[0]);
    private IBaseStoragePgService visController;

    public IBaseStoragePgService getVisController() {
        logger.debug((Object)"getVisController");
        return this.visController;
    }

    public void setVisController(IBaseStoragePgService visController) {
        logger.debug((Object)"setVisController");
        this.visController = visController;
    }

    public List<String> getProtectType() {
        logger.debug((Object)"getProtectType");
        ArrayList<String> notHostProtectType = new ArrayList<String>();
        notHostProtectType.add(ProtectTypeEnum.STORAGE_SNAP_ACTIVE.getType());
        notHostProtectType.add(ProtectTypeEnum.SAN_HYPER_ACTIVE.getType());
        notHostProtectType.add(ProtectTypeEnum.STORAGE_ARRAY.getType());
        notHostProtectType.add(ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType());
        return notHostProtectType;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"ProtectGroup is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        if (!ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType().equals(protectType)) {
            new ProtectGroupCommon().checkIsHostPo(protectGroup);
            String uuid = protectGroup.getTemplate().getUuid();
            PolicyTemplate policyTemplate = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getPtByUuid(uuid);
            int templateType = policyTemplate.getType();
            protectGroup.getTemplate().setType(templateType);
            if (SMALL_LUN_TEMPLATE_TYPES.contains(templateType)) {
                ((IProtectObjectStorageInfoService)ServiceLocator.getInstance().getService(IProtectObjectStorageInfoService.class)).setDataStoreInfoForProtectGroup(protectGroup);
            } else {
                String dsgId = (String)protectGroup.getProps().get(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
                if (VerifyUtil.isEmpty((String)dsgId)) {
                    logger.error((Object)"Parameter dsgId is empty.");
                    throw new LegoCheckedException(1073947393L);
                }
                IDataStoreGroupDelegate groupDelegate = (IDataStoreGroupDelegate)ServiceLocator.getInstance().getService(IDataStoreGroupDelegate.class);
                groupDelegate.checkDataStoreGroup(dsgId, this.protectTypeConvert(protectType), protectGroup);
                groupDelegate.setDataStoreInfoForProtectGroup(this.protectTypeConvert(protectType), dsgId, protectGroup);
            }
        }
        this.fillProtectObjects(protectGroup);
        if (ProtectTypeEnum.STORAGE_ARRAY.getType().equals(protectType)) {
            this.checkPgResMapping(protectGroup);
        }
    }

    public Map<String, List<String>> checkAvailableGalaxVm(List<GalaxVM> vmLit, int templateType) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (ProtectionTypeEnum.FC_HIGH_AVAILABILITY.getValue() == templateType) {
            ThreadPoolConfig config = ThreadPoolHelper.defaultConfig((String)VM_FILTER_KEY, (int)16);
            List<JudgeHandler.JudgeUnit<GalaxVM>> judgeList = this.buildJudgeList(true);
            ThreadPoolHelper.synBatchExecute((ThreadPoolConfig)config, vmLit, gVm -> {
                gVm.setVmConfigType((VmConfigType)CommonUtil.jsonToBean((String)gVm.getVmConfig(), VmConfigType.class));
                JudgeHandler handler = JudgeHandler.build((Object)gVm);
                handler.recordMessage(true);
                if (handler.judge(judgeList)) {
                    result.put(gVm.getUrn(), Collections.emptyList());
                } else {
                    result.put(gVm.getUrn(), handler.failureMessageList(String.class));
                }
            });
        }
        return result;
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition, Map<String, Object> extendResults) {
        int startIndex;
        ProtectGroup pg;
        String protectType = (String)extendCondition.get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        List<GalaxVM> vmList = this.filterGalaxVms(poProviderSn, extendCondition, protectType, pg = (ProtectGroup)extendCondition.get("pg"));
        if (VerifyUtil.isEmpty(vmList)) {
            return Collections.emptyList();
        }
        ArrayList<ProtectObject> poData = new ArrayList<ProtectObject>();
        String vmid = (String)extendCondition.get("vmid");
        if (!VerifyUtil.isEmpty((String)vmid)) {
            for (GalaxVM vm : vmList) {
                String vmId = this.getVmIdByUri(vm.getUri());
                if (!vmid.equals(vmId)) continue;
                ProtectObject po = this.getProtectObjectByVm(vm);
                poData.add(po);
                vmList.clear();
                return poData;
            }
            return Collections.emptyList();
        }
        extendResults.put("totalCount", vmList.size());
        int pageSize = (Integer)extendCondition.get("pageSize");
        int startPage = (Integer)extendCondition.get("pageIndex");
        for (int i = startIndex = startPage * pageSize; i < vmList.size() && i < startIndex + pageSize; ++i) {
            GalaxVM vm = vmList.get(i);
            ProtectObject po = this.getProtectObjectByVm(vm);
            poData.add(po);
        }
        return poData;
    }

    private List<GalaxVM> filterGalaxVms(String poProviderSn, Map<String, Object> extendCondition, String protectType, ProtectGroup pg) {
        List<GalaxVM> vmList;
        int templateType = -1;
        if (!VerifyUtil.isEmpty((Object)pg)) {
            templateType = pg.getTemplate().getType();
        }
        if (ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType().equals(protectType)) {
            vmList = this.visController.getFilterVms(poProviderSn, extendCondition);
            this.filterInvalidVm(vmList);
        } else if ("vm".equalsIgnoreCase((String)extendCondition.get(PgExParamsEnum.PG_PO_PROTECTION_TYPE.getValue())) || templateType == 33 || templateType == 38) {
            extendCondition.put("isTemplateAllow", true);
            vmList = this.visController.getFilterVms(poProviderSn, extendCondition);
            boolean isHyperMetro = ProtectTypeEnum.SAN_HYPER_ACTIVE.getType().equals(protectType) || templateType == 38;
            vmList = this.filterInvalidFcVm(vmList, extendCondition, isHyperMetro);
        } else {
            String dsgUuid = (String)extendCondition.get(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
            vmList = BaseStoragePgDao.getInstance().getGalaxVMsByDsg(dsgUuid);
        }
        return vmList;
    }

    private ProtectObject getProtectObjectByVm(GalaxVM vm) {
        ProtectObject po = new ProtectObject();
        po.setMoUuid(vm.getUuid());
        po.setName(vm.getName());
        po.setPoType(12);
        po.setProtectMo((ManagedObject)vm);
        HashMap<String, String> props = new HashMap<String, String>();
        String vmId = this.getVmIdByUri(vm.getUri());
        props.put(PoExParamsEnum.VM_ID.getValue(), vmId);
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vm.getVmConfig(), VmConfigType.class);
        if (!VerifyUtil.isEmpty((Object)vmConfig) && !VerifyUtil.isEmpty((Object)vmConfig.getProperties())) {
            Integer timeout = vmConfig.getProperties().getBlockIoHangTimeout();
            String strTimeout = timeout == null ? "0" : String.valueOf(timeout);
            props.put(PoExParamsEnum.BLOCK_IO_HANG_TIMEOUT.getValue(), strTimeout);
        }
        po.setProps(props);
        return po;
    }

    private String getVmIdByUri(String uri) {
        return uri.split("vms")[1].replace("/", "");
    }

    public void updateProtectGroup(String pgId) {
        logger.debug((Object)"updateProtectGroup");
    }

    public void fillProtectObjects(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"ProtectGroup is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"ProtectObjects is empty.");
            throw new LegoCheckedException(1073948166L);
        }
        Object[] uuids = this.getVmUuids(protectGroup);
        QueryCondition qc = new QueryCondition("uuid", (Object)uuids, 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vms = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            logger.error((Object)"GalaxVM is empty, uuid: %s.", new Object[]{StringUtil.arrayToString((Object[])uuids)});
            throw new LegoCheckedException(1073948166L);
        }
        if (uuids.length != vms.size()) {
            logger.error((Object)"Some vsphereVirtualMachine is not existed, uuids: %s.", new Object[]{StringUtil.arrayToString((Object[])uuids)});
            throw new LegoCheckedException(1073947394L);
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            ProtectObjectExtendUtils.generateVmBaseInfo((List)vms, (ProtectObject)po, (String)protectGroup.getPoProviderSN());
            if (!VerifyUtil.isEmpty((String)po.getUuid())) continue;
            po.setUuid(UUIDGenerator.getUUID());
        }
        ArrayList poList = new ArrayList();
        poList.addAll(protectGroup.getPolist());
        this.updateProtectObjectProperties(protectGroup);
        ((IProtectObjectStorageInfoService)ServiceLocator.getInstance().getService(IProtectObjectStorageInfoService.class)).loadProtectObjectStorageInfo(poList);
        poList.clear();
    }

    public void updateProtectObjectProperties(ProtectGroup pg) {
        logger.info((Object)"Begin to update pg( %s )'s pos.", new Object[]{pg.getName()});
        ProtectGroupProxy pgProxy = GalaxProxyFactory.createPgProxy(pg);
        pgProxy.updateMgrInfo(true);
        pgProxy.updatePos();
        logger.info((Object)"Finished to update pg( %s )'s pos.", new Object[]{pg.getName()});
    }

    private String[] getVmUuids(ProtectGroup protectGroup) {
        String[] uuids = new String[protectGroup.getPolist().size()];
        int index = 0;
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)"Uuid is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        return uuids;
    }

    private void checkPgResMapping(ProtectGroup protectGroup) {
        logger.debug((Object)"checkPgResMapping");
        ArrayList<VmMgrInfo> vmMgrInfoList = new ArrayList<VmMgrInfo>();
        for (ProtectObject po : protectGroup.getPolist()) {
            ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
            VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
            vmMgrInfoList.add(vmMgr);
        }
        new PgResMappingCheckService().checkPgResMapping(protectGroup, vmMgrInfoList, protectGroup.getPoProviderSN());
    }

    private void filterInvalidVm(List<GalaxVM> galvmList) {
        logger.debug((Object)"filterInvalidVm");
        Iterator<GalaxVM> iterator = galvmList.iterator();
        ArrayList<JudgeHandler.JudgeUnit> judgeList = new ArrayList<JudgeHandler.JudgeUnit>();
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NIC, (boolean)true));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NON_PERSISTENT_DISK, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VRM, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_LOCAL_HOST_VM, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit(this::isVmDSTypeSupport, (boolean)true));
        while (iterator.hasNext()) {
            GalaxVM gVm = iterator.next();
            gVm.setVmConfigType((VmConfigType)CommonUtil.jsonToBean((String)gVm.getVmConfig(), VmConfigType.class));
            if (JudgeHandler.build((Object)gVm).judge(judgeList)) continue;
            iterator.remove();
        }
    }

    private boolean isVmDSTypeSupport(GalaxVM galaxVM) {
        HashSet<String> vmUuids = new HashSet<String>();
        vmUuids.add(galaxVM.getUuid());
        List<DataStore> dsList = BaseStoragePgDao.getInstance().getDataStoresByVmUuids(vmUuids);
        if (VerifyUtil.isEmpty(dsList)) {
            return false;
        }
        for (DataStore ds : dsList) {
            if (VrmUtil.isDataStoreTypeSupport((String)ds.getStorageType())) continue;
            return false;
        }
        return true;
    }

    private List<GalaxVM> filterInvalidFcVm(List<GalaxVM> galvmList, Map<String, Object> extendCondition, boolean isHyperMetro) {
        logger.debug((Object)"Filter invalid fc vm.");
        HashSet availableUuids = new HashSet();
        HashSet unavailableUuids = new HashSet();
        LinkedList queue = new LinkedList(ProtectGroupBlockingQueue.getQueue());
        BlockingQueue excuteQueue = ProtectGroupBlockingQueue.getExcutingQueue();
        queue.addAll(excuteQueue);
        HashSet vmMouuids = new HashSet();
        queue.forEach(pg -> pg.getPolist().forEach(po -> vmMouuids.add(po.getMoUuid())));
        Map<String, String> urnSnMap = this.queryDatastoreUrnSnMap(galvmList);
        ThreadPoolConfig config = ThreadPoolHelper.defaultConfig((String)VM_FILTER_KEY, (int)16);
        List<JudgeHandler.JudgeUnit<GalaxVM>> judgeList = this.buildJudgeList(isHyperMetro);
        String selectedDevSn = this.getDevSnCondition(extendCondition);
        ThreadPoolHelper.synBatchExecute((ThreadPoolConfig)config, galvmList, gVm -> {
            gVm.setVmConfigType((VmConfigType)CommonUtil.jsonToBean((String)gVm.getVmConfig(), VmConfigType.class));
            if (JudgeHandler.build((Object)gVm).judge(judgeList) && this.checkVmDatastore((GalaxVM)gVm, urnSnMap, selectedDevSn) && !vmMouuids.contains(gVm.getUuid())) {
                availableUuids.add(gVm.getUuid());
            } else {
                unavailableUuids.add(gVm.getUuid());
            }
        });
        unavailableUuids.addAll(VrmUtil.vmExistRollBackTask(availableUuids));
        return galvmList.stream().filter(vm -> !unavailableUuids.contains(vm.getUuid())).sorted((o1, o2) -> o1.getName().compareTo(o2.toString())).collect(Collectors.toList());
    }

    private String getDevSnCondition(Map<String, Object> extendCondition) {
        Object objSn = extendCondition.get("storageDevSn");
        if (VerifyUtil.isEmpty((Object)objSn)) {
            logger.info((Object)"The devSn fromm extend condition is empty.");
            return "";
        }
        if (objSn instanceof String) {
            return new String(Base64.base64ToByteArray((String)((String)objSn)), StandardCharsets.UTF_8);
        }
        throw new LegoCheckedException(1073947393L, "StorageDevSn is invalid.");
    }

    private boolean checkVmDatastore(GalaxVM vm, Map<String, String> urnSnMap, String devSnCondition) {
        String dataStoreUrns = vm.getDataStoreUrns();
        String vmName = vm.getName();
        if (VerifyUtil.isEmpty((String)dataStoreUrns)) {
            logger.warn((Object)"The virtual machine does not have any datastore, vm's name: %s.", new Object[]{vmName});
            return false;
        }
        HashSet<String> tmpDevSnSet = new HashSet<String>();
        for (String urn : dataStoreUrns.split(",")) {
            String devSn = urnSnMap.get(urn);
            if (VerifyUtil.isEmpty((String)devSn)) {
                logger.warn((Object)"The virtual machine's disks are not all managed by UltraVR, vm's name: %s.", new Object[]{vmName});
                return false;
            }
            if (!VerifyUtil.isEmpty((String)devSnCondition) && !devSn.equals(devSnCondition)) {
                logger.warn((Object)"The virtual machine's disks do not belong to the specified device, vm's name: %s.", new Object[]{vmName});
                return false;
            }
            tmpDevSnSet.add(devSn);
            if (tmpDevSnSet.size() <= 1) continue;
            logger.warn((Object)"The virtual machine's disks do not belong to the same device, vm's name: %s.", new Object[]{vmName});
            return false;
        }
        return true;
    }

    private Map<String, String> queryDatastoreUrnSnMap(List<GalaxVM> vmList) {
        if (VerifyUtil.isEmpty(vmList)) {
            return Collections.emptyMap();
        }
        Set<String> vmUuids = vmList.stream().map(ManagedObject::getUuid).collect(Collectors.toSet());
        List<DataStore> dataStoreList = BaseStoragePgDao.getInstance().getDataStoresByVmUuids(vmUuids);
        return dataStoreList.stream().filter(dataStore -> !VerifyUtil.isEmpty((String)dataStore.getDevSn())).collect(Collectors.toMap(GalaxObject::getUrn, DataStore::getDevSn));
    }

    private List<JudgeHandler.JudgeUnit<GalaxVM>> buildJudgeList(boolean isHyperMetro) {
        ArrayList<JudgeHandler.JudgeUnit<GalaxVM>> judgeList = new ArrayList<JudgeHandler.JudgeUnit<GalaxVM>>();
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NIC, (boolean)true, (Object)"lego.err.1073949770"));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NON_PERSISTENT_DISK, (boolean)false, (Object)"lego.err.1073949771"));
        if (isHyperMetro) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_SMALL_LUN_DISK_TYPE, (boolean)true, (Object)"lego.err.1073949772"));
        } else {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_FS_DISK_TYPE, (boolean)true, (Object)"lego.err.1073949773"));
        }
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_LINK_CLONE, (boolean)false, (Object)"lego.err.1073949774"));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VRM, (boolean)false, (Object)"lego.err.1073949775"));
        if (!isHyperMetro) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_LOCAL_HOST_VM, (boolean)false, (Object)"lego.err.1073949776"));
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_GPU_GROUP, (boolean)false, (Object)"lego.err.1073949777"));
        }
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PASS_THROUGH_GPU, (boolean)false, (Object)"lego.err.1073949778"));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_USB, (boolean)false, (Object)"lego.err.1073949779"));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PCIS, (boolean)false, (Object)"lego.err.1073949780"));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_DR_SUPPORT, (boolean)true, (Object)"lego.err.1073949781"));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NOF, (boolean)false, (Object)"lego.err.1073949782"));
        if (isHyperMetro) {
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.HAS_SHARE_VOLUME, (boolean)false, (Object)"lego.err.1073949783"));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.HAS_SNAPSHOTS, (boolean)false, (Object)"lego.err.1073949784"));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_SCSI, (boolean)false, (Object)"lego.err.1073949785"));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_IDE, (boolean)false, (Object)"lego.err.1073949786"));
            judgeList.add((JudgeHandler.JudgeUnit<GalaxVM>)JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_SECURITY_VM, (boolean)false, (Object)"lego.err.1073949787"));
        }
        return judgeList;
    }

    private boolean isBelongToStorage(String ipAddress, GalaxVM gVm) {
        VmConfigType vmConfig = VrmUtil.getVmConfigType((GalaxVM)gVm);
        if (VerifyUtil.isEmpty((Object)vmConfig)) {
            return false;
        }
        List diskInfos = vmConfig.getDisks();
        if (VerifyUtil.isEmpty((Collection)diskInfos)) {
            return false;
        }
        Map drExtParamMap = (Map)JSONObject.toBean((String)((VmConfigDiskType)diskInfos.get(0)).getDrExtParams(), Map.class);
        if (VerifyUtil.isEmpty((Map)drExtParamMap) || VerifyUtil.isEmpty((String)((String)drExtParamMap.get("dsMgntIp")))) {
            return false;
        }
        return ((String)drExtParamMap.get("dsMgntIp")).equals(ipAddress);
    }

    private int protectTypeConvert(String protectType) {
        logger.debug((Object)"protectTypeConvert");
        int protectTypeInteger = 0;
        if (protectType.equals(ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType())) {
            protectTypeInteger = ProtectionTypeEnum.VIS_HIGHAVAILABILITY.getValue();
        }
        if (protectType.equals(ProtectTypeEnum.STORAGE_SNAP_ACTIVE.getType())) {
            protectTypeInteger = ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue();
        }
        if (protectType.equals(ProtectTypeEnum.STORAGE_ARRAY.getType())) {
            protectTypeInteger = ProtectionTypeEnum.STORAGE_REPLICATION.getValue();
        }
        if (protectType.equals(ProtectTypeEnum.SAN_HYPER_ACTIVE.getType())) {
            protectTypeInteger = ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue();
        }
        return protectTypeInteger;
    }

    public void encryptProperties(ProtectGroup protectGroup) {
        for (ProtectObject po : protectGroup.getPolist()) {
            ProtectObjectProxy poProxy = new ProtectObjectProxy(po);
            VmMgrInfo vmMgrInfo = poProxy.getPoMgrInfo();
            if (!GalaxVM.VMProviderType.FC.getValue().equals(vmMgrInfo.getVmType())) continue;
            OsOptionsType osOptions = (OsOptionsType)CommonUtil.jsonToBean((String)vmMgrInfo.getOsOption(), OsOptionsType.class);
            if (osOptions != null && !VerifyUtil.isEmpty((String)osOptions.getPassword())) {
                osOptions.setPassword(WccEncryptor.encrypt((String)osOptions.getPassword()));
                String osOptionEncode = CommonUtil.beanToJson((Object)osOptions);
                vmMgrInfo.setOsOption(osOptionEncode);
            }
            poProxy.updateMgrinfo(vmMgrInfo);
        }
    }

    public void decryptPropreties(ProtectGroup protectGroup) {
        for (ProtectObject po : protectGroup.getPolist()) {
            ProtectObjectProxy poProxy = new ProtectObjectProxy(po);
            VmMgrInfo vmMgrInfo = poProxy.getPoMgrInfo();
            if (!GalaxVM.VMProviderType.FC.getValue().equals(vmMgrInfo.getVmType())) continue;
            OsOptionsType osOptions = (OsOptionsType)CommonUtil.jsonToBean((String)vmMgrInfo.getOsOption(), OsOptionsType.class);
            if (osOptions != null && !VerifyUtil.isEmpty((String)osOptions.getPassword())) {
                osOptions.setPassword(WccEncryptor.decrypt((String)osOptions.getPassword()));
                String osOptionDecode = CommonUtil.beanToJson((Object)osOptions);
                vmMgrInfo.setOsOption(osOptionDecode);
            }
            poProxy.updateMgrinfo(vmMgrInfo);
        }
    }
}

