/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.protectgroup.service;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.ProtectObjectExtendUtils;
import com.huawei.ism.drm.galax.resource.topology.GalaxVirtualMachineTopoBuilder;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.pg.service.IProtectObjectStorageInfoService;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.manager.CloudPlatformServiceManager;
import com.huawei.ism.drm.galax.storage.protection.common.ProtectGroupCommon;
import com.huawei.ism.drm.galax.storage.protection.protectgroup.check.PgResMappingCheckService;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectGroupProxy;
import com.huawei.ism.drm.galax.storage.support.dao.BaseStoragePgDao;
import com.huawei.ism.drm.galax.util.alarm.AlarmGenerator;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.cloud.JudgeHandler;
import com.huawei.ism.drm.galax.util.cloud.VrmJudgeDefine;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupService;
import com.huawei.ism.drm.virtualization.sdk.service.IVirtualMachineManager;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.service.impl.VirtualizationServiceHelper;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GalaxVirtualMachineManager
implements IVirtualMachineManager {
    private Log logger = LogFactory.getInstance(GalaxVirtualMachineManager.class);
    private String debug = "debug";

    public Set<String> getUnsupportedVm(Set<String> vmUuidSet, int protectType) {
        this.logger.info((Object)"GetUnsupportedVm enter.");
        if (VerifyUtil.isEmpty(vmUuidSet)) {
            this.logger.error((Object)"Parameter vmUuidSet is null or empty.");
            return Collections.emptySet();
        }
        ArrayList<JudgeHandler.JudgeUnit> judgeList = new ArrayList<JudgeHandler.JudgeUnit>();
        judgeList.add(JudgeHandler.JudgeUnit.unit(galaxVM -> VerifyUtil.isEmpty((Collection)VrmUtil.getVmConfig((GalaxVM)galaxVM)), (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NIC, (boolean)true));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_USB, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NON_PERSISTENT_DISK, (boolean)false));
        if (protectType != ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue()) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_GPU_GROUP, (boolean)false));
        }
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PASS_THROUGH_GPU, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PCIS, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_DR_SUPPORT, (boolean)true));
        if (protectType == ProtectionTypeEnum.STORAGE_REPLICATION.getValue() || protectType == ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue()) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_LINK_CLONE, (boolean)false));
        }
        List<GalaxVM> galaxVms = this.getGalaxVMsByUuid(vmUuidSet);
        return galaxVms.stream().filter(galaxVM -> {
            galaxVM.setVmConfigType((VmConfigType)CommonUtil.jsonToBean((String)galaxVM.getVmConfig(), VmConfigType.class));
            return !JudgeHandler.build((Object)galaxVM).judge(judgeList);
        }).map(ManagedObject::getUuid).collect(Collectors.toSet());
    }

    public Set<String> getSpecialInvalidVm(Set<String> vmUuidSet, int templateType) {
        this.logger.trace((Object)(this.debug + "getSpecialInvalidVm enter."));
        return new HashSet<String>();
    }

    private List<ResourcepoolVMServiceV2Stub.VMInfo0> getFmInfo0s(GalaxVM gVm, List<String> listVmUrns) {
        this.logger.trace((Object)(this.debug + "getFmInfo0s enter."));
        if (VerifyUtil.isEmpty(listVmUrns)) {
            return null;
        }
        IFmService fmService = (IFmService)ServiceLocator.getInstance().getService(IFmService.class);
        Hypervisor hyperV = fmService.getHypervisorByVrm(gVm.getTopMoUuid());
        if (null == hyperV) {
            this.logger.warn((Object)("FusionManager is not discovery, vmUuid=" + gVm.getUuid()), 90160758787071L);
            return null;
        }
        FmObject fmInfo = FmUtils.generateFmObj((String)hyperV.getTopMoUuid());
        String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
        IFMInfosRetriever fmRetriever = CloudPlatformServiceManager.getInstance().getFmRetriever();
        try {
            return fmRetriever.queryVMs(fmInfo, hypervisorId, listVmUrns);
        }
        catch (FmBusinessException e) {
            this.logger.error((Object)"Failed to query vms from fusionmanager.", (Throwable)e, 90160758787071L);
            return null;
        }
    }

    public Set<String> getInvalidVm(Set<String> vmUuidSet, Set<String> dsUuidSet, int templateType) {
        this.logger.trace((Object)(this.debug + "getInvalidVm enter."));
        if (2 != templateType && 19 != templateType) {
            return new HashSet<String>();
        }
        if (VerifyUtil.isEmpty(vmUuidSet)) {
            this.logger.error((Object)"parameter vmUuidSet is null or empty.", 90160758787071L);
            return vmUuidSet;
        }
        if (VerifyUtil.isEmpty(dsUuidSet)) {
            return vmUuidSet;
        }
        List<GalaxVM> vmList = this.getGalaxVMsByUuid(vmUuidSet);
        HashSet<String> uuidSet = new HashSet<String>();
        for (GalaxVM gVm : vmList) {
            String urns = gVm.getDataStoreUrns();
            Set dsUrns = CommonUtil.stringArray2Set((String)urns, (String)",");
            if (!dsUuidSet.containsAll(dsUrns)) {
                uuidSet.add(gVm.getUuid());
                continue;
            }
            if (19 != templateType || !VrmUtil.isVmLinkClone((GalaxVM)gVm)) continue;
            uuidSet.add(gVm.getUuid());
        }
        return uuidSet;
    }

    public void updateProtectObjectInfo(ProtectGroup protectGroup, Set<String> invalidVms, Set<String> unsupportedVms) {
        this.logger.trace((Object)(this.debug + "updateProtectObjectInfo enter."));
        new ProtectGroupCommon().checkIsHostPo(protectGroup);
        HashSet<String> vmUuids = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                this.logger.error((Object)"uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            vmUuids.add(po.getMoUuid());
        }
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        List<GalaxVM> vms = this.getGalaxVMsByUuid(new HashSet<String>(vmUuids));
        for (ProtectObject po : protectGroup.getPolist()) {
            if (ProtectTypeEnum.STORAGE_ARRAY.getType().equals(protectType)) {
                this.updatePoInfoForArrayRep(vms, po, protectGroup);
            } else {
                this.updatePoInfoForArraySnap(vms, po, protectGroup);
            }
            if (VerifyUtil.isEmpty((String)po.getUuid())) {
                po.setUuid(UUIDGenerator.getUUID());
            }
            if (!VerifyUtil.isEmpty(invalidVms) && invalidVms.contains(po.getMoUuid())) {
                po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
                continue;
            }
            if (!VerifyUtil.isEmpty(unsupportedVms) && unsupportedVms.contains(po.getMoUuid())) {
                po.setPoStatus(ProtectObjectStatusEnum.UNSUPPORTED.getValue());
                continue;
            }
            po.setPoStatus(ProtectObjectStatusEnum.VALID.getValue());
        }
        this.updatePgs(protectGroup, !ProtectTypeEnum.STORAGE_ARRAY.getType().equals(protectType));
    }

    private void updatePgs(ProtectGroup pg, boolean useLocal) {
        this.logger.trace((Object)(this.debug + "updatePgs enter."));
        ProtectGroupProxy pgProxy = GalaxProxyFactory.createPgProxy(pg);
        pgProxy.updateMgrInfo(useLocal);
        pgProxy.updatePos();
        if (useLocal) {
            pgProxy.syncPgInfo(pg.getProductSiteId());
        }
    }

    private void updatePoInfoForArrayRep(List<GalaxVM> vms, ProtectObject po, ProtectGroup pg) {
        this.logger.trace((Object)(this.debug + "updatePoInfoForArrayRep enter."));
        boolean vmNotExisted = true;
        for (GalaxVM vm : vms) {
            if (!vm.getUuid().equals(po.getMoUuid())) continue;
            vmNotExisted = false;
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setProtectMo((ManagedObject)new GalaxVM());
            po.setPoType(12);
            po.setProviderSN(pg.getPoProviderSN());
            po.setProtectGroup(pg);
        }
        if (vmNotExisted) {
            this.logger.error((Object)"vm is not existed.");
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void updatePoInfoForArraySnap(List<GalaxVM> vms, ProtectObject po, ProtectGroup pg) {
        this.logger.trace((Object)(this.debug + "updatePoInfoForArraySnap enter."));
        ProtectObjectExtendUtils.generateVmBaseInfo(vms, (ProtectObject)po, (String)pg.getPoProviderSN());
    }

    public void updateProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        this.logger.trace((Object)(this.debug + "updateProtectObjectStorageInfo enter."));
        ((IProtectObjectStorageInfoService)ServiceLocator.getInstance().getService(IProtectObjectStorageInfoService.class)).loadProtectObjectStorageInfo(protectObjectList);
    }

    public List<Map<String, Object>> getStorageResourceByVms(Set<String> vmUuidSet) {
        this.logger.trace((Object)(this.debug + "getStorageResourceByVms enter."));
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        if (VerifyUtil.isEmpty(vmUuidSet)) {
            this.logger.error((Object)"parameter error.", 90160758787071L);
            return retList;
        }
        List<DataStore> dsList = BaseStoragePgDao.getInstance().getDataStoresByVmUuids(vmUuidSet);
        if (VerifyUtil.isEmpty(dsList)) {
            this.logger.error((Object)("can not find the datastore, vmUuidSet=" + vmUuidSet), 90160758787071L);
            return retList;
        }
        for (DataStore ds : dsList) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("virtualStorageName", ds.getName());
            ArrayList lunJsonList = new ArrayList();
            List luns = DsgUtil.getLunsByDs((DataStore)ds, (boolean)false);
            if (VerifyUtil.isEmpty((Collection)luns)) {
                luns = DsgUtil.getVolumeLunsByDs((DataStore)ds, (boolean)false);
            }
            if (!VerifyUtil.isEmpty((Collection)luns)) {
                for (Lun lun : luns) {
                    HashMap<String, String> lunMap = new HashMap<String, String>();
                    lunMap.put("name", lun.getName());
                    lunMap.put("wwn", lun.getWwn());
                    lunMap.put("storageDeviceName", lun.getParentMo().getParentMo().getName());
                    lunJsonList.add(lunMap);
                }
            }
            jsonMap.put("storageResource", lunJsonList);
            retList.add(jsonMap);
        }
        return retList;
    }

    public Page getVirtualMachineByVmUuid(Set<String> vmUuidSet, String orderBy, int pageNo, int pageSize, boolean isAsc) {
        Page page;
        this.logger.trace((Object)(this.debug + "getVirtualMachineByVmUuid enter."));
        try {
            StringBuilder hql = new StringBuilder("from GalaxVM where uuid in (");
            int length = vmUuidSet.size();
            Object[] params = new Object[length];
            int i = 0;
            for (String vmUuid : vmUuidSet) {
                params[i] = vmUuid;
                hql.append("?");
                if (i == length - 1) continue;
                hql.append(',');
                ++i;
            }
            hql.append(")");
            if (orderBy != null && orderBy.matches("\\w+")) {
                hql.append(" order by ").append(orderBy).append(isAsc ? " asc" : " desc");
            }
            page = CommonDAOLocator.getBaseDao().pagedQuery(hql.toString(), pageNo, pageSize, params);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"pageQueryRessources Exception.", (Throwable)e, 90160758787071L);
            throw e;
        }
        if (null == page) {
            return new Page();
        }
        List galaxVMs = page.getResult();
        List vmMachines = VrmUtil.convertGalaxVm((List)galaxVMs);
        page.setResult(vmMachines);
        return page;
    }

    public boolean isVirtualMachineInSamePlatform(VirtualDataStoreGroup dsg) {
        this.logger.trace((Object)(this.debug + "isVirtualMachineInSamePlatform enter."));
        if (null == dsg || VerifyUtil.isEmpty((Collection)dsg.getVmUuidSet())) {
            return true;
        }
        List<GalaxVM> vmList = this.getGalaxVMsByUuid(dsg.getVmUuidSet());
        if (VerifyUtil.isEmpty(vmList)) {
            this.logger.error((Object)("can not find the vms, uuids=" + dsg.getVmUuidSet()), 90160758787071L);
            return true;
        }
        String providerID = null;
        for (GalaxVM vm : vmList) {
            if (VerifyUtil.isEmpty(providerID)) {
                dsg.setVmProviderType(vm.getProviderID());
                providerID = vm.getProviderID();
                continue;
            }
            if (providerID.equalsIgnoreCase(vm.getProviderID())) continue;
            this.logger.error((Object)("there has vm in different platform, vmUuids=" + dsg.getVmUuidSet()), 90160758787071L);
            return false;
        }
        return true;
    }

    public int getAppType() {
        this.logger.trace((Object)(this.debug + "getAppType enter."));
        return 12;
    }

    private boolean checkResMapping(ProtectGroup protectGroup, GalaxVM gVm, ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo0) {
        String priderSn;
        this.logger.trace((Object)(this.debug + "checkResMapping enter."));
        ArrayList<VmMgrInfo> vmMgrInfoList = new ArrayList<VmMgrInfo>();
        if (GalaxVM.VMProviderType.FC == gVm.getVMProviderType()) {
            VmMgrInfo vmMgrInfo = new VmMgrInfo(gVm);
            vmMgrInfoList.add(vmMgrInfo);
            priderSn = gVm.getTopMoUuid();
        } else {
            IFmService fmService = (IFmService)ServiceLocator.getInstance().getService(IFmService.class);
            Hypervisor hyperV = fmService.getHypervisorByVrm(gVm.getTopMoUuid());
            if (null == hyperV) {
                this.logger.warn((Object)("FusionManager is not discovery, vmUuid=" + gVm.getUuid()), 90160758787071L);
                return false;
            }
            if (null == vmInfo0) {
                this.logger.warn((Object)("can not find the FM vm, vmName=" + gVm.getName()), 90160758787071L);
                return false;
            }
            VmMgrInfo vmMgrInfo = new VmMgrInfo(gVm, vmInfo0);
            vmMgrInfoList.add(vmMgrInfo);
            priderSn = hyperV.getTopMoUuid();
        }
        try {
            new PgResMappingCheckService().checkPgResMapping(protectGroup, vmMgrInfoList, priderSn);
            return true;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"check resource mapping failed.", (Throwable)e, 90160758787071L);
            return false;
        }
    }

    private ResourcepoolVMServiceV2Stub.VMInfo0 getVmInfoByVm(List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos, GalaxVM vm) {
        this.logger.trace((Object)(this.debug + "getVmInfoByVm enter."));
        if (VerifyUtil.isEmpty(vmInfos)) {
            return null;
        }
        for (ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo : vmInfos) {
            if (!vmInfo.getVVMURN().equals(vm.getUrn())) continue;
            return vmInfo;
        }
        return null;
    }

    private List<GalaxVM> getGalaxVMsByUuid(Set<String> vmUuidSet) {
        this.logger.trace((Object)(this.debug + "getGalaxVMsByUuid enter."));
        QueryCondition qc = new QueryCondition("uuid", (Object)vmUuidSet.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vmList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            this.logger.error((Object)("there is no vm in those uuids, vmUuidSet=" + vmUuidSet), 90160758787071L);
            return new ArrayList<GalaxVM>();
        }
        return vmList;
    }

    public boolean checkDsgProviderSn(String pgProviderSn, String dsgProviderSn) {
        this.logger.trace((Object)(this.debug + "checkDsgProviderSn enter."));
        if (null == pgProviderSn || null == dsgProviderSn) {
            throw new LegoCheckedException(1073947393L);
        }
        if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(pgProviderSn)) {
            return pgProviderSn.equals(dsgProviderSn);
        }
        List vrms = ((IFmService)ServiceLocator.getInstance().getService(IFmService.class)).getRegistedFcOfSpecfiedFm(pgProviderSn);
        if (VerifyUtil.isEmpty((Collection)vrms)) {
            this.logger.error((Object)("there is no FusionCompute under FusionManager, sn=" + pgProviderSn), 90160758787071L);
            return false;
        }
        for (VRM vrm : vrms) {
            if (!dsgProviderSn.equals(vrm.getSn())) continue;
            return true;
        }
        return false;
    }

    public List<ProtectGroup> getAllProtectGroupByProviderSn(String providerSn) {
        this.logger.trace((Object)(this.debug + "getAllProtectGroupByProviderSn enter."));
        return this.filterPgsForVrm(new HashSet<ProtectGroup>(((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByType(12, Long.valueOf(1L))), providerSn);
    }

    public void handleVmAlarm(String pgId, VirtualDataStoreGroup dsg) {
        this.logger.trace((Object)(this.debug + "handleVmAlarm enter."));
        ProtectGroup pg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByID(pgId, false);
        if (null == pg) {
            return;
        }
        this.dealHasDifferentTypeVMAlarm(dsg, pg);
        this.dealVMNotMappingAlarm(pg);
    }

    public void sendVmDeleteAlarm(ProtectGroup protectGroup, Set<ProtectObject> poToBeDeleted) {
        AlarmGenerator.sendProtectObjectRemoveAlarm((String)protectGroup.getUuid(), (String)protectGroup.getName(), poToBeDeleted);
    }

    private void dealVMNotMappingAlarm(ProtectGroup pg) {
        GalaxVM galaxVM2;
        if (!(VirtualizationServiceHelper.getInstance().isArrayReplication(pg.getTemplate().getType()) || VirtualizationServiceHelper.getInstance().is3DCReplication(pg.getTemplate().getType()) || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType()))) {
            return;
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (ProtectObject po : pg.getPolist()) {
            vmUuidSet.add(po.getMoUuid());
        }
        List<GalaxVM> gVms = this.getGalaxVMsByUuid(vmUuidSet);
        ArrayList<String> listVmUrns = new ArrayList<String>();
        for (GalaxVM galaxVM2 : gVms) {
            listVmUrns.add(galaxVM2.getUrn());
        }
        List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = null;
        if (!VerifyUtil.isEmpty(gVms) && GalaxVM.VMProviderType.FM == (galaxVM2 = gVms.get(0)).getVMProviderType()) {
            vmInfos = this.getFmInfo0s(galaxVM2, listVmUrns);
        }
        for (GalaxVM galaxVM3 : gVms) {
            if (!this.checkResMapping(pg, galaxVM3, this.getVmInfoByVm(vmInfos, galaxVM3))) {
                AlarmGenerator.generateVMNotMappingAlarm((String)galaxVM3.getUuid(), (String)galaxVM3.getName(), (String)pg.getUuid());
                continue;
            }
            AlarmGenerator.restoreVMNotMappingAlarm((String)galaxVM3.getUuid());
        }
    }

    private void dealHasDifferentTypeVMAlarm(VirtualDataStoreGroup dsg, ProtectGroup pg) {
        boolean isSamePlat = dsg.getIsSamePlatform();
        String dsUuids = dsg.getDataStoreUuids();
        if (!VerifyUtil.isEmpty((String)dsUuids)) {
            String[] dsgArray = dsUuids.split(";");
            List dsGroups = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getDataStoreGroupByIds(dsgArray, dsg.getGroupType().intValue());
            if (!VerifyUtil.isEmpty((Collection)dsGroups)) {
                isSamePlat = this.isALlDsgInSamePlat(dsGroups);
            }
        }
        if (isSamePlat) {
            AlarmGenerator.restorePGHasDifferentTypeVMAlarm((String)pg.getUuid());
        } else {
            AlarmGenerator.generatePGHasDifferentTypeVMAlarm((String)pg.getUuid(), (String)pg.getName());
        }
    }

    private List<ProtectGroup> filterPgsForVrm(Set<ProtectGroup> listPg, String vrmSn) {
        this.logger.trace((Object)(this.debug + "filterPgsForVrm enter."));
        ArrayList<ProtectGroup> listResultPgs = new ArrayList<ProtectGroup>();
        ProtectGroupCommon common = new ProtectGroupCommon();
        for (ProtectGroup pg : listPg) {
            String productSiteId = pg.getProductSiteId();
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(productSiteId);
            if (VerifyUtil.isEmpty((Object)site) || 1 == site.getSiteType()) {
                this.logger.error((Object)("find no site or site type is remote, siteId is:" + productSiteId), 90160758787071L);
                continue;
            }
            if (GalaxVirtualMachineTopoBuilder.getOpenstackTemplateTypeList().contains(pg.getTemplate().getType())) {
                listResultPgs.add(pg);
                continue;
            }
            if (!common.isStorageProtectGroup(pg) || !GalaxProxyFactory.createPgProxy(pg).isBelongToVrm(vrmSn)) continue;
            listResultPgs.add(pg);
        }
        return listResultPgs;
    }

    private boolean isALlDsgInSamePlat(List<VirtualDataStoreGroup> dsgs) {
        this.logger.trace((Object)(this.debug + "isALlDsgInSamePlat enter."));
        boolean isSamePlat = true;
        for (VirtualDataStoreGroup dsg : dsgs) {
            if (dsg.getIsSamePlatform().booleanValue()) continue;
            isSamePlat = false;
            break;
        }
        return isSamePlat;
    }
}

