/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.protectgroup.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class InitProtectGroupDsgService {
    private static final Log logger = LogFactory.getInstance(InitProtectGroupDsgService.class);

    public void initiliazeData() {
        try {
            List<ProtectGroup> protectGroups = this.getFsProtectgroups();
            if (VerifyUtil.isEmpty(protectGroups)) {
                return;
            }
            this.updateProtectGroups(protectGroups);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Query protect group failed.", (Throwable)e, 90160758786894L);
        }
        catch (Exception e) {
            logger.error((Object)("Query protect group failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786894L);
        }
    }

    private List<ProtectGroup> getFsProtectgroups() {
        List<?> pgDatas = this.queryProtectGroupFromDB();
        List<ProtectGroup> protectGroups = this.castDataToProtectgroup(pgDatas);
        if (VerifyUtil.isEmpty(protectGroups)) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (ProtectGroup pg : protectGroups) {
            ids.add(pg.getUuid());
        }
        Map<String, Map<String, String>> pgProps = this.getProtectGroupProps(ids);
        if (VerifyUtil.isEmpty(pgProps)) {
            logger.error((Object)"Query protect group result is empty.", 90160758786894L);
            return null;
        }
        for (ProtectGroup pg : protectGroups) {
            pg.setProps(pgProps.get(pg.getUuid()));
        }
        return protectGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> queryProtectGroupFromDB() {
        List list;
        String selectPg = "select PGID, POTYPE, PGPROVIDERSN from ti_protectgroup where poType = ?";
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery sqlQuery = session.createSQLQuery(selectPg);
            sqlQuery.setInteger(0, 12);
            list = sqlQuery.list();
        }
        catch (Exception e) {
            List<?> list2;
            try {
                logger.error((Object)("query  pg basic information failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                list2 = null;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return list2;
        }
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    private List<ProtectGroup> castDataToProtectgroup(List<?> pgDatas) {
        if (VerifyUtil.isEmpty(pgDatas)) {
            return null;
        }
        ArrayList<ProtectGroup> protectGroups = new ArrayList<ProtectGroup>();
        for (Object pgData : pgDatas) {
            Object[] item = (Object[])pgData;
            if (item.length < 3) continue;
            ProtectGroup pg = new ProtectGroup();
            pg.setUuid((String)item[0]);
            pg.setPoType(NumberUtil.convertToInteger((Object)item[1]).intValue());
            pg.setPoProviderSN((String)item[2]);
            protectGroups.add(pg);
        }
        return protectGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> getProtectGroupProps(List<String> ids) {
        Map<String, Map<String, String>> map;
        Session session = null;
        try {
            Map<String, Map<String, String>> map2;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String pgSql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID in(:ids)";
            NativeQuery sqlQuery = session.createSQLQuery(pgSql);
            sqlQuery.setParameterList("ids", ids);
            List props = sqlQuery.list();
            map = map2 = this.groupPgPropItems(props);
        }
        catch (Exception e) {
            Map<String, Map<String, String>> map3;
            try {
                logger.error((Object)("Query infomation for ProtectGroup failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786894L);
                map3 = null;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return map3;
        }
        DBOperationUtil.closeSession((Session)session);
        return map;
    }

    private Map<String, Map<String, String>> groupPgPropItems(List<?> props) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Object prop : props) {
            String id;
            HashMap<String, String> attrs;
            int i = 0;
            Object[] items = (Object[])prop;
            if (items == null || items.length < 3) continue;
            if ((attrs = (HashMap<String, String>)map.get(id = (String)items[i++])) == null) {
                attrs = new HashMap<String, String>();
                map.put(id, attrs);
            }
            attrs.put((String)items[i++], (String)items[i]);
        }
        return map;
    }

    private void updateProtectGroups(List<ProtectGroup> protectGroups) {
        for (ProtectGroup pg : protectGroups) {
            String dsgId = (String)pg.getProps().get(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
            if (VerifyUtil.isEmpty((String)dsgId)) continue;
            List<ReplicationPair> pairs = null;
            if (dsgId.startsWith("singleLun_")) {
                String repId = dsgId.substring("singleLun_".length());
                pairs = this.getReplicationById(repId, 0);
            } else if (!dsgId.contains("_")) {
                pairs = this.getReplicationById(dsgId, 1);
            }
            if (VerifyUtil.isEmpty(pairs)) continue;
            this.updateDsgForProtectGroup(pairs, pg);
        }
    }

    private void updateDsgForProtectGroup(List<ReplicationPair> pairs, ProtectGroup pg) {
        HashSet<String> dsgKeySet = new HashSet<String>();
        for (ReplicationPair pair : pairs) {
            dsgKeySet.add(this.getDsgKey(pair));
        }
        for (String dsgKey : dsgKeySet) {
            this.updateDsgIDInDataBase(pg, dsgKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDsgIDInDataBase(ProtectGroup pg, String dsgKey) {
        Session session = null;
        try {
            String updateDsgSql = "update ti_protectgroup_prop set PROPVALUE = ? where PGID = ? and PROPNAME = ?";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(updateDsgSql);
            query.setString(0, dsgKey);
            query.setString(1, pg.getUuid());
            query.setString(2, PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("update pg for dsg id failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private List<ReplicationPair> getReplicationById(String replicationId, int relationType) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(relationType == 1 ? "consistentGroupId" : "replicationId", replicationId);
        props.put("isPrimary", Boolean.TRUE);
        return CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
    }

    private String getDsgKey(ReplicationPair pair) {
        String groupId = pair.getConsistentGroupId();
        StringBuilder key = new StringBuilder();
        key.append(pair.getDevSn());
        key.append("_");
        if (this.isNotConsistentGroup(groupId)) {
            key.append(pair.getReplicationId());
            key.append("_REP");
        } else {
            key.append(pair.getConsistentGroupId());
            key.append("_CG");
        }
        return key.toString();
    }

    private boolean isNotConsistentGroup(String groupId) {
        return VerifyUtil.isEmpty((String)groupId) || "--".equals(groupId);
    }
}

