/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.protection.protectgroup.service;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.pg.service.IProtectObjectStorageInfoService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.storage.support.dao.BaseStoragePgDao;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceBaseService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@Service(name="com.huawei.ism.drm.galax.sdk.pg.service.IProtectObjectStorageInfoService", desc="", interfaceClass=IProtectObjectStorageInfoService.class)
public class ProtectObjectStorageInfoServiceImpl
extends BaseService
implements IProtectObjectStorageInfoService {
    private static final Log logger = LogFactory.getInstance(ProtectObjectStorageInfoServiceImpl.class);

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            logger.warn((Object)"ProtectObjectList is empty.");
            return;
        }
        String dsgId = null;
        HashSet<String> vmUuids = new HashSet<String>();
        for (ProtectObject protectObject : protectObjectList) {
            if (!VerifyUtil.isEmpty((Object)protectObject.getProtectGroup())) {
                dsgId = (String)protectObject.getProtectGroup().getProps().get("dsgId");
            }
            String moUuid = protectObject.getMoUuid();
            vmUuids.add(moUuid);
        }
        HashMap<String, StorageResource> storageMap = new HashMap<String, StorageResource>();
        HashMap<String, List<VmConfigDiskType>> vmDiskMap = new HashMap<String, List<VmConfigDiskType>>();
        this.queryDiskInfo(dsgId, vmUuids, storageMap, vmDiskMap);
        for (ProtectObject protectObject : protectObjectList) {
            String moUuid = protectObject.getMoUuid();
            if (VerifyUtil.isEmpty((String)dsgId) && vmDiskMap.containsKey(moUuid)) {
                protectObject.clearUsedStorageResource();
                for (VmConfigDiskType disk : (List)vmDiskMap.get(moUuid)) {
                    this.buildStorageInfo((StorageResource)storageMap.get(disk.getVolumeUuid()), disk).ifPresent(arg_0 -> ((ProtectObject)protectObject).addHostStorageResourceInfo(arg_0));
                }
                continue;
            }
            protectObject.clearUsedStorageResource();
            this.addStorageInfo(protectObject, moUuid);
        }
    }

    private Optional<ProtectObjectStorageInfo> buildStorageInfo(StorageResource storageResource, VmConfigDiskType disk) {
        if (storageResource == null) {
            logger.warn((Object)"Can not find storageResource, disk: %s", new Object[]{disk.getDiskName()});
            return Optional.empty();
        }
        if (!(storageResource instanceof Lun)) {
            logger.warn((Object)"StorageResource's type is not lun: %s.", new Object[]{storageResource.getName()});
            return Optional.empty();
        }
        ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
        Lun lun = (Lun)storageResource;
        info.setLunWWN(lun.getWwn());
        info.setResourceProviderSN(lun.getDevSn());
        info.setResourceId(lun.getResourceId());
        info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        info.setDeviceName(disk.getDiskName());
        info.setResourceName(lun.getName());
        return Optional.of(info);
    }

    private void queryDiskInfo(String dsgId, Set<String> vmUuids, Map<String, StorageResource> storageMap, Map<String, List<VmConfigDiskType>> vmDiskMap) {
        if (!VerifyUtil.isEmpty((String)dsgId)) {
            return;
        }
        Map<String, List<VmConfigDiskType>> storageDiskMap = this.queryDiskMap(vmUuids, vmDiskMap);
        for (String devSn : storageDiskMap.keySet()) {
            List<VmConfigDiskType> eVolDisks;
            StorageNE storage = (StorageNE)CommonDAOLocator.getMoDao().getMo(StorageNE.class, "sn", (Object)devSn);
            if (VerifyUtil.isEmpty((Object)storage)) {
                logger.warn((Object)"Can not find storage.");
                continue;
            }
            List<VmConfigDiskType> disks = storageDiskMap.get(devSn);
            if (VerifyUtil.isEmpty(disks)) {
                logger.warn((Object)"Can not find disks.");
                continue;
            }
            Map<String, List<VmConfigDiskType>> diskTypeMap = disks.stream().collect(Collectors.groupingBy(VmConfigDiskType::getStorageType));
            List<VmConfigDiskType> dswareDisks = diskTypeMap.get("DSWARE");
            if (!VerifyUtil.isEmpty(dswareDisks)) {
                storageMap.putAll(this.queryDswareStorageMap(devSn, dswareDisks));
            }
            if (VerifyUtil.isEmpty(eVolDisks = diskTypeMap.get("advanceSan"))) continue;
            storageMap.putAll(this.queryEVolStorageMap(devSn, eVolDisks));
        }
    }

    private Map<String, StorageResource> queryDswareStorageMap(String devSn, List<VmConfigDiskType> diskTypeList) {
        Map<String, String> nameUuidMap = diskTypeList.stream().collect(Collectors.toMap(VmConfigDiskType::getVolNameOnDev, VmConfigDiskType::getVolumeUuid, (volumeUuid1, volumeUuid2) -> volumeUuid1));
        Set<String> nameList = nameUuidMap.keySet();
        if (VerifyUtil.isEmpty(nameList)) {
            return Collections.emptyMap();
        }
        List storageRes = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).queryStorageResourcesByName(devSn, new ArrayList<String>(nameList));
        if (nameList.size() != CollectionUtils.size((Object)storageRes)) {
            logger.warn((Object)"Can not find all dsware storage, name: %s", new Object[]{nameList});
        }
        return storageRes.stream().collect(Collectors.toMap(res -> (String)nameUuidMap.get(res.getName()), Function.identity()));
    }

    private Map<String, StorageResource> queryEVolStorageMap(String devSn, List<VmConfigDiskType> diskTypeList) {
        int prefixIndex = 6;
        Map<String, String> wwnUuidMap = diskTypeList.stream().collect(Collectors.toMap(disk -> StringUtils.substring((String)disk.getVolumeUrl(), (int)prefixIndex), VmConfigDiskType::getVolumeUuid, (o1, o2) -> o1));
        Set<String> wwnSet = wwnUuidMap.keySet();
        if (VerifyUtil.isEmpty(wwnSet)) {
            return Collections.emptyMap();
        }
        List lunList = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getLunByWwn(devSn, wwnSet).stream().filter(lun -> devSn.equals(lun.getDevSn())).collect(Collectors.toList());
        if (wwnSet.size() != lunList.size()) {
            logger.warn((Object)"Can not find all eVol storage, wwn: %s", new Object[]{wwnSet});
        }
        if (VerifyUtil.isEmpty(lunList)) {
            return Collections.emptyMap();
        }
        return lunList.stream().collect(Collectors.toMap(lun -> (String)wwnUuidMap.get(lun.getWwn()), Function.identity()));
    }

    private Map<String, List<VmConfigDiskType>> queryDiskMap(Set<String> vmUuids, Map<String, List<VmConfigDiskType>> vmDiskMap) {
        List<GalaxVM> vmList = BaseStoragePgDao.getInstance().queryGalaxVMByVmUuids(vmUuids);
        if (VerifyUtil.isEmpty(vmList)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<VmConfigDiskType>> storageDiskMap = new HashMap<String, List<VmConfigDiskType>>();
        Map<String, String> urnSnMap = this.queryDatastoreUrnSnMap(vmList);
        for (GalaxVM galaxVM : vmList) {
            if (VerifyUtil.isEmpty((String)galaxVM.getVmConfig())) {
                logger.warn((Object)"Can not find vmConfig for vm: %s", new Object[]{galaxVM.getName()});
                continue;
            }
            VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)galaxVM.getVmConfig(), VmConfigType.class);
            if (VerifyUtil.isEmpty((Object)vmConfig) || VerifyUtil.isEmpty((Collection)vmConfig.getDisks())) {
                logger.warn((Object)"Can not find disk for vm: %s", new Object[]{galaxVM.getName()});
                continue;
            }
            for (VmConfigDiskType disk : vmConfig.getDisks()) {
                if (!disk.getPersistentDisk().booleanValue()) {
                    logger.warn((Object)"The disk is not a persistent disk: %s", new Object[]{disk.getDiskName()});
                    continue;
                }
                String devSn = urnSnMap.get(disk.getDatastoreUrn());
                if (!VerifyUtil.isEmpty((String)devSn) && StringUtils.equalsAny((CharSequence)disk.getStorageType(), (CharSequence[])new CharSequence[]{"DSWARE", "advanceSan"})) {
                    CommUtil.addToMap(storageDiskMap, (String)devSn, (Object)disk);
                    CommUtil.addToMap(vmDiskMap, (String)galaxVM.getUuid(), (Object)disk);
                    continue;
                }
                logger.warn((Object)"Can not find datastore's devSn for disk: %s", new Object[]{disk.getDiskName()});
            }
        }
        return storageDiskMap;
    }

    private Map<String, String> queryDatastoreUrnSnMap(List<GalaxVM> vmList) {
        List<String> datastoreUrnList = vmList.stream().map(GalaxVM::getDataStoreUrns).filter(urns -> !VerifyUtil.isEmpty((String)urns)).map(urns -> urns.split(",")).flatMap(Stream::of).distinct().collect(Collectors.toList());
        ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>();
        conditionList.add(new QueryCondition("urn", (Object)datastoreUrnList.toArray(new String[0]), 8));
        return CommonDAOLocator.getMoDao().findMoBy(DataStore.class, conditionList).stream().filter(dataStore -> !VerifyUtil.isEmpty((String)dataStore.getDevSn())).collect(Collectors.toMap(GalaxObject::getUrn, DataStore::getDevSn));
    }

    private void addStorageInfo(ProtectObject protectObject, String moUuid) {
        HashSet<String> vmUuids = new HashSet<String>();
        vmUuids.add(moUuid);
        List<DataStore> dsList = BaseStoragePgDao.getInstance().getDataStoresByVmUuids(vmUuids);
        if (VerifyUtil.isEmpty(dsList)) {
            return;
        }
        List sns = null;
        ProtectGroup protectGroup = protectObject.getProtectGroup();
        if (!VerifyUtil.isEmpty((Object)protectGroup)) {
            String productSiteId = protectGroup.getProductSiteId();
            sns = SiteResourceManagerUtil.getResourceSNBySiteId((String)productSiteId, (int)2);
        }
        for (DataStore ds : dsList) {
            Set wwns = DsgUtil.getDataStoreStorageWwns((DataStore)ds);
            for (String wwn : wwns) {
                protectObject.addHostStorageResourceInfo(this.constructStorageInfo(protectObject, wwn, ds, sns));
            }
        }
    }

    private ProtectObjectStorageInfo constructStorageInfo(ProtectObject po, String wwn, DataStore ds, List<String> sns) {
        ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
        if (VerifyUtil.isEmpty((String)info.getId())) {
            info.setId(UUIDGenerator.getUUID());
        }
        info.setLunWWN(wwn);
        if ("NAS".equals(ds.getStorageType())) {
            String[] lunValue = wwn.split(":");
            if (lunValue.length != 2) {
                return info;
            }
            List list = ((IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class)).getFileSystemsByNFSShare(lunValue[0], lunValue[1], true);
            if (VerifyUtil.isEmpty((Collection)list)) {
                info.setResourceProviderSN("UNKNOWN");
                info.setResourceId(wwn);
            } else {
                NasFileSystem nfs = null;
                if (list.iterator().hasNext()) {
                    nfs = (NasFileSystem)list.iterator().next();
                }
                if (nfs != null) {
                    info.setResourceProviderSN(nfs.getDevSn());
                    info.setResourceId(nfs.getResourceId());
                    info.setResourceName(nfs.getName());
                    info.setVstoreId(nfs.getVstoreId());
                    this.putVstoreHyperPairId(po.getProtectGroup(), nfs);
                }
            }
            info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()));
        } else {
            this.getStorageResourceByWwn(wwn, sns).ifPresent(storageDev -> {
                info.setResourceProviderSN(storageDev.getDevSn());
                info.setResourceId(VerifyUtil.isEmpty((String)storageDev.getResourceId()) ? wwn : storageDev.getResourceId());
                if (storageDev instanceof Lun) {
                    info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
                } else {
                    info.setResourceProviderSN(ds.getUuid());
                    info.setDeviceName(ds.getName());
                    info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.VIS.getValue()));
                }
            });
        }
        return info;
    }

    private void putVstoreHyperPairId(ProtectGroup protectGroup, NasFileSystem nasFileSystem) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            return;
        }
        String pairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        if (VerifyUtil.isEmpty((String)pairId) && !VerifyUtil.isEmpty((String)nasFileSystem.getVstoreId())) {
            try {
                VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstoreId(nasFileSystem.getDevSn(), nasFileSystem.getVstoreId());
                if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
                    logger.error((Object)"The vstoreHyperMetroPair does not exist, vstore: %s.", new Object[]{nasFileSystem.getVstoreId()});
                } else {
                    protectGroup.getProps().put("PROP_KEY_VSTORE_PAIR_ID", vstoreHyperMetroPair.getVstorePairId());
                    protectGroup.getProps().put("PROP_KEY_VSTORE_ID", vstoreHyperMetroPair.getLocalVstoreId());
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Get vstoreHyperMetroPair error, vstore: %s.", new Object[]{nasFileSystem.getVstoreId()});
            }
        }
    }

    private Optional<StorageResource> getStorageResourceByWwn(String wwn, List<String> sns) {
        List storageRes = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResourceByWwn(new String[]{wwn});
        if (VerifyUtil.isEmpty((Collection)storageRes)) {
            logger.error((Object)"Can not find the lun by wwn, wwn: %s.", new Object[]{wwn});
            return Optional.empty();
        }
        if (!VerifyUtil.isEmpty(sns)) {
            for (StorageResource storageResource : storageRes) {
                if (!sns.contains(storageResource.getDevSn())) continue;
                return Optional.of(storageResource);
            }
        }
        storageRes.sort(new CommonComparator("devSn", true));
        return Optional.of(storageRes.get(0));
    }

    private List<DataStore> loadDataStoresForPg(ProtectGroup pg) {
        HashSet<String> vmUuids = new HashSet<String>();
        for (ProtectObject protectObject : pg.getPolist()) {
            String moUuid = protectObject.getMoUuid();
            vmUuids.add(moUuid);
        }
        HashSet<String> dsUrnSet = new HashSet<String>();
        List<GalaxVM> vmList = BaseStoragePgDao.getInstance().queryGalaxVMByVmUuids(vmUuids);
        if (!VerifyUtil.isEmpty(vmList)) {
            for (GalaxVM galaxVM : vmList) {
                if (VerifyUtil.isEmpty((String)galaxVM.getVmConfig())) {
                    logger.warn((Object)"Can not find vmConfig for vm: %s.", new Object[]{galaxVM.getName()});
                    continue;
                }
                VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)galaxVM.getVmConfig(), VmConfigType.class);
                if (VerifyUtil.isEmpty((Object)vmConfig) || VerifyUtil.isEmpty((Collection)vmConfig.getDisks())) {
                    logger.warn((Object)("Can not find disk for vm:" + galaxVM.getName()));
                    continue;
                }
                for (VmConfigDiskType disk : vmConfig.getDisks()) {
                    dsUrnSet.add(disk.getDatastoreUrn());
                }
            }
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)dsUrnSet.toArray(new String[0]), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        return CommonDAOLocator.getMoDao().findMoBy(DataStore.class, qcList);
    }

    public void setDataStoreInfoForProtectGroup(ProtectGroup protectGroup) {
        List<DataStore> dataStoreList = this.loadDataStoresForPg(protectGroup);
        List dataStoreInfoList = dataStoreList.stream().map(ds -> new DataStoreInfo(ds.getUuid(), ds.getName(), DrmEnumDefine.ResourceTypeE.LUN.name())).collect(Collectors.toList());
        protectGroup.getProps().put("pgDsInfo", JSONArray.fromObject(dataStoreInfoList).toString());
    }
}

