/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.proxy;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmStatusEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.pg.model.GalaxCNAInfo;
import com.huawei.ism.drm.galax.sdk.pg.model.GalaxCNATopoData;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxObjectObserver;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.ism.drm.galax.storage.entity.DsMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.manager.CloudPlatformServiceManager;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class ProtectGroupProxy {
    private static final int MAX_PG_PROP_VALUE_LENGTH = 262144;
    private static Log log = LogFactory.getInstance(ProtectGroupProxy.class);
    private static String trace = "trace";
    private ProtectGroup pg;
    private PgMgrInfo mgrInfo;
    private IFMInfosRetriever fmRetriever = CloudPlatformServiceManager.getInstance().getFmRetriever();

    public ProtectGroupProxy(ProtectGroup pg) {
        log.trace((Object)(trace + " trace message"));
        this.pg = pg;
        this.mgrInfo = this.generateMgrInfo();
    }

    private PgMgrInfo generateMgrInfo() {
        log.trace((Object)(trace + " trace message"));
        FixLengthProps pgRecoveryProps = new FixLengthProps(this.pg.getProps(), 262144);
        String mgrInfoJson = pgRecoveryProps.getValue("pgMgrInfo");
        if (VerifyUtil.isEmpty((String)mgrInfoJson)) {
            return new PgMgrInfo(this.pg);
        }
        PgMgrInfo pgMgr = (PgMgrInfo)((Object)CommonUtil.jsonToBean((String)mgrInfoJson, PgMgrInfo.class));
        ArrayList<DsMgrInfo> baseList = new ArrayList<DsMgrInfo>();
        if (null != pgMgr && null != pgMgr.getDsInfos()) {
            for (DsMgrInfoBase dsBase : pgMgr.getDsInfos()) {
                DsMgrInfo dsMgr = new DsMgrInfo(dsBase);
                baseList.add(dsMgr);
            }
            pgMgr.setDsInfos(baseList);
        }
        return pgMgr;
    }

    public void updateMgrInfo(boolean isUseLocalInfo) {
        log.trace((Object)(trace + " trace message"));
        PgMgrInfo pgMgr = new PgMgrInfo(this.pg);
        log.info((Object)"begin to update protect group manage info", 90160758786816L);
        if (null == pgMgr.getPgFcSn()) {
            log.error((Object)"the fcsn of the protect group is null", 90160758787071L);
            return;
        }
        if (isUseLocalInfo && !VerifyUtil.isEmpty((Collection)pgMgr.getDsInfos())) {
            for (DsMgrInfoBase dsBase : pgMgr.getDsInfos()) {
                dsBase.setUseLocalDs(Boolean.valueOf(true));
            }
        }
        this.mgrInfo = pgMgr;
        String pgProps = CommonUtil.beanToJson((Object)((Object)pgMgr));
        FixLengthProps pgRecoveryProps = new FixLengthProps(this.pg.getProps(), 262144);
        pgRecoveryProps.setProp("pgMgrInfo", pgProps);
    }

    public String getRecoveryArray(String recSiteId) {
        if (this.pg.getReplicaList() == null) {
            return null;
        }
        for (ProtectGroupReplica pgr : this.pg.getReplicaList()) {
            if (!pgr.getRecoverySite().equals(recSiteId)) continue;
            return pgr.getRecoveryArray();
        }
        return null;
    }

    private void generateGolbalTopoData() {
        log.trace((Object)(trace + " trace message"));
        List<String> productFcSns = this.getProductFcSns(this.pg.getPoProviderSN());
        ArrayList<GalaxCNATopoData> topoInfo = new ArrayList<GalaxCNATopoData>();
        for (String productFcSn : productFcSns) {
            HashSet<String> clusterUrnSet = new HashSet<String>();
            HashSet<String> hostUrnSet = new HashSet<String>();
            this.getClusterOrHostUrn(this.pg, clusterUrnSet, hostUrnSet, productFcSn);
            this.createClusterTopoInfo(clusterUrnSet, topoInfo);
            this.createHostTopoInfo(hostUrnSet, topoInfo);
        }
        String topoString = CommonUtil.beanToJson(topoInfo);
        FixLengthProps pgRecoveryProps = new FixLengthProps(this.pg.getProps(), 262144);
        pgRecoveryProps.setProp(PgExParamsEnum.PG_GLOBAL_TOPO.getValue(), topoString);
    }

    private List<String> getProductFcSns(String providerSn) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<String> productFcSns = new ArrayList<String>();
        if (!providerSn.startsWith("Dr_Vrm")) {
            List vrmList = FmUtils.getVRMByFmSn((String)providerSn);
            for (VRM vrm : vrmList) {
                productFcSns.add(vrm.getSn());
            }
        } else {
            productFcSns.add(providerSn);
        }
        return productFcSns;
    }

    private void createClusterTopoInfo(Set<String> clusterUrnSet, List<GalaxCNATopoData> topoInfo) {
        log.trace((Object)(trace + " trace message"));
        for (String clusterUrn : clusterUrnSet) {
            ComputeCluster cluster = (ComputeCluster)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ComputeCluster.class, "urn", (Object)clusterUrn);
            if (null == cluster) continue;
            GalaxCNATopoData info = new GalaxCNATopoData();
            info.setClusterUuid(cluster.getUuid());
            info.setClusterName(cluster.getName());
            List cnInCluster = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getListMo(ComputeNode.class, "computeClusterUrn", (Object)clusterUrn);
            for (ComputeNode cn : cnInCluster) {
                GalaxCNAInfo cna = new GalaxCNAInfo();
                cna.setHostUuid(cn.getUuid());
                cna.setHostname(cn.getName());
                cna.setHostStatus(cn.getHostStatus());
                info.addHost(cna);
            }
            info.setClusterFlg(true);
            topoInfo.add(info);
        }
    }

    private void createHostTopoInfo(Set<String> hostUrnSet, List<GalaxCNATopoData> topoInfo) {
        log.trace((Object)(trace + " trace message"));
        for (String hostUrn : hostUrnSet) {
            ComputeNode cn = (ComputeNode)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ComputeNode.class, "urn", (Object)hostUrn);
            if (null == cn) continue;
            GalaxCNATopoData info = new GalaxCNATopoData();
            GalaxCNAInfo cna = new GalaxCNAInfo();
            cna.setHostUuid(cn.getUuid());
            cna.setHostname(cn.getName());
            cna.setHostStatus(cn.getHostStatus());
            info.addHost(cna);
            info.setClusterFlg(false);
            topoInfo.add(info);
        }
    }

    private void getClusterOrHostUrn(ProtectGroup protectGroup, Set<String> clusterUrnSet, Set<String> hostUrnSet, String productFcSn) {
        log.trace((Object)(trace + " trace message"));
        Set protectObjectList = protectGroup.getPolist();
        ArrayList<String> vmUuidList = new ArrayList<String>();
        for (ProtectObject protectObject : protectObjectList) {
            String vmMoUuid = protectObject.getMoUuid();
            if (vmUuidList.contains(vmMoUuid)) continue;
            vmUuidList.add(protectObject.getMoUuid());
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)vmUuidList.toArray(), 8);
        QueryCondition qc2 = new QueryCondition("topMoUuid", (Object)productFcSn, 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        qcList.add(qc2);
        List fusionsphereVMs = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        for (GalaxVM vm : fusionsphereVMs) {
            if (VerifyUtil.isEmpty((String)vm.getClusterUrn())) {
                hostUrnSet.add(vm.getHostUrn());
                continue;
            }
            clusterUrnSet.add(vm.getClusterUrn());
        }
    }

    public void syncPgInfo(String siteId) {
        log.trace((Object)(trace + " trace message"));
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            log.error((Object)("find no site,and siteId is:" + siteId), 90160758787071L);
            return;
        }
        if (1 == site.getSiteType()) {
            try {
                IProtectionRemoteService pgService = (IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class);
                pgService.syncProtectGroupToRemoteSite(this.pg, "/ws/protectgroups/action/syncProtectGroupInfo");
            }
            catch (LegoCheckedException e) {
                String errorMsg = "sync Protect Group to remote site error";
                log.error((Object)errorMsg, (Throwable)e, 90160758787071L);
                throw new LegoCheckedException(1073947440L, (Throwable)e);
            }
            log.info((Object)"sync Protect Group to remote site done.", 90160758786816L);
        } else {
            MessageEvent updateEvent = new MessageEvent();
            updateEvent.setMessageType(1);
            ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
            objectList.add(this.pg);
            updateEvent.setObjectList(objectList);
            ((IGalaxObjectObserver)ServiceLocator.getInstance().getService(IGalaxObjectObserver.class)).after(updateEvent);
        }
    }

    public PgMgrInfo getMgrInfo() {
        log.trace((Object)(trace + " trace message"));
        return this.mgrInfo;
    }

    public void addPgParam(String key, String value) {
        log.trace((Object)(trace + " trace message"));
        this.pg.getProps().put(key, value);
    }

    public boolean isBelongToVrm(String vrmSn) {
        log.trace((Object)(trace + " trace message"));
        String fcSn = this.mgrInfo.getPgFcSn();
        if (null == fcSn || !fcSn.equals(vrmSn)) {
            log.info((Object)("Pg(" + this.pg.getName() + ") doesn't belongs to vrm:" + vrmSn), 90160758786816L);
            return false;
        }
        return true;
    }

    public Map<ProtectObject, GalaxVM> getMapPoToGalaxVM() {
        log.trace((Object)(trace + " trace message"));
        HashMap<ProtectObject, GalaxVM> mapPoToVm = new HashMap<ProtectObject, GalaxVM>();
        List<GalaxVM> listVm = this.getPosGalaxVms();
        if (null == listVm || listVm.isEmpty()) {
            return mapPoToVm;
        }
        block0: for (ProtectObject po : this.pg.getPolist()) {
            for (GalaxVM vm : listVm) {
                if (!vm.getUuid().equals(po.getMoUuid())) continue;
                mapPoToVm.put(po, vm);
                continue block0;
            }
        }
        return mapPoToVm;
    }

    private List<GalaxVM> getPosGalaxVms() {
        log.trace((Object)(trace + " trace message"));
        Set pos = this.pg.getPolist();
        if (null == pos || pos.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List listVm = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb = sb.append("from GalaxVM as vm where vm.uuid in (");
            Object[] params = new Object[pos.size()];
            int i = 0;
            for (ProtectObject po : pos) {
                params[i] = po.getMoUuid();
                sb.append("?");
                if (i == pos.size() - 1) continue;
                sb.append(',');
                ++i;
            }
            sb.append(")");
            listVm = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(sb.toString(), params);
        }
        catch (DataAccessException e) {
            log.error((Object)"Failed to query vms.", (Throwable)e, 90160758787071L);
        }
        if (null != listVm) {
            log.info((Object)("Vm list number is:" + listVm.size()), 90160758786816L);
        }
        return listVm;
    }

    private Map<GalaxVM, ResourcepoolVMServiceV2Stub.VMInfo0> getMapVmToInfoE(List<GalaxVM> listVms) {
        log.trace((Object)(trace + " trace message"));
        if (VerifyUtil.isEmpty(listVms)) {
            log.error((Object)"listVms is empty", 90160758787071L);
            return new HashMap<GalaxVM, ResourcepoolVMServiceV2Stub.VMInfo0>();
        }
        String vmTopMoUuid = listVms.get(0).getTopMoUuid();
        for (GalaxVM vm : listVms) {
            if (vm.getTopMoUuid().equals(vmTopMoUuid)) continue;
            log.error((Object)("Failed to add ProtectObject. This vm comes from " + vm.getTopMoUuid()), 90160758787071L);
            throw new LegoCheckedException(1073948385L);
        }
        List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = this.getFmVmInfo(listVms);
        HashMap<GalaxVM, ResourcepoolVMServiceV2Stub.VMInfo0> mapVmToInfoE = new HashMap<GalaxVM, ResourcepoolVMServiceV2Stub.VMInfo0>();
        for (GalaxVM vm : listVms) {
            for (ResourcepoolVMServiceV2Stub.VMInfo0 info : vmInfos) {
                if (null == info) {
                    log.error((Object)("can not find the FM vm. fc vm name is=" + vm.getName()), 90160758787071L);
                    continue;
                }
                if (null == vm.getUrn() || !vm.getUrn().equals(info.getVVMURN())) continue;
                mapVmToInfoE.put(vm, info);
            }
        }
        return mapVmToInfoE;
    }

    public boolean isFcPg() {
        log.trace((Object)(trace + " trace message"));
        return this.pg.getPoProviderSN().startsWith("Dr_Vrm");
    }

    private List<ResourcepoolVMServiceV2Stub.VMInfo0> getFmVmInfo(List<GalaxVM> listVms) {
        log.trace((Object)(trace + " trace message"));
        if (this.isFcPg()) {
            return new ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0>();
        }
        log.info((Object)("fmSn is:" + this.pg.getPoProviderSN()), 90160758786816L);
        List<String> listVmUrns = this.getVmUrns(listVms);
        String hypervisorId = this.getHyperVId();
        FmObject fmInfo = FmUtils.generateFmObj((String)this.pg.getPoProviderSN());
        List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = this.getVmInfoEList(fmInfo, hypervisorId, listVmUrns);
        return vmInfos;
    }

    private List<String> getVmUrns(List<GalaxVM> listVms) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<String> listVmUrns = new ArrayList<String>();
        for (GalaxVM vm : listVms) {
            listVmUrns.add(vm.getUrn());
        }
        return listVmUrns;
    }

    private String getHyperVId() {
        log.trace((Object)(trace + " trace message"));
        Hypervisor hyperV = ((IFmService)ServiceLocator.getInstance().getService(IFmService.class)).getHypervisorByVrm(this.mgrInfo.getPgFcSn());
        if (null == hyperV) {
            return null;
        }
        String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
        return hypervisorId;
    }

    private List<ResourcepoolVMServiceV2Stub.VMInfo0> getVmInfoEList(FmObject fmInfo, String hypervisorId, List<String> listVmUrns) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = new ArrayList();
        try {
            vmInfos = this.fmRetriever.queryVMs(fmInfo, hypervisorId, listVmUrns);
        }
        catch (FmBusinessException e) {
            log.error((Object)"Failed to query vms.", (Throwable)e, 90160758787071L);
        }
        return vmInfos;
    }

    public boolean isPgPropsExchanged() {
        log.trace((Object)(trace + " trace message"));
        FixLengthProps pgRecoveryProps = new FixLengthProps(this.pg.getProps(), 262144);
        String mgrInfoJson = pgRecoveryProps.getValue("pgMgrInfo");
        PgMgrInfo pgMgrNew = new PgMgrInfo(this.pg);
        String mgrInfoJsonTemp = CommonUtil.beanToJson((Object)((Object)pgMgrNew));
        if (null == mgrInfoJsonTemp) {
            return false;
        }
        if (!mgrInfoJsonTemp.equals(mgrInfoJson)) {
            return true;
        }
        Map<ProtectObject, GalaxVM> mapPoToVm = this.getMapPoToGalaxVM();
        Map<GalaxVM, ResourcepoolVMServiceV2Stub.VMInfo0> mapVmToInfo = this.getMapVmToInfoE(new ArrayList<GalaxVM>(mapPoToVm.values()));
        for (ProtectObject po : this.pg.getPolist()) {
            VmMgrInfo vmMgrInfo;
            ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
            GalaxVM vm = mapPoToVm.get(po);
            if (null == vm || !poProxy.isPoPropsExchanged(vmMgrInfo = new VmMgrInfo(vm, mapVmToInfo.get(vm)))) continue;
            log.info((Object)("vm(" + po.getName() + ")'s caculate or net resource is changed."), 90160758786816L);
            return true;
        }
        log.info((Object)("Pg(" + this.pg.getName() + ")'s resource is not exchanged."), 90160758786816L);
        return false;
    }

    public boolean isPgStorageExchanged() {
        log.trace((Object)(trace + " trace message"));
        for (ProtectObject po : this.pg.getPolist()) {
            ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
            if (!poProxy.isStorageRelationExchanged()) continue;
            return true;
        }
        return false;
    }

    public void updatePos() {
        Map<String, List<Lun>> mapDsUrnToLun;
        log.info((Object)"begin to update protect object ", 90160758786816L);
        List listDs = RecoveryPlanUtil.getDataStoreFromPg((ProtectGroup)this.pg);
        if (VerifyUtil.isEmpty((Collection)listDs)) {
            log.error((Object)("can not get datastore form pg, uuid=" + this.pg.getUuid()), 90160758787071L);
        }
        if (null == (mapDsUrnToLun = this.getMapDsUrnToLun(listDs)) || mapDsUrnToLun.isEmpty()) {
            mapDsUrnToLun = this.getMapDsUrnToVolLun(listDs);
        }
        Map<ProtectObject, GalaxVM> mapPoToVm = this.getMapPoToGalaxVM();
        Map<GalaxVM, ResourcepoolVMServiceV2Stub.VMInfo0> mapVmToInfoE = this.getMapVmToInfoE(new ArrayList<GalaxVM>(mapPoToVm.values()));
        Set<Map.Entry<ProtectObject, GalaxVM>> entryMap = mapPoToVm.entrySet();
        Iterator<Map.Entry<ProtectObject, GalaxVM>> iterator = entryMap.iterator();
        HashMap<String, Hypervisor> vrmHypervisorMap = new HashMap<String, Hypervisor>();
        while (iterator.hasNext()) {
            String vrmSn;
            Hypervisor hyperV;
            Map.Entry<ProtectObject, GalaxVM> entry = iterator.next();
            ProtectObject po = entry.getKey();
            GalaxVM galaxVM = entry.getValue();
            if (!galaxVM.getTopMoUuid().equals(po.getProviderSN()) && null == (hyperV = (Hypervisor)vrmHypervisorMap.get(vrmSn = galaxVM.getTopMoUuid()))) {
                vrmHypervisorMap.put(vrmSn, ((IFmService)ServiceLocator.getInstance().getService(IFmService.class)).getHypervisorByVrm(vrmSn));
            }
            try {
                ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
                poProxy.update(galaxVM, mapVmToInfoE.get(galaxVM), mapDsUrnToLun, (Hypervisor)vrmHypervisorMap.get(galaxVM.getTopMoUuid()));
                HashMap<String, String> props = po.getProps();
                if (props == null) {
                    props = new HashMap<String, String>();
                }
                String vmId = galaxVM.getUri().split("vms")[1].replace("/", "");
                props.put(PoExParamsEnum.VM_ID.getValue(), vmId);
                VmStatusEnum statusEnum = VmStatusEnum.findStatusByKey((int)galaxVM.getStatus());
                props.put("VMSTATUS", null == statusEnum ? VmStatusEnum.UNKNOWN.getValue() : statusEnum.getValue());
                po.setProps(props);
            }
            catch (Exception e) {
                log.error((Object)("update pg catch exception," + galaxVM.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
            }
        }
        this.generateGolbalTopoData();
    }

    private Map<String, List<Lun>> getMapDsUrnToLun(List<DataStore> listDs) {
        log.trace((Object)(trace + " trace message"));
        if (null == listDs || listDs.isEmpty()) {
            log.info((Object)"listDs is empty!");
            return new HashMap<String, List<Lun>>();
        }
        HashMap<String, List<Lun>> mapDsUrnToLun = new HashMap<String, List<Lun>>();
        for (DataStore ds : listDs) {
            List luns = DsgUtil.getLunsByDs((DataStore)ds, (boolean)false);
            if (VerifyUtil.isEmpty((Collection)luns)) {
                return null;
            }
            mapDsUrnToLun.put(ds.getUrn(), luns);
        }
        log.info((Object)("mapDsUrnToLun is:" + mapDsUrnToLun), 90160758786816L);
        return mapDsUrnToLun;
    }

    private Map<String, List<Lun>> getMapDsUrnToVolLun(List<DataStore> listDs) {
        log.trace((Object)(trace + " trace message"));
        if (null == listDs || listDs.isEmpty()) {
            log.info((Object)"listDs is empty!");
            return new HashMap<String, List<Lun>>();
        }
        HashMap<String, List<Lun>> mapDsUrnToLun = new HashMap<String, List<Lun>>();
        for (DataStore ds : listDs) {
            List luns = DsgUtil.getVolumeLunsByDs((DataStore)ds, (boolean)false);
            mapDsUrnToLun.put(ds.getUrn(), luns);
        }
        log.info((Object)("mapDsUrnToLun is:" + mapDsUrnToLun), 90160758786816L);
        return mapDsUrnToLun;
    }

    public static List<Lun> queryLunByDsUrns(String[] dsUrns) {
        log.trace((Object)(trace + " trace message"));
        if (null == dsUrns || dsUrns.length == 0) {
            return Collections.EMPTY_LIST;
        }
        HashSet lunSet = new HashSet();
        try {
            int length = dsUrns.length;
            StringBuilder sb = new StringBuilder();
            sb = sb.append("from DataStore as ds where ds.urn in (");
            Object[] params = new Object[length];
            int i = 0;
            for (String dsUrn : dsUrns) {
                params[i] = dsUrn;
                sb.append("?");
                if (i == length - 1) continue;
                sb.append(',');
                ++i;
            }
            sb.append(")");
            List dsList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(sb.toString(), params);
            for (DataStore ds : dsList) {
                lunSet.addAll(DsgUtil.getLunsByDs((DataStore)ds, (boolean)false));
            }
        }
        catch (Exception e) {
            log.info((Object)("Failed to query lun by urns." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return new ArrayList<Lun>(lunSet);
    }

    public static String generateQueryStr(String[] querys) {
        log.trace((Object)(trace + " trace message"));
        StringBuilder sb = new StringBuilder();
        int length = querys.length;
        if (length == 0) {
            return "";
        }
        sb.append('(');
        int i = 0;
        for (String dataStore : querys) {
            sb.append('\'');
            sb.append(dataStore);
            sb.append('\'');
            if (i == length - 1) continue;
            sb.append(',');
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

