/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.proxy;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.ProtectGroupProxy;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProtectObjectProxy {
    private static final int MAX_POPROPS_LEN = 8192;
    private Log logger = LogFactory.getInstance(ProtectObjectProxy.class);
    private ProtectObject po;
    private String debug = "debug";

    public ProtectObjectProxy(ProtectObject po) {
        this.po = po;
    }

    public String getPoId() {
        this.logger.trace((Object)(this.debug + "getPoId enter."));
        return this.po.getUuid();
    }

    public boolean isTemplate() {
        this.logger.trace((Object)(this.debug + "isTemplate enter."));
        VmMgrInfo vmMgr = this.getPoMgrInfo();
        return vmMgr.isTemplate();
    }

    public VmMgrInfo getPoMgrInfo() {
        this.logger.trace((Object)(this.debug + "getPoMgrInfo enter."));
        VmMgrInfo poMgrInfo = new VmMgrInfo(null);
        FixLengthProps poRecoveryProps = new FixLengthProps(this.po.getProps(), 8192);
        String vmMgrJson = poRecoveryProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
        if (null != vmMgrJson) {
            poMgrInfo = (VmMgrInfo)((Object)CommonUtil.jsonToBean((String)vmMgrJson, VmMgrInfo.class));
        }
        this.logger.debug((Object)(this.debug + "getPoMgrInfo leave."), 90160758786816L);
        return poMgrInfo;
    }

    public boolean isPoPropsExchanged(VmMgrInfo vmMgrInfo) {
        this.logger.trace((Object)(this.debug + "isPoPropsExchanged enter."));
        VmMgrInfo mgrInfo = this.getPoMgrInfo();
        if (!mgrInfo.isPropsSame(vmMgrInfo)) {
            this.logger.info((Object)("vm(" + this.po.getName() + ")'s caculate or net resource is changed."), 90160758786816L);
            return true;
        }
        this.logger.debug((Object)(this.debug + "isPoPropsExchanged leave false."), 90160758786816L);
        return false;
    }

    private Set<ProtectObjectStorageInfo> getPoStorageInfoSet(List<Lun> associatedLuns) {
        this.logger.trace((Object)(this.debug + "getPoStorageInfoSet enter."));
        HashSet<ProtectObjectStorageInfo> poStoInfoSet = new HashSet<ProtectObjectStorageInfo>();
        for (Lun lun : associatedLuns) {
            ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
            info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
            info.setResourceProviderSN(lun.getDevSn());
            info.setResourceId(lun.getLunId());
            poStoInfoSet.add(info);
        }
        return poStoInfoSet;
    }

    public boolean isStorageRelationExchanged() {
        Set<ProtectObjectStorageInfo> newerStorageInfo;
        this.logger.trace((Object)(this.debug + "isStorageRelationExchanged enter."));
        List<Lun> associatedLuns = this.getStorageResourceUsedByProtectObject(this.po.getMoUuid());
        if (associatedLuns == null || VerifyUtil.isEmpty(associatedLuns)) {
            this.logger.error((Object)("Can't get lun info(" + this.po.getName() + ")"), 90160758787071L);
            return false;
        }
        Set usedStorageResourceSet = this.po.getUsedStorageResourceSet();
        boolean isProductStorageExchanged = this.checkStorageInfoChanged(usedStorageResourceSet, newerStorageInfo = this.getPoStorageInfoSet(associatedLuns));
        if (isProductStorageExchanged) {
            this.logger.warn((Object)"Product storage exchanged", 90160758787071L);
            return true;
        }
        for (Lun lun : associatedLuns) {
            if (!this.isTgtLunExchanged(lun)) continue;
            this.logger.warn((Object)"associatedLuns exchanged", 90160758787071L);
            return true;
        }
        this.logger.debug((Object)(this.debug + "isStorageRelationExchanged leave false."), 90160758786816L);
        return false;
    }

    private List<Lun> getStorageResourceUsedByProtectObject(String protectObjectUuid) {
        this.logger.trace((Object)(this.debug + "getStorageResourceUsedByProtectObject enter."));
        IMoDao moDao = CommonDAOLocator.getMoDao();
        GalaxVM vm = (GalaxVM)moDao.getMo(GalaxVM.class, "uuid", (Object)protectObjectUuid);
        if (null == vm) {
            this.logger.warn((Object)("Po(" + protectObjectUuid + ") has been removed"), 90160758786816L);
            return null;
        }
        String[] dsUrns = vm.getDataStoreUrns().split(",");
        return ProtectGroupProxy.queryLunByDsUrns(dsUrns);
    }

    private boolean checkStorageInfoChanged(Set<ProtectObjectStorageInfo> older, Set<ProtectObjectStorageInfo> newer) {
        this.logger.trace((Object)(this.debug + "checkStorageInfoChanged enter."));
        HashSet<String> olderStorageInfo = new HashSet<String>();
        HashSet<String> newerStorageInfo = new HashSet<String>();
        for (ProtectObjectStorageInfo poStorage : older) {
            olderStorageInfo.add(poStorage.getResourceProviderSN() + ":" + poStorage.getResourceId());
        }
        for (ProtectObjectStorageInfo poStorage : newer) {
            newerStorageInfo.add(poStorage.getResourceProviderSN() + ":" + poStorage.getResourceId());
        }
        return olderStorageInfo.size() != newerStorageInfo.size() || !olderStorageInfo.containsAll(newerStorageInfo);
    }

    private boolean isTgtLunExchanged(Lun lun) {
        this.logger.trace((Object)(this.debug + "getPoReplica enter."));
        RelicaStorageInfo sInfo = this.getLunStorageInfo(lun);
        if (null == sInfo) {
            return true;
        }
        List<ReplicationTargetLun> tgtLuns = this.getTgtLunsByLun(lun);
        if (tgtLuns == null || VerifyUtil.isEmpty(tgtLuns)) {
            this.logger.warn((Object)("Lun(" + lun.getName() + ")'s slave LUN is empty."), 90160758787071L);
            return true;
        }
        boolean isExchanged = true;
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            if (!tgtLun.getTgtDevSN().equals(sInfo.getStorageProviderSN()) || !sInfo.getStorageId().equals(String.valueOf(tgtLun.getTgtLunId()))) continue;
            isExchanged = false;
            break;
        }
        return isExchanged;
    }

    private List<ReplicationTargetLun> getTgtLunsByLun(Lun lun) {
        this.logger.trace((Object)(this.debug + "getPoReplica enter."));
        ReplicationPair pair = DsgUtil.getReplicationPairBySrcLun((Lun)lun);
        if (null == pair) {
            this.logger.warn((Object)("Lun(" + lun.getName() + ")'s pair cannot been found."), 90160758787071L);
            return null;
        }
        List tgtLuns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getSubListMo(ReplicationTargetLun.class, pair.getMoId(), new ArrayList());
        return tgtLuns;
    }

    private ProtectObjectReplica getPoReplica() {
        this.logger.trace((Object)(this.debug + "getPoReplica enter."));
        if (null == this.po.getProtectGroup().getReplicaList()) {
            return null;
        }
        for (ProtectGroupReplica pgReplica : this.po.getProtectGroup().getReplicaList()) {
            for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
                if (!this.po.getUuid().equals(poReplica.getPoId())) continue;
                return poReplica;
            }
        }
        return null;
    }

    private RelicaStorageInfo getLunStorageInfo(Lun lun) {
        this.logger.trace((Object)(this.debug + "getPoReplica enter."));
        ProtectObjectReplica poRep = this.getPoReplica();
        if (null == poRep) {
            this.logger.warn((Object)("Po(" + this.po.getName() + ")'s replica not been found."), 90160758787071L);
            return null;
        }
        for (RelicaStorageInfo sInfo : poRep.getStorageInfos()) {
            if (!sInfo.getSrcStorageProviderSN().equals(lun.getDevSn()) || !sInfo.getSrcStorageId().equals(lun.getLunId())) continue;
            return sInfo;
        }
        return null;
    }

    public void update(GalaxVM galaxVM, ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo, Map<String, List<Lun>> mapDsUrnToLun, Hypervisor hyperV) {
        this.logger.info((Object)(this.debug + "begin to update protect object, vm =" + galaxVM.getName()), 90160758786816L);
        if (VerifyUtil.isEmpty((String)this.po.getUuid())) {
            this.po.setUuid(UUIDGenerator.getUUID());
        }
        this.po.setName(galaxVM.getName());
        this.po.setProtectMo((ManagedObject)galaxVM);
        if (GalaxVM.VMProviderType.FM.getValue().equals(galaxVM.getProviderID()) && null == vmInfo) {
            this.logger.error((Object)("can not find the FM vm, fc vm =" + galaxVM.getName()));
            this.po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
        }
        VmMgrInfo vmMgr = new VmMgrInfo(galaxVM, vmInfo);
        Map<String, List<String>> mapSrcdsurnToLunId = this.getMapSrcdsurnToLunId(mapDsUrnToLun);
        vmMgr.setMapSrcdsurnToLunId(mapSrcdsurnToLunId);
        HashMap extendInfo = new HashMap();
        FixLengthProps props = new FixLengthProps(extendInfo, 8192);
        String vmMgrStr = CommonUtil.beanToJson((Object)((Object)vmMgr));
        props.setProp(PoExParamsEnum.VM_MGR_INFO.getValue(), vmMgrStr);
        if (!galaxVM.getTopMoUuid().equals(this.po.getProviderSN()) && null != hyperV) {
            String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
            props.setProp("HYPERV_VMURN", hypervisorId + "$" + galaxVM.getUrn());
        }
        props.setProp("osType", galaxVM.getOsType());
        Map poMap = this.po.getProps();
        if (null != poMap.get("storagePoolMapping")) {
            props.setProp("storagePoolMapping", (String)poMap.get("storagePoolMapping"));
        }
        this.po.setProps(extendInfo);
        this.logger.trace((Object)(this.debug + "update leave."));
    }

    private Map<String, List<String>> getMapSrcdsurnToLunId(Map<String, List<Lun>> mapDsUrnToLun) {
        this.logger.trace((Object)(this.debug + "getMapSrcdsurnToLunId enter."));
        Set<Map.Entry<String, List<Lun>>> entryMap = mapDsUrnToLun.entrySet();
        Iterator<Map.Entry<String, List<Lun>>> iterator = entryMap.iterator();
        HashMap<String, List<String>> mapResult = new HashMap<String, List<String>>();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Lun>> iter = iterator.next();
            String dsUrn = iter.getKey();
            ArrayList<String> lunIdList = new ArrayList<String>();
            for (Lun lun : iter.getValue()) {
                lunIdList.add(lun.getWwn());
            }
            mapResult.put(dsUrn, lunIdList);
        }
        return mapResult;
    }

    public List<VmConfigNicType> getFcNicList() {
        this.logger.trace((Object)(this.debug + "getFcNicList enter."));
        ArrayList<VmConfigNicType> fcNics = new ArrayList();
        VmMgrInfo vmMgrInfo = this.getPoMgrInfo();
        if (GalaxVM.VMProviderType.FC.getValue().equals(vmMgrInfo.getVmType())) {
            VmConfigType vmConfigType = (VmConfigType)vmMgrInfo.generateVmConfig();
            fcNics = vmConfigType.getNics();
        }
        this.logger.trace((Object)(this.debug + "getFcNicList leave."));
        return fcNics;
    }

    public List<ResourcepoolVMServiceV2Stub.Nic> getFMNicList() {
        this.logger.trace((Object)(this.debug + "getFMNicList enter."));
        ArrayList<ResourcepoolVMServiceV2Stub.Nic> fmNics = new ArrayList<ResourcepoolVMServiceV2Stub.Nic>();
        VmMgrInfo vmMgrInfo = this.getPoMgrInfo();
        if (GalaxVM.VMProviderType.FM.getValue().equals(vmMgrInfo.getVmType())) {
            ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfigType = (ResourcepoolVMServiceV2Stub.VmConfigSetE)vmMgrInfo.generateVmConfig();
            ResourcepoolVMServiceV2Stub.Nic[] fmNicArray = vmConfigType.getNics();
            if (null == fmNicArray) {
                return fmNics;
            }
            for (ResourcepoolVMServiceV2Stub.Nic nic : fmNicArray) {
                fmNics.add(nic);
            }
        }
        this.logger.trace((Object)(this.debug + "getFMNicList leave."));
        return fmNics;
    }

    public String getVMProviderType() {
        this.logger.trace((Object)(this.debug + "getVMProviderType enter."));
        return this.getPoMgrInfo().getVmType();
    }

    public String getProviderSn() {
        this.logger.trace((Object)(this.debug + "getProviderSn enter."));
        return this.po.getProviderSN();
    }

    public void updateMgrinfo(VmMgrInfo vmMgr) {
        if (VerifyUtil.isEmpty((Object)this.po) || VerifyUtil.isEmpty((Object)((Object)vmMgr))) {
            this.logger.error((Object)"po or po's manage information is null");
            return;
        }
        HashMap extendInfo = new HashMap();
        FixLengthProps props = new FixLengthProps(extendInfo, 8192);
        String vmMgrStr = CommonUtil.beanToJson((Object)((Object)vmMgr));
        props.setProp(PoExParamsEnum.VM_MGR_INFO.getValue(), vmMgrStr);
        this.po.getProps().putAll(extendInfo);
        this.logger.trace((Object)(this.debug + "update leave."));
    }
}

