/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.DsRpParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateDatastoreRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateDatastoreResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;

public class CreateDsCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(CreateDsCmd.class);
    private String hostUrn;
    private String lunUrn;
    private String dsName;
    private Map<String, String> wwnMap;
    private String storageType;
    private String confidentialityLevel;

    public CreateDsCmd(String siteId, String vrmSn, Map<String, Object> params) {
        super(siteId, vrmSn);
        this.hostUrn = (String)params.get(DsRpParamsEnum.HOST_URN.getValue());
        this.lunUrn = (String)params.get(DsRpParamsEnum.LUN_URN.getValue());
        this.dsName = (String)params.get(DsRpParamsEnum.DS_NAME.getValue());
        this.storageType = (String)params.get(DsRpParamsEnum.DS_TYPE.getValue());
        this.wwnMap = (Map)params.get(DsRpParamsEnum.LUN_WWN_MAP.getValue());
        this.confidentialityLevel = (String)params.get(DsRpParamsEnum.DS_CONFIDENTIALITY_LEVEL.getValue());
    }

    public CloudPlatformResponse excute(Object ... params) {
        return this.excuteCmd();
    }

    private CloudPlatformResponse excuteCmd() {
        CreateDatastoreRequestType request = new CreateDatastoreRequestType();
        request.setHostUrn(this.hostUrn);
        if (!VerifyUtil.isEmpty((String)this.confidentialityLevel)) {
            request.setConfidentialityLevel(this.confidentialityLevel);
        }
        if (this.lunUrn != null) {
            request.setStorageUnitUrn(this.lunUrn);
        }
        request.setName(this.dsName);
        if ("LUN".equals(this.storageType)) {
            request.setUseType(Integer.valueOf(2));
        }
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject((String)this.getCloudSn());
        logger.info((Object)"Execute create datastore, vrmInfo=%s, request=%s.", new Object[]{vrmInfo, request});
        CreateDatastoreResponseType response = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).createDatastore(vrmInfo, request);
        if (response == null) {
            logger.error((Object)"Failed to execute cmd, response is null.");
            CloudPlatformResponse cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        cloudResponse.getExtendParam().put(DsRpParamsEnum.DS_URI.getValue(), response.getUri());
        cloudResponse.getExtendParam().put(DsRpParamsEnum.FC_SN.getValue(), this.getCloudSn());
        logger.info((Object)"result of create datastore is %s.", new Object[]{cloudResponse});
        return cloudResponse;
    }

    public String getHostUrn() {
        return this.hostUrn;
    }

    public Map<String, String> getWwnMap() {
        return this.wwnMap;
    }
}

