/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class DeleteDsCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(DeleteDsCmd.class);
    private static final int MAX_DELETE_TIMES = 60;
    private static final int MAX_DELETE_INTERVAL = 10000;
    private static final String DATASTORE_IN_USING_ERROR_CODE = "10410017";
    private static final String DATASTORE_IS_DELETING_ERROR_CODE = "10410054";
    private static final String DATASTORE_IS_DEASSOCIATING_ERROR_CODE = "10410050";
    private String hostUrn;
    private String datastoreUri;

    public DeleteDsCmd(String siteId, String vrmSn, String hostUrn, String datastoreUri) {
        super(siteId, vrmSn);
        this.hostUrn = hostUrn;
        this.datastoreUri = datastoreUri;
    }

    public CloudPlatformResponse excute(Object ... params) {
        CloudPlatformResponse response = null;
        for (int i = 0; i <= 60 && !this.handleDeleteDataStoreTaskErrorCode((response = this.excuteDelDs()).getErrorCode()); ++i) {
            CommonUtil.sleep((long)10000L);
        }
        return response;
    }

    private CloudPlatformResponse excuteDelDs() {
        CloudPlatformResponse cloudResponse;
        VMOperateResponseType response;
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(this.getSiteId());
        if (1 == site.getSiteType()) {
            String params = this.hostUrn + ";" + this.datastoreUri;
            logger.info((Object)("excute delete datastore to remote cloud, params=" + params + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
            response = (VMOperateResponseType)FsRecoveryUtil.excuteCmdToCloud((String)this.getSiteId(), (String)this.getCloudSn(), (String)params, (String)VmRecoveryCmdEnum.DELETE_DS.toString());
        } else {
            VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject((String)this.getCloudSn());
            logger.info((Object)("excute delete datastore, vrmInfo=" + vrmInfo + ", hostUrn=" + this.hostUrn + ", datastoreUri=" + this.datastoreUri), 90160758786816L);
            response = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).deleteDatastore(vrmInfo, this.hostUrn, this.datastoreUri);
        }
        if (null == response) {
            logger.error((Object)"faild to excute cmd, response is null.", 90160758787071L);
            cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        logger.info((Object)("result of delete datastore is " + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private boolean handleDeleteDataStoreTaskErrorCode(String errorcode) {
        boolean result = true;
        if (!VerifyUtil.isEmpty((String)errorcode)) {
            if (errorcode.equals(DATASTORE_IN_USING_ERROR_CODE)) {
                logger.info((Object)"The datastore is in using, try again", 90160758786816L);
                result = false;
            } else if (errorcode.equals(DATASTORE_IS_DELETING_ERROR_CODE)) {
                logger.info((Object)"The datastore is deleting, try again", 90160758786816L);
                result = false;
            } else if (errorcode.equals(DATASTORE_IS_DEASSOCIATING_ERROR_CODE)) {
                logger.info((Object)"The datastore is deassociating, try again", 90160758786816L);
                result = false;
            } else {
                result = true;
            }
        }
        return result;
    }
}

