/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.HostStatusEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.HostMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmTaskType;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVRMDrManager;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.storage.recovery.command.exception.PowerOnHostFailedException;
import com.huawei.ism.drm.galax.util.common.task.constants.TaskExecuteStatus;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class QueryHostStatusCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(QueryHostStatusCmd.class);
    private String hostUri;
    private boolean isTaskSuccessed;

    public QueryHostStatusCmd(String siteId, String cloudSn, String hostUri) {
        super(siteId, cloudSn);
        this.hostUri = hostUri;
        this.isTaskSuccessed = false;
    }

    public CloudPlatformResponse excute(Object ... params) {
        logger.info((Object)"Query host status cmd enter.", 90160758786816L);
        if (!this.isTaskSuccessed && VerifyUtil.isEmpty((Object[])params)) {
            logger.error((Object)"isTaskSuccessed is false and params is null");
            throw new LegoCheckedException(-1L);
        }
        String taskId = (String)params[0];
        logger.info((Object)("Query host status start. hostUri=" + this.hostUri + ",taskId = " + taskId + ",isTaskSuccessed=" + this.isTaskSuccessed), 90160758786816L);
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject((String)this.getCloudSn());
        if (!this.isTaskSuccessed) {
            CloudPlatformResponse response = this.queryTask(taskId, vrmInfo);
            return response;
        }
        HostMsgsData host = ((IVRMDrManager)ServiceLocator.getInstance().getService(IVRMDrManager.class)).queryHost(vrmInfo, this.hostUri);
        CloudPlatformResponse response = new CloudPlatformResponse(null, null);
        logger.info((Object)("Query host response is " + CommonUtil.beanToJson((Object)host)), 90160758786816L);
        if (host != null && HostStatusEnum.NORMAL.getValue().equalsIgnoreCase(host.getStatus())) {
            response.setFinished(true);
            response.setSuccess(true);
        } else if (host != null && HostStatusEnum.BOOTING.getValue().equalsIgnoreCase(host.getStatus())) {
            response.setFinished(false);
            response.setSuccess(false);
        } else {
            throw new PowerOnHostFailedException();
        }
        return response;
    }

    private CloudPlatformResponse queryTask(String taskId, VrmObject vrmInfo) {
        VrmTaskType taskResult = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).describeTasks(vrmInfo, taskId);
        if (null == taskResult) {
            throw new PowerOnHostFailedException();
        }
        CloudPlatformResponse response = new CloudPlatformResponse(taskResult.getUri(), taskResult.getReason());
        if (taskResult.getStatus().equals(TaskExecuteStatus.success.name())) {
            this.isTaskSuccessed = true;
            response.setFinished(false);
            response.setSuccess(false);
        } else if (taskResult.getStatus().equals(TaskExecuteStatus.failed.name())) {
            response.setFinished(true);
            response.setSuccess(false);
        } else {
            response.setFinished(false);
            response.setSuccess(false);
        }
        return response;
    }
}

