/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.impl;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.constant.cloudenum.CloudParamType;
import com.huawei.ism.drm.galax.constant.cloudenum.FcRegisterVmType;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.command.exception.FindNoResourceMappingCheckedException;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractRegisterVmCmd;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.TestNetworkSetting;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.RegisterVMRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmCustomization;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.recovery.command.exception.RegisterVmFindNoLunCheckedException;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegisterVmCmd
extends AbstractRegisterVmCmd {
    private static final Log LOGGER = LogFactory.getInstance(RegisterVmCmd.class);
    private Map<String, String> globalSetting;
    private int procType;
    private int planType;
    private ProtectObject po;

    public RegisterVmCmd(RecoveryPlatformInfo platformInfo, VmMgrInfo vmMgrInfo, Map<String, String> globalSetting, Set<RecoverySetting> recoverySetting, int procType, int planType) {
        super(platformInfo, (VmMgrInfoBase)vmMgrInfo, recoverySetting);
        this.globalSetting = globalSetting;
        this.procType = procType;
        this.planType = planType;
        if (this.isUseGlobalSettingForLocal()) {
            this.initLocationByGlobalSetting();
        } else {
            this.initLocationByResourceMapping();
        }
    }

    private RegisterVmCmd(RegisterVmCmdBuilder builder) {
        super(builder.platformInfo, (VmMgrInfoBase)builder.vmMgrInfo, builder.recoverySetting);
        this.globalSetting = builder.globalSetting;
        this.procType = builder.procType;
        this.planType = builder.planType;
        this.po = builder.po;
        if (this.isUseGlobalSettingForLocal()) {
            this.initLocationByGlobalSetting();
        } else {
            this.initLocationByResourceMapping();
        }
    }

    protected void fillRegisterVMRequest(RegisterVMRequestType registerRequest, VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter fillRegisterVMRequest.");
        super.fillRegisterVMRequest(registerRequest, vrmInfo);
        if (this.globalSetting.containsKey("FSB_MANAGEMENT_IP_MAP")) {
            registerRequest.setRegisterType(Integer.valueOf(FcRegisterVmType.FSBReplication.getType()));
        } else {
            registerRequest.setRegisterType(Integer.valueOf(FcRegisterVmType.StorageReplication.getType()));
        }
        LOGGER.debug((Object)"Leave fillRegisterVMRequest");
    }

    private boolean updateTestNetworkFromRecoverySetting(VmConfigNicType fcNic, ResourcepoolVMServiceV2Stub.VMNic fmNic, String netId) {
        LOGGER.debug((Object)"Enter updateTestNetworkFromRecoverySetting.");
        if (this.isUseGlobalSettingForLocal()) {
            if (fcNic != null) {
                return this.updatePortGroupForLocal(fcNic, netId);
            }
            if (fmNic != null) {
                return this.updateNetworkForLocal(fmNic, netId);
            }
            LOGGER.debug((Object)"Leave updateTestNetworkFromRecoverySetting.");
            return false;
        }
        return this.updateNetworkForReplication(fcNic, fmNic, netId);
    }

    protected void updateVmInfoByRecoverySetting(RegisterVMRequestType request) {
        LOGGER.debug((Object)"Enter updateVmInfoByRecoverySetting.");
        if (VerifyUtil.isEmpty((Collection)this.getRecoverySetting())) {
            return;
        }
        for (RecoverySetting setting : this.getRecoverySetting()) {
            if (!"NicInfo".equals(setting.getName())) continue;
            VmCustomization customization = this.getNicCustomSetting(request.getName(), request.getVmConfig().getNics(), setting);
            customization.setOsType(request.getOsOptions().getOsType());
            request.setVmCustomization(customization);
        }
        LOGGER.debug((Object)"Leave updateVmInfoByRecoverySetting.");
    }

    protected void updateVmConfig(VmConfigType vmConfigType) {
        LOGGER.debug((Object)"Enter updateVmConfig.");
        this.configVmNic(vmConfigType);
        List disks = vmConfigType.getDisks();
        if (disks == null || disks.isEmpty()) {
            LOGGER.info((Object)"The disks is null!");
            return;
        }
        this.filterUnprotectedDisks(disks);
        int diskNum = 0;
        for (VmConfigDiskType disk : disks) {
            LOGGER.info((Object)"The %s th disk start to update datastore urn: %s.", new Object[]{diskNum, disk.getDatastoreUrn()});
            JSONObject diskNameMap = null;
            JSONObject fsbIpMap = null;
            JSONObject poolIdMap = null;
            if (this.globalSetting.containsKey("DRILLING_DISK_NAME_MAP")) {
                diskNameMap = JSONObject.fromObject((Object)this.globalSetting.get("DRILLING_DISK_NAME_MAP"));
            }
            if (this.globalSetting.containsKey("FSB_MANAGEMENT_IP_MAP")) {
                fsbIpMap = JSONObject.fromObject((Object)this.globalSetting.get("FSB_MANAGEMENT_IP_MAP"));
            }
            if (this.globalSetting.containsKey("STORAGE_POOL_ID_MAP")) {
                poolIdMap = JSONObject.fromObject((Object)this.globalSetting.get("STORAGE_POOL_ID_MAP"));
            }
            if (fsbIpMap != null && poolIdMap != null) {
                JSONObject drExtParamsJson = JSONObject.fromObject((Object)disk.getDrExtParams());
                HashMap params = new HashMap();
                params.put("dsMgntIp", fsbIpMap.get(drExtParamsJson.get("dsMgntIp")));
                params.put("dsResourceId", poolIdMap.get(drExtParamsJson.get("dsResourceId")));
                JSONObject result = JSONObject.fromObject(params);
                ((VmConfigDiskType)vmConfigType.getDisks().get(diskNum)).setDrExtParams(result.toString());
                ((VmConfigDiskType)vmConfigType.getDisks().get(diskNum)).setDatastoreUrn(null);
                if (!VerifyUtil.isEmpty((Map)diskNameMap) && diskNameMap.containsKey(disk.getVolNameOnDev())) {
                    ((VmConfigDiskType)vmConfigType.getDisks().get(diskNum)).setVolNameOnDev((String)diskNameMap.get(disk.getVolNameOnDev()));
                }
                ((VmConfigDiskType)vmConfigType.getDisks().get(diskNum)).setVolumeUuid(((VmConfigDiskType)vmConfigType.getDisks().get(diskNum)).getVolNameOnDev());
            } else {
                this.updateDataStoreUrn(disk);
            }
            ++diskNum;
        }
        LOGGER.debug((Object)"Leave updateVmConfig.");
    }

    private void configVmNic(VmConfigType vmConfigType) {
        List nics = vmConfigType.getNics();
        for (VmConfigNicType nic : nics) {
            if (this.isLocalRollback()) continue;
            String pgUrn = nic.getPortGroupUrn();
            if (this.procType != DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || !this.updateTestNetworkFromRecoverySetting(nic, null, pgUrn)) {
                String productSiteId = null == this.globalSetting.get("PRODUCT_SITE_ID") ? null : this.globalSetting.get("PRODUCT_SITE_ID");
                String recoverySiteId = null == this.globalSetting.get("SELECT_DISASTER_SITE_KEY") ? null : this.globalSetting.get("SELECT_DISASTER_SITE_KEY");
                ResourceMapping res = FsRecoveryUtil.getResourceMapping((String)pgUrn, (int)ResTypeEnum.PORT_GROUP.getResType(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
                if (res == null) {
                    LOGGER.error((Object)"Failed to get resourceMapping, portGroupUrn: %s.", new Object[]{nic.getPortGroupUrn()});
                    throw new FindNoResourceMappingCheckedException();
                }
                nic.setPortGroupName(res.getRecoveryResourceName());
                nic.setPortGroupUrn(res.getRecoveryResourceId());
            }
            if (nic.getSequenceNum() != null) continue;
            int num = this.querySequenceNum(nics);
            nic.setSequenceNum(Integer.valueOf(num));
        }
    }

    private void updateDataStoreUrn(VmConfigDiskType disk) {
        LOGGER.debug((Object)"Enter updateDataStoreUrn.");
        DataStore ds = this.getRecDsByProDsUrn(disk.getDatastoreUrn());
        disk.setDatastoreUrn(ds.getUrn());
        LOGGER.debug((Object)"Leave updateDataStoreUrn.");
    }

    private DataStore getRecDsByProDsUrn(String dsUrn) {
        LOGGER.debug((Object)"Enter getRecDsByProDsUrn.");
        List lunWwns = (List)this.getVmMgrInfo().getMapSrcdsurnToLunId().get(dsUrn);
        if (VerifyUtil.isEmpty((Collection)lunWwns)) {
            LOGGER.info((Object)"The lunWwns is null. datastore urn is : %s.", new Object[]{dsUrn});
            throw new RegisterVmFindNoLunCheckedException();
        }
        VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)this.getVrmSn());
        DataStore ds = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).queryDataStoreByWWN(vrmInfo, (String)lunWwns.get(0));
        if (ds == null) {
            LOGGER.info((Object)"Failed to update Disk's dsUrn:%s.", new Object[]{dsUrn});
            throw new RegisterVmFindNoLunCheckedException();
        }
        LOGGER.debug((Object)"Leave getRecDsByProDsUrn.");
        return ds;
    }

    protected void updateVmInfo(ResourcepoolVMServiceV2Stub.VMInfo vmInfo) {
        LOGGER.debug((Object)"Enter updateVmInfo.");
        super.updateVmInfo(vmInfo);
        vmInfo.setRegisterType(FcRegisterVmType.StorageReplication.getType());
        LOGGER.debug((Object)"Leave updateVmInfo.");
    }

    protected void findVpcId() {
        LOGGER.debug((Object)"Enter findVpcId.");
        String oldVpcId = (String)this.getVmMgrInfo().getExtendParams().get(CloudParamType.VPC_ID.getValue());
        if (oldVpcId == null) {
            return;
        }
        if (this.isLocalRollback()) {
            this.setVpcId(oldVpcId);
            return;
        }
        oldVpcId = FmUtils.getFmResourceUrn((String)this.getProCloudSn(), (String)VPC.class.getSimpleName(), (String)oldVpcId);
        LOGGER.info((Object)"Param oldVpcId = %s.", new Object[]{oldVpcId});
        if (this.isUseGlobalSettingForLocal()) {
            this.initVpcIdByForLocal(oldVpcId);
        } else {
            this.initVpcIdByForReplication(oldVpcId);
        }
        LOGGER.debug((Object)"Leave findVpcId.");
    }

    protected void updateFmNicForNetwork(ResourcepoolVMServiceV2Stub.VMNic vmNic, ResourcepoolVMServiceV2Stub.Nic nic) {
        LOGGER.debug((Object)"Enter updateFmNicForNetwork.");
        if (this.isLocalRollback()) {
            vmNic.setPostNetworkId(nic.getNetworkid());
        } else {
            this.updateFmNetWorkForNoLocal(vmNic, nic);
        }
        LOGGER.debug((Object)"Leave updateFmNicForNetwork.");
    }

    protected void updateFmNicForSgPort(ResourcepoolVMServiceV2Stub.VMNic vmNic, ResourcepoolVMServiceV2Stub.Nic nic) {
        LOGGER.debug((Object)"Enter updateFmNicForSgPort.");
        vmNic.setSgIdPost(this.isLocalRollback() ? nic.getSgId() : this.getRecSgId(nic.getSgId()));
    }

    private String getRecSgId(String proSgId) {
        LOGGER.debug((Object)"trace message");
        if (proSgId == null || "-1".equals(proSgId)) {
            LOGGER.info((Object)"Failed to get rm by SECURITY_GROUP because nic is not in sg.", 90160758786816L);
            return proSgId;
        }
        return this.isUseGlobalSettingForLocal() ? this.getSecurityGroupForLocal(proSgId) : this.getSecurityGroupForReplication(proSgId);
    }

    protected void updateDisk(ResourcepoolVMServiceV2Stub.Disk disk) {
        LOGGER.debug((Object)"trace message");
        DataStore ds = this.getRecDsByProDsUrn(disk.getDataStoreURN());
        disk.setDataStoreURN(ds.getUrn());
        LOGGER.debug((Object)"trace message");
    }

    private boolean isUseGlobalSettingForLocal() {
        LOGGER.debug((Object)"trace message");
        return DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == this.planType || this.isLocalRollback();
    }

    private void initLocationByResourceMapping() {
        LOGGER.debug((Object)"Enter initLocationByResourceMapping.");
        String productSiteId = null == this.globalSetting.get("PRODUCT_SITE_ID") ? null : this.globalSetting.get("PRODUCT_SITE_ID");
        String recoverySiteId = null == this.globalSetting.get("SELECT_DISASTER_SITE_KEY") ? null : this.globalSetting.get("SELECT_DISASTER_SITE_KEY");
        ResourceMapping res = FsRecoveryUtil.getResourceMapping((String)this.getVmMgrInfo().getLocation(), (boolean)this.getVmMgrInfo().isHostLoc(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        if (res != null) {
            this.setLocation(res.getRecoveryResourceId());
            this.setVrmSn(res.getRecoveryResourceProviderId());
        }
        LOGGER.debug((Object)"Leave initLocationByResourceMapping.");
    }

    private void initLocationByGlobalSetting() {
        LOGGER.debug((Object)"Enter initLocationByGlobalSetting.");
        if (this.isLocalRollback()) {
            this.setLocation(this.getVmMgrInfo().getLocation());
        } else {
            JSONObject clusterSetting = this.getJsonObjectFromArray("testHostCluster", "srcHostClusterId", this.getVmMgrInfo().getLocation());
            if (clusterSetting != null) {
                this.setLocation(clusterSetting.getString("remoteHostClusterId"));
            }
        }
        if (!VerifyUtil.isEmpty((String)this.getLocation())) {
            ManagedObject mo = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ManagedObject.class, "uuid", (Object)this.getLocation());
            this.setVrmSn(mo != null ? mo.getTopMoUuid() : null);
        }
        LOGGER.debug((Object)"Leave initLocationByGlobalSetting.");
    }

    private JSONObject getJsonObjectFromArray(String parentKey, String subKey, String subKeyValue) {
        LOGGER.debug((Object)"Enter getJsonObjectFromArray.");
        String parentSetting = this.globalSetting.get(parentKey);
        if (VerifyUtil.isEmpty((String)parentSetting)) {
            LOGGER.error((Object)"Can not get the goal setting.");
            return null;
        }
        try {
            JSONArray jsonArray = JSONArray.fromObject((Object)parentSetting);
            if (jsonArray == null || jsonArray.isEmpty()) {
                return null;
            }
            JSONObject oldSetting = null;
            for (int idx = 0; idx < jsonArray.size(); ++idx) {
                JSONObject tempJson = jsonArray.getJSONObject(idx);
                if (!subKeyValue.equals(tempJson.getString(subKey))) continue;
                oldSetting = tempJson;
                break;
            }
            LOGGER.debug((Object)"Leave getJsonObjectFromArray.");
            return oldSetting;
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Parse info catch json exception, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            return null;
        }
    }

    private boolean updateNetworkForReplication(VmConfigNicType fcNic, ResourcepoolVMServiceV2Stub.VMNic fmNic, String pgId) {
        LOGGER.debug((Object)"Enter updateNetworkForReplication.");
        if (VerifyUtil.isEmpty(this.globalSetting) || VerifyUtil.isEmpty((String)this.globalSetting.get("TestNetwork"))) {
            return false;
        }
        List testNetworks = (List)CommonUtil.json2Bean((String)this.globalSetting.get("TestNetwork"), TestNetworkSetting[].class);
        for (TestNetworkSetting testNet : testNetworks) {
            if (!pgId.equals(testNet.getProNetworkUrn()) || VerifyUtil.isEmpty((String)testNet.getTestNetworkUrn())) continue;
            if (fcNic != null) {
                fcNic.setPortGroupUrn(testNet.getTestNetworkUrn());
                fcNic.setPortGroupName(testNet.getTestNetworkName());
                return true;
            }
            if (fmNic == null) continue;
            fmNic.setPostNetworkId(FmUtils.getCommonObjectId((String)testNet.getTestNetworkUrn(), (String)FmNetwork.class.getSimpleName()));
            return true;
        }
        LOGGER.debug((Object)"Leave updateNetworkForReplication.");
        return false;
    }

    private boolean updatePortGroupForLocal(VmConfigNicType fcNic, String portGroupId) {
        String testPgUrn;
        LOGGER.debug((Object)"Enter updatePortGroupForLocal.");
        JSONObject tempJson = this.getJsonObjectFromArray("testPortGroup", "srcPortGroupId", portGroupId);
        if (tempJson != null && !VerifyUtil.isEmpty((String)(testPgUrn = tempJson.getString("remotePortGroupId")))) {
            fcNic.setPortGroupUrn(testPgUrn);
            fcNic.setPortGroupName(tempJson.getString("remotePortGroupName"));
            return true;
        }
        LOGGER.debug((Object)"Leave updatePortGroupForLocal.");
        return false;
    }

    private boolean updateNetworkForLocal(ResourcepoolVMServiceV2Stub.VMNic fmNic, String networkId) {
        String testPgUrn;
        LOGGER.debug((Object)"Enter updateNetworkForLocal.");
        String oldNetworkId = FmUtils.getFmResourceUrn((String)this.getProCloudSn(), (String)FmNetwork.class.getSimpleName(), (String)networkId);
        JSONObject tempJson = this.getJsonObjectFromArray("testNetwork", "srcNetworkId", oldNetworkId);
        if (tempJson != null && !VerifyUtil.isEmpty((String)(testPgUrn = tempJson.getString("remoteNetworkId")))) {
            fmNic.setPostNetworkId(FmUtils.getCommonObjectId((String)testPgUrn, (String)FmNetwork.class.getSimpleName()));
            return true;
        }
        LOGGER.debug((Object)"Leave updateNetworkForLocal.");
        return false;
    }

    private String getSecurityGroupForReplication(String proSgId) {
        LOGGER.debug((Object)"Enter getSecurityGroupForReplication.");
        String sgIdPro = FmUtils.getFmResourceUrn((String)this.getProCloudSn(), (String)SecurityGroup.class.getSimpleName(), (String)proSgId);
        String productSiteId = null == this.globalSetting.get("PRODUCT_SITE_ID") ? null : this.globalSetting.get("PRODUCT_SITE_ID");
        String recoverySiteId = null == this.globalSetting.get("SELECT_DISASTER_SITE_KEY") ? null : this.globalSetting.get("SELECT_DISASTER_SITE_KEY");
        ResourceMapping rmSg = FsRecoveryUtil.getResourceMapping((String)sgIdPro, (int)ResTypeEnum.SECURITY_GROUP.getResType(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        if (rmSg == null) {
            LOGGER.error((Object)"Failed to get rm by SECURITY_GROUP: %s.", new Object[]{proSgId});
            throw new FindNoResourceMappingCheckedException();
        }
        LOGGER.debug((Object)"Leave getSecurityGroupForReplication.");
        return FmUtils.getCommonObjectId((String)rmSg.getRecoveryResourceId(), (String)SecurityGroup.class.getSimpleName());
    }

    private String getSecurityGroupForLocal(String proSgId) {
        LOGGER.debug((Object)"Enter getSecurityGroupForLocal.");
        String sgIdPro = FmUtils.getFmResourceUrn((String)this.getProCloudSn(), (String)SecurityGroup.class.getSimpleName(), (String)proSgId);
        JSONObject tempJson = this.getJsonObjectFromArray("testSecurityGroup", "srcSecurityGroupId", sgIdPro);
        if (tempJson != null) {
            return FmUtils.getCommonObjectId((String)tempJson.getString("remoteSecurityGroupId"), (String)SecurityGroup.class.getSimpleName());
        }
        LOGGER.error((Object)"Can not find the securuty group info mapping, sgId=%s.", new Object[]{proSgId});
        throw new LegoCheckedException(1073947393L);
    }

    private void initVpcIdByForReplication(String oldVpcId) {
        LOGGER.debug((Object)"Enter initVpcIdByForReplication.");
        String productSiteId = null == this.globalSetting.get("PRODUCT_SITE_ID") ? null : this.globalSetting.get("PRODUCT_SITE_ID");
        String recoverySiteId = null == this.globalSetting.get("SELECT_DISASTER_SITE_KEY") ? null : this.globalSetting.get("SELECT_DISASTER_SITE_KEY");
        ResourceMapping rm = FsRecoveryUtil.getResourceMapping((String)oldVpcId, (int)ResTypeEnum.NETWORK.getResType(), (String)"productVpcId", (String)productSiteId, (String)recoverySiteId);
        if (rm != null) {
            this.setVpcId(FmUtils.getCommonObjectId((String)rm.getRecoveryVpcId(), (String)VPC.class.getSimpleName()));
            LOGGER.info((Object)"The newVpcId = %s.", new Object[]{this.getVpcId()});
        } else {
            LOGGER.error((Object)"The rm null!!! oldVpcId=%s, productSiteId=%s, recoverySiteId=%s.", new Object[]{oldVpcId, productSiteId, recoverySiteId});
        }
        LOGGER.debug((Object)"Leave initVpcIdByForReplication.");
    }

    private void initVpcIdByForLocal(String oldVpcId) {
        LOGGER.debug((Object)"trace message");
        if (this.isLocalRollback()) {
            this.setVpcId(oldVpcId);
        } else {
            JSONObject tempJson = this.getJsonObjectFromArray("testNetwork", "srcVPCId", oldVpcId);
            if (tempJson != null) {
                this.setVpcId(FmUtils.getCommonObjectId((String)tempJson.getString("remoteVPCId"), (String)VPC.class.getSimpleName()));
            } else {
                LOGGER.error((Object)"can not find the vpc mapping info, oldVpc=%s.", new Object[]{oldVpcId});
            }
        }
        LOGGER.debug((Object)"trace message");
    }

    private void updateFmNetWorkForNoLocal(ResourcepoolVMServiceV2Stub.VMNic vmNic, ResourcepoolVMServiceV2Stub.Nic nic) {
        LOGGER.debug((Object)"Enter updateFmNetWorkForNoLocal.");
        if (this.procType != DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || !this.updateTestNetworkFromRecoverySetting(null, vmNic, nic.getNetworkid())) {
            LOGGER.info((Object)"Come in find rm,nic.getNetworkid():%s.", new Object[]{nic.getNetworkid()});
            String netWorkKey = FmUtils.getFmResourceUrn((String)this.getProCloudSn(), (String)FmNetwork.class.getSimpleName(), (String)nic.getNetworkid());
            String productSiteId = null == this.globalSetting.get("PRODUCT_SITE_ID") ? null : this.globalSetting.get("PRODUCT_SITE_ID");
            String recoverySiteId = null == this.globalSetting.get("SELECT_DISASTER_SITE_KEY") ? null : this.globalSetting.get("SELECT_DISASTER_SITE_KEY");
            ResourceMapping rm = FsRecoveryUtil.getResourceMapping((String)netWorkKey, (int)ResTypeEnum.NETWORK.getResType(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
            if (rm == null) {
                LOGGER.error((Object)"Failed to get rm by netWorkId: %s.", new Object[]{nic.getNetworkid()});
                throw new FindNoResourceMappingCheckedException();
            }
            String postNetWorkId = FmUtils.getCommonObjectId((String)rm.getRecoveryResourceId(), (String)FmNetwork.class.getSimpleName());
            vmNic.setPostNetworkId(postNetWorkId);
            this.setVpcId(FmUtils.getCommonObjectId((String)rm.getRecoveryVpcId(), (String)VPC.class.getSimpleName()));
            LOGGER.info((Object)"Po(%s)'s networkId is: %s and vpcId is: %s.", new Object[]{this.getVmMgrInfo().getName(), postNetWorkId, this.getVpcId()});
        }
        LOGGER.debug((Object)"Leave updateFmNetWorkForNoLocal.");
    }

    private boolean isLocalRollback() {
        LOGGER.debug((Object)"trace message");
        return this.procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue();
    }

    private void filterUnprotectedDisks(List<VmConfigDiskType> disks) {
        if (this.po == null) {
            return;
        }
        ProtectGroup pg = this.po.getProtectGroup();
        if (pg == null) {
            return;
        }
        if (pg.getTemplate().getType() != 33 && pg.getTemplate().getType() != 39) {
            return;
        }
        Set replicaList = this.po.getProtectGroup().getReplicaList();
        HashSet srcStorageIds = new HashSet();
        replicaList.forEach(protectGroupReplica -> {
            Set replicas = protectGroupReplica.getReplicas();
            replicas.forEach(protectObjectReplica -> {
                Set storageInfos = protectObjectReplica.getStorageInfos();
                storageInfos.forEach(storageInfo -> {
                    String key = CommUtil.combineString((String[])new String[]{storageInfo.getSrcStorageProviderSN(), storageInfo.getSrcStorageId()});
                    srcStorageIds.add(key);
                });
            });
        });
        HashSet<String> deviceNameAndResourceNames = new HashSet<String>();
        HashSet<String> allDeviceNameAndResourceNames = new HashSet<String>();
        Set usedStorageResourceSet = this.po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
            allDeviceNameAndResourceNames.add(protectObjectStorageInfo.getResourceName());
            if (srcStorageIds.contains(CommUtil.combineString((String[])new String[]{protectObjectStorageInfo.getResourceProviderSN(), protectObjectStorageInfo.getResourceId()}))) continue;
            deviceNameAndResourceNames.add(protectObjectStorageInfo.getResourceName());
        }
        disks.removeIf(disk -> deviceNameAndResourceNames.contains(disk.getVolumeUuid()));
        disks.removeIf(disk -> !allDeviceNameAndResourceNames.contains(disk.getVolumeUuid()));
    }

    public static class RegisterVmCmdBuilder {
        private RecoveryPlatformInfo platformInfo;
        private VmMgrInfo vmMgrInfo;
        private Map<String, String> globalSetting;
        private Set<RecoverySetting> recoverySetting;
        private int procType;
        private int planType;
        private ProtectObject po;

        public RegisterVmCmdBuilder platformInfo(RecoveryPlatformInfo platformInfo) {
            this.platformInfo = platformInfo;
            return this;
        }

        public RegisterVmCmdBuilder vmMgrInfo(VmMgrInfo vmMgrInfo) {
            this.vmMgrInfo = vmMgrInfo;
            return this;
        }

        public RegisterVmCmdBuilder globalSetting(Map<String, String> globalSetting) {
            this.globalSetting = globalSetting;
            return this;
        }

        public RegisterVmCmdBuilder recoverySetting(Set<RecoverySetting> recoverySetting) {
            this.recoverySetting = recoverySetting;
            return this;
        }

        public RegisterVmCmdBuilder procType(int procType) {
            this.procType = procType;
            return this;
        }

        public RegisterVmCmdBuilder planType(int planType) {
            this.planType = planType;
            return this;
        }

        public RegisterVmCmdBuilder po(ProtectObject po) {
            this.po = po;
            return this;
        }

        public RegisterVmCmd build() {
            return new RegisterVmCmd(this);
        }
    }
}

