/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.impl;

import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.RefreshStorageResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RefreshStorageUnitRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;

public class ScanDsCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(ScanDsCmd.class);
    private static final long TEN_SECOND = 10000L;
    private static final String HOST_IS_SCANNING_DS = "10410023";
    private String hostUrn;

    public ScanDsCmd(String siteId, String vrmSn, String hostUrn) {
        super(siteId, vrmSn);
        this.hostUrn = hostUrn;
    }

    public CloudPlatformResponse excute(Object ... params) {
        CloudPlatformResponse cloudResponse = this.excuteCmd();
        long scanTimes = LegoBaseConfig.getInstance().getNumber("scan.task.times", -1L);
        while (HOST_IS_SCANNING_DS.equals(cloudResponse.getErrorCode())) {
            if (scanTimes == 0L) {
                cloudResponse = new CloudPlatformResponse(null, null);
                cloudResponse.setFinished(true);
                cloudResponse.setSuccess(false);
                return cloudResponse;
            }
            logger.error((Object)("Failed to get scanning task,cloudResponse is:" + cloudResponse), 90160758787071L);
            CommonUtil.sleep((long)10000L);
            cloudResponse = this.excuteCmd();
            if (scanTimes <= 0L) continue;
            --scanTimes;
        }
        return cloudResponse;
    }

    private CloudPlatformResponse excuteCmd() {
        RefreshStorageUnitRequestType request = new RefreshStorageUnitRequestType();
        request.setHostUrn(this.hostUrn);
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject((String)this.getCloudSn());
        logger.info((Object)("excute scan datastore, vrmInfo=" + vrmInfo + ", hostUrn=" + this.hostUrn), 90160758786816L);
        RefreshStorageResponseType response = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).refreshStorageUnitByHost(vrmInfo, request);
        if (null == response) {
            logger.error((Object)"faild to excute cmd, response is null.", 90160758787071L);
            CloudPlatformResponse cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        logger.info((Object)("result of excute scan datastore, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }
}

