/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.FmScanCriteriaEnum;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.storage.manager.CloudPlatformServiceManager;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class ScanHyperVCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(ScanHyperVCmd.class);
    private String hyperVId;

    public ScanHyperVCmd(String siteId, String cloudSn, String hyperVId) {
        super(siteId, cloudSn);
        this.hyperVId = hyperVId;
    }

    public CloudPlatformResponse excute(Object ... params) {
        FmObject fo = FmUtils.generateFmObj((String)this.getCloudSn());
        String taskId = null;
        String errorCode = null;
        try {
            logger.info((Object)("excute scan hypervior, fo=" + fo + ", hyperVId=" + this.hyperVId), 90160758786816L);
            taskId = CloudPlatformServiceManager.getInstance().getFmRetriever().rescanHyperVRes(fo, this.hyperVId, FmScanCriteriaEnum.ALL.getScanType());
        }
        catch (FmBusinessException e) {
            logger.error((Object)"Failed to excute ScanHyperV Cmd.", (Throwable)e, 90160758787071L);
            errorCode = e.getErrorCode();
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        logger.info((Object)("result of excute scan hypervior is " + cloudResponse), 90160758786816L);
        return cloudResponse;
    }
}

