/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.command.parsor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.parse.BaseRecoveryCmdResParser;
import com.huawei.ism.drm.galax.storage.recovery.command.exception.PowerOnHostFailedException;
import com.huawei.ism.drm.galax.storage.recovery.command.exception.RegisterVmFindNoLunCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class RecoveryCmdResponseParser
extends BaseRecoveryCmdResParser {
    public static final String DS_NOT_EXIST = "10410006";
    private static final Log logger = LogFactory.getInstance(RecoveryCmdResponseParser.class);
    private static final String DS_IS_EMPTY_ERROR_CODE = "10410055";
    private static final String DS_EXICT_ERRCODE = "10410049";

    public RecoveryCmdResponseParser(GalaxBaseSubRecoveryProcessor processor) {
        super(processor);
        this.addIgnoreErrorCode(DS_EXICT_ERRCODE);
        this.addIgnoreErrorCode(DS_IS_EMPTY_ERROR_CODE);
        this.addIgnoreErrorCode(DS_NOT_EXIST);
    }

    public RecoveryCmdResponseParser(GalaxBaseSubRecoveryProcessor processor, List<String> ignoreErrorCodeList) {
        super(processor, ignoreErrorCodeList);
    }

    public boolean paserException(Exception e) {
        if (e instanceof RegisterVmFindNoLunCheckedException) {
            logger.error((Object)"Failed to find vm's lun when registering vm.", (Throwable)e, 90160758787071L);
            this.getProcessor().updateProcessDetail("ism.drm.recovery.registervm.vrm.nolun", new String[0]);
            this.getProcessor().setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.getProcessor().endRecoveryProcessor();
        } else if (e instanceof PowerOnHostFailedException) {
            logger.error((Object)"Failed to power on the host.", (Throwable)e, 90160758787071L);
            this.getProcessor().updateProcessDetail("ism.drm.recovery.process.poweron.host.failed", new String[0]);
            this.getProcessor().setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.getProcessor().endRecoveryProcessor();
        } else {
            super.paserException(e);
        }
        return true;
    }
}

