/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.common;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.recovery.common.ProtectObjectUtils;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class StartupSettingUtils {
    private static final String CONFIG_TO_SINGLE_PO = "0";
    private static final Log logger = LogFactory.getInstance(StartupSettingUtils.class);

    private StartupSettingUtils() {
    }

    public static void configStartupSetting(String poId, String pgId, String isStartup, String startupNo, String setToOthers, RecoveryPlan plan) {
        if (!StartupSettingUtils.checkParams(poId, pgId, startupNo, isStartup, startupNo, setToOthers) || plan == null) {
            logger.error((Object)"params: poId,pgId,isStartup,startupNo,setToOthers error or RecoveryPlan is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (ProtectObjectUtils.getProtectObjectInRecoveryPlan((RecoveryPlan)plan, (String)poId) == null) {
            logger.error((Object)"method: getProtectObjectInRecoveryPlan is null.");
            throw new LegoCheckedException(1073947394L);
        }
        Set vmRecoverySettings = plan.getRecoverySettings();
        if (VerifyUtil.isEmpty((Collection)vmRecoverySettings)) {
            logger.error((Object)"vmRecoverySettings is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        if (setToOthers.equals(CONFIG_TO_SINGLE_PO)) {
            StartupSettingUtils.configToSingleProtectObject(plan, poId, isStartup, startupNo);
        } else {
            StartupSettingUtils.configToSameRecoveryPlan(isStartup, startupNo, plan);
        }
    }

    private static boolean checkParams(String ... params) {
        for (String param : params) {
            if (!VerifyUtil.isEmpty((String)param)) continue;
            return false;
        }
        return true;
    }

    private static void configToSameRecoveryPlan(String isStartup, String startupNo, RecoveryPlan plan) {
        for (ProtectGroup pg : plan.getProtectGroups()) {
            for (ProtectObject po : pg.getPolist()) {
                StartupSettingUtils.configToSingleProtectObject(plan, po.getUuid(), isStartup, startupNo);
            }
        }
    }

    private static void configToSingleProtectObject(RecoveryPlan plan, String poId, String isStartup, String startupNo) {
        RecoverySetting poSetting = StartupSettingUtils.getVmStartupSetting(plan, poId);
        if (poSetting != null) {
            ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(ProtectObjectUtils.getProtectObjectInRecoveryPlan((RecoveryPlan)plan, (String)poId));
            if (poProxy.getPoMgrInfo().isTemplate()) {
                poSetting.setValue(String.valueOf(0));
            } else if (isStartup.equals(Boolean.TRUE.toString())) {
                poSetting.setValue(startupNo);
            } else {
                poSetting.setValue(String.valueOf(0));
            }
        }
    }

    public static RecoverySetting getVmStartupSetting(RecoveryPlan plan, String poId) {
        Set vmRecoverySettings = plan.getRecoverySettings();
        if (VerifyUtil.isEmpty((Collection)vmRecoverySettings)) {
            return null;
        }
        return StartupSettingUtils.getVmStartupSetting(vmRecoverySettings, poId);
    }

    private static RecoverySetting getVmStartupSetting(Set<RecoverySetting> vMRecoverySettings, String poId) {
        if (VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty(vMRecoverySettings)) {
            return null;
        }
        for (RecoverySetting setting : vMRecoverySettings) {
            if (!poId.equals(setting.getOwnerId()) || !"VmStartUpSetting".equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }
}

