/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.common;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.PhysicalStorageDevice;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.pg.model.HostMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.storage.entity.DsMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.HostMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryDBUtil;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VrmRecoveryUtil {
    private static Log logger = LogFactory.getInstance(VrmRecoveryUtil.class);
    private static String trace = "trace";

    public static String getVrmSnByPgForLocalTest(RecoveryPlan plan) {
        logger.trace((Object)(trace + "trace message"));
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        String cloudSn = pg.getPoProviderSN();
        String array = FsRecoveryUtil.getGlobalSettingFromPlan((RecoveryPlan)plan, (String)"testHostCluster");
        JSONObject jObject = VrmRecoveryUtil.getMappingSettingFromPlan(array, "srcCloudId", cloudSn);
        String newCloudSn = jObject.getString("remoteCloudId");
        if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(newCloudSn)) {
            return newCloudSn;
        }
        String newCLuster = jObject.getString("remoteHostClusterId");
        ManagedObject mo = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ManagedObject.class, "uuid", (Object)newCLuster);
        if (null == mo) {
            logger.error((Object)("can not find the cluster or host, urn=" + newCLuster), 90160758787071L);
            return null;
        }
        return mo.getTopMoUuid();
    }

    public static String getVrmSnByPgForLocalRollback(RecoveryPlan plan) {
        logger.trace((Object)(trace + "trace message"));
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        String cloudSn = pg.getPoProviderSN();
        if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(cloudSn)) {
            return cloudSn;
        }
        for (ProtectObject po : pg.getPolist()) {
            ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
            VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
            ManagedObject mo = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ManagedObject.class, "uuid", (Object)vmMgr.getLocation());
            if (null == mo) {
                logger.warn((Object)("can not find the cluster or host, urn=" + vmMgr.getLocation()), 90160758787071L);
                continue;
            }
            return mo.getTopMoUuid();
        }
        logger.error((Object)("there is no protect object in pg, urn=" + pg.getUuid()), 90160758787071L);
        return null;
    }

    public static VrmObject getRecoveryVrmObjectByMoId(Long moId) {
        logger.trace((Object)(trace + "trace message"));
        VRM vrm = ((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).getVrmByMoId(String.valueOf(moId));
        if (null == vrm) {
            return null;
        }
        NeMgrProtocolExtend extend = VrmUtil.getExtend((String)String.valueOf(vrm.getMoId()));
        return VrmUtil.generateVrmObj((NeMgrProtocolExtend)extend);
    }

    public static VrmObject getVrmObjectByHostUrn(String hostUrn) {
        logger.trace((Object)(trace + "trace message"));
        ComputeNode computeNode = VrmRecoveryDBUtil.getComputeNodeByHostUrn(hostUrn);
        if (computeNode != null) {
            VrmObject vrmObject = VrmRecoveryUtil.getRecoveryVrmObjectByMoId(computeNode.getParentId());
            return vrmObject;
        }
        return null;
    }

    public static List<StorageResource> getTgtResources(RecoveryProcessorContext context, ProtectGroup pg, String srcDsUrn, String siteId, Map<String, String> wwnMap) {
        logger.trace((Object)" trace message");
        PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(pg);
        DsMgrInfo dsMgr = null;
        for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
            if (!dsMgrInfo.getDsUrn().equals(srcDsUrn)) continue;
            dsMgr = (DsMgrInfo)dsMgrInfo;
            break;
        }
        if (null == dsMgr) {
            return null;
        }
        ProtectGroupReplica groupReplica = VrmRecoveryUtil.getGroupReplicaBySite(pg, siteId);
        if (null == groupReplica) {
            logger.error((Object)("pg has no replica, pgId=" + pg.getUuid()), 90160758787071L);
            return null;
        }
        ArrayList<StorageResource> storageResources = new ArrayList<StorageResource>();
        List wwns = dsMgr.getWwns();
        Set poReplicas = groupReplica.getReplicas();
        for (ProtectObjectReplica poReplica : poReplicas) {
            Set storageInfos = poReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageInfos) {
                if (!wwns.contains(storageInfo.getProtectObjectStorageWwn())) continue;
                VrmRecoveryUtil.dealNasOrLunWwn(context, storageInfo, storageResources, wwnMap);
            }
        }
        return storageResources;
    }

    public static ProtectGroupReplica getGroupReplicaBySite(ProtectGroup pg, String siteId) {
        logger.trace((Object)(trace + "trace message"));
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"parameter pg is null.", 90160758787071L);
            return null;
        }
        Set replicas = pg.getReplicaList();
        for (ProtectGroupReplica tmpReplica : replicas) {
            if (!tmpReplica.getRecoverySite().equals(siteId)) continue;
            return tmpReplica;
        }
        return null;
    }

    public static List<String> getLunWwnsByDs(ProtectObject po, String srcDsUrn) {
        logger.trace((Object)(trace + "trace message"));
        PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(po.getProtectGroup());
        for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
            if (!dsMgrInfo.getDsUrn().equals(srcDsUrn)) continue;
            return dsMgrInfo.getWwns();
        }
        return null;
    }

    public static String scanFmDs(RecoveryProcessorContext context, RecoveryPlan plan, boolean product) {
        logger.trace((Object)(trace + "trace message"));
        if (null == plan) {
            return null;
        }
        String vrmSn = null;
        Iterator iterator = plan.getProtectGroups().iterator();
        if (iterator.hasNext()) {
            ProtectGroup pg = (ProtectGroup)iterator.next();
            if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(pg.getPoProviderSN())) {
                logger.info((Object)"No need to scan fm ds.", 90160758786816L);
                return null;
            }
            String productSiteId = null == context.getAttribute("PRODUCT_SITE_ID") ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
            String recoverySiteId = null == context.getAttribute("SELECT_DISASTER_SITE_KEY") ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
            vrmSn = FsRecoveryUtil.getVrmSnByPg((ProtectGroup)pg, (boolean)product, (String)productSiteId, (String)recoverySiteId);
        }
        logger.info((Object)("Scan fm ds,and vrmSn is:" + vrmSn), 90160758786816L);
        if (null == vrmSn) {
            return null;
        }
        String siteId = VrmRecoveryUtil.getSiteIdFromPp(plan, product);
        String taskId = (String)FsRecoveryUtil.excuteCmdToCloud((String)siteId, vrmSn, null, (String)VmRecoveryCmdEnum.SCAN_FM_DS.toString());
        return taskId;
    }

    private static String getSiteIdFromPp(RecoveryPlan plan, boolean isProduct) {
        logger.trace((Object)(trace + "trace message"));
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(plan);
        String siteId = isProduct ? rpProxy.getProductSite() : rpProxy.getRecoverySite();
        return siteId;
    }

    public static JSONObject getMappingSettingFromPlan(String arrayValue, String key, String keyValue) {
        logger.trace((Object)(trace + "trace message"));
        if (VerifyUtil.isEmpty((String)arrayValue) || VerifyUtil.isEmpty((String)key) || VerifyUtil.isEmpty((String)keyValue)) {
            return new JSONObject();
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)arrayValue);
            if (null == array) {
                return new JSONObject();
            }
            for (int idx = 0; idx < array.size(); ++idx) {
                JSONObject jsonObject = array.getJSONObject(idx);
                if (!keyValue.equals(jsonObject.get(key))) continue;
                return jsonObject;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("parse mapping excption:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)"", (long)1073947393L, (String[])new String[0]);
        }
        return new JSONObject();
    }

    public static ResourceVO getResourceVO(String hostClusterId) {
        logger.trace((Object)(trace + "trace message"));
        ComputeNode cn = (ComputeNode)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ComputeNode.class, "urn", (Object)hostClusterId);
        if (null != cn) {
            return VrmRecoveryUtil.getHostVo(cn);
        }
        List cnList = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getListMo(ComputeNode.class, "computeClusterUrn", (Object)hostClusterId);
        if (VerifyUtil.isEmpty((Collection)cnList)) {
            return null;
        }
        HostGroupVO hostGroupVo = new HostGroupVO();
        hostGroupVo.setName("");
        ArrayList<HostVO> hostVos = new ArrayList<HostVO>();
        hostGroupVo.setId(hostClusterId);
        for (ComputeNode host : cnList) {
            HostVO hostVO = VrmRecoveryUtil.getHostVo(host);
            hostVos.add(hostVO);
        }
        hostGroupVo.setHostVOs(hostVos);
        return hostGroupVo;
    }

    private static HostVO getHostVo(ComputeNode host) {
        logger.trace((Object)(trace + "trace message"));
        List physicalDevices = CommonDAOLocator.getMoDao().getAllSubMo(host.getMoId().longValue(), PhysicalStorageDevice.class);
        HostVO hostVO = new HostVO();
        hostVO.setId(host.getUuid());
        hostVO.setName(host.getName());
        hostVO.setInitiators(VrmRecoveryUtil.getInitiators(physicalDevices));
        hostVO.setOsType(XveEnumDefinePParent.OS_TYPE_E.Linux.getValue());
        if (!VerifyUtil.isEmpty((String)host.getIp())) {
            hostVO.setIpAddress(host.getIp());
        } else {
            hostVO.setIpAddress("UnKnown");
        }
        return hostVO;
    }

    private static List<Initiator> getInitiators(List<PhysicalStorageDevice> physicalDevices) {
        logger.trace((Object)(trace + "trace message"));
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        for (PhysicalStorageDevice physicalDevice : physicalDevices) {
            Initiator initiator;
            if ("FC".equalsIgnoreCase(physicalDevice.getDeviceType())) {
                initiator = new Initiator();
                initiator.setHbaType("FC");
                initiator.setIdentity(physicalDevice.getStorageWwn());
                initiators.add(initiator);
                continue;
            }
            if (!"ISCSI".equalsIgnoreCase(physicalDevice.getDeviceType())) continue;
            initiator = new Initiator();
            initiator.setHbaType("ISCSI");
            initiator.setIdentity(physicalDevice.getStorageWwn());
            initiators.add(initiator);
        }
        return initiators;
    }

    public static List<HostMgrInfo> queryLocalTestHostMgrInfo(RecoveryPlan plan, List<HostMgrInfoBase> hosts) {
        logger.trace((Object)(trace + " trace message"));
        HashSet<String> hostClusters = new HashSet<String>();
        for (HostMgrInfoBase host : hosts) {
            hostClusters.add(null == host.getClusterUrn() ? host.getHostUrn() : host.getClusterUrn());
        }
        HashSet<String> remoteCluster = new HashSet<String>();
        String array = FsRecoveryUtil.getGlobalSettingFromPlan((RecoveryPlan)plan, (String)"testHostCluster");
        for (String hostCluster : hostClusters) {
            String hostCLuster;
            JSONObject jObject = VrmRecoveryUtil.getMappingSettingFromPlan(array, "srcHostClusterId", hostCluster);
            if (null == jObject || VerifyUtil.isEmpty((String)(hostCLuster = jObject.getString("remoteHostClusterId")))) continue;
            remoteCluster.add(hostCLuster);
        }
        return VrmRecoveryUtil.queryHostOrCLusterByUrn(remoteCluster);
    }

    public static List<HostMgrInfo> queryRollBackHostMgrInfo(List<HostMgrInfoBase> hosts) {
        logger.trace((Object)(trace + " trace message"));
        HashSet<String> hostClusters = new HashSet<String>();
        for (HostMgrInfoBase host : hosts) {
            hostClusters.add(null == host.getClusterUrn() ? host.getHostUrn() : host.getClusterUrn());
        }
        return VrmRecoveryUtil.queryHostOrCLusterByUrn(hostClusters);
    }

    private static List<HostMgrInfo> queryHostOrCLusterByUrn(Set<String> urns) {
        logger.trace((Object)(trace + " trace message"));
        ArrayList<HostMgrInfo> recHosts = new ArrayList<HostMgrInfo>();
        for (String urn : urns) {
            ComputeNode cn = (ComputeNode)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(ComputeNode.class, "urn", (Object)urn);
            if (null != cn) {
                recHosts.add(new HostMgrInfo(cn));
                continue;
            }
            List cnList = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getListMo(ComputeNode.class, "computeClusterUrn", (Object)urn);
            if (VerifyUtil.isEmpty((Collection)cnList)) continue;
            for (ComputeNode cNode : cnList) {
                recHosts.add(new HostMgrInfo(cNode));
            }
        }
        return recHosts;
    }

    private static void dealNasOrLunWwn(RecoveryProcessorContext context, RelicaStorageInfo storageInfo, List<StorageResource> storageResources, Map<String, String> wwnMap) {
        String[] wwnValue = storageInfo.getProtectObjectStorageWwn().split(":");
        if (wwnValue.length == 2) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(storageInfo.getStorageId());
            List storageResourceList = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResources(storageInfo.getStorageProviderSN(), list);
            if (VerifyUtil.isEmpty((Collection)storageResourceList)) {
                logger.error((Object)("can not get the Nas, devSn=" + storageInfo.getStorageProviderSN() + ", NasId=" + storageInfo.getStorageId()), 90160758787071L);
                return;
            }
            RecoveryPlan plan = context.getRecoveryPlan();
            String storageSrvIp = (String)plan.getGlobalSettings().get("nasSharePortIp");
            String sharePath = "/" + ((StorageResource)storageResourceList.iterator().next()).getName();
            storageResources.add((StorageResource)storageResourceList.iterator().next());
            String wwn = storageSrvIp + ":" + sharePath;
            wwnMap.put(storageInfo.getProtectObjectStorageWwn(), wwn);
        } else {
            Lun lun = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getLunBySnAndLunId(storageInfo.getStorageProviderSN(), storageInfo.getStorageId());
            if (null == lun) {
                logger.error((Object)("can not get the LUN, devSn=" + storageInfo.getStorageProviderSN() + ", lunId=" + storageInfo.getStorageId()), 90160758787071L);
                return;
            }
            storageResources.add((StorageResource)lun);
            wwnMap.put(storageInfo.getProtectObjectStorageWwn(), lun.getWwn());
        }
    }
}

