/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.DsRpParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.excuter.ProcessConcurrentExcuter;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.vrm.model.ChangeDsStorageUnitRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVRMDrManager;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.CreateDsCmd;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.CreateDataStoreSubProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.ScanHyperVResSubProcessor;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateDataStoreProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = 5033593649550697904L;
    private static final Log logger = LogFactory.getInstance(CreateDataStoreProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        this.setContextRef(context);
        RecoveryPlan recoveryPlan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        logger.info((Object)"[Create ds] Begin to create rp(%s)'s dss.", new Object[]{recoveryPlan.getName()});
        this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return this.endRecoveryProcessWithoutProcessor("ism.drm.recovery.no.datastore.need.create", false);
        }
        HashSet<String> hostUrlSet = new HashSet<String>();
        VrmObject vrmInfo = this.getVrmObject(recoveryPlan, hostUrlSet);
        for (RecoveryProcessor processor : this.getChildProc()) {
            if (!(processor instanceof CreateDataStoreSubProcessor)) continue;
            RecoveryProcessTask task = (RecoveryProcessTask)((CreateDataStoreSubProcessor)processor).getExcuteTask();
            if (task == null || VerifyUtil.isEmpty(hostUrlSet)) {
                logger.info((Object)"[Create ds] get CreateDataStoreSubProcessor failed,Rp name is (%s)", new Object[]{recoveryPlan.getName()});
                continue;
            }
            CreateDsCmd createDsCmd = (CreateDsCmd)task.getExcuteCmd();
            Map<String, String> wwnMap = createDsCmd.getWwnMap();
            if (VerifyUtil.isEmpty(wwnMap)) continue;
            ChangeDsStorageUnitRequestType changeDsRequest = new ChangeDsStorageUnitRequestType();
            for (Map.Entry<String, String> entry : wwnMap.entrySet()) {
                changeDsRequest.addStorageUnit(null, entry.getKey(), null, entry.getValue());
            }
            String hostUrl = (String)hostUrlSet.stream().findAny().get();
            changeDsRequest.setHostUrn(hostUrl);
            ((IVRMDrManager)ServiceLocator.getInstance().getService(IVRMDrManager.class)).changeDsStorageUnit(vrmInfo, "/datastores", changeDsRequest);
        }
        this.excuteSubProcessors(context, "vrm_batchExecuteCreatDatastore", CreateDataStoreSubProcessor.class);
        logger.info((Object)"Create ds end.");
        boolean exeRet = this.calcCreateDsProcessResult(context);
        if (exeRet) {
            this.postCreateDataStoreObserver(context);
        }
        return exeRet;
    }

    private VrmObject getVrmObject(RecoveryPlan recoveryPlan, Set<String> hostUrlSet) {
        VrmObject vrmInfo = null;
        for (RecoveryProcessor processor : this.getChildProc()) {
            if (!(processor instanceof CreateDataStoreSubProcessor)) continue;
            RecoveryProcessTask task = (RecoveryProcessTask)((CreateDataStoreSubProcessor)processor).getExcuteTask();
            if (task == null) {
                logger.info((Object)"[Create ds] get CreateDataStoreSubProcessor failed,Rp name is (%s)", new Object[]{recoveryPlan.getName()});
                continue;
            }
            CreateDsCmd createDsCmd = (CreateDsCmd)task.getExcuteCmd();
            if (vrmInfo == null) {
                vrmInfo = FsRecoveryUtil.getRecoveryVrmObject((String)createDsCmd.getCloudSn());
            }
            hostUrlSet.add(createDsCmd.getHostUrn());
        }
        return vrmInfo;
    }

    private boolean calcCreateDsProcessResult(RecoveryProcessorContext context) {
        if (!this.isAllProcessorsFailedToExc()) {
            this.excuteSubProcessors(context, "vrm_batchScanHyperV", ScanHyperVResSubProcessor.class);
            this.calcProcessResultBySubProc();
            return super.calcExcuteResult();
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        context.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    private void postCreateDataStoreObserver(RecoveryProcessorContext context) {
        RecoveryPlan plan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() != plan.getPlanType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType()) {
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        if (ProtectTypeEnum.SAN_HYPER_ACTIVE.getType().equals(protectType)) {
            return;
        }
        Map dsUrnLunMap = (Map)context.getAttribute("fsDatastoreLunMap");
        if (VerifyUtil.isEmpty((Map)dsUrnLunMap)) {
            return;
        }
        HashMap<String, String> dsChangeMap = new HashMap<String, String>();
        for (RecoveryProcessor processor : this.getChildProc()) {
            String oldUrn;
            DataStore ds;
            GalaxBaseSubRecoveryProcessor subProcessor = (GalaxBaseSubRecoveryProcessor)processor;
            String dsUri = (String)subProcessor.getExtendParams().get(DsRpParamsEnum.DS_URI.getValue());
            String vrmSn = (String)subProcessor.getExtendParams().get(DsRpParamsEnum.FC_SN.getValue());
            if (VerifyUtil.isEmpty((String)vrmSn) || VerifyUtil.isEmpty((String)dsUri) || (ds = this.getDataStoreByUri(vrmSn, dsUri)) == null || VerifyUtil.isEmpty((String)(oldUrn = this.getDatastoreUrnByDs(dsUrnLunMap, ds)))) continue;
            dsChangeMap.put(oldUrn, ds.getUrn());
        }
        if (!VerifyUtil.isEmpty(dsChangeMap)) {
            HashMap<String, HashMap<String, String>> dataMap = new HashMap<String, HashMap<String, String>>();
            dataMap.put("dsmap", dsChangeMap);
            dataMap.put("pgobj", (HashMap<String, String>)context.getProtectGroup());
            ObserverManager.getInstance((String)"RE_CREATE_DATASTORE_MANAGER").syncNotifyAllObservers(dataMap);
        }
    }

    private DataStore getDataStoreByUri(String vrmSn, String dsUri) {
        if (VerifyUtil.isEmpty((String)vrmSn) || VerifyUtil.isEmpty((String)dsUri)) {
            return null;
        }
        VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)vrmSn);
        List dataStores = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).queryDataStore(vrmInfo);
        if (VerifyUtil.isEmpty((Collection)dataStores)) {
            return null;
        }
        for (DataStore ds : dataStores) {
            if (!dsUri.equals(ds.getUri())) continue;
            return ds;
        }
        return null;
    }

    private String getDatastoreUrnByDs(Map<String, List<String>> dsUrnLunMap, DataStore ds) {
        Set newWwns = DsgUtil.getDataStoreStorageWwns((DataStore)ds);
        for (Map.Entry<String, List<String>> entry : dsUrnLunMap.entrySet()) {
            List<String> oldLunWwns = entry.getValue();
            for (String newWwn : newWwns) {
                if (!oldLunWwns.contains(newWwn)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private boolean isAllProcessorsFailedToExc() {
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        Set<RecoveryProcessor> subProcessors = this.getRecoveryProcessSet(CreateDataStoreSubProcessor.class);
        for (RecoveryProcessor rp : subProcessors) {
            if (successStatus != rp.getProcStatus()) continue;
            return false;
        }
        return true;
    }

    private void excuteSubProcessors(RecoveryProcessorContext context, String taskType, Class<?> cls) {
        Set<RecoveryProcessor> subProcessors = this.getRecoveryProcessSet(cls);
        Set oldSubProcessors = this.getChildProc();
        this.setChildProc(subProcessors);
        ProcessConcurrentExcuter processExcuter = new ProcessConcurrentExcuter(context, (RecoveryProcessor)this);
        processExcuter.concurrentExcuteSubProcessors(taskType);
        this.setChildProc(oldSubProcessors);
    }

    private Set<RecoveryProcessor> getRecoveryProcessSet(Class<?> cls) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor rp : this.getChildProc()) {
            if (rp.getClass() != cls) continue;
            processors.add(rp);
        }
        return processors;
    }

    private void updateSubProcessors(RecoveryProcessorContext context) {
        Set subProcessors = this.getSubProcessorFactory().createCreateDsSubProcessors(context, (RecoveryProcessor)this);
        this.saveProcessors(subProcessors);
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.CreateDataStoreProcessor.des");
    }
}

