/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.storage.recovery.process.CreateDataStoreProcessor;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateFSBDataStoreProcessor
extends GalaxBaseRecoveryProcessor {
    public static final String DRILLING_DISK_NAME_MAP = "DRILLING_DISK_NAME_MAP";
    public static final String FSB_MANAGEMENT_IP_MAP = "FSB_MANAGEMENT_IP_MAP";
    public static final String STORAGE_POOL_ID_MAP = "STORAGE_POOL_ID_MAP";
    private static final long serialVersionUID = 5033593649550697904L;
    private static final Log logger = LogFactory.getInstance(CreateFSBDataStoreProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        List<StoragePair> storagePairs;
        String tgtDevSn;
        Map<String, String> fsbIpMap;
        Map prop;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        Set poSet = protectGroup.getPolist();
        HashMap<String, String> diskNameMap = new HashMap<String, String>();
        this.fillDiskNameMap(recoveryPlan, poSet, diskNameMap);
        JSONObject diskNameMapJson = JSONObject.fromObject(diskNameMap);
        context.getRecoveryPlan().getGlobalSettings().put(DRILLING_DISK_NAME_MAP, diskNameMapJson.toString());
        String srcDevSn = "";
        String srcIpAddress = "";
        ProtectObject protectObject = (ProtectObject)poSet.stream().findAny().get();
        Iterator iterator = protectObject.getUsedStorageResourceSet().iterator();
        if (iterator.hasNext()) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)iterator.next();
            srcDevSn = protectObjectStorageInfo.getResourceProviderSN();
        }
        if (!(prop = protectObject.getProps()).isEmpty() && prop.containsKey(PoExParamsEnum.VM_MGR_INFO.getValue())) {
            VmConfigType vmConfigType = CreateFSBDataStoreProcessor.getVmConfigType(prop);
            if (VerifyUtil.isEmpty((Object)vmConfigType)) {
                logger.error((Object)"vm config info error, vm_mgr_info is %s.", new Object[]{prop.get(PoExParamsEnum.VM_MGR_INFO.getValue())});
                return false;
            }
            for (VmConfigDiskType disk : vmConfigType.getDisks()) {
                if (VerifyUtil.isEmpty((String)disk.getDrExtParams())) continue;
                JSONObject drExtParamsJson = JSONObject.fromObject((Object)disk.getDrExtParams());
                srcIpAddress = drExtParamsJson.get("dsMgntIp").toString();
                break;
            }
        }
        if ((fsbIpMap = CreateFSBDataStoreProcessor.getFsbIpMap(srcIpAddress, tgtDevSn = CreateFSBDataStoreProcessor.getTgtDevSn(srcDevSn, storagePairs = CreateFSBDataStoreProcessor.getStoragePairs(context, srcDevSn)))).isEmpty()) {
            logger.error((Object)"Can't get src address.");
            return false;
        }
        JSONObject fsbIpMapJson = JSONObject.fromObject(fsbIpMap);
        context.getRecoveryPlan().getGlobalSettings().put(FSB_MANAGEMENT_IP_MAP, fsbIpMapJson.toString());
        CreateFSBDataStoreProcessor.fillStoragePool(context, srcDevSn, storagePairs);
        logger.info((Object)"Create FSB DataStore end.");
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private static Map<String, String> getFsbIpMap(String srcIpAddress, String tgtDevSn) {
        NetworkEntity tgtNetEntity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)tgtDevSn);
        HashMap<String, String> fsbIpMap = new HashMap<String, String>();
        if (!srcIpAddress.isEmpty()) {
            fsbIpMap.put(srcIpAddress, tgtNetEntity.getIpAddress());
        }
        return fsbIpMap;
    }

    private static VmConfigType getVmConfigType(Map<String, String> prop) {
        FixLengthProps poRecoveryProps = new FixLengthProps(prop, 8192);
        String vmMgrJson = poRecoveryProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
        Map vmMgrInfoMap = (Map)JSONObject.toBean((String)vmMgrJson, Map.class);
        return (VmConfigType)CommonUtil.jsonToBean((String)vmMgrInfoMap.get("vmConfig").toString(), VmConfigType.class);
    }

    private static void fillStoragePool(RecoveryProcessorContext context, String srcDevSn, List<StoragePair> storagePairs) {
        for (StoragePair storagePair : storagePairs) {
            if (!storagePair.getSrcDevSN().equals(srcDevSn)) continue;
            JSONObject storagePoolIdMapJson = JSONObject.fromObject((Object)storagePair.getStoragePools());
            context.getRecoveryPlan().getGlobalSettings().put(STORAGE_POOL_ID_MAP, storagePoolIdMapJson.toString());
            break;
        }
    }

    private static String getTgtDevSn(String srcDevSn, List<StoragePair> storagePairs) {
        String tgtDevSn = "";
        for (StoragePair storagePair : storagePairs) {
            if (!storagePair.getSrcDevSN().equals(srcDevSn)) continue;
            tgtDevSn = storagePair.getTgtDevSN();
            break;
        }
        return tgtDevSn;
    }

    private static List<StoragePair> getStoragePairs(RecoveryProcessorContext context, String srcDevSn) {
        String replicationCfg = (String)context.getProtectGroup().getProps().get("storagePoolMapping");
        ReplicationPairConfiguration config = new ReplicationPairConfiguration(replicationCfg);
        return config.findStoragePair(srcDevSn);
    }

    protected void fillDiskNameMap(RecoveryPlan recoveryPlan, Set<ProtectObject> poSet, Map<String, String> diskNameMap) {
        if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            return;
        }
        List recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, CreateSnapshotSubProcessor.class);
        for (RecoveryProcessor innerProcess : recoveryProcesses) {
            CreateSnapshotSubProcessor createSnapshotProcessor = (CreateSnapshotSubProcessor)innerProcess;
            for (ProtectObject protectObject : poSet) {
                this.putDiskNameMap(diskNameMap, createSnapshotProcessor, protectObject);
            }
        }
    }

    private void putDiskNameMap(Map<String, String> diskNameMap, CreateSnapshotSubProcessor createSnapshotProcessor, ProtectObject protectObject) {
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObject.getUsedStorageResourceSet()) {
            if (!protectObjectStorageInfo.getResourceId().equals(createSnapshotProcessor.getSrcLunId()) || !protectObjectStorageInfo.getResourceProviderSN().equals(createSnapshotProcessor.getSrcDeviceId())) continue;
            diskNameMap.put(protectObjectStorageInfo.getResourceName(), createSnapshotProcessor.getSnapshotName().replaceAll("_BAK$", "_Clone"));
        }
    }

    public String getName() {
        return CreateDataStoreProcessor.class.getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.CreateDataStoreProcessor.des");
    }
}

