/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.excuter.ProcessConcurrentExcuter;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class DeleteDataStoreProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = -1352360224097703112L;
    private static final Log logger = LogFactory.getInstance(DeleteDataStoreProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"[Delete ds]Begin to delete dss.", 90160758786816L);
        this.setContextRef(context);
        this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"[Delete ds]No ds need delete.", 90160758786816L);
            return this.endRecoveryProcessWithoutProcessor("ism.drm.recovery.no.datastore.need.delete", true);
        }
        ProcessConcurrentExcuter excuter = new ProcessConcurrentExcuter(context, (RecoveryProcessor)this);
        excuter.concurrentExcuteSubProcessors("vrm_batchExecuteDeleteDatastore");
        return this.calcProcessResult(context);
    }

    private boolean calcProcessResult(RecoveryProcessorContext context) {
        boolean executeResult = this.calcProcessResultBySubProc();
        if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) && DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.getProcStatus()) {
            executeResult = false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.scanFmDs(context);
            return true;
        }
        return executeResult;
    }

    private void scanFmDs(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        VrmRecoveryUtil.scanFmDs(context, recoveryPlan, true);
    }

    private void updateSubProcessors(RecoveryProcessorContext context) {
        Set subProcessors = this.getSubProcessorFactory().createDeleteDsSubProcessors(context, (RecoveryProcessor)this);
        this.saveProcessors(subProcessors);
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.DeleteDataStoreProcessor.pm.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.DeleteDataStoreProcessor.sr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.DeleteDataStoreProcessor.des");
        }
    }
}

