/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.DsRpParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.excuter.ProcessConcurrentExcuter;
import com.huawei.ism.drm.galax.recovery.process.RegisterVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetDataStoreModeRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.process.CreateDataStoreProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.CreateDataStoreSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteVmRecoveryProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = 5695348013522281499L;
    private static Log logger = LogFactory.getInstance(DeleteVmRecoveryProcessor.class);

    private boolean isRegisterAllVmsSuccess(RecoveryProcessorContext context) {
        logger.trace((Object)"isRegisterAllVmsSuccess");
        RecoveryPlan rp = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(rp);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessor registerVmProcessor = rpProxy.getRecoveryProcessByType(type, RegisterVmRecoveryProcessor.class);
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        if (registerVmProcessor == null) {
            return false;
        }
        return registerVmProcessor.getProcStatus() == successStatus;
    }

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Ready to delete vms.");
        this.setContextRef(context);
        if (!this.isRegisterAllVmsSuccess(context) && this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            logger.info((Object)"The %s doesn't register all vms successfully.", new Object[]{context.getRecoveryPlan().getName()});
            this.updateProcessDetail("ism.drm.recovery.registerallvms.vrm.errorcode", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            context.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"No vm need delete.");
            return this.endRecoveryProcessWithoutProcessor("ism.drm.recovery.process.no.need", true);
        }
        if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            this.setDataStoreMode(context);
        }
        ProcessConcurrentExcuter excuter = new ProcessConcurrentExcuter(context, (RecoveryProcessor)this);
        excuter.concurrentExcuteSubProcessors("vrm_batchExecuteDeleteVM");
        this.updateProtectGroup(context);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.calcProcessResultBySubProc();
            return true;
        }
        logger.info((Object)"Complete the process of delete vm.");
        return this.calcExcuteResult();
    }

    private void setPlanedMotionDsMode(RecoveryProcessorContext context, ProtectGroup pg) {
        String recoverySiteId;
        String productSiteId = context.getAttribute("PRODUCT_SITE_ID") == null ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
        String cloudSn = FsRecoveryUtil.getVrmSnByPg((ProtectGroup)pg, (boolean)true, (String)productSiteId, (String)(recoverySiteId = context.getAttribute("SELECT_DISASTER_SITE_KEY") == null ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"))));
        if (cloudSn == null) {
            logger.info((Object)"Failed to find cloud sn,maybe pg has no po, poName is %s.", new Object[]{pg.getName()});
            return;
        }
        PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(pg);
        for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
            FsRecoveryUtil.excuteCmdToCloud((String)pg.getProductSiteId(), (String)cloudSn, (String)dsMgrInfo.getDsUri(), (String)VmRecoveryCmdEnum.SET_STORAGEMODE.toString());
        }
    }

    private void updateProtectGroup(RecoveryProcessorContext context) {
        logger.trace((Object)"updateProtectGroup");
        RecoveryPlan recoveryPlan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        if (recoveryPlan.getPlanType() != DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() || this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            return;
        }
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus() || DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            Set protectGroups = recoveryPlan.getProtectGroups();
            for (ProtectGroup pg : protectGroups) {
                ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus.INVALID, new String[]{pg.getUuid()});
            }
        }
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        logger.info((Object)"Enter updateSubProcessors.");
        RecoveryPlan recoveryPlan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) continue;
            this.setPlanedMotionDsMode(context, pg);
        }
        Set deleteVmProcessors = this.getSubProcessorFactory().createDeleteVmSubProcessors(context, (RecoveryProcessor)this);
        return this.saveProcessors(deleteVmProcessors);
    }

    private void setDataStoreMode(RecoveryProcessorContext context) {
        logger.info((Object)"Set datastore mode start.");
        List<RecoveryProcessor> createDataStoreProcessors = this.getCreateDataStoreProcessor(context);
        if (!createDataStoreProcessors.isEmpty()) {
            HashSet<String> datastoreUrlSet = new HashSet<String>();
            for (RecoveryProcessor process : createDataStoreProcessors) {
                CreateDataStoreSubProcessor createDataStore = (CreateDataStoreSubProcessor)process;
                String hostUrn = (String)createDataStore.getExtendParams().get(DsRpParamsEnum.HOST_URN.getValue());
                VrmObject vrmInfo = VrmRecoveryUtil.getVrmObjectByHostUrn(hostUrn);
                if (vrmInfo == null) {
                    logger.error((Object)"The vrmInfo is null.");
                    return;
                }
                String datastoreUri = (String)createDataStore.getExtendParams().get(DsRpParamsEnum.DS_URI.getValue());
                if (datastoreUrlSet.contains(datastoreUri)) continue;
                datastoreUrlSet.add(datastoreUri);
                SetDataStoreModeRequestType setDataStoreModeRequest = this.generateSetDataStoreModeRequest("protecting");
                this.sendSetDataStoreModeRequestToVrm(vrmInfo, datastoreUri, setDataStoreModeRequest);
            }
        } else {
            logger.info((Object)"No datastore need set mode.");
        }
    }

    private void sendSetDataStoreModeRequestToVrm(VrmObject vrmInfo, String datastoreUri, SetDataStoreModeRequestType setDataStoreModeRequest) {
        if (setDataStoreModeRequest == null) {
            logger.info((Object)"Failed to generate set datastore mode request ,datastoreUri=%s.", new Object[]{datastoreUri});
        } else {
            try {
                VMOperateResponseType setDataStoreModeResponse = ((IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class)).setDataStoreMode(vrmInfo, datastoreUri, setDataStoreModeRequest);
                this.handleSetDataStoreModeResponse(setDataStoreModeResponse, datastoreUri);
            }
            catch (Exception e) {
                logger.error((Object)"Set datastore mode failed ,datastoreUri=%s, error=%s.", new Object[]{datastoreUri, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private List<RecoveryProcessor> getCreateDataStoreProcessor(RecoveryProcessorContext context) {
        logger.info((Object)"GetCreateDataStoreProcessor start.");
        ArrayList<RecoveryProcessor> createDataStoreSubProcessors = new ArrayList<RecoveryProcessor>();
        RecoveryProcessDefinition rpd = context.getRecoveryPlan().getRecoveryProcess(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
        Set rpSet = rpd.getRecoveryProcessors();
        if (VerifyUtil.isEmpty((Collection)rpSet)) {
            logger.error((Object)"The rpSet is null or empty.");
            return createDataStoreSubProcessors;
        }
        for (RecoveryProcessor rp : rpSet) {
            if (rp.getClass() != CreateDataStoreProcessor.class) continue;
            createDataStoreSubProcessors.addAll(this.getChildProcessors(rp));
        }
        if (createDataStoreSubProcessors.isEmpty()) {
            logger.info((Object)"Set datastore mode function get createDataStoreSubProcessors is 0.");
        } else {
            logger.info((Object)"Set datastore mode function get createDataStoreSubProcessors num: %s.", new Object[]{String.valueOf(createDataStoreSubProcessors.size())});
        }
        return createDataStoreSubProcessors;
    }

    private Set<RecoveryProcessor> getChildProcessors(RecoveryProcessor rp) {
        logger.info((Object)"Enter getChildProcessors.");
        HashSet<RecoveryProcessor> rpSet = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor child : rp.getChildProc()) {
            if (!(child instanceof CreateDataStoreSubProcessor)) continue;
            rpSet.add(child);
        }
        return rpSet;
    }

    private SetDataStoreModeRequestType generateSetDataStoreModeRequest(String dataStoreMode) {
        logger.info((Object)"Enter generateSetDataStoreModeRequest.");
        SetDataStoreModeRequestType setDataStoreModeRequest = new SetDataStoreModeRequestType();
        setDataStoreModeRequest.setMode(dataStoreMode);
        return setDataStoreModeRequest;
    }

    private void handleSetDataStoreModeResponse(Object response, String datastoreUri) {
        if (response == null) {
            logger.info((Object)"Succeed to set datastore mode ,datastoreUri=%s.", new Object[]{datastoreUri});
            return;
        }
        if (response instanceof VMOperateResponseType) {
            VMOperateResponseType task = (VMOperateResponseType)response;
            String taskErrorCode = task.getErrorCode();
            if (VerifyUtil.isEmpty((String)taskErrorCode)) {
                logger.info((Object)"The task's error code is null ,taskUri=%s.", new Object[]{task.getTaskUri()});
            } else {
                logger.info((Object)"Set datastore's mode failed, the errorCode=%s, errorDes=%s.", new Object[]{String.valueOf(task.getErrorCode()), task.getErrorDes()});
            }
        } else {
            logger.info((Object)"Failed to set datastore mode, datastoreUri=%s.", new Object[]{datastoreUri});
        }
    }

    public void updateProcessName() {
        logger.info((Object)"Enter updateProcessName.");
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            this.setProcName("com.huawei.ism.drm.galax.storage.recovery.process.DeleteProductVmRecoveryProcessor");
        }
    }

    public void updateDescription() {
        logger.info((Object)"Enter updateDescription.");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.DeleteProductVmRecoveryProcessor.pm.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.DeleteProductVmRecoveryProcessor.sr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.DeleteVmRecoveryProcessor.des");
        }
    }
}

