/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.RegisterVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.StartVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.subprocess.RegisterVmRecoverySubProcessor;
import com.huawei.ism.drm.recovery.framework.process.BeginRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.EndRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class GalaxEndRecoveryProcessor
extends EndRecoveryProcessor {
    private static final long serialVersionUID = -1410992583871817347L;
    private static final Log logger = LogFactory.getInstance(GalaxEndRecoveryProcessor.class);

    public int getPreviousProcessorStatus() {
        int procResult = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() ? this.getReprotectResult() : (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() : this.getProcResult());
        return procResult;
    }

    private int getReprotectResult() {
        RecoveryProcessor process = this.getTgtRecoveryProcess(RefactorProtectRelationProcessor.class);
        if (process == null) {
            logger.error((Object)"Failed to find start vm process.");
            process = this.getPreviousProcessor();
        }
        return process.getProcStatus();
    }

    private int getProcResult() {
        int sucess = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        RecoveryProcessor startProcess = this.getTgtRecoveryProcess(StartVmRecoveryProcessor.class);
        if (startProcess == null || !startProcess.getIsEnabled().booleanValue()) {
            logger.error((Object)"Failed to find start vm process.");
            startProcess = this.getPreviousProcessor();
        }
        while (startProcess != null && !startProcess.getIsEnabled().booleanValue()) {
            logger.error((Object)"Current processor is %s disabled.", new Object[]{startProcess.getName()});
            startProcess = startProcess.getPreviousProcessor();
        }
        int procResult = startProcess == null ? DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() : startProcess.getProcStatus();
        RecoveryProcessor registerProcess = this.getTgtRecoveryProcess(RegisterVmRecoveryProcessor.class);
        int partSucess = DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue();
        if (registerProcess == null || registerProcess.getProcStatus() == sucess || partSucess == procResult) {
            logger.info((Object)"Register Process has no impact.");
            return procResult;
        }
        logger.info((Object)"Register Process result:%s,registerProcess:%s.", new Object[]{String.valueOf(registerProcess.getProcStatus()), registerProcess});
        if (registerProcess.getProcStatus() == partSucess && procResult == sucess) {
            logger.info((Object)"Register vm part success.");
            return partSucess;
        }
        int failed = DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        if (failed == procResult) {
            return this.getRegisterProcessor(registerProcess, procResult);
        }
        logger.info((Object)"procResult result:%s,procStatus:%s.", new Object[]{procResult, String.valueOf(registerProcess.getProcStatus())});
        return procResult;
    }

    private RecoveryProcessor getTgtRecoveryProcess(Class<?> process) {
        RecoveryProcessor rp = this.getPreviousProcessor();
        if (rp.getClass() == process) {
            return rp;
        }
        while (rp.getPreviousProcessor() != null && !(rp instanceof BeginRecoveryProcessor)) {
            if ((rp = rp.getPreviousProcessor()).getClass() != process) continue;
            return rp;
        }
        return null;
    }

    private int getRegisterProcessor(RecoveryProcessor registerProcess, int procResult) {
        int partSucess = DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue();
        for (RecoveryProcessor processor : registerProcess.getChildProc()) {
            if (!(processor instanceof RegisterVmRecoverySubProcessor)) {
                logger.info((Object)"PrePre processor is not register processor.");
                continue;
            }
            RegisterVmRecoverySubProcessor registerSubProcessor = (RegisterVmRecoverySubProcessor)processor;
            Boolean status = this.getRegisterSubProcessorStatus(registerSubProcessor);
            if (!status.booleanValue()) continue;
            logger.info((Object)"Some vms restored successfully.");
            return partSucess;
        }
        return procResult;
    }

    private Boolean getRegisterSubProcessorStatus(RegisterVmRecoverySubProcessor processor) {
        Set poRecoveryStatusEntries = processor.getPoRecoveryStatus(null);
        if (VerifyUtil.isEmpty((Collection)poRecoveryStatusEntries)) {
            return false;
        }
        Iterator iterator = poRecoveryStatusEntries.iterator();
        if (iterator.hasNext()) {
            AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)iterator.next();
            Boolean value = (Boolean)entry.getValue();
            return value;
        }
        return false;
    }
}

